/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketDemandAPI;
import com.fs.starfarer.api.util.IntervalUtil;

public class GalatiaMarketScript
implements EveryFrameScript {
    protected MarketAPI market;
    protected IntervalUtil interval = new IntervalUtil(15.0f, 25.0f);

    public GalatiaMarketScript(MarketAPI market) {
        this.market = market;
        FactionAPI faction = market.getFaction();
        market.getTariff().modifyFlat("default_tariff", faction.getTariffFraction());
        this.updateCommodities();
    }

    Object readResolve() {
        this.market.updatePrices();
        return this;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        this.updateCommodities();
    }

    protected void updateCommodities() {
        for (CommodityOnMarketAPI com : this.market.getAllCommodities()) {
            com.setStockpile(200.0f);
        }
        for (MarketDemandAPI demand : this.market.getDemandData().getDemandList()) {
            CommodityOnMarketAPI com = this.market.getCommodityData(demand.getBaseCommodity().getId());
            com.addToStockpile(demand.getDemandValue());
        }
        CommodityOnMarketAPI supplies = this.market.getCommodityData("supplies");
        supplies.addToStockpile(100.0f + 100.0f * (float)Math.random());
        CommodityOnMarketAPI fuel = this.market.getCommodityData("fuel");
        fuel.addToStockpile(100.0f + 100.0f * (float)Math.random());
        this.market.updatePrices();
    }

    public boolean isDone() {
        return this.market.isInEconomy();
    }

    public boolean runWhilePaused() {
        return false;
    }
}

