/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.util.Misc;

public class TutorialLeashAssignmentAI
extends BaseAssignmentAI {
    protected StarSystemAPI system;
    protected SectorEntityToken jumpPoint;
    protected float elapsed = 0.0f;
    protected float dur = 30.0f + (float)Math.random() * 20.0f;
    protected SectorEntityToken toGuard;

    public TutorialLeashAssignmentAI(CampaignFleetAPI fleet, StarSystemAPI system, SectorEntityToken toGuard) {
        this.fleet = fleet;
        this.system = system;
        this.toGuard = toGuard;
        this.giveInitialAssignments();
    }

    protected void giveInitialAssignments() {
        this.pickNext();
    }

    protected void pickNext() {
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.toGuard, 100.0f);
    }

    public void advance(float amount) {
        super.advance(amount);
        float dist = Misc.getDistance(this.fleet.getLocation(), this.toGuard.getLocation());
        if (dist > 1500.0f && this.fleet.getAI().getCurrentAssignmentType() == FleetAssignment.ORBIT_AGGRESSIVE) {
            this.fleet.addAssignmentAtStart(FleetAssignment.ORBIT_PASSIVE, this.toGuard, 3.0f, null);
            CampaignFleetAIAPI ai = this.fleet.getAI();
            if (ai instanceof ModularFleetAIAPI) {
                ModularFleetAIAPI m = (ModularFleetAIAPI)ai;
                m.getStrategicModule().getDoNotAttack().add(m.getTacticalModule().getTarget(), 1.0f);
                m.getTacticalModule().setTarget(null);
            }
        }
    }
}

