/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.submarkets.StoragePlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.RogueMinerMiscFleetManager;
import com.fs.starfarer.api.impl.campaign.tutorial.SaveNagScript;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLeashAssignmentAI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.ui.HintPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialMissionEvent
extends BaseEventPlugin {
    public static final String TUT_STAGE = "$tutStage";
    public static final String REASON = "tut";
    protected float elapsedDays = 0.0f;
    protected boolean ended = false;
    protected StarSystemAPI system;
    protected PlanetAPI ancyra;
    protected PlanetAPI pontus;
    protected PlanetAPI tetra;
    protected SectorEntityToken derinkuyu;
    protected SectorEntityToken probe;
    protected SectorEntityToken inner;
    protected SectorEntityToken fringe;
    protected SectorEntityToken detachment;
    protected SectorEntityToken relay;
    protected PersonAPI mainContact;
    protected PersonAPI dataContact;
    protected PersonAPI jangalaContact;
    protected PlanetAPI jangala;
    protected TutorialMissionStage stage = TutorialMissionStage.INIT;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
    }

    @Override
    public void setParam(Object param) {
    }

    @Override
    public void startEvent() {
        super.startEvent();
        this.system = Global.getSector().getStarSystem("galatia");
        this.ancyra = (PlanetAPI)this.system.getEntityById("ancyra");
        this.pontus = (PlanetAPI)this.system.getEntityById("pontus");
        this.tetra = (PlanetAPI)this.system.getEntityById("tetra");
        this.derinkuyu = this.system.getEntityById("derinkuyu_station");
        this.probe = this.system.getEntityById("galatia_probe");
        this.inner = this.system.getEntityById("galatia_jump_point_alpha");
        this.fringe = this.system.getEntityById("galatia_jump_point_fringe");
        this.detachment = this.system.getEntityById("tutorial_security_detachment");
        this.relay = this.system.getEntityById("ancyra_relay");
        this.mainContact = TutorialMissionEvent.createMainContact(this.ancyra);
        this.dataContact = Global.getSector().getFaction("independent").createRandomPerson();
        this.dataContact.setRankId(Ranks.AGENT);
        this.dataContact.setPostId(Ranks.POST_AGENT);
        this.derinkuyu.getMarket().getCommDirectory().addPerson(this.dataContact);
        String stageId = "start";
        Global.getSector().reportEventStage(this, stageId, Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.ancyra));
        this.mainContact.getMemoryWithoutUpdate().set("$tut_mainContact", true);
        this.mainContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
        Misc.makeImportant(this.mainContact, REASON);
        this.updateStage(TutorialMissionStage.INIT);
    }

    public static PersonAPI createMainContact(PlanetAPI ancyra) {
        PersonAPI mainContact = ancyra.getFaction().createRandomPerson();
        mainContact.setRankId(Ranks.CITIZEN);
        mainContact.setPostId(Ranks.POST_STATION_COMMANDER);
        ancyra.getMarket().getCommDirectory().addPerson(mainContact);
        return mainContact;
    }

    public static PersonAPI getJangalaContact() {
        StarSystemAPI corvus = Global.getSector().getStarSystem("Corvus");
        PlanetAPI jangala = (PlanetAPI)corvus.getEntityById("jangala");
        for (CommDirectoryEntryAPI entry : jangala.getMarket().getCommDirectory().getEntriesCopy()) {
            PersonAPI curr;
            if (entry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(entry.getEntryData() instanceof PersonAPI) || !Ranks.POST_STATION_COMMANDER.equals((curr = (PersonAPI)entry.getEntryData()).getPostId())) continue;
            return curr;
        }
        return null;
    }

    public PersonAPI getMainContact() {
        return this.mainContact;
    }

    protected void updateStage(TutorialMissionStage stage) {
        this.stage = stage;
        Global.getSector().getMemoryWithoutUpdate().set(TUT_STAGE, stage.name());
    }

    protected void endEvent() {
        this.ended = true;
        Global.getSector().getMemoryWithoutUpdate().unset(TUT_STAGE);
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        this.elapsedDays += days;
        if (this.probe == null) {
            this.probe = this.system.getEntityById("galatia_probe");
        }
        if (this.tetra == null) {
            this.tetra = (PlanetAPI)this.system.getEntityById("tetra");
        }
        if (this.derinkuyu == null) {
            this.derinkuyu = this.system.getEntityById("derinkuyu_station");
        }
        if (this.inner == null) {
            this.inner = this.system.getEntityById("galatia_jump_point_alpha");
        }
        if (this.fringe == null) {
            this.fringe = this.system.getEntityById("galatia_jump_point_fringe");
        }
        if (this.detachment == null) {
            this.detachment = this.system.getEntityById("tutorial_security_detachment");
        }
        if (this.stage == TutorialMissionStage.GO_GET_AI_CORE) {
            int cores = (int)player.getCargo().getCommodityQuantity("gamma_core");
            float distToProbe = Misc.getDistance(player.getLocation(), this.probe.getLocation());
            if (cores > 0 && (!this.probe.isAlive() || distToProbe < 300.0f)) {
                Global.getSector().reportEventStage(this, "salvage_core_end", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.ancyra));
                Misc.makeImportant(this.mainContact, REASON);
                this.updateStage(TutorialMissionStage.GOT_AI_CORE);
            }
        }
        if (this.stage == TutorialMissionStage.GO_RECOVER_SHIPS) {
            int count = 0;
            for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
                ++count;
            }
            int wrecks = 0;
            for (SectorEntityToken entity : this.system.getEntitiesWithTag("salvageable")) {
                String id = entity.getCustomEntityType();
                if (id == null || !"wreck".equals(id)) continue;
                ++wrecks;
            }
            if (count >= 5 || wrecks < 3) {
                Global.getSector().reportEventStage(this, "ship_recovery_end", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.ancyra));
                Misc.makeImportant(this.mainContact, REASON);
                Misc.makeUnimportant(this.tetra, REASON);
                this.updateStage(TutorialMissionStage.RECOVERED_SHIPS);
            }
        }
        if (this.stage == TutorialMissionStage.GO_STABILIZE) {
            boolean fringeStable;
            boolean innerStable = this.inner.getMemoryWithoutUpdate().getExpire("$unstable") > 0.0f;
            boolean bl = fringeStable = this.fringe.getMemoryWithoutUpdate().getExpire("$unstable") > 0.0f;
            if (innerStable || fringeStable) {
                Global.getSector().reportEventStage(this, "stabilize_jump_point_done", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.ancyra));
                Misc.makeImportant(this.mainContact, REASON);
                Misc.makeUnimportant(this.inner, REASON);
                this.updateStage(TutorialMissionStage.STABILIZED);
            }
        }
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        if (action.equals("startGetData")) {
            Global.getSector().reportEventStage(this, "sneak_start", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.derinkuyu));
            this.dataContact.getMemoryWithoutUpdate().set("$tut_dataContact", true);
            this.dataContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
            Misc.makeImportant(this.dataContact, REASON);
            Misc.makeUnimportant(this.mainContact, REASON);
            this.detachment.getMemoryWithoutUpdate().set("$patrolAllowTOff", true);
            this.updateStage(TutorialMissionStage.GO_GET_DATA);
            this.saveNag();
        } else if (action.equals("endGetData")) {
            Global.getSector().reportEventStage(this, "sneak_end", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.ancyra));
            Misc.cleanUpMissionMemory(this.dataContact.getMemoryWithoutUpdate(), "tut_");
            Misc.makeUnimportant(this.dataContact, REASON);
            Misc.makeImportant(this.mainContact, REASON);
            this.updateStage(TutorialMissionStage.GOT_DATA);
        } else if (action.equals("goSalvage")) {
            Global.getSector().reportEventStage(this, "salvage_core_start", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.pontus));
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.probe, REASON);
            this.updateStage(TutorialMissionStage.GO_GET_AI_CORE);
            this.saveNag();
        } else if (action.equals("goRecover")) {
            Global.getSector().reportEventStage(this, "ship_recovery_start", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.tetra));
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.tetra, REASON);
            FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "mudskipper_Standard");
            playerFleet.getFleetData().addFleetMember(member);
            AddRemoveCommodity.addFleetMemberGainText(member, dialog.getTextPanel());
            this.updateStage(TutorialMissionStage.GO_RECOVER_SHIPS);
        } else if (action.equals("goStabilize")) {
            Global.getSector().reportEventStage(this, "stabilize_jump_point", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.inner));
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.inner, REASON);
            this.addWeaponsToStorage();
            this.inner.getMemoryWithoutUpdate().set("$canStabilize", true);
            this.fringe.getMemoryWithoutUpdate().set("$canStabilize", true);
            this.updateStage(TutorialMissionStage.GO_STABILIZE);
            this.saveNag();
        } else if (action.equals("pickJangalaContact")) {
            StarSystemAPI corvus = Global.getSector().getStarSystem("Corvus");
            this.jangala = (PlanetAPI)corvus.getEntityById("jangala");
            this.jangalaContact = TutorialMissionEvent.getJangalaContact();
            MemoryAPI mem = this.mainContact.getMemoryWithoutUpdate();
            mem.set("$jangalaContactPost", this.jangalaContact.getPost().toLowerCase(), 0.0f);
            mem.set("$jangalaContactLastName", this.jangalaContact.getName().getLast(), 0.0f);
            float distLY = Misc.getDistanceLY(playerFleet.getLocationInHyperspace(), this.jangala.getLocationInHyperspace());
            float fuel = playerFleet.getLogistics().getFuelCostPerLightYear() * (distLY += 4.0f);
            fuel = (float)(Math.ceil(fuel / 10.0f) * 10.0);
            mem.set("$jangalaFuel", (int)fuel);
        } else if (action.equals("deliverReport")) {
            Global.getSector().reportEventStage(this, "deliver_message", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.jangala));
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.cleanUpMissionMemory(this.mainContact.getMemoryWithoutUpdate(), "tut_");
            Misc.makeUnimportant(this.inner, REASON);
            this.jangalaContact.getMemoryWithoutUpdate().set("$tut_jangalaContact", true);
            this.jangalaContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
            Misc.makeImportant(this.jangalaContact, REASON);
            this.updateStage(TutorialMissionStage.DELIVER_REPORT);
            TutorialMissionEvent.endGalatiaPortionOfMission();
            Global.getSector().getMemoryWithoutUpdate().unset("$tutorialRespawn");
        } else if (action.equals("reportDelivered")) {
            Global.getSector().reportEventStage(this, "end", Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, this.createSetMessageLocationScript(this.jangala));
            Misc.makeUnimportant(this.jangalaContact, REASON);
            Misc.cleanUpMissionMemory(this.jangalaContact.getMemoryWithoutUpdate(), "tut_");
            this.updateStage(TutorialMissionStage.DONE);
            MarketAPI jangala = Global.getSector().getEconomy().getMarket("jangala");
            if (jangala != null) {
                SystemBountyManager.getInstance().addOrResetBounty(jangala);
            }
            this.endEvent();
        } else if (action.equals("printRefitHint")) {
            String refit = Global.getSettings().getControlStringForEnumName("CORE_REFIT");
            String autofit = Global.getSettings().getControlStringForEnumName("REFIT_MANAGE_VARIANTS");
            String transponder = "";
            if (!playerFleet.isTransponderOn()) {
                transponder = "\n\nAlso: you'll need to re-dock with your transponder turned on to take advantage of Ancyra's facilities.";
            }
            dialog.getTextPanel().addPara("(Once this conversation is over, press %s to open the refit screen. After selecting a specific ship, you can press %s to %s - pick a desired loadout, and the ship will be automatically refitted to match it, using what weapons are available." + transponder, Misc.getHighlightColor(), refit, autofit, "\"autofit\"");
            dialog.getTextPanel().addPara("In addition, you now have access to local storage at Ancyra, and some weapons and supplies have been placed there. To access it, click on the \"Storage\" button in the trade screen.)", Misc.getHighlightColor(), refit, autofit, "\"Storage\"");
        }
        return true;
    }

    public static void endGalatiaPortionOfMission() {
        StarSystemAPI system = Global.getSector().getStarSystem("galatia");
        PlanetAPI ancyra = (PlanetAPI)system.getEntityById("ancyra");
        PlanetAPI pontus = (PlanetAPI)system.getEntityById("pontus");
        PlanetAPI tetra = (PlanetAPI)system.getEntityById("tetra");
        SectorEntityToken derinkuyu = system.getEntityById("derinkuyu_station");
        SectorEntityToken probe = system.getEntityById("galatia_probe");
        SectorEntityToken inner = system.getEntityById("galatia_jump_point_alpha");
        SectorEntityToken fringe = system.getEntityById("galatia_jump_point_fringe");
        SectorEntityToken relay = system.getEntityById("ancyra_relay");
        relay.getMemoryWithoutUpdate().unset("$objectiveNonFunctional");
        Global.getSector().getCharacterData().addAbility("transponder");
        Global.getSector().getCharacterData().addAbility("go_dark");
        Global.getSector().getCharacterData().addAbility("sensor_burst");
        Global.getSector().getCharacterData().addAbility("emergency_burn");
        Global.getSector().getCharacterData().addAbility("sustained_burn");
        Global.getSector().getCharacterData().addAbility("scavenge");
        Global.getSector().getCharacterData().addAbility("interdiction_pulse");
        Global.getSector().getCharacterData().addAbility("distress_call");
        FactionAPI hegemony = Global.getSector().getFaction("hegemony");
        if (hegemony.getRelToPlayer().getRel() < 0.0f) {
            hegemony.getRelToPlayer().setRel(0.0f);
        }
        Global.getSector().getEconomy().addMarket(ancyra.getMarket(), false);
        Global.getSector().getEconomy().addMarket(derinkuyu.getMarket(), false);
        HintPanelAPI hints = Global.getSector().getCampaignUI().getHintPanel();
        if (hints != null) {
            hints.clearHints(false);
        }
        if (!SystemBountyManager.getInstance().isActive(ancyra.getMarket())) {
            SystemBountyManager.getInstance().addActive(new SystemBountyIntel(ancyra.getMarket()));
        }
        RogueMinerMiscFleetManager script = new RogueMinerMiscFleetManager(derinkuyu);
        int i = 0;
        while (i < 20) {
            script.advance(1.0f);
            ++i;
        }
        system.addScript(script);
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (!"pirates".equals(fleet.getFaction().getId())) continue;
            fleet.removeScriptsOfClass(TutorialLeashAssignmentAI.class);
        }
        inner.getMemoryWithoutUpdate().unset("$unstable");
        inner.getMemoryWithoutUpdate().unset("$canStabilize");
        fringe.getMemoryWithoutUpdate().unset("$unstable");
        fringe.getMemoryWithoutUpdate().unset("$canStabilize");
    }

    protected void saveNag() {
        if (!Global.getSector().hasScript(SaveNagScript.class)) {
            Global.getSector().addScript(new SaveNagScript(10.0f));
        }
    }

    public void addWeaponsToStorage() {
        StoragePlugin plugin = (StoragePlugin)this.ancyra.getMarket().getSubmarket("storage").getPlugin();
        plugin.setPlayerPaidToUnlock(true);
        CargoAPI cargo = plugin.getCargo();
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
            for (WeaponSlotAPI slot : member.getVariant().getHullSpec().getAllWeaponSlotsCopy()) {
                String weaponId = this.getWeaponForSlot(slot);
                if (weaponId == null) continue;
                cargo.addWeapons(weaponId, 1);
            }
        }
        cargo.addFighters("broadsword_wing", 1);
        cargo.addFighters("piranha_wing", 1);
        cargo.addSupplies(50.0f);
        cargo.sort();
    }

    public String getWeaponForSlot(WeaponSlotAPI slot) {
        switch (slot.getWeaponType()) {
            case BALLISTIC: 
            case UNIVERSAL: 
            case HYBRID: 
            case COMPOSITE: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("mark9", "hephag", "hellbore");
                    }
                    case MEDIUM: {
                        return this.pick("arbalest", "heavymortar", "shredder");
                    }
                    case SMALL: {
                        return this.pick("lightmg", "lightac", "lightmortar");
                    }
                }
                break;
            }
            case MISSILE: 
            case SYNERGY: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("hammerrack");
                    }
                    case MEDIUM: {
                        return this.pick("pilum", "annihilatorpod");
                    }
                    case SMALL: {
                        return this.pick("harpoon", "sabot", "annihilator");
                    }
                }
                break;
            }
            case ENERGY: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("autopulse", "hil");
                    }
                    case MEDIUM: {
                        return this.pick("miningblaster", "gravitonbeam", "pulselaser");
                    }
                    case SMALL: {
                        return this.pick("mininglaser", "taclaser", "pdlaser", "ioncannon");
                    }
                }
            }
        }
        return null;
    }

    public String pick(String ... strings) {
        return strings[new Random().nextInt(strings.length)];
    }

    public OnMessageDeliveryScript createSetMessageLocationScript(final SectorEntityToken entity) {
        return new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                if (entity != null && entity.getContainingLocation() instanceof StarSystemAPI) {
                    message.setStarSystemId(entity.getContainingLocation().getId());
                } else {
                    message.setStarSystemId(TutorialMissionEvent.this.system.getId());
                }
                message.setCenterMapOnEntity(entity);
            }
        };
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        TutorialMissionEvent.addPersonTokens(map, "mainContact", this.mainContact);
        if (this.dataContact != null) {
            TutorialMissionEvent.addPersonTokens(map, "dataContact", this.dataContact);
        }
        if (this.jangalaContact != null) {
            TutorialMissionEvent.addPersonTokens(map, "jangalaContact", this.jangalaContact);
        }
        map.put("$systemName", this.system.getNameWithLowercaseType());
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        if (!"posting".equals(stageId)) {
            "success".equals(stageId);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        return super.getHighlightColors(stageId);
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    @Override
    public String getEventName() {
        if (this.stage == TutorialMissionStage.INIT) {
            return "Contact " + this.mainContact.getPost() + " " + this.mainContact.getName().getLast();
        }
        if (this.stage == TutorialMissionStage.DELIVER_REPORT) {
            return "Deliver Report to Jangala";
        }
        if (this.stage == TutorialMissionStage.DONE) {
            return "Deliver Report to Jangala - completed";
        }
        return "Stabilize the Jump-points";
    }

    @Override
    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.MISSION;
    }

    @Override
    public String getEventIcon() {
        return Global.getSettings().getSpriteName("campaignMissions", "tutorial");
    }

    @Override
    public String getCurrentImage() {
        return this.ancyra.getFaction().getLogo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TutorialMissionStage {
        INIT,
        GO_GET_DATA,
        GOT_DATA,
        GO_GET_AI_CORE,
        GOT_AI_CORE,
        GO_RECOVER_SHIPS,
        RECOVERED_SHIPS,
        GO_STABILIZE,
        STABILIZED,
        DELIVER_REPORT,
        DONE;

    }
}

