/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialSustainedBurnDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected MarketAPI ancyra;

    public TutorialSustainedBurnDialogPluginImpl(MarketAPI ancyra) {
        this.ancyra = ancyra;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("Your fleet", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String name = this.ancyra.getName();
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph(String.valueOf(name) + " is pretty far away, and it'll take a while to get there at this rate.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("sustained_burn");
                this.textPanel.addPara("The %s ability is useful for long-distance travel. Activating it will briefly stop the fleet and reduce its acceleration to a minimum, but the maximum burn level will be much higher. A sustained burn can be interrupted by other fleets activating an interdiction pulse.", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                Global.getSector().getCharacterData().addAbility(ability.getId());
                PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
                slots.setCurrBarIndex(0);
                int slotIndex = 4;
                slots.getCurrSlotsCopy().get(slotIndex).setAbilityId(ability.getId());
                AddRemoveCommodity.addAbilityGainText(ability.getId(), this.textPanel);
                Global.getSector().getCharacterData().addAbility("interdiction_pulse");
                slots.getCurrSlotsCopy().get(6).setAbilityId("interdiction_pulse");
                AddRemoveCommodity.addAbilityGainText("interdiction_pulse", this.textPanel);
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("sustained_burn");
                String control = Global.getSettings().getControlStringForEnumName("FAST_FORWARD");
                this.textPanel.addPara("Activate %s to get to " + name + " more quickly.", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                this.textPanel.addPara("You can also press and hold %s to speed up time.", Misc.getHighlightColor(), "\"" + control + "\"");
                this.options.clearOptions();
                this.options.addOption("Finish", (Object)OptionId.CONT3, null);
                break;
            }
            case CONT3: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3;

    }
}

