/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamBuilder;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.impl.campaign.world.TTBlackSite;
import com.fs.starfarer.api.util.CollisionGridUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlipstreamManager
implements EveryFrameScript {
    public static int WIDTH = 21;
    public static int HEIGHT = 11;
    public static float MAP_WIDTH_PADDING = 8000.0f;
    public static float MAP_HEIGHT_PADDING = 5000.0f;
    public static Map<String, Float> STREAM_CONFIGS = new LinkedHashMap<String, Float>();
    protected transient CollisionGridUtil grid;
    protected IntervalUtil interval = new IntervalUtil(1.0f, 2.0f);
    protected Random random = new Random();
    protected int prevMonth = -1;
    protected int desiredNumStreams = 0;
    protected List<AddedStream> active = new ArrayList<AddedStream>();
    protected StreamConfig config;
    protected String prevConfig;

    static {
        SlipstreamManager.loadConfigs();
    }

    public static void loadConfigs() {
        STREAM_CONFIGS.put("aD?                 BC?                 EA                  c                                                      X                                                      d                  A!E?                CB!                 Db", Float.valueOf(10.0f));
        STREAM_CONFIGS.put("Ba   C         D   aB                                                                                             CXD                   e                                                                         A!bE              EbA", Float.valueOf(10.0f));
        STREAM_CONFIGS.put("A! D?            F? A                                          a                   a                     C!   DE   X   FG    C                     b                   b                                          B! E?            G? B", Float.valueOf(10.0f));
        STREAM_CONFIGS.put("C!   D!            cA                                                               A?                 aa          X         cB?                 bb                                          d             C      d                  DB", Float.valueOf(10.0f));
        STREAM_CONFIGS.put("B^!     I^?   H^? a G                        i         h                           g    A!|  H^G^?          C^<I   X              D^    E^?F^?    Fc  AB                                     b    d               C?          D?e   a E", Float.valueOf(10.0f));
        STREAM_CONFIGS.put("       b  a          A|~+0               A                     B|~+0               B      c          a             X                               C|!+0 d             C               b     D|~+0               D          d   c      ", Float.valueOf(10.0f));
        STREAM_CONFIGS.put("A*       B*         G    H*         g                h      H      b                 C*     A        G*            X         F     c       D         B     E*      e              d       f                       D*     C    F*      E", Float.valueOf(5.0f));
        String prev = (String)STREAM_CONFIGS.keySet().toArray()[STREAM_CONFIGS.size() - 1];
        STREAM_CONFIGS.put(SlipstreamManager.mirrorHorz(prev), Float.valueOf(5.0f));
        STREAM_CONFIGS.put(SlipstreamManager.mirrorVert(prev), Float.valueOf(5.0f));
        STREAM_CONFIGS.put(SlipstreamManager.mirrorHorz(SlipstreamManager.mirrorVert(prev)), Float.valueOf(5.0f));
    }

    public static void mirrorPrevVert(float weight) {
        String prev = (String)STREAM_CONFIGS.keySet().toArray()[STREAM_CONFIGS.size() - 1];
        STREAM_CONFIGS.put(SlipstreamManager.mirrorVert(prev), Float.valueOf(weight));
    }

    public static String mirrorVert(String in) {
        String out = "";
        int j = 0;
        while (j < HEIGHT) {
            out = String.valueOf(in.substring(j * WIDTH, (j + 1) * WIDTH)) + out;
            ++j;
        }
        return out;
    }

    public static void mirrorPrevHorz(float weight) {
        String prev = (String)STREAM_CONFIGS.keySet().toArray()[STREAM_CONFIGS.size() - 1];
        STREAM_CONFIGS.put(SlipstreamManager.mirrorHorz(prev), Float.valueOf(weight));
    }

    public static String mirrorHorz(String in) {
        String out = "";
        int j = 0;
        while (j < HEIGHT) {
            out = String.valueOf(out) + new StringBuilder(in.substring(j * WIDTH, (j + 1) * WIDTH)).reverse();
            ++j;
        }
        return out;
    }

    public static void validateConfigs() {
        for (String key : STREAM_CONFIGS.keySet()) {
            if (key.length() != WIDTH * HEIGHT) {
                throw new RuntimeException("Length of slipstream config not WIDTHxHEIGHT [" + key + "]");
            }
            try {
                new StreamConfig(key, null);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error parsing slipstream config [" + key + "]", t);
            }
        }
    }

    protected Object readResolve() {
        if (this.active == null) {
            this.active = new ArrayList<AddedStream>();
        }
        return this;
    }

    @Override
    public void advance(float amount) {
        if (DebugFlags.SLIPSTREAM_DEBUG) {
            this.random = Misc.random;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (DebugFlags.SLIPSTREAM_DEBUG) {
            days *= 100.0f;
        }
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            Iterator<AddedStream> iter = this.active.iterator();
            while (iter.hasNext()) {
                AddedStream curr = iter.next();
                if (curr.terrain.isAlive()) continue;
                iter.remove();
            }
            int month = Global.getSector().getClock().getMonth();
            if (month == 6 || month == 12) {
                for (AddedStream curr : this.active) {
                    if (curr.plugin.isDespawning()) continue;
                    float despawnDelay = 0.0f + this.random.nextFloat() * 20.0f;
                    float timeMinusDelay = 27.0f - despawnDelay;
                    float despawnDays = timeMinusDelay * 0.5f + this.random.nextFloat() * timeMinusDelay * 0.5f;
                    curr.plugin.despawn(despawnDelay, despawnDays, this.random);
                }
                if (this.config != null) {
                    this.prevConfig = this.config.data;
                }
                this.config = null;
            } else if (month != 6 && month != 12) {
                if (this.config == null) {
                    if (DebugFlags.SLIPSTREAM_DEBUG) {
                        STREAM_CONFIGS.clear();
                        SlipstreamManager.loadConfigs();
                    }
                    WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
                    for (String key : STREAM_CONFIGS.keySet()) {
                        if (this.prevConfig != null && this.prevConfig.equals(key) && STREAM_CONFIGS.size() > 1) continue;
                        picker.add(key, STREAM_CONFIGS.get(key).floatValue());
                    }
                    if (picker.isEmpty() && this.prevConfig != null) {
                        picker.add(this.prevConfig, 1.0f);
                    }
                    ListenerUtil.updateSlipstreamConfig(this.prevConfig, picker, this);
                    String data = picker.pick();
                    if (data != null) {
                        this.config = new StreamConfig(data, this.random);
                    }
                }
                this.addStream(month);
            }
            this.prevMonth = month;
        }
        this.grid = null;
    }

    public void addStream(int month) {
        Vector2f temp;
        StreamData data2;
        if (this.config == null) {
            return;
        }
        WeightedRandomPicker<StreamData> picker = new WeightedRandomPicker<StreamData>(this.random);
        for (StreamData data2 : this.config.streams) {
            if (data2.wasUsed || !data2.priority) continue;
            picker.add(data2);
        }
        if (picker.isEmpty()) {
            for (StreamData data2 : this.config.streams) {
                if (data2.wasUsed) continue;
                picker.add(data2);
            }
        }
        if ((data2 = (StreamData)picker.pick()) == null) {
            return;
        }
        SlipstreamTerrainPlugin2.SlipstreamParams2 params = new SlipstreamTerrainPlugin2.SlipstreamParams2();
        params.burnLevel = 30 + data2.burnMod;
        params.minSpeed = Misc.getSpeedForBurnLevel(params.burnLevel - 5);
        params.maxSpeed = Misc.getSpeedForBurnLevel(params.burnLevel + 5);
        params.lineLengthFractionOfSpeed = 0.25f * Math.max(0.25f, Math.min(1.0f, 30.0f / (float)params.burnLevel));
        Vector2f from = data2.generateP0(this.random);
        Vector2f to = data2.generateP1(this.random);
        Vector2f control = data2.generateControl(this.random);
        Vector2f control2 = data2.generateControl2(this.random);
        if (from == null || to == null) {
            return;
        }
        if (month == 12 || month < 6) {
            if (!data2.reverse && from.x > to.x || data2.reverse && from.x < to.x) {
                temp = to;
                to = from;
                from = temp;
            }
        } else if (!data2.reverse && from.x < to.x || data2.reverse && from.x > to.x) {
            temp = to;
            to = from;
            from = temp;
        }
        LocationAPI hyperspace = Global.getSector().getHyperspace();
        CampaignTerrainAPI slipstream = (CampaignTerrainAPI)hyperspace.addTerrain("slipstream", params);
        slipstream.setLocation(from.x, from.y);
        SlipstreamTerrainPlugin2 plugin = (SlipstreamTerrainPlugin2)slipstream.getPlugin();
        SlipstreamBuilder builder = new SlipstreamBuilder(slipstream.getLocation(), plugin, data2.type, this.random);
        if (data2.straight) {
            float mult = 0.25f;
            builder.setMaxAngleVariance(builder.getMaxAngleVariance() * mult);
            builder.setMaxAngleVarianceForCurve(builder.getMaxAngleVarianceForCurve() * mult);
        }
        if (control2 != null) {
            float dist1 = Misc.getDistance(from, control);
            float dist2 = Misc.getDistance(from, control2);
            if (dist2 < dist1) {
                Vector2f temp2 = control2;
                control2 = control;
                control = temp2;
            }
            builder.buildToDestination(control, control2, to);
        } else if (control != null) {
            builder.buildToDestination(control, to);
        } else {
            builder.buildToDestination(to);
        }
        this.checkIntersectionsAndFadeSections(plugin, data2.onlyKeepLongestSegment);
        if (plugin.getSegments().size() < 3) {
            hyperspace.removeEntity(slipstream);
            return;
        }
        float spawnDays = 1.0f + 2.0f * this.random.nextFloat();
        if (DebugFlags.SLIPSTREAM_DEBUG) {
            spawnDays = 0.0f;
        }
        plugin.spawn(spawnDays, this.random);
        plugin.recomputeEncounterPoints();
        AddedStream added = new AddedStream(plugin);
        this.active.add(added);
        data2.wasUsed = true;
    }

    public void checkIntersectionsAndFadeSections(SlipstreamTerrainPlugin2 plugin, boolean onlyKeepLongestBetweenStreams) {
        this.updateGrid();
        plugin.recomputeIfNeeded();
        List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments = plugin.getSegments();
        HashSet<SlipstreamTerrainPlugin2.SlipstreamSegment> otherStreamCuts = new HashSet<SlipstreamTerrainPlugin2.SlipstreamSegment>();
        for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : segments) {
            Iterator<Object> iter = this.grid.getCheckIterator(curr.loc, curr.width / 2.0f, curr.width / 2.0f);
            while (iter.hasNext()) {
                float fadeDistAlong;
                float minDistAlong;
                float distAlong;
                float distPerp;
                Object diff;
                Vector2f loc;
                Object obj = iter.next();
                if (obj instanceof JumpPointAPI) {
                    JumpPointAPI jp = (JumpPointAPI)obj;
                    loc = jp.getLocation();
                    float radius = jp.getRadius();
                    if (jp.getOrbitFocus() != null) {
                        loc = jp.getOrbitFocus().getLocation();
                        radius = Misc.getDistance(jp.getOrbitFocus(), jp) + jp.getRadius();
                    }
                    diff = Vector2f.sub((Vector2f)loc, (Vector2f)curr.loc, (Vector2f)new Vector2f());
                    distPerp = Math.abs(Vector2f.dot((Vector2f)curr.normal, (Vector2f)diff));
                    distAlong = Math.abs(Vector2f.dot((Vector2f)curr.dir, (Vector2f)diff));
                    distPerp -= radius;
                    distAlong -= radius;
                    minDistAlong = Math.max(curr.lengthToNext, curr.lengthToPrev);
                    fadeDistAlong = 500.0f + minDistAlong;
                    if (!(distPerp < curr.width / 2.0f) || !(distAlong < fadeDistAlong)) continue;
                    if (distAlong < minDistAlong) {
                        curr.fader.forceOut();
                        curr.bMult = 0.0f;
                        continue;
                    }
                    curr.bMult = Math.min(curr.bMult, (distAlong - minDistAlong) / (fadeDistAlong - minDistAlong));
                    continue;
                }
                if (obj instanceof CampaignTerrainAPI) {
                    CampaignTerrainAPI terrain = (CampaignTerrainAPI)obj;
                    SlipstreamTerrainPlugin2 otherPlugin = (SlipstreamTerrainPlugin2)terrain.getPlugin();
                    if (otherPlugin == plugin) continue;
                    for (SlipstreamTerrainPlugin2.SlipstreamSegment other : otherPlugin.getSegmentsNear(curr.loc, curr.width / 2.0f)) {
                        float minDist;
                        float fadeDist;
                        float dist;
                        if (other.bMult <= 0.0f || !((dist = Misc.getDistance(curr.loc, other.loc)) < (fadeDist = (minDist = curr.width / 2.0f + other.width / 2.0f) + 500.0f))) continue;
                        if (dist < minDist) {
                            curr.fader.forceOut();
                            curr.bMult = 0.0f;
                            otherStreamCuts.add(curr);
                            continue;
                        }
                        curr.bMult = Math.min(curr.bMult, (dist - minDist) / (fadeDist - minDist));
                    }
                    continue;
                }
                if (!(obj instanceof CustomStreamBlocker)) continue;
                CustomStreamBlocker blocker = (CustomStreamBlocker)obj;
                loc = blocker.loc;
                float radius = blocker.radius;
                diff = Vector2f.sub((Vector2f)loc, (Vector2f)curr.loc, (Vector2f)new Vector2f());
                distPerp = Math.abs(Vector2f.dot((Vector2f)curr.normal, (Vector2f)diff));
                distAlong = Math.abs(Vector2f.dot((Vector2f)curr.dir, (Vector2f)diff));
                distPerp -= radius;
                distAlong -= radius;
                minDistAlong = Math.max(curr.lengthToNext, curr.lengthToPrev);
                fadeDistAlong = 500.0f + minDistAlong;
                if (!(distPerp < curr.width / 2.0f) || !(distAlong < fadeDistAlong)) continue;
                if (distAlong < minDistAlong) {
                    curr.fader.forceOut();
                    curr.bMult = 0.0f;
                    continue;
                }
                curr.bMult = Math.min(curr.bMult, (distAlong - minDistAlong) / (fadeDistAlong - minDistAlong));
            }
        }
        SlipstreamManager.fadeOutSectionsShorterThan(segments, 5000.0f);
        SlipstreamManager.removedFadesThatDoNotReachZero(segments);
        if (onlyKeepLongestBetweenStreams) {
            ArrayList longest = new ArrayList();
            ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment> currList = new ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment>();
            for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : segments) {
                if (otherStreamCuts.contains(curr)) {
                    if (currList.size() > longest.size()) {
                        longest = currList;
                    }
                    currList = new ArrayList();
                }
                if (!(curr.bMult > 0.0f)) continue;
                currList.add(curr);
            }
            if (currList.size() > longest.size()) {
                longest = currList;
            }
            for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : segments) {
                if (longest.contains(curr)) continue;
                curr.bMult = 0.0f;
                curr.fader.forceOut();
            }
        }
    }

    public static void fadeOutSectionsShorterThan(List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments, float minLength) {
        float minRunLength = minLength;
        ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment> currRun = new ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment>();
        for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : segments) {
            if (curr.bMult <= 0.0f) {
                float runLength = 0.0f;
                for (SlipstreamTerrainPlugin2.SlipstreamSegment inRun : currRun) {
                    runLength += inRun.lengthToNext;
                }
                if (runLength < minRunLength) {
                    for (SlipstreamTerrainPlugin2.SlipstreamSegment inRun : currRun) {
                        inRun.fader.forceOut();
                        inRun.bMult = 0.0f;
                    }
                }
                currRun.clear();
                continue;
            }
            currRun.add(curr);
        }
    }

    public static void removedFadesThatDoNotReachZero(List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments) {
        ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment> currRun = new ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment>();
        boolean currRunReachedZero = false;
        for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : segments) {
            if (curr.bMult < 1.0f) {
                currRun.add(curr);
                if (!(curr.bMult <= 0.0f) && (curr.fader.getBrightness() != 0.0f || curr.fader.isFadingIn())) continue;
                currRunReachedZero = true;
                continue;
            }
            if (!currRunReachedZero) {
                for (SlipstreamTerrainPlugin2.SlipstreamSegment inRun : currRun) {
                    inRun.fader.fadeIn();
                    inRun.bMult = 1.0f;
                }
            }
            currRun.clear();
            currRunReachedZero = false;
        }
    }

    public CollisionGridUtil getGrid() {
        return this.grid;
    }

    public void updateGrid() {
        float size;
        if (this.grid != null) {
            return;
        }
        float sw = Global.getSettings().getFloat("sectorWidth");
        float sh = Global.getSettings().getFloat("sectorHeight");
        float minCellSize = 12000.0f;
        float cellSize = Math.max(minCellSize, sw * 0.05f);
        this.grid = new CollisionGridUtil(-sw / 2.0f, sw / 2.0f, -sh / 2.0f, sh / 2.0f, cellSize);
        LocationAPI hyperspace = Global.getSector().getHyperspace();
        for (SectorEntityToken jp : hyperspace.getJumpPoints()) {
            size = jp.getRadius() * 2.0f + 100.0f;
            this.grid.addObject(jp, jp.getLocation(), size * 2.0f, size * 2.0f);
        }
        Object alphaSiteWell = Global.getSector().getMemoryWithoutUpdate().get(TTBlackSite.NASCENT_WELL_KEY);
        if (alphaSiteWell instanceof NascentGravityWellAPI) {
            NascentGravityWellAPI well = (NascentGravityWellAPI)alphaSiteWell;
            size = 1000.0f + well.getRadius();
            CustomStreamBlocker blocker = new CustomStreamBlocker(well.getLocation(), size);
            this.grid.addObject(blocker, well.getLocation(), size * 2.0f, size * 2.0f);
        }
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (!system.hasTag("theme_core")) continue;
            Vector2f loc = system.getLocation();
            float size2 = 4000.0f;
            CustomStreamBlocker blocker = new CustomStreamBlocker(loc, size2);
            this.grid.addObject(blocker, loc, size2 * 2.0f, size2 * 2.0f);
        }
        int segmentsToSkip = (int)((cellSize - 2000.0f) / 400.0f);
        float checkSize = minCellSize - 2000.0f;
        for (CampaignTerrainAPI curr : hyperspace.getTerrainCopy()) {
            if (!(curr.getPlugin() instanceof SlipstreamTerrainPlugin2)) continue;
            SlipstreamTerrainPlugin2 plugin = (SlipstreamTerrainPlugin2)curr.getPlugin();
            List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments = plugin.getSegments();
            ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment> check = new ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment>();
            int i = 0;
            while (i < segments.size()) {
                check.add(segments.get(i));
                i += segmentsToSkip;
            }
            if (!check.contains(segments.get(segments.size() - 1))) {
                check.add(segments.get(segments.size() - 1));
            }
            for (SlipstreamTerrainPlugin2.SlipstreamSegment seg : check) {
                this.grid.addObject(curr, seg.loc, checkSize, checkSize);
            }
        }
        ListenerUtil.updateSlipstreamBlockers(this.grid, this);
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public static class AddedStream {
        public CampaignTerrainAPI terrain;
        public SlipstreamTerrainPlugin2 plugin;
        public Vector2f from;
        public Vector2f to;
        public Vector2f control;
        public long timestamp;

        public AddedStream(SlipstreamTerrainPlugin2 plugin) {
            this.plugin = plugin;
            this.terrain = (CampaignTerrainAPI)plugin.getEntity();
            this.from = new Vector2f((ReadableVector2f)plugin.getSegments().get((int)0).loc);
            this.to = new Vector2f((ReadableVector2f)plugin.getSegments().get((int)(plugin.getSegments().size() - 1)).loc);
            this.timestamp = Global.getSector().getClock().getTimestamp();
        }
    }

    public static class CustomStreamBlocker {
        public Vector2f loc;
        public float radius;

        public CustomStreamBlocker(Vector2f loc, float radius) {
            this.loc = new Vector2f((ReadableVector2f)loc);
            this.radius = radius;
        }
    }

    public static class CustomStreamRevealer
    extends CustomStreamBlocker {
        public CustomStreamRevealer(Vector2f loc, float radius) {
            super(loc, radius);
        }
    }

    public static class StreamConfig {
        public List<StreamData> streams = new ArrayList<StreamData>();
        public String data;

        public StreamConfig(String data, Random random) {
            this.data = data;
            LinkedHashSet<String> ids = new LinkedHashSet<String>();
            int i = 0;
            while (i < data.length()) {
                char c = data.charAt(i);
                if (c != 'X' && Character.isUpperCase(c)) {
                    ids.add("" + c);
                }
                ++i;
            }
            for (String id : ids) {
                StreamData curr = new StreamData(id);
                int i2 = 0;
                while (i2 < data.length()) {
                    char c = data.charAt(i2);
                    if (c != 'X') {
                        int cellX = i2 % WIDTH;
                        int cellY = HEIGHT - i2 / WIDTH - 1;
                        if (id.equals("" + c)) {
                            if (curr.p0x < 0) {
                                curr.p0x = cellX;
                                curr.p0y = cellY;
                            } else if (curr.p1x < 0) {
                                curr.p1x = cellX;
                                curr.p1y = cellY;
                            }
                        } else if (id.toLowerCase().equals("" + c)) {
                            if (curr.controlX < 0) {
                                curr.controlX = cellX;
                                curr.controlY = cellY;
                            } else {
                                curr.control2X = cellX;
                                curr.control2Y = cellY;
                            }
                        }
                        if (id.equals("" + c)) {
                            int j = i2 + 1;
                            while (j < data.length() && j < i2 + 10) {
                                int burnMod;
                                char c2 = data.charAt(j);
                                if (c2 == ' ' || Character.isAlphabetic(c2)) break;
                                if (c2 == '<') {
                                    curr.reverse = true;
                                } else if (c2 == '~') {
                                    curr.type = SlipstreamBuilder.StreamType.NARROW;
                                } else if (c2 == '=') {
                                    curr.type = SlipstreamBuilder.StreamType.WIDE;
                                } else if (c2 == '-') {
                                    burnMod = data.charAt(j + 1) - 48;
                                    if (burnMod == 0) {
                                        burnMod = 10;
                                    }
                                    curr.burnMod = -1 * burnMod;
                                } else if (c2 == '+') {
                                    burnMod = data.charAt(j + 1) - 48;
                                    if (burnMod == 0) {
                                        burnMod = 10;
                                    }
                                    curr.burnMod = burnMod;
                                } else if (c2 == '|') {
                                    curr.straight = true;
                                } else if (c2 == '!') {
                                    curr.priority = true;
                                } else if (c2 == '^') {
                                    curr.onlyKeepLongestSegment = true;
                                } else if (c2 == '*') {
                                    curr.randomize = true;
                                } else if (c2 == '?') {
                                    curr.minorRandomize = true;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i2;
                }
                if (curr.p0x < 0 && curr.p1x < 0) continue;
                if ((curr.randomize || curr.minorRandomize) && random != null) {
                    if (!curr.reverse && !curr.minorRandomize) {
                        boolean bl = curr.reverse = random.nextFloat() < 0.5f;
                    }
                    if (!curr.straight) {
                        boolean bl = curr.straight = random.nextFloat() < 0.25f;
                    }
                    if (curr.burnMod == 0) {
                        curr.burnMod = curr.minorRandomize ? random.nextInt(6) : random.nextInt(11);
                    }
                    if (curr.type == SlipstreamBuilder.StreamType.NORMAL) {
                        float r = random.nextFloat();
                        if (r < 0.2f) {
                            curr.type = SlipstreamBuilder.StreamType.NARROW;
                        } else if (r < 0.4f) {
                            curr.type = SlipstreamBuilder.StreamType.WIDE;
                        }
                    }
                }
                this.streams.add(curr);
            }
        }
    }

    public static class StreamData {
        public String id;
        public int p0x = -1;
        public int p0y = -1;
        public int p1x = -1;
        public int p1y = -1;
        public int controlX = -1;
        public int controlY = -1;
        public int control2X = -1;
        public int control2Y = -1;
        public int burnMod = 0;
        public boolean reverse = false;
        public SlipstreamBuilder.StreamType type = SlipstreamBuilder.StreamType.NORMAL;
        public boolean wasUsed = false;
        public boolean straight = false;
        public boolean priority = false;
        public boolean onlyKeepLongestSegment = false;
        public boolean randomize = false;
        public boolean minorRandomize = false;

        public StreamData(String id) {
            this.id = id;
        }

        public Vector2f generateP0(Random random) {
            if (this.p0x < 0) {
                return null;
            }
            return this.generate(this.p0x, this.p0y, random);
        }

        public Vector2f generateP1(Random random) {
            if (this.p1x < 0) {
                return null;
            }
            return this.generate(this.p1x, this.p1y, random);
        }

        public Vector2f generateControl(Random random) {
            if (this.controlX < 0) {
                return null;
            }
            return this.generate(this.controlX, this.controlY, random);
        }

        public Vector2f generateControl2(Random random) {
            if (this.control2X < 0) {
                return null;
            }
            return this.generate(this.control2X, this.control2Y, random);
        }

        public Vector2f generate(int cellX, int cellY, Random random) {
            float sw = Global.getSettings().getFloat("sectorWidth") - MAP_WIDTH_PADDING;
            float sh = Global.getSettings().getFloat("sectorHeight") - MAP_HEIGHT_PADDING;
            float cellWidth = sw / (float)WIDTH;
            float cellHeight = sh / (float)HEIGHT;
            Vector2f p = new Vector2f();
            float minX = -sw / 2.0f + cellWidth * (float)cellX;
            float maxX = -sw / 2.0f + cellWidth * (float)(cellX + 1);
            float minY = -sh / 2.0f + cellHeight * (float)cellY;
            float maxY = -sh / 2.0f + cellHeight * (float)(cellY + 1);
            p.x = minX + (maxX - minX) * random.nextFloat();
            p.y = minY + (maxY - minY) * random.nextFloat();
            return p;
        }
    }
}

