/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.CoreUITabListener;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamManager;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.CollisionGridUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamVisibilityManager
implements CoreUITabListener {
    public void reportAboutToOpenCoreTab(CoreUITabId tab, Object param) {
        if (tab == CoreUITabId.MAP) {
            HyperspaceTopographyEventIntel intel = HyperspaceTopographyEventIntel.get();
            if (intel != null) {
                intel.updateMarketDetectionRanges();
            }
            SlipstreamVisibilityManager.updateSlipstreamVisibility(null, 0.0f);
        }
    }

    public static void updateSlipstreamVisibility(Vector2f extraPoint, float extraRangeLY) {
        float sw = Global.getSettings().getFloat("sectorWidth");
        float sh = Global.getSettings().getFloat("sectorHeight");
        float minCellSize = 12000.0f;
        float cellSize = Math.max(minCellSize, sw * 0.05f);
        CollisionGridUtil grid = new CollisionGridUtil(-sw / 2.0f, sw / 2.0f, -sh / 2.0f, sh / 2.0f, cellSize);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || market.getContainingLocation() == null || !market.isPlayerOwned()) continue;
            float range = market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod").computeEffective(0.0f);
            if ((range *= Misc.getUnitsPerLightYear()) <= 0.0f) continue;
            Vector2f loc = market.getLocationInHyperspace();
            SlipstreamManager.CustomStreamRevealer revealer = new SlipstreamManager.CustomStreamRevealer(loc, range);
            grid.addObject(revealer, loc, range * 2.0f, range * 2.0f);
        }
        if (extraPoint != null && extraRangeLY > 0.0f) {
            float range = extraRangeLY * Misc.getUnitsPerLightYear();
            SlipstreamManager.CustomStreamRevealer revealer = new SlipstreamManager.CustomStreamRevealer(extraPoint, range);
            grid.addObject(revealer, extraPoint, range * 2.0f, range * 2.0f);
        }
        float maxDist = 0.0f;
        List<CampaignTerrainAPI> terrainList = Global.getSector().getHyperspace().getTerrainCopy();
        for (CampaignTerrainAPI terrain : terrainList) {
            SlipstreamTerrainPlugin2 stream;
            if (!(terrain.getPlugin() instanceof SlipstreamTerrainPlugin2) || (stream = (SlipstreamTerrainPlugin2)terrain.getPlugin()).isDynamic()) continue;
            block2: for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : stream.getSegments()) {
                if (curr.discovered) continue;
                Iterator<Object> iter = grid.getCheckIterator(curr.loc, curr.width / 2.0f, curr.width / 2.0f);
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof SlipstreamManager.CustomStreamRevealer)) continue;
                    SlipstreamManager.CustomStreamRevealer rev = (SlipstreamManager.CustomStreamRevealer)obj;
                    Vector2f loc = rev.loc;
                    float radius = rev.radius;
                    float dist = Misc.getDistance(loc, curr.loc);
                    if (dist > maxDist) {
                        maxDist = dist;
                    }
                    if (!(dist < radius)) continue;
                    curr.discovered = true;
                    continue block2;
                }
            }
        }
    }
}

