/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class AcausalDisruptorStats
extends BaseShipSystemScript {
    public static float ENERGY_DAM_PENALTY_MULT = 1.0f;
    public static float DISRUPTION_DUR = 1.0f;
    protected static float MIN_DISRUPTION_RANGE = 500.0f;
    public static final Color OVERLOAD_COLOR = new Color(255, 155, 255, 255);
    public static final Color JITTER_COLOR = new Color(255, 155, 255, 75);
    public static final Color JITTER_UNDER_COLOR = new Color(255, 155, 255, 155);

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        stats.getEnergyWeaponDamageMult().modifyMult(id, ENERGY_DAM_PENALTY_MULT);
        float jitterLevel = effectLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            jitterLevel *= jitterLevel;
        }
        float maxRangeBonus = 50.0f;
        float jitterRangeBonus = jitterLevel * maxRangeBonus;
        ship.setJitterUnder(this, JITTER_UNDER_COLOR, jitterLevel, 21, 0.0f, 3.0f + jitterRangeBonus);
        ship.setJitter(this, JITTER_COLOR, jitterLevel, 4, 0.0f, 0.0f + jitterRangeBonus);
        String targetKey = String.valueOf(ship.getId()) + "_acausal_target";
        Object foundTarget = Global.getCombatEngine().getCustomData().get(targetKey);
        if (state == ShipSystemStatsScript.State.IN) {
            ShipAPI target;
            if (foundTarget == null && (target = this.findTarget(ship)) != null) {
                Global.getCombatEngine().getCustomData().put(targetKey, target);
            }
        } else if (effectLevel >= 1.0f) {
            if (foundTarget instanceof ShipAPI) {
                ShipAPI target = (ShipAPI)foundTarget;
                if (target.getFluxTracker().isOverloadedOrVenting()) {
                    target = ship;
                }
                this.applyEffectToTarget(ship, target);
            }
        } else if (state == ShipSystemStatsScript.State.OUT && foundTarget != null) {
            Global.getCombatEngine().getCustomData().remove(targetKey);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getEnergyWeaponDamageMult().unmodify(id);
    }

    protected ShipAPI findTarget(ShipAPI ship) {
        float range = AcausalDisruptorStats.getMaxRange(ship);
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        ShipAPI target = ship.getShipTarget();
        if (ship.getShipAI() != null && ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.TARGET_FOR_SHIP_SYSTEM)) {
            target = (ShipAPI)ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.TARGET_FOR_SHIP_SYSTEM);
        }
        if (target != null) {
            float radSum;
            float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
            if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius())) {
                target = null;
            }
        } else {
            if (target == null || target.getOwner() == ship.getOwner()) {
                if (player) {
                    target = Misc.findClosestShipEnemyOf(ship, ship.getMouseTarget(), ShipAPI.HullSize.FIGHTER, range, true);
                } else {
                    Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
                    if (test instanceof ShipAPI) {
                        float radSum;
                        target = (ShipAPI)test;
                        float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
                        if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius())) {
                            target = null;
                        }
                    }
                }
            }
            if (target == null) {
                target = Misc.findClosestShipEnemyOf(ship, ship.getLocation(), ShipAPI.HullSize.FIGHTER, range, true);
            }
        }
        if (target == null || target.getFluxTracker().isOverloadedOrVenting()) {
            target = ship;
        }
        return target;
    }

    public static float getMaxRange(ShipAPI ship) {
        return ship.getMutableStats().getSystemRangeBonus().computeEffective(MIN_DISRUPTION_RANGE);
    }

    protected void applyEffectToTarget(ShipAPI ship, final ShipAPI target) {
        if (target.getFluxTracker().isOverloadedOrVenting()) {
            return;
        }
        if (target == ship) {
            return;
        }
        target.setOverloadColor(OVERLOAD_COLOR);
        target.getFluxTracker().beginOverloadWithTotalBaseDuration(DISRUPTION_DUR);
        if (target.getFluxTracker().showFloaty() || ship == Global.getCombatEngine().getPlayerShip() || target == Global.getCombatEngine().getPlayerShip()) {
            target.getFluxTracker().playOverloadSound();
            target.getFluxTracker().showOverloadFloatyIfNeeded("System Disruption!", OVERLOAD_COLOR, 4.0f, true);
        }
        Global.getCombatEngine().addPlugin(new BaseEveryFrameCombatPlugin(){

            @Override
            public void advance(float amount, List<InputEventAPI> events) {
                if (!target.getFluxTracker().isOverloadedOrVenting()) {
                    target.resetOverloadColor();
                    Global.getCombatEngine().removePlugin(this);
                }
            }
        });
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float percent = (1.0f - ENERGY_DAM_PENALTY_MULT) * 100.0f;
        if (index == 0 && percent > 0.0f) {
            return new ShipSystemStatsScript.StatusData(String.valueOf((int)percent) + "% less energy damage", false);
        }
        return null;
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        ShipAPI target = this.findTarget(ship);
        if (target != null && target != ship) {
            return "READY";
        }
        if ((target == null || target == ship) && ship.getShipTarget() != null) {
            return "OUT OF RANGE";
        }
        return "NO TARGET";
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        ShipAPI target = this.findTarget(ship);
        return target != null && target != ship;
    }
}

