/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.DamageListener;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.hullmods.ShardSpawner;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ChiralFigmentStats
extends BaseShipSystemScript {
    public static Map<String, String> FIGMENTS = new HashMap<String, String>();
    public static final Color JITTER_COLOR;
    public static final Color JITTER_UNDER_COLOR;
    public static float DAMAGE_TAKEN_MULT;
    public static float JITTER_PER_DAMAGE_DIVISOR;
    public static float JITTER_PER_DAMAGE_DECAY_SECONDS;

    static {
        FIGMENTS.put("shard_left_Attack", "shard_right_Attack");
        FIGMENTS.put("shard_left_Attack2", "shard_right_Attack");
        FIGMENTS.put("shard_right_Attack", "shard_left_Attack");
        FIGMENTS.put("shard_left_Armorbreaker", "shard_right_Attack");
        FIGMENTS.put("shard_left_Shieldbreaker", "shard_right_Shieldbreaker");
        FIGMENTS.put("shard_right_Shieldbreaker", "shard_left_Shieldbreaker");
        FIGMENTS.put("shard_left_Defense", "shard_right_Shock");
        FIGMENTS.put("shard_right_Shock", "shard_left_Defense");
        FIGMENTS.put("shard_left_Missile", "shard_right_Missile");
        FIGMENTS.put("shard_right_Missile", "shard_left_Missile");
        JITTER_COLOR = ShardSpawner.JITTER_COLOR;
        JITTER_UNDER_COLOR = Misc.setAlpha(JITTER_COLOR, 155);
        DAMAGE_TAKEN_MULT = 1.0f;
        JITTER_PER_DAMAGE_DIVISOR = 100.0f;
        JITTER_PER_DAMAGE_DECAY_SECONDS = 1.0f;
    }

    public static float getSpawnAngle(ShipAPI ship) {
        String variant = FIGMENTS.get(ship.getVariant().getHullVariantId());
        if (ship.getVariant().getOriginalVariant() != null && variant == null) {
            variant = FIGMENTS.get(ship.getVariant().getOriginalVariant());
        }
        if (variant != null && variant.contains("_left")) {
            return 90.0f;
        }
        return -90.0f;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        block6: {
            ShipAPI ship = null;
            if (!(stats.getEntity() instanceof ShipAPI)) {
                return;
            }
            ship = (ShipAPI)stats.getEntity();
            float jitterLevel = effectLevel;
            if (state == ShipSystemStatsScript.State.OUT) {
                jitterLevel *= jitterLevel;
            }
            float maxRangeBonus = 25.0f;
            float jitterRangeBonus = jitterLevel * maxRangeBonus;
            ship.setJitterUnder(this, JITTER_UNDER_COLOR, jitterLevel, 11, 0.0f, 3.0f + jitterRangeBonus);
            ship.setJitter(this, JITTER_COLOR, jitterLevel, 4, 0.0f, 0.0f + jitterRangeBonus);
            if (state == ShipSystemStatsScript.State.IN) break block6;
            if (effectLevel >= 1.0f) {
                String variant = FIGMENTS.get(ship.getVariant().getHullVariantId());
                if (ship.getVariant().getOriginalVariant() != null && variant == null) {
                    variant = FIGMENTS.get(ship.getVariant().getOriginalVariant());
                }
                if (variant != null) {
                    float angle = ChiralFigmentStats.getSpawnAngle(ship);
                    float dist = ship.getCollisionRadius() * 1.25f;
                    Vector2f loc = Misc.getUnitVectorAtDegreeAngle(ship.getFacing() + angle);
                    loc.scale(dist);
                    Vector2f.add((Vector2f)loc, (Vector2f)ship.getLocation(), (Vector2f)loc);
                    if (this.isLocationClear(ship, loc, dist / 2.0f)) {
                        FigmentPlugin figment = new FigmentPlugin(variant, ship, 1.0f, 20.0f, loc);
                        Global.getCombatEngine().addPlugin(figment);
                    }
                }
            }
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    private boolean isLocationClear(ShipAPI ship, Vector2f loc, float minDist) {
        for (ShipAPI shipAPI : Global.getCombatEngine().getShips()) {
            float r;
            if (shipAPI.isShuttlePod() || shipAPI.isFighter() || shipAPI == ship) continue;
            Vector2f otherLoc = shipAPI.getShieldCenterEvenIfNoShield();
            float otherR = shipAPI.getShieldRadiusEvenIfNoShield();
            float dist = Misc.getDistance(loc, otherLoc);
            if (!(dist < (r = otherR) + minDist)) continue;
            return false;
        }
        for (CombatEntityAPI combatEntityAPI : Global.getCombatEngine().getAsteroids()) {
            float dist = Misc.getDistance(loc, combatEntityAPI.getLocation());
            if (!(dist < combatEntityAPI.getCollisionRadius() + minDist)) continue;
            return false;
        }
        return true;
    }

    public static class FigmentDamageListener
    implements DamageListener {
        public FigmentPlugin plugin;

        public FigmentDamageListener(FigmentPlugin plugin) {
            this.plugin = plugin;
        }

        public void reportDamageApplied(Object source, CombatEntityAPI target, ApplyDamageResultAPI result) {
            float totalDamage = result.getDamageToHull() + result.getDamageToShields() + result.getTotalDamageToArmor();
            float max = 1.0f;
            if (result.isDps()) {
                max = 0.1f;
            }
            this.plugin.recentHits += Math.min(max, totalDamage / 10.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FigmentPlugin
    extends BaseEveryFrameCombatPlugin {
        float elapsed = 0.0f;
        ShipAPI[] ships = null;
        CollisionClass collisionClass;
        String variantId;
        ShipAPI source;
        float fadeInTime;
        Vector2f loc;
        float dur;
        boolean finishedFadingIn = false;
        float recentHits = 0.0f;

        public FigmentPlugin(String variantId, ShipAPI source, float fadeInTime, float dur, Vector2f loc) {
            this.variantId = variantId;
            this.source = source;
            this.fadeInTime = fadeInTime;
            this.dur = dur;
            this.loc = loc;
        }

        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            ShipAPI ship;
            int i;
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            this.elapsed += amount;
            CombatEngineAPI engine = Global.getCombatEngine();
            if (this.ships == null) {
                float facing = this.source.getFacing() + 15.0f * ((float)Math.random() - 0.5f);
                CombatFleetManagerAPI fleetManager = engine.getFleetManager(this.source.getOriginalOwner());
                boolean wasSuppressed = fleetManager.isSuppressDeploymentMessages();
                fleetManager.setSuppressDeploymentMessages(true);
                if (this.variantId.endsWith("_wing")) {
                    FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(this.variantId);
                    this.ships = new ShipAPI[spec.getNumFighters()];
                    PersonAPI captain = Global.getSettings().createPerson();
                    captain.setPersonality("reckless");
                    captain.getStats().setSkillLevel("point_defense", 2.0f);
                    captain.getStats().setSkillLevel("gunnery_implants", 2.0f);
                    captain.getStats().setSkillLevel("impact_mitigation", 2.0f);
                    ShipAPI leader = engine.getFleetManager(this.source.getOriginalOwner()).spawnShipOrWing(this.variantId, this.loc, facing, 0.0f, captain);
                    int i2 = 0;
                    while (i2 < this.ships.length) {
                        this.ships[i2] = leader.getWing().getWingMembers().get(i2);
                        this.ships[i2].getLocation().set((ReadableVector2f)this.loc);
                        ++i2;
                    }
                    this.collisionClass = this.ships[0].getCollisionClass();
                } else {
                    this.ships = new ShipAPI[1];
                    this.ships[0] = engine.getFleetManager(this.source.getOriginalOwner()).spawnShipOrWing(this.variantId, this.loc, facing, 0.0f, this.source.getOriginalCaptain());
                }
                fleetManager.setSuppressDeploymentMessages(wasSuppressed);
                this.collisionClass = this.ships[0].getCollisionClass();
            }
            float progress = this.elapsed / this.fadeInTime;
            float maxAlpha = 0.67f;
            if (progress <= 1.0f) {
                i = 0;
                while (i < this.ships.length) {
                    ship = this.ships[i];
                    ship.setAlphaMult(progress * maxAlpha);
                    if (progress < 0.5f) {
                        ship.blockCommandForOneFrame(ShipCommand.ACCELERATE);
                        ship.blockCommandForOneFrame(ShipCommand.TURN_LEFT);
                        ship.blockCommandForOneFrame(ShipCommand.TURN_RIGHT);
                        ship.blockCommandForOneFrame(ShipCommand.STRAFE_LEFT);
                        ship.blockCommandForOneFrame(ShipCommand.STRAFE_RIGHT);
                    }
                    ship.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
                    ship.blockCommandForOneFrame(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK);
                    ship.blockCommandForOneFrame(ShipCommand.FIRE);
                    ship.blockCommandForOneFrame(ShipCommand.PULL_BACK_FIGHTERS);
                    ship.blockCommandForOneFrame(ShipCommand.VENT_FLUX);
                    ship.setHoldFireOneFrame(true);
                    ship.setHoldFire(true);
                    ship.setCollisionClass(CollisionClass.NONE);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("FigmentInvuln", 0.0f);
                    if (progress < 0.5f) {
                        ship.getVelocity().set((ReadableVector2f)this.source.getVelocity());
                    } else if (progress > 0.75f) {
                        ship.setCollisionClass(this.collisionClass);
                        ship.getMutableStats().getHullDamageTakenMult().unmodifyMult("FigmentInvuln");
                    }
                    float jitterLevel = progress;
                    float jitterRange = 1.0f - progress * 0.5f;
                    float maxRangeBonus = 50.0f;
                    float jitterRangeBonus = jitterRange * (maxRangeBonus -= 30.0f * progress);
                    Color c = JITTER_COLOR;
                    float num = 18.0f * (1.0f - progress * progress) + 7.0f;
                    ship.setJitter(this, c, jitterLevel, Math.round(num), 0.0f, jitterRangeBonus);
                    ++i;
                }
            }
            if (this.elapsed > this.fadeInTime && !this.finishedFadingIn) {
                i = 0;
                while (i < this.ships.length) {
                    ship = this.ships[i];
                    ship.setAlphaMult(maxAlpha);
                    ship.setHoldFire(false);
                    ship.setCollisionClass(this.collisionClass);
                    ship.getMutableStats().getHullDamageTakenMult().unmodifyMult("FigmentInvuln");
                    DAMAGE_TAKEN_MULT = 1.0f;
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("FigmentExtraDamage", DAMAGE_TAKEN_MULT);
                    ship.getMutableStats().getShieldDamageTakenMult().modifyMult("FigmentExtraDamage", DAMAGE_TAKEN_MULT);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("FigmentExtraDamage", DAMAGE_TAKEN_MULT);
                    ship.addListener(new FigmentDamageListener(this));
                    ++i;
                }
                this.finishedFadingIn = true;
            }
            if (this.elapsed > this.fadeInTime) {
                i = 0;
                while (i < this.ships.length) {
                    ship = this.ships[i];
                    if (!ship.isAlive() || !engine.isInPlay(ship)) {
                        engine.removePlugin(this);
                        return;
                    }
                    ship.setAlphaMult(maxAlpha);
                    ship.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
                    ship.blockCommandForOneFrame(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK);
                    float minus = this.recentHits * amount * 2.0f;
                    this.recentHits -= (minus += 0.1f * amount);
                    if (this.recentHits < 0.0f) {
                        this.recentHits = 0.0f;
                    }
                    if (this.recentHits > 5.0f) {
                        this.recentHits = 5.0f;
                    }
                    float jitterLevel = 1.0f;
                    float jitterRange = 0.5f;
                    float maxRangeBonus = 50.0f;
                    maxRangeBonus = 20.0f;
                    float jitterRangeBonus = jitterRange * (maxRangeBonus += this.recentHits * 40.0f);
                    Color c = JITTER_COLOR;
                    float numCopies = 7.0f;
                    ship.setJitter(this, c, jitterLevel, Math.round(numCopies += this.recentHits * 2.0f), 0.0f, jitterRangeBonus);
                    ++i;
                }
            }
        }
    }
}

