/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class NeuralTransferVisual
extends BaseCombatLayeredRenderingPlugin {
    public static float TEX_SCROLL_SPEED = 1.0f;
    protected ShipAPI from;
    protected ShipAPI to;
    protected float duration;
    protected FaderUtil fader = new FaderUtil(0.0f, 0.5f, 0.5f);
    protected SpriteAPI sprite;
    protected float texProgress = 0.0f;

    public NeuralTransferVisual(ShipAPI from, ShipAPI to, float duration) {
        this.from = from;
        this.to = to;
        this.duration = duration;
        this.sprite = Global.getSettings().getSprite("misc", "neural_transfer_beam");
        this.fader.fadeIn();
    }

    public void advance(float amount) {
        super.advance(amount);
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.entity.getLocation().set((ReadableVector2f)this.to.getShieldCenterEvenIfNoShield());
        this.fader.advance(amount);
        this.duration -= amount;
        if (!this.fader.isFadingOut() && this.duration <= 0.0f) {
            this.fader.fadeOut();
        }
        this.texProgress -= TEX_SCROLL_SPEED * amount * 2.0f;
    }

    public float getRenderRadius() {
        return this.to.getShieldRadiusEvenIfNoShield() * 3.0f + 200.0f;
    }

    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
        float length1 = 500.0f;
        length1 = Math.min(length1, Misc.getDistance(this.from.getLocation(), this.to.getLocation()));
        float length2 = this.to.getShieldRadiusEvenIfNoShield();
        if (length1 < length2) {
            length1 = length2;
        }
        length1 += length2;
        float w1 = this.to.getShieldRadiusEvenIfNoShield() * 0.3f;
        float w2 = this.to.getShieldRadiusEvenIfNoShield() * 1.5f;
        float w3 = this.to.getShieldRadiusEvenIfNoShield() * 2.5f;
        float wMult = 0.33f;
        w1 *= wMult;
        w2 *= wMult;
        w3 *= wMult;
        float angle = Misc.getAngleInDegrees(this.from.getLocation(), this.to.getLocation());
        Vector2f dest = new Vector2f((ReadableVector2f)this.to.getShieldCenterEvenIfNoShield());
        Vector2f src = Misc.getUnitVectorAtDegreeAngle(angle + 180.0f);
        src.scale(length1 - length2 / 2.0f);
        Vector2f.add((Vector2f)src, (Vector2f)dest, (Vector2f)src);
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
        Vector2f dest2 = new Vector2f((ReadableVector2f)dir);
        dest2.scale(length2 / 3.0f * 1.0f);
        Vector2f.add((Vector2f)dest2, (Vector2f)dest, (Vector2f)dest2);
        Vector2f dest1 = new Vector2f((ReadableVector2f)dir);
        dest1.scale(-length2 / 3.0f * 2.0f);
        Vector2f.add((Vector2f)dest1, (Vector2f)dest, (Vector2f)dest1);
        Vector2f perp = Misc.getUnitVectorAtDegreeAngle(angle + 90.0f);
        GL11.glEnable((int)3553);
        this.sprite.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        Color color = new Color(0, 121, 216, 255);
        boolean wireframe = false;
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)3553);
        }
        float alpha = (float)((double)viewport.getAlphaMult() * Math.sqrt(this.fader.getBrightness()));
        alpha *= 0.5f;
        GL11.glBegin((int)6);
        Misc.setColor(color, (alpha *= 0.5f + Math.min(0.5f, 0.5f * w2 / 360.0f)) * 1.0f);
        GL11.glTexCoord2f((float)(0.5f + this.texProgress), (float)0.5f);
        GL11.glVertex2f((float)((src.x + dest1.x) / 2.0f), (float)((src.y + dest1.y) / 2.0f));
        Misc.setColor(color, alpha * 0.0f);
        GL11.glTexCoord2f((float)(0.0f + this.texProgress), (float)0.0f);
        GL11.glVertex2f((float)(src.x + perp.x * w1 / 2.0f), (float)(src.y + perp.y * w1 / 2.0f));
        GL11.glTexCoord2f((float)(0.0f + this.texProgress), (float)1.0f);
        GL11.glVertex2f((float)(src.x - perp.x * w1 / 2.0f), (float)(src.y - perp.y * w1 / 2.0f));
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(1.0f + this.texProgress), (float)1.0f);
        GL11.glVertex2f((float)(dest1.x - perp.x * w2 / 2.0f), (float)(dest1.y - perp.y * w2 / 2.0f));
        GL11.glTexCoord2f((float)(1.0f + this.texProgress), (float)0.0f);
        GL11.glVertex2f((float)(dest1.x + perp.x * w2 / 2.0f), (float)(dest1.y + perp.y * w2 / 2.0f));
        Misc.setColor(color, alpha * 0.0f);
        GL11.glTexCoord2f((float)(0.0f + this.texProgress), (float)0.0f);
        GL11.glVertex2f((float)(src.x + perp.x * w1 / 2.0f), (float)(src.y + perp.y * w1 / 2.0f));
        GL11.glEnd();
        float th = length2 / length1;
        GL11.glBegin((int)6);
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(0.5f + this.texProgress + th), (float)0.5f);
        GL11.glVertex2f((float)((dest1.x + dest2.x) / 2.0f), (float)((dest1.y + dest2.y) / 2.0f));
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(0.0f + this.texProgress), (float)0.0f);
        GL11.glVertex2f((float)(dest1.x + perp.x * w2 / 2.0f), (float)(dest1.y + perp.y * w2 / 2.0f));
        GL11.glTexCoord2f((float)(0.0f + this.texProgress), (float)1.0f);
        GL11.glVertex2f((float)(dest1.x - perp.x * w2 / 2.0f), (float)(dest1.y - perp.y * w2 / 2.0f));
        Misc.setColor(color, alpha * 0.0f);
        GL11.glTexCoord2f((float)(1.0f + this.texProgress + th), (float)1.0f);
        GL11.glVertex2f((float)(dest2.x - perp.x * w3 / 2.0f), (float)(dest2.y - perp.y * w3 / 2.0f));
        GL11.glTexCoord2f((float)(1.0f + this.texProgress + th), (float)0.0f);
        GL11.glVertex2f((float)(dest2.x + perp.x * w3 / 2.0f), (float)(dest2.y + perp.y * w3 / 2.0f));
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(0.0f + this.texProgress + th), (float)0.0f);
        GL11.glVertex2f((float)(dest1.x + perp.x * w2 / 2.0f), (float)(dest1.y + perp.y * w2 / 2.0f));
        GL11.glEnd();
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    public boolean isExpired() {
        return this.fader.isFadedOut() && this.duration <= 0.0f;
    }
}

