/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;

public class PlasmaJetsStats
extends BaseShipSystemScript {
    public static float SPEED_BONUS = 125.0f;
    public static float TURN_BONUS = 20.0f;
    private Color color = new Color(100, 255, 100, 255);

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getMaxSpeed().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        } else {
            stats.getMaxSpeed().modifyFlat(id, SPEED_BONUS);
            stats.getAcceleration().modifyPercent(id, SPEED_BONUS * 3.0f * effectLevel);
            stats.getDeceleration().modifyPercent(id, SPEED_BONUS * 3.0f * effectLevel);
            stats.getTurnAcceleration().modifyFlat(id, TURN_BONUS * effectLevel);
            stats.getTurnAcceleration().modifyPercent(id, TURN_BONUS * 5.0f * effectLevel);
            stats.getMaxTurnRate().modifyFlat(id, 15.0f);
            stats.getMaxTurnRate().modifyPercent(id, 100.0f);
        }
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            ship.getEngineController().fadeToOtherColor(this, this.color, new Color(0, 0, 0, 0), effectLevel, 0.67f);
            ship.getEngineController().extendFlame(this, 2.0f * effectLevel, 0.0f * effectLevel, 0.0f * effectLevel);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("improved maneuverability", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("+" + (int)SPEED_BONUS + " top speed", false);
        }
        return null;
    }
}

