/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecallDeviceStats
extends BaseShipSystemScript {
    public static final Object KEY_JITTER = new Object();
    public static final Color JITTER_COLOR = new Color(100, 165, 255, 155);

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        if (effectLevel > 0.0f) {
            float jitterLevel = effectLevel;
            boolean firstTime = false;
            String fightersKey = String.valueOf(ship.getId()) + "_recall_device_target";
            ArrayList fighters = null;
            if (!Global.getCombatEngine().getCustomData().containsKey(fightersKey)) {
                fighters = RecallDeviceStats.getFighters(ship);
                Global.getCombatEngine().getCustomData().put(fightersKey, fighters);
                firstTime = true;
            } else {
                fighters = (ArrayList)Global.getCombatEngine().getCustomData().get(fightersKey);
            }
            if (fighters == null) {
                fighters = new ArrayList();
            }
            for (ShipAPI fighter : fighters) {
                if (fighter.isHulk()) continue;
                float maxRangeBonus = fighter.getCollisionRadius() * 1.0f;
                float jitterRangeBonus = 5.0f + jitterLevel * maxRangeBonus;
                if (firstTime) {
                    Global.getSoundPlayer().playSound("system_phase_skimmer", 1.0f, 0.5f, fighter.getLocation(), fighter.getVelocity());
                }
                fighter.setJitter(KEY_JITTER, JITTER_COLOR, jitterLevel, 10, 0.0f, jitterRangeBonus);
                if (fighter.isAlive()) {
                    fighter.setPhased(true);
                }
                if (state == ShipSystemStatsScript.State.IN) {
                    float alpha = 1.0f - effectLevel * 0.5f;
                    fighter.setExtraAlphaMult(alpha);
                }
                if (effectLevel != 1.0f) continue;
                if (fighter.getWing() != null && fighter.getWing().getSource() != null) {
                    fighter.getWing().getSource().makeCurrentIntervalFast();
                    fighter.getWing().getSource().land(fighter);
                    continue;
                }
                fighter.setExtraAlphaMult(1.0f);
            }
        }
    }

    public static List<ShipAPI> getFighters(ShipAPI carrier) {
        ArrayList<ShipAPI> result = new ArrayList<ShipAPI>();
        for (ShipAPI ship : Global.getCombatEngine().getShips()) {
            if (!ship.isFighter() || ship.getWing() == null || ship.getWing().getSourceShip() != carrier) continue;
            result.add(ship);
        }
        return result;
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        String fightersKey = String.valueOf(ship.getId()) + "_recall_device_target";
        Global.getCombatEngine().getCustomData().remove(fightersKey);
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }
}

