/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class RiftBeamEffect
implements EveryFrameWeaponEffectPlugin {
    public static float TARGET_RANGE = 100.0f;
    public static float RIFT_RANGE = 50.0f;
    protected IntervalUtil interval = new IntervalUtil(0.8f, 1.2f);

    public RiftBeamEffect() {
        this.interval.setElapsed((float)Math.random() * this.interval.getIntervalDuration());
    }

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        List<BeamAPI> beams = weapon.getBeams();
        if (beams.isEmpty()) {
            return;
        }
        BeamAPI beam = beams.get(0);
        if (beam.getBrightness() < 1.0f) {
            return;
        }
        this.interval.advance(amount * 2.0f);
        if (this.interval.intervalElapsed()) {
            if (beam.getLengthPrevFrame() < 10.0f) {
                return;
            }
            CombatEntityAPI target = this.findTarget(beam, beam.getWeapon(), engine);
            Vector2f loc = target == null ? this.pickNoTargetDest(beam, beam.getWeapon(), engine) : target.getLocation();
            Vector2f from = Misc.closestPointOnSegmentToPoint(beam.getFrom(), beam.getRayEndPrevFrame(), loc);
            Vector2f to = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(from, loc));
            to.scale(Math.min(Misc.getDistance(from, loc), RIFT_RANGE));
            Vector2f.add((Vector2f)from, (Vector2f)to, (Vector2f)to);
            this.spawnMine(beam.getSource(), to);
        }
    }

    public void spawnMine(ShipAPI source, Vector2f mineLoc) {
        CombatEngineAPI engine = Global.getCombatEngine();
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, "riftbeam_minelayer", mineLoc, (float)Math.random() * 360.0f, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, mine.getDamage());
        }
        float fadeInTime = 0.05f;
        mine.getVelocity().scale(0.0f);
        mine.fadeOutThenIn(fadeInTime);
        float liveTime = 0.0f;
        mine.setFlightTime(mine.getMaxFlightTime() - liveTime);
        mine.addDamagedAlready(source);
        mine.setNoMineFFConcerns(true);
    }

    public Vector2f pickNoTargetDest(BeamAPI beam, WeaponAPI weapon, CombatEngineAPI engine) {
        Vector2f from = beam.getFrom();
        Vector2f to = beam.getRayEndPrevFrame();
        float length = beam.getLengthPrevFrame();
        float f = 0.25f + (float)Math.random() * 0.75f;
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(from, to));
        loc.scale(length * f);
        Vector2f.add((Vector2f)from, (Vector2f)loc, (Vector2f)loc);
        return Misc.getPointWithinRadius(loc, RIFT_RANGE);
    }

    public CombatEntityAPI findTarget(BeamAPI beam, WeaponAPI weapon, CombatEngineAPI engine) {
        Vector2f to = beam.getRayEndPrevFrame();
        Iterator<Object> iter = Global.getCombatEngine().getAllObjectGrid().getCheckIterator(to, RIFT_RANGE * 2.0f, RIFT_RANGE * 2.0f);
        int owner = weapon.getShip().getOwner();
        WeightedRandomPicker<CombatEntityAPI> picker = new WeightedRandomPicker<CombatEntityAPI>();
        while (iter.hasNext()) {
            ShipAPI ship;
            CombatEntityAPI other;
            Object o = iter.next();
            if (!(o instanceof MissileAPI) && !(o instanceof ShipAPI) || (other = (CombatEntityAPI)o).getOwner() == owner || other instanceof ShipAPI && !(ship = (ShipAPI)other).isFighter() && !ship.isDrone()) continue;
            float radius = Misc.getTargetingRadius(to, other, false);
            Vector2f p = Misc.closestPointOnSegmentToPoint(beam.getFrom(), beam.getRayEndPrevFrame(), other.getLocation());
            float dist = Misc.getDistance(p, other.getLocation()) - radius;
            if (dist > TARGET_RANGE) continue;
            picker.add(other);
        }
        return (CombatEntityAPI)picker.pick();
    }
}

