/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.BattleObjectiveEffect;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.ElectronicWarfareScript;
import com.fs.starfarer.api.impl.combat.BaseBattleObjectiveEffect;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorArrayEffect
extends BaseBattleObjectiveEffect {
    public static final float SENSOR_ARRAY_FOG_LIFT_RADIUS = 999.0f;
    private List<BattleObjectiveEffect.ShipStatusItem> items = new ArrayList<BattleObjectiveEffect.ShipStatusItem>();
    private String id;

    @Override
    public void init(CombatEngineAPI engine, BattleObjectiveAPI objective) {
        super.init(engine, objective);
        this.id = "sensor_array_boost_" + objective.toString();
    }

    @Override
    public void advance(float amount) {
        this.revealArea(999.0f);
    }

    @Override
    public String getLongDescription() {
        float min = Global.getSettings().getFloat("minFractionOfBattleSizeForSmallerSide");
        int total = Global.getSettings().getBattleSize();
        int maxPoints = Math.round((float)total * (1.0f - min));
        return String.format("+%d%% ECM rating\nreduces weapon range for\nside with lower ECM rating\n%d%% maximum reduction\n\n+%d bonus deployment points\nup to a maximum of " + maxPoints + " points", (int)ElectronicWarfareScript.PER_JAMMER, (int)ElectronicWarfareScript.BASE_MAXIMUM, this.getBonusDeploymentPoints());
    }

    @Override
    public List<BattleObjectiveEffect.ShipStatusItem> getStatusItemsFor(ShipAPI ship) {
        return null;
    }
}

