/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;

public class BaseLogisticsHullMod
extends BaseHullMod {
    public static int MAX_MODS = Global.getSettings().getInt("maxLogisticsHullmods");

    public int getMax(ShipAPI ship) {
        return Math.round(ship.getMutableStats().getDynamic().getMod("max_logistics_hullmods_mod").computeEffective(MAX_MODS));
    }

    public String getUnapplicableReason(ShipAPI ship) {
        int max;
        boolean has = this.spec != null && ship.getVariant().hasHullMod(this.spec.getId());
        int num = this.getNumLogisticsMods(ship);
        if (has) {
            --num;
        }
        if (num >= (max = this.getMax(ship))) {
            String text = "many";
            if (max == 1) {
                text = "one";
            } else if (max == 2) {
                text = "two";
            } else if (max == 3) {
                text = "three";
            } else if (max == 4) {
                text = "four";
            }
            text = "" + max;
            if (max == MAX_MODS) {
                return "Maximum of " + text + " non-built-in \"Logistics\" hullmods per hull";
            }
            return "Maximum of " + text + " non-built-in \"Logistics\" hullmods for this hull";
        }
        return super.getUnapplicableReason(ship);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        int max;
        boolean has = this.spec != null && ship.getVariant().hasHullMod(this.spec.getId());
        int num = this.getNumLogisticsMods(ship);
        if (has) {
            --num;
        }
        if (num >= (max = this.getMax(ship))) {
            return false;
        }
        return super.isApplicableToShip(ship);
    }

    protected int getNumLogisticsMods(ShipAPI ship) {
        int num = 0;
        for (String id : ship.getVariant().getHullMods()) {
            HullModSpecAPI mod;
            if (ship.getHullSpec().isBuiltInMod(id) || ship.getVariant().getPermaMods().contains(id) || !(mod = Global.getSettings().getHullModSpec(id)).hasUITag("Logistics")) continue;
            ++num;
        }
        return num;
    }
}

