/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.CompromisedStructure;

public class DamagedWeaponMounts
extends BaseHullMod {
    public static float ROTATE_MULT = 0.75f;
    public static float RECOIL_PERCENT = 30.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float effect = stats.getDynamic().getValue("dmod_effect_mult");
        float rotMult = ROTATE_MULT + (1.0f - ROTATE_MULT) * (1.0f - effect);
        stats.getWeaponTurnRateBonus().modifyMult(id, rotMult);
        stats.getBeamWeaponTurnRateBonus().modifyMult(id, rotMult);
        stats.getMaxRecoilMult().modifyPercent(id, RECOIL_PERCENT * effect);
        stats.getRecoilPerShotMult().modifyPercent(id, RECOIL_PERCENT * effect);
        CompromisedStructure.modifyCost(hullSize, stats, id);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float effect = 1.0f;
        if (ship != null) {
            effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        }
        float rotMult = ROTATE_MULT + (1.0f - ROTATE_MULT) * (1.0f - effect);
        if (index == 0) {
            return Math.round((1.0f - rotMult) * 100.0f) + "%";
        }
        if (index == 1) {
            return Math.round(RECOIL_PERCENT * effect) + "%";
        }
        if (index >= 2) {
            return CompromisedStructure.getCostDescParam(index, 2);
        }
        return null;
    }
}

