/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.combat.listeners.WeaponBaseRangeModifier;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class HighScatterAmp
extends BaseHullMod {
    public static float RANGE_THRESHOLD = 200.0f;
    public static float RANGE_MULT = 0.5f;
    public static float DAMAGE_BONUS_PERCENT = 10.0f;
    public static float SMOD_MODIFIER = 5.0f;

    public boolean isApplicableToShip(ShipAPI ship) {
        return !ship.getVariant().getHullMods().contains("advancedoptics");
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().getHullMods().contains("advancedoptics")) {
            return "Incompatible with Advanced Optics";
        }
        return null;
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        boolean sMod = this.isSMod(stats);
        stats.getBeamWeaponDamageMult().modifyPercent(id, DAMAGE_BONUS_PERCENT + (sMod ? SMOD_MODIFIER : 0.0f));
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return Math.round(SMOD_MODIFIER) + "%";
        }
        return null;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.addListener(new HighScatterAmpDamageDealtMod(ship));
        ship.addListener(new HighScatterAmpRangeMod());
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("Beam weapons deal %s more damage and deal hard flux damage to shields.", opad, h, (int)DAMAGE_BONUS_PERCENT + "%");
        tooltip.addPara("Reduces the portion of the range of beam weapons that is above %s units by %s. The base range is affected.", opad, h, "" + (int)RANGE_THRESHOLD, Math.round((1.0f - RANGE_MULT) * 100.0f) + "%");
        tooltip.addSectionHeading("Interactions with other modifiers", Alignment.MID, opad);
        tooltip.addPara("The base range is reduced, thus percentage and multiplicative modifiers - such as from Integrated Targeting Unit, skills, or similar sources - apply to the reduced base value.", opad);
    }

    public static class HighScatterAmpDamageDealtMod
    implements DamageDealtModifier {
        protected ShipAPI ship;

        public HighScatterAmpDamageDealtMod(ShipAPI ship) {
            this.ship = ship;
        }

        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (!(param instanceof DamagingProjectileAPI) && param instanceof BeamAPI) {
                damage.setForceHardFlux(true);
            }
            return null;
        }
    }

    public static class HighScatterAmpRangeMod
    implements WeaponBaseRangeModifier {
        public float getWeaponBaseRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
            return 0.0f;
        }

        public float getWeaponBaseRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
            return 1.0f;
        }

        public float getWeaponBaseRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
            if (weapon.isBeam()) {
                float range = weapon.getSpec().getMaxRange();
                if (range < RANGE_THRESHOLD) {
                    return 0.0f;
                }
                float past = range - RANGE_THRESHOLD;
                float penalty = past * (1.0f - RANGE_MULT);
                return -penalty;
            }
            return 0.0f;
        }
    }
}

