/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.loading;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.json.JSONException;
import org.json.JSONObject;

public class DamagingExplosionSpec
implements Cloneable {
    private float duration;
    private float radius;
    private float coreRadius;
    private float maxDamage;
    private float minDamage;
    private float particleSpawnRadius = -1.0f;
    private CollisionClass collisionClass;
    private CollisionClass collisionClassByFighter;
    private float particleSizeMin = 10.0f;
    private float particleSizeRange = 10.0f;
    private float particleDuration = 0.5f;
    private int particleCount = 10;
    private Color particleColor = new Color(255, 255, 255, 255);
    private Color explosionColor = new Color(255, 255, 255, 255);
    private DamageType damageType = DamageType.ENERGY;
    private String soundSetId;
    private boolean showGraphic = true;
    private boolean useDetailedExplosion = true;
    private float detailedExplosionRadius = -1.0f;
    private float detailedExplosionFlashRadius = -1.0f;
    private Color detailedExplosionFlashColorFringe = null;
    private Color detailedExplosionFlashColorCore = null;
    private float detailedExplosionFlashDuration = -1.0f;
    private OnHitEffectPlugin effect;
    private MutableStat modifier = new MutableStat(1.0f);

    public static float getShipExplosionRadius(ShipAPI ship) {
        float mult = ship.getMutableStats().getDynamic().getValue("explosion_radius_mult");
        float radius = ship.getCollisionRadius() + Math.min(200.0f, ship.getCollisionRadius()) * mult;
        return radius;
    }

    public static DamagingExplosionSpec explosionSpecForShip(ShipAPI ship) {
        float radius = DamagingExplosionSpec.getShipExplosionRadius(ship);
        float coreRadius = ship.getCollisionRadius();
        float maxDamage = ship.getMaxFlux() * (0.5f + 0.5f * (float)Math.random());
        float minDamage = 0.0f;
        float mult = ship.getMutableStats().getDynamic().getValue("explosion_damage_mult");
        DamagingExplosionSpec spec = new DamagingExplosionSpec(0.1f, radius, coreRadius, maxDamage *= mult, minDamage, CollisionClass.HITS_SHIPS_AND_ASTEROIDS, CollisionClass.HITS_SHIPS_AND_ASTEROIDS, 10.0f, 10.0f, 1.0f, 0, Color.white, Color.white);
        spec.setShowGraphic(false);
        spec.setDamageType(DamageType.HIGH_EXPLOSIVE);
        return spec;
    }

    public OnHitEffectPlugin getEffect() {
        return this.effect;
    }

    public void setEffect(OnHitEffectPlugin effect) {
        this.effect = effect;
    }

    public String getSoundSetId() {
        return this.soundSetId;
    }

    public void setSoundSetId(String soundSetId) {
        this.soundSetId = soundSetId;
    }

    public static DamagingExplosionSpec loadFromJSON(JSONObject explosionSpecJson) throws JSONException {
        if (explosionSpecJson != null) {
            DamagingExplosionSpec spec = new DamagingExplosionSpec((float)explosionSpecJson.getDouble("duration"), (float)explosionSpecJson.getDouble("radius"), (float)explosionSpecJson.getDouble("coreRadius"), (float)explosionSpecJson.optDouble("maxDamage", 0.0), (float)explosionSpecJson.optDouble("minDamage", 0.0), Misc.mapToEnum(explosionSpecJson, "collisionClass", CollisionClass.class, null), Misc.mapToEnum(explosionSpecJson, "collisionClassByFighter", CollisionClass.class, null), (float)explosionSpecJson.optDouble("particleSizeMin", 0.0), (float)explosionSpecJson.optDouble("particleSizeRange", 0.0), (float)explosionSpecJson.optDouble("particleDuration", 0.0), explosionSpecJson.optInt("particleCount", 0), Misc.getColor(explosionSpecJson, "particleColor"), Misc.optColor(explosionSpecJson, "explosionColor", null));
            spec.useDetailedExplosion = explosionSpecJson.optBoolean("useDetailedExplosion", false);
            spec.detailedExplosionRadius = (float)explosionSpecJson.optDouble("detailedExplosionRadius", -1.0);
            spec.detailedExplosionFlashRadius = (float)explosionSpecJson.optDouble("detailedExplosionFlashRadius", -1.0);
            spec.detailedExplosionFlashDuration = (float)explosionSpecJson.optDouble("detailedExplosionFlashDuration", -1.0);
            spec.detailedExplosionFlashColorFringe = Misc.optColor(explosionSpecJson, "detailedExplosionFlashColorFringe", null);
            spec.detailedExplosionFlashColorCore = Misc.optColor(explosionSpecJson, "detailedExplosionFlashColorCore", null);
            spec.particleSpawnRadius = (float)explosionSpecJson.optDouble("particleSpawnRadius", -1.0);
            if (spec.getParticleCount() == 0) {
                spec.setShowGraphic(false);
            }
            spec.setSoundSetId(explosionSpecJson.optString("sound", null));
            return spec;
        }
        return null;
    }

    public DamagingExplosionSpec(float duration, float radius, float coreRadius, float maxDamage, float minDamage, CollisionClass collisionClass, CollisionClass collisionClassByFighter, float particleSizeMin, float particleSizeRange, float particleDuration, int particleCount, Color particleColor, Color explosionColor) {
        this.duration = duration;
        this.radius = radius;
        this.coreRadius = coreRadius;
        this.maxDamage = maxDamage;
        this.minDamage = minDamage;
        this.collisionClass = collisionClass;
        this.collisionClassByFighter = collisionClassByFighter;
        this.particleSizeMin = particleSizeMin;
        this.particleSizeRange = particleSizeRange;
        this.particleDuration = particleDuration;
        this.particleCount = particleCount;
        this.particleColor = particleColor;
        this.explosionColor = explosionColor != null ? explosionColor : particleColor;
    }

    public float getParticleSpawnRadius() {
        return this.particleSpawnRadius;
    }

    public void setParticleSpawnRadius(float particleSpawnRadius) {
        this.particleSpawnRadius = particleSpawnRadius;
    }

    public Color getExplosionColor() {
        return this.explosionColor;
    }

    public void setExplosionColor(Color explosionColor) {
        this.explosionColor = explosionColor;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public void setDamageType(DamageType damageType) {
        this.damageType = damageType;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getMaxDamage() {
        return this.maxDamage;
    }

    public void setMaxDamage(float maxDamage) {
        this.maxDamage = maxDamage;
    }

    public float getMinDamage() {
        return this.minDamage;
    }

    public void setMinDamage(float minDamage) {
        this.minDamage = minDamage;
    }

    public CollisionClass getCollisionClass() {
        return this.collisionClass;
    }

    public void setCollisionClass(CollisionClass collisionClass) {
        this.collisionClass = collisionClass;
    }

    public CollisionClass getCollisionClassIfByFighter() {
        return this.collisionClassByFighter;
    }

    public void setCollisionClassByFighter(CollisionClass collisionClassByFighter) {
        this.collisionClassByFighter = collisionClassByFighter;
    }

    public float getParticleSizeMin() {
        return this.particleSizeMin;
    }

    public void setParticleSizeMin(float particleSizeMin) {
        this.particleSizeMin = particleSizeMin;
    }

    public float getParticleSizeRange() {
        return this.particleSizeRange;
    }

    public void setParticleSizeRange(float particleSizeRange) {
        this.particleSizeRange = particleSizeRange;
    }

    public float getParticleDuration() {
        return this.particleDuration;
    }

    public void setParticleDuration(float particleDuration) {
        this.particleDuration = particleDuration;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public Color getParticleColor() {
        return this.particleColor;
    }

    public void setParticleColor(Color particleColor) {
        this.particleColor = particleColor;
    }

    public float getCoreRadius() {
        return this.coreRadius;
    }

    public void setCoreRadius(float coreRadius) {
        this.coreRadius = coreRadius;
    }

    public boolean isShowGraphic() {
        return this.showGraphic;
    }

    public void setShowGraphic(boolean showGraphic) {
        this.showGraphic = showGraphic;
    }

    public DamagingExplosionSpec clone() {
        try {
            return (DamagingExplosionSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isUseDetailedExplosion() {
        return this.useDetailedExplosion;
    }

    public void setUseDetailedExplosion(boolean useDetailedExplosion) {
        this.useDetailedExplosion = useDetailedExplosion;
    }

    public CollisionClass getCollisionClassByFighter() {
        return this.collisionClassByFighter;
    }

    public MutableStat getModifier() {
        return this.modifier;
    }

    public void setModifier(MutableStat modifier) {
        this.modifier = modifier;
    }

    public float getDetailedExplosionRadius() {
        return this.detailedExplosionRadius;
    }

    public void setDetailedExplosionRadius(float detailedExplosionRadius) {
        this.detailedExplosionRadius = detailedExplosionRadius;
    }

    public float getDetailedExplosionFlashRadius() {
        return this.detailedExplosionFlashRadius;
    }

    public void setDetailedExplosionFlashRadius(float detailedExplosionFlashRadius) {
        this.detailedExplosionFlashRadius = detailedExplosionFlashRadius;
    }

    public Color getDetailedExplosionFlashColorFringe() {
        return this.detailedExplosionFlashColorFringe;
    }

    public void setDetailedExplosionFlashColorFringe(Color detailedExplosionFlashColorFringe) {
        this.detailedExplosionFlashColorFringe = detailedExplosionFlashColorFringe;
    }

    public Color getDetailedExplosionFlashColorCore() {
        return this.detailedExplosionFlashColorCore;
    }

    public void setDetailedExplosionFlashColorCore(Color detailedExplosionFlashColorCore) {
        this.detailedExplosionFlashColorCore = detailedExplosionFlashColorCore;
    }

    public float getDetailedExplosionFlashDuration() {
        return this.detailedExplosionFlashDuration;
    }

    public void setDetailedExplosionFlashDuration(float detailedExplosionFlashDuration) {
        this.detailedExplosionFlashDuration = detailedExplosionFlashDuration;
    }
}

