/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.combat.CollisionGridAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionGridUtil
implements CollisionGridAPI {
    protected float cellSize;
    protected List<Object>[][] buckets;
    protected int width;
    protected int height;
    protected int leftOf;
    protected int rightOf;
    protected int below;
    protected int above;

    public CollisionGridUtil(float minX, float maxX, float minY, float maxY, float cellSize) {
        this.cellSize = cellSize;
        this.leftOf = -((int)Math.floor(minX / cellSize));
        this.rightOf = (int)Math.ceil(maxX / cellSize);
        this.below = -((int)Math.floor(minY / cellSize));
        this.above = (int)Math.ceil(maxY / cellSize);
        this.width = this.leftOf + this.rightOf;
        this.height = this.below + this.above;
        this.buckets = new List[this.width][this.height];
    }

    @Override
    public void addObject(Object object, Vector2f loc, float objWidth, float objHeight) {
        int startX = (int)((float)this.leftOf + (loc.x - objWidth / 2.0f) / this.cellSize);
        int endX = (int)((float)this.leftOf + (loc.x + objWidth / 2.0f) / this.cellSize);
        int startY = (int)((float)this.below + (loc.y - objHeight / 2.0f) / this.cellSize);
        int endY = (int)((float)this.below + (loc.y + objHeight / 2.0f) / this.cellSize);
        int limit = 0x3FFFFFFF;
        if (startX > limit) {
            startX = limit;
        }
        if (endX > limit) {
            endX = limit;
        }
        if (startY > limit) {
            startY = limit;
        }
        if (endY > limit) {
            endY = limit;
        }
        if (startX < -limit) {
            startX = -limit;
        }
        if (endX < -limit) {
            endX = -limit;
        }
        if (startY < -limit) {
            startY = -limit;
        }
        if (endY < -limit) {
            endY = -limit;
        }
        int i = startX;
        while (i <= endX) {
            int j = startY;
            while (j <= endY) {
                this.addToBucket(i, j, object);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void removeObject(Object object, Vector2f loc, float objWidth, float objHeight) {
        int startX = (int)((float)this.leftOf + (loc.x - objWidth / 2.0f) / this.cellSize);
        int endX = (int)((float)this.leftOf + (loc.x + objWidth / 2.0f) / this.cellSize);
        int startY = (int)((float)this.below + (loc.y - objHeight / 2.0f) / this.cellSize);
        int endY = (int)((float)this.below + (loc.y + objHeight / 2.0f) / this.cellSize);
        int i = startX;
        while (i <= endX) {
            int j = startY;
            while (j <= endY) {
                this.removeFromBucket(i, j, object);
                ++j;
            }
            ++i;
        }
    }

    protected void addToBucket(int cellX, int cellY, Object object) {
        if (cellX < 0 || cellX >= this.width || cellY < 0 || cellY >= this.height) {
            return;
        }
        if (this.buckets[cellX][cellY] == null) {
            this.buckets[cellX][cellY] = new ArrayList<Object>();
        }
        if (!this.buckets[cellX][cellY].contains(object)) {
            this.buckets[cellX][cellY].add(object);
        }
    }

    protected void removeFromBucket(int cellX, int cellY, Object object) {
        if (cellX < 0 || cellX >= this.width || cellY < 0 || cellY >= this.height) {
            return;
        }
        if (this.buckets[cellX][cellY] == null) {
            return;
        }
        this.buckets[cellX][cellY].remove(object);
    }

    @Override
    public Iterator<Object> getCheckIterator(Vector2f loc, float objWidth, float objHeight) {
        int startX = (int)((float)this.leftOf + (loc.x - objWidth / 2.0f) / this.cellSize);
        int endX = (int)((float)this.leftOf + (loc.x + objWidth / 2.0f) / this.cellSize);
        int startY = (int)((float)this.below + (loc.y - objHeight / 2.0f) / this.cellSize);
        int endY = (int)((float)this.below + (loc.y + objHeight / 2.0f) / this.cellSize);
        BucketIterator result = new BucketIterator(startX, endX, startY, endY);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BucketIterator
    implements Iterator<Object> {
        protected Iterator<Object> curr = null;
        protected Set<Object> objects;

        protected BucketIterator() {
        }

        protected BucketIterator(int startX, int endX, int startY, int endY) {
            this.objects = new LinkedHashSet<Object>();
            if (startX < 0) {
                startX = 0;
            }
            if (endX >= CollisionGridUtil.this.width) {
                endX = CollisionGridUtil.this.width - 1;
            }
            if (startY < 0) {
                startY = 0;
            }
            if (endY >= CollisionGridUtil.this.height) {
                endY = CollisionGridUtil.this.height - 1;
            }
            int i = startX;
            while (i <= endX) {
                int j = startY;
                while (j <= endY) {
                    if (CollisionGridUtil.this.buckets[i][j] != null) {
                        this.objects.addAll(CollisionGridUtil.this.buckets[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            this.curr = this.objects.iterator();
        }

        public BucketIterator createCopy() {
            BucketIterator copy = new BucketIterator();
            copy.objects = this.objects;
            copy.curr = copy.objects.iterator();
            return copy;
        }

        @Override
        public boolean hasNext() {
            return this.curr.hasNext();
        }

        @Override
        public Object next() {
            return this.curr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

