/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

public class IntervalUtil {
    private float minInterval;
    private float maxInterval;
    private float currInterval;
    private float elapsed = 0.0f;
    private boolean intervalElapsed = false;

    public IntervalUtil(float minInterval, float maxInterval) {
        this.setInterval(minInterval, maxInterval);
    }

    public void forceCurrInterval(float value) {
        this.currInterval = value;
    }

    public void randomize() {
        this.advance((float)Math.random() * this.minInterval);
    }

    public void forceIntervalElapsed() {
        this.elapsed = this.currInterval;
    }

    public float getElapsed() {
        return this.elapsed;
    }

    private void nextInterval() {
        this.currInterval = this.minInterval + (this.maxInterval - this.minInterval) * (float)Math.random();
        this.elapsed = 0.0f;
        this.intervalElapsed = false;
    }

    public void advance(float amount) {
        if (this.intervalElapsed) {
            this.nextInterval();
        }
        this.elapsed += amount;
        if (this.elapsed >= this.currInterval) {
            this.intervalElapsed = true;
        }
    }

    public boolean intervalElapsed() {
        return this.intervalElapsed;
    }

    public float getIntervalDuration() {
        return this.currInterval;
    }

    public void setInterval(float min, float max) {
        this.minInterval = min;
        this.maxInterval = max;
        this.nextInterval();
    }

    public void setElapsed(float elapsed) {
        this.elapsed = elapsed;
    }

    public float getMinInterval() {
        return this.minInterval;
    }

    public float getMaxInterval() {
        return this.maxInterval;
    }
}

