/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutTracker<T> {
    private List<ItemData<T>> items = new ArrayList<ItemData<T>>();
    private transient Set<T> set = new HashSet<T>();

    Object readResolve() {
        this.set = new HashSet<T>();
        for (ItemData<T> item : this.items) {
            this.set.add(item.item);
        }
        return this;
    }

    Object writeReplace() {
        return this;
    }

    public void add(T item, float time) {
        this.getData(item).remaining += time;
    }

    public void add(T item, float time, float limit) {
        ItemData<T> d = this.getData(item);
        if (time > 0.0f && d.remaining + time > limit) {
            time = Math.max(0.0f, limit - d.remaining);
        }
        d.remaining += time;
        if (d.remaining < 0.0f) {
            d.remaining = 0.0f;
        }
    }

    public void set(T item, float time) {
        this.getData(item).remaining = time;
    }

    public float getRemaining(T item) {
        return this.getData(item).remaining;
    }

    public void remove(T item) {
        for (ItemData<T> d : this.items) {
            if (!d.item.equals(item)) continue;
            this.items.remove(d);
            this.set.remove(item);
            return;
        }
    }

    public List<T> getItems() {
        ArrayList list = new ArrayList();
        for (ItemData<T> d : this.items) {
            list.add(d.item);
        }
        return list;
    }

    public void clear() {
        this.items.clear();
        this.set.clear();
    }

    private ItemData<T> getData(T item) {
        ItemData d2;
        for (ItemData d2 : this.items) {
            if (!d2.item.equals(item)) continue;
            return d2;
        }
        d2 = new ItemData();
        d2.item = item;
        d2.remaining = 0.0f;
        this.items.add(d2);
        this.set.add(item);
        return d2;
    }

    public void advance(float amount) {
        ArrayList<ItemData<T>> remove = new ArrayList<ItemData<T>>();
        for (ItemData<T> d : this.items) {
            d.remaining -= amount;
            if (!(d.remaining <= 0.0f)) continue;
            remove.add(d);
            this.set.remove(d.item);
        }
        this.items.removeAll(remove);
    }

    public boolean contains(T item) {
        return this.set.contains(item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemData<T> {
        public T item;
        public float remaining;
    }
}

