/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.util.DoNotObfuscate;

public abstract class BaseParticle
implements DoNotObfuscate {
    private float age = 0.0f;
    private float maxAge = 1.0f;
    private float angle;
    private float rotationSpeed;
    private float x;
    private float y;
    private float dx;
    private float dy;
    private float rampUpPeriod = 0.0f;
    private float cutoff = 1.0f;

    public abstract void preBatch();

    public abstract void preBatch(int var1);

    public abstract void postBatch();

    public abstract void render();

    public float getBrightness() {
        float f = this.getNewness();
        if (f > this.cutoff) {
            return (1.0f - f) / (1.0f - this.cutoff);
        }
        return f / this.cutoff;
    }

    public float getNewness() {
        return 1.0f - this.getAge() / this.getMaxAge();
    }

    public boolean isExpired() {
        return this.age >= this.maxAge;
    }

    public void advance(float f) {
        this.age += f;
        this.x += this.dx * f;
        this.y += this.dy * f;
        this.angle += this.rotationSpeed * f;
    }

    public void setVel(float f, float f2) {
        this.dx = f;
        this.dy = f2;
    }

    public void setPos(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getAge() {
        return this.age;
    }

    public void setAge(float f) {
        this.age = f;
    }

    public float getDx() {
        return this.dx;
    }

    public void setDx(float f) {
        this.dx = f;
    }

    public float getDy() {
        return this.dy;
    }

    public void setDy(float f) {
        this.dy = f;
    }

    public float getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(float f) {
        this.maxAge = f;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(float f) {
        this.rotationSpeed = f;
    }

    public float getRampUpPeriod() {
        return this.rampUpPeriod;
    }

    public void setRampUpPeriod(float f) {
        this.rampUpPeriod = f;
        this.cutoff = 1.0f - f;
    }
}

