/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.graphics.C;
import com.fs.graphics.G;
import com.fs.graphics.particle.BaseParticle;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class NebulaParticle
extends BaseParticle
implements DoNotObfuscate {
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private transient C texture = null;
    private Color color;
    private float origSize;
    private float endSize;
    private float fullBrightnessFraction;
    private float tw;
    private float th;
    private int i;
    private int j;
    private int src = 770;
    private int dst = 771;
    private String textureId;
    private static Random random = new Random(NebulaParticle.genRandomSeed());
    private boolean negative;
    private boolean expandAsSqrt;
    private int w = 4;
    boolean fullyFadedIn = false;
    private float offsetX;
    private float offsetY;
    private float width;
    private float height;

    public NebulaParticle(String string, Color color, float f, float f2, float f3, boolean bl, boolean bl2) {
        this.negative = bl;
        this.expandAsSqrt = bl2;
        this.texture = G.new(string);
        this.color = color;
        this.origSize = f;
        this.endSize = f2;
        this.fullBrightnessFraction = f3;
        this.setSize(f, f);
        this.tw = this.texture.while();
        this.th = this.texture.o00000();
        this.i = random.nextInt(4);
        this.j = random.nextInt(4);
        this.setAngle(random.nextFloat() * 360.0f);
    }

    public void rerollTile(int n, int n2) {
        this.w = n;
        this.i = random.nextInt(n);
        this.j = random.nextInt(n2);
    }

    Object readResolve() {
        if (this.textureId != null) {
            this.texture = G.new(this.textureId);
        }
        return this;
    }

    public void advance(float f) {
        super.advance(f);
        if (this.expandAsSqrt) {
            this.setCurrSize((float)((double)this.origSize + (double)(this.endSize - this.origSize) * Math.sqrt(this.getAge()) / (double)this.getMaxAge()));
        } else {
            this.setCurrSize(this.origSize + (this.endSize - this.origSize) * this.getAge() / this.getMaxAge());
        }
    }

    public void preBatch() {
        if (this.negative) {
            GL14.glBlendEquation((int)32779);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        this.texture.\u00d800000();
    }

    public void setBlendFunc(int n, int n2) {
        this.src = n;
        this.dst = n2;
    }

    public void postBatch() {
        GL11.glDisable((int)3553);
        if (this.negative) {
            GL14.glBlendEquation((int)32774);
        }
    }

    public void render() {
        float f = this.getBrightness();
        if (f >= 1.0f) {
            this.fullyFadedIn = true;
        }
        if (this.fullyFadedIn && this.fullBrightnessFraction > 0.0f) {
            f = this.getAge() / this.getMaxAge();
            f = f <= this.fullBrightnessFraction ? 1.0f : 1.0f - (f - this.fullBrightnessFraction) / (1.0f - this.fullBrightnessFraction);
        }
        GL11.glBlendFunc((int)this.src, (int)this.dst);
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * f)));
        float f2 = this.getX();
        float f3 = this.getY();
        GL11.glPushMatrix();
        float f4 = this.getAngle();
        GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
        GL11.glRotatef((float)f4, (float)0.0f, (float)0.0f, (float)1.0f);
        float f5 = 0.25f;
        if (this.w == 2) {
            f5 = 0.5f;
        }
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)((float)this.i * f5), (float)((float)this.j * f5));
        GL11.glVertex2f((float)this.offsetX, (float)this.offsetY);
        GL11.glTexCoord2f((float)((float)this.i * f5), (float)((float)this.j * f5 + f5));
        GL11.glVertex2f((float)this.offsetX, (float)(this.offsetY + this.height));
        GL11.glTexCoord2f((float)((float)this.i * f5 + f5), (float)((float)this.j * f5 + f5));
        GL11.glVertex2f((float)(this.offsetX + this.width), (float)(this.offsetY + this.height));
        GL11.glTexCoord2f((float)((float)this.i * f5 + f5), (float)((float)this.j * f5));
        GL11.glVertex2f((float)(this.offsetX + this.width), (float)this.offsetY);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.offsetX = -f / 2.0f;
        this.offsetY = -f2 / 2.0f;
    }

    private void setCurrSize(float f) {
        this.width = f;
        this.height = f;
        this.offsetX = -f / 2.0f;
        this.offsetY = -f / 2.0f;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public Color getColor() {
        return this.color;
    }

    public void preBatch(int n) {
        this.preBatch();
    }

    public static long genRandomSeed() {
        return NebulaParticle.seedUniquifier() ^ System.nanoTime();
    }

    public static long seedUniquifier() {
        long l;
        long l2;
        while (!seedUniquifier.compareAndSet(l2 = seedUniquifier.get(), l = l2 * 181783497276652981L)) {
        }
        return l;
    }
}

