/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FleetEncounterContextPlugin {
    public DataForEncounterSide getDataFor(CampaignFleetAPI var1);

    public DataForEncounterSide getWinnerData();

    public DataForEncounterSide getLoserData();

    public CampaignFleetAPI getWinner();

    public CampaignFleetAPI getLoser();

    public boolean isEngagedInHostilities();

    public EngagementOutcome getLastEngagementOutcome();

    public PursueAvailability getPursuitAvailability(CampaignFleetAPI var1, CampaignFleetAPI var2);

    public DisengageHarryAvailability getDisengageHarryAvailability(CampaignFleetAPI var1, CampaignFleetAPI var2);

    public float performPostVictoryRecovery(EngagementResultAPI var1);

    public BattleAPI getBattle();

    public void setOtherFleetHarriedPlayer(boolean var1);

    public boolean isOtherFleetHarriedPlayer();

    public boolean adjustPlayerReputation(InteractionDialogAPI var1, String var2);

    public float computePlayerContribFraction();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataForEncounterSide {
        private float maxTimeDeployed;
        private Map<PersonAPI, OfficerEngagementData> officerData = new HashMap<PersonAPI, OfficerEngagementData>();
        private Map<FleetMemberAPI, OfficerEngagementData> fleetMemberDeploymentData = new HashMap<FleetMemberAPI, OfficerEngagementData>();
        private CampaignFleetAPI fleet;
        private List<FleetMemberData> ownCasualties = new ArrayList<FleetMemberData>();
        private List<FleetMemberData> enemyCasualties = new ArrayList<FleetMemberData>();
        private List<FleetMemberAPI> deployedInLastEngagement = new ArrayList<FleetMemberAPI>();
        private List<FleetMemberAPI> retreatedFromLastEngagement = new ArrayList<FleetMemberAPI>();
        private List<FleetMemberAPI> inReserveDuringLastEngagement = new ArrayList<FleetMemberAPI>();
        private List<FleetMemberAPI> disabledInLastEngagement = new ArrayList<FleetMemberAPI>();
        private List<FleetMemberAPI> destroyedInLastEngagement = new ArrayList<FleetMemberAPI>();
        private Map<FleetMemberAPI, DeployedFleetMemberAPI> memberToDeployedMap = new HashMap<FleetMemberAPI, DeployedFleetMemberAPI>();
        private Set<FleetMemberAPI> membersWithOfficerOrPlayerAsOrigCaptain = new LinkedHashSet<FleetMemberAPI>();
        private CrewCompositionAPI crewLossesDuringLastEngagement = Global.getFactory().createCrewComposition();
        private CrewCompositionAPI recoverableCrewLosses = Global.getFactory().createCrewComposition();
        private boolean wonLastEngagement = false;
        private FleetGoal lastGoal = null;
        private boolean disengaged = false;
        private boolean didEnoughToDisengage = false;
        private boolean enemyCanCleanDisengage = false;

        public DataForEncounterSide(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }

        public Set<FleetMemberAPI> getMembersWithOfficerOrPlayerAsOrigCaptain() {
            return this.membersWithOfficerOrPlayerAsOrigCaptain;
        }

        public float getMaxTimeDeployed() {
            return this.maxTimeDeployed;
        }

        public void setMaxTimeDeployed(float maxTimeDeployed) {
            this.maxTimeDeployed = maxTimeDeployed;
        }

        public Map<PersonAPI, OfficerEngagementData> getOfficerData() {
            return this.officerData;
        }

        public Map<FleetMemberAPI, OfficerEngagementData> getFleetMemberDeploymentData() {
            return this.fleetMemberDeploymentData;
        }

        public CrewCompositionAPI getRecoverableCrewLosses() {
            return this.recoverableCrewLosses;
        }

        public CrewCompositionAPI getCrewLossesDuringLastEngagement() {
            return this.crewLossesDuringLastEngagement;
        }

        public CampaignFleetAPI getFleet() {
            return this.fleet;
        }

        public List<FleetMemberData> getOwnCasualties() {
            return this.ownCasualties;
        }

        public List<FleetMemberData> getEnemyCasualties() {
            return this.enemyCasualties;
        }

        public void addOwn(FleetMemberAPI member, Status status) {
            this.ownCasualties.add(new FleetMemberData(status, member));
        }

        public void removeOwnCasualty(FleetMemberAPI member) {
            for (FleetMemberData data : this.ownCasualties) {
                if (data.member != member) continue;
                this.ownCasualties.remove(data);
                break;
            }
        }

        public void removeEnemyCasualty(FleetMemberAPI member) {
            for (FleetMemberData data : this.enemyCasualties) {
                if (data.member != member) continue;
                this.enemyCasualties.remove(data);
                break;
            }
        }

        public void changeOwn(FleetMemberAPI member, Status newStatus) {
            for (FleetMemberData data : this.ownCasualties) {
                if (data.member != member) continue;
                data.status = newStatus;
                break;
            }
        }

        public void changeEnemy(FleetMemberAPI member, Status newStatus) {
            for (FleetMemberData data : this.enemyCasualties) {
                if (data.member != member) continue;
                data.status = newStatus;
                break;
            }
        }

        public void addEnemy(FleetMemberAPI member, Status status) {
            this.enemyCasualties.add(new FleetMemberData(status, member));
        }

        public boolean isWonLastEngagement() {
            return this.wonLastEngagement;
        }

        public void setWonLastEngagement(boolean wonLastEngagement) {
            this.wonLastEngagement = wonLastEngagement;
        }

        public FleetGoal getLastGoal() {
            return this.lastGoal;
        }

        public void setLastGoal(FleetGoal lastGoal) {
            this.lastGoal = lastGoal;
        }

        public boolean disengaged() {
            return this.disengaged;
        }

        public void setDisengaged(boolean disengaged) {
            this.disengaged = disengaged;
        }

        public List<FleetMemberAPI> getDeployedInLastEngagement() {
            return this.deployedInLastEngagement;
        }

        public List<FleetMemberAPI> getRetreatedFromLastEngagement() {
            return this.retreatedFromLastEngagement;
        }

        public List<FleetMemberAPI> getInReserveDuringLastEngagement() {
            return this.inReserveDuringLastEngagement;
        }

        public List<FleetMemberAPI> getDisabledInLastEngagement() {
            return this.disabledInLastEngagement;
        }

        public List<FleetMemberAPI> getDestroyedInLastEngagement() {
            return this.destroyedInLastEngagement;
        }

        public boolean isDidEnoughToDisengage() {
            return this.didEnoughToDisengage;
        }

        public void setDidEnoughToDisengage(boolean didEnoughToDisengage) {
            this.didEnoughToDisengage = didEnoughToDisengage;
        }

        public Map<FleetMemberAPI, DeployedFleetMemberAPI> getMemberToDeployedMap() {
            return this.memberToDeployedMap;
        }

        public boolean isEnemyCanCleanDisengage() {
            return this.enemyCanCleanDisengage;
        }

        public void setEnemyCanCleanDisengage(boolean enemyCanCleanDisengage) {
            this.enemyCanCleanDisengage = enemyCanCleanDisengage;
        }

        public static class OfficerEngagementData {
            public CampaignFleetAPI sourceFleet;
            public PersonAPI person;
            public float timeDeployed;

            public OfficerEngagementData(CampaignFleetAPI sourceFleet) {
                this.sourceFleet = sourceFleet;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisengageHarryAvailability {
        AVAILABLE,
        NO_READY_SHIPS,
        LOST_LAST_ENGAGEMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EngagementOutcome {
        MUTUAL_DESTRUCTION,
        BATTLE_PLAYER_WIN,
        BATTLE_PLAYER_WIN_TOTAL,
        BATTLE_ENEMY_WIN,
        BATTLE_ENEMY_WIN_TOTAL,
        ESCAPE_PLAYER_LOSS_TOTAL,
        ESCAPE_PLAYER_SUCCESS,
        ESCAPE_PLAYER_WIN,
        ESCAPE_PLAYER_WIN_TOTAL,
        ESCAPE_ENEMY_LOSS_TOTAL,
        ESCAPE_ENEMY_SUCCESS,
        ESCAPE_ENEMY_WIN,
        ESCAPE_ENEMY_WIN_TOTAL,
        BATTLE_PLAYER_OUT_FIRST_WIN,
        BATTLE_PLAYER_OUT_FIRST_LOSS,
        ESCAPE_PLAYER_OUT_FIRST_WIN,
        ESCAPE_PLAYER_OUT_FIRST_LOSS,
        PURSUIT_PLAYER_OUT_FIRST_WIN,
        PURSUIT_PLAYER_OUT_FIRST_LOSS;

    }

    public static class FleetMemberData {
        private Status status;
        private FleetMemberAPI member;

        public FleetMemberData(Status status, FleetMemberAPI member) {
            this.status = status;
            this.member = member;
        }

        public Status getStatus() {
            return this.status;
        }

        public FleetMemberAPI getMember() {
            return this.member;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setMember(FleetMemberAPI member) {
            this.member = member;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PursueAvailability {
        AVAILABLE,
        TOO_SLOW,
        NO_READY_SHIPS,
        TOOK_SERIOUS_LOSSES,
        LOST_LAST_ENGAGEMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NORMAL,
        DISABLED,
        DESTROYED,
        REPAIRED,
        CAPTURED;

    }
}

