/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.MonthlyReportNodeTooltipCreator;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonthlyReport {
    public static String CREW = "node_id_crew";
    public static String MARINES = "node_id_marines";
    public static String FLEET = "node_id_fleet";
    public static String OUTPOSTS = "node_id_outposts";
    public static String PRODUCTION = "node_id_prod";
    public static String PRODUCTION_WEAPONS = "node_id_prod_weapons";
    public static String OVERHEAD = "node_id_overhead";
    public static String STOCKPILING = "node_id_stockpiling";
    public static String RESTOCKING = "node_id_restocking";
    public static String INCENTIVES = "node_id_incentives";
    public static String INDUSTRIES = "node_id_industries";
    public static String EXPORTS = "node_id_exports";
    public static String STORAGE = "node_id_storage";
    public static String ADMIN = "node_id_admin";
    public static String STORAGE_CARGO = "node_id_storage_cargo";
    public static String STORAGE_SHIPS = "node_id_storage_ships";
    public static String LAST_MONTH_DEBT = "node_id_last_month_debt";
    public static String OFFICERS = "node_id_officers";
    private FDNode root = new FDNode();
    private long timestamp;
    private int debt = 0;
    private int previousDebt = 0;
    private MonthlyReportNodeTooltipCreator monthlyReportTooltip;

    public MonthlyReportNodeTooltipCreator getMonthlyReportTooltip() {
        if (this.monthlyReportTooltip == null) {
            this.monthlyReportTooltip = new MonthlyReportNodeTooltipCreator();
        }
        return this.monthlyReportTooltip;
    }

    public void computeTotals() {
        this.computeTotals(this.root);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getPreviousDebt() {
        return this.previousDebt;
    }

    public void setPreviousDebt(int previousDebt) {
        this.previousDebt = previousDebt;
    }

    public int getDebt() {
        return this.debt;
    }

    public void setDebt(int debt) {
        this.debt = debt;
    }

    public FDNode getRoot() {
        return this.root;
    }

    protected void computeTotals(FDNode curr) {
        curr.totalIncome = curr.income;
        curr.totalUpkeep = curr.upkeep;
        for (FDNode child : curr.getChildren().values()) {
            this.computeTotals(child);
        }
        if (curr.parent != null) {
            curr.parent.totalIncome += curr.totalIncome;
            curr.parent.totalUpkeep += curr.totalUpkeep;
        }
    }

    public List<FDNode> getAllNodes() {
        ArrayList<FDNode> all = new ArrayList<FDNode>();
        this.getAllNodes(this.root, all);
        return all;
    }

    protected void getAllNodes(FDNode curr, List<FDNode> nodes) {
        nodes.add(curr);
        for (FDNode child : curr.getChildren().values()) {
            this.getAllNodes(child, nodes);
        }
    }

    public FDNode getNode(String ... path) {
        return this.getNode(this.root, new LinkedList<String>(Arrays.asList(path)));
    }

    public FDNode getNode(FDNode from, String ... path) {
        return this.getNode(from, new LinkedList<String>(Arrays.asList(path)));
    }

    public FDNode getNode(FDNode from, List<String> path) {
        FDNode next;
        if (path.isEmpty()) {
            return from;
        }
        String nextId = path.remove(0);
        FDNode fDNode = next = from.children == null ? null : from.children.get(nextId);
        if (next == null) {
            if (from.children == null) {
                from.children = new LinkedHashMap();
            }
            next = new FDNode();
            next.parent = from;
            from.children.put(nextId, next);
        }
        return this.getNode(next, path);
    }

    public FDNode getColoniesNode() {
        FDNode marketsNode = this.getNode(OUTPOSTS);
        if (marketsNode.name == null) {
            marketsNode.name = "Colonies";
            marketsNode.custom = OUTPOSTS;
            marketsNode.tooltipCreator = this.getMonthlyReportTooltip();
        }
        return marketsNode;
    }

    public FDNode getMarketNode(MarketAPI market) {
        FDNode marketsNode = this.getColoniesNode();
        FDNode mNode = this.getNode(marketsNode, market.getId());
        if (mNode.name == null) {
            mNode.name = String.valueOf(market.getName()) + " (" + market.getSize() + ")";
            mNode.custom = market;
        }
        return mNode;
    }

    public FDNode getCounterShortageNode(MarketAPI market) {
        FDNode mNode = this.getMarketNode(market);
        FDNode sNode = this.getNode(mNode, STOCKPILING);
        if (sNode.name == null) {
            sNode.name = "Stockpiles used to counter shortages";
            sNode.custom = STOCKPILING;
            sNode.custom2 = Global.getFactory().createCargo(true);
            ((CargoAPI)sNode.custom2).initMothballedShips("player");
            sNode.tooltipCreator = this.getMonthlyReportTooltip();
        }
        return sNode;
    }

    public FDNode getRestockingNode(MarketAPI market) {
        FDNode mNode = this.getColoniesNode();
        FDNode sNode = this.getNode(mNode, RESTOCKING);
        if (sNode.name == null) {
            sNode.name = "Stockpiles drawn by your fleet";
            sNode.custom = RESTOCKING;
            sNode.custom2 = Global.getFactory().createCargo(true);
            ((CargoAPI)sNode.custom2).initMothballedShips("player");
            sNode.tooltipCreator = this.getMonthlyReportTooltip();
        }
        return sNode;
    }

    public FDNode getDebtNode() {
        FDNode debtNode = this.getNode(LAST_MONTH_DEBT);
        if (debtNode.name == null) {
            debtNode.name = "Last month's debt";
            debtNode.custom = LAST_MONTH_DEBT;
            debtNode.icon = Global.getSettings().getSpriteName("income_report", "generic_expense");
            debtNode.tooltipCreator = this.getMonthlyReportTooltip();
        }
        return debtNode;
    }

    public static void main(String[] args) {
        MonthlyReport data = new MonthlyReport();
        String[] stringArray = new String[]{"test", "test1", "test2"};
        data.getNode((String[])stringArray).income = 10.0f;
        System.out.println(data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FDNode {
        protected LinkedHashMap<String, FDNode> children;
        public FDNode parent;
        public String name;
        public String icon;
        public float income;
        public float upkeep;
        public float totalIncome;
        public float totalUpkeep;
        public Object custom;
        public Object custom2;
        public SectorEntityToken mapEntity;
        public TooltipMakerAPI.TooltipCreator tooltipCreator = null;
        public Object tooltipParam;

        public LinkedHashMap<String, FDNode> getChildren() {
            if (this.children == null) {
                return new LinkedHashMap<String, FDNode>();
            }
            return this.children;
        }

        public int getDepth() {
            FDNode curr = this;
            int count = 0;
            while (curr.parent != null) {
                curr = curr.parent;
                ++count;
            }
            return count;
        }
    }
}

