/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShipBlueprintItemPlugin
extends BaseSpecialItemPlugin
implements BlueprintProviderItem {
    protected ShipHullSpecAPI ship;

    @Override
    public void init(CargoStackAPI stack) {
        super.init(stack);
        this.ship = Global.getSettings().getHullSpec(stack.getSpecialDataIfSpecial().getData());
    }

    @Override
    public List<String> getProvidedFighters() {
        return null;
    }

    @Override
    public List<String> getProvidedShips() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.ship.getHullId());
        return result;
    }

    @Override
    public List<String> getProvidedWeapons() {
        return null;
    }

    @Override
    public List<String> getProvidedIndustries() {
        return null;
    }

    @Override
    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        float blX = cx - 30.0f;
        float blY = cy - 15.0f;
        float tlX = cx - 20.0f;
        float tlY = cy + 26.0f;
        float trX = cx + 23.0f;
        float trY = cy + 26.0f;
        float brX = cx + 15.0f;
        float brY = cy - 18.0f;
        String hullId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsShip(hullId);
        float mult = 1.0f;
        Color bgColor = Global.getSector().getPlayerFaction().getDarkUIColor();
        bgColor = Misc.setAlpha(bgColor, 255);
        renderer.renderBGWithCorners(bgColor, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * mult, glowMult * 0.5f * mult, false);
        renderer.renderShipWithCorners(hullId, null, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * mult, glowMult * 0.5f * mult, !known);
        SpriteAPI overlay = Global.getSettings().getSprite("ui", "bpOverlayShip");
        overlay.setColor(Color.green);
        overlay.setColor(Global.getSector().getPlayerFaction().getBrightUIColor());
        overlay.setAlphaMult(alphaMult);
        overlay.setNormalBlend();
        renderer.renderScanlinesWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult, false);
        if (known) {
            renderer.renderBGWithCorners(Color.black, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * 0.5f, 0.0f, false);
        }
        overlay.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
    }

    @Override
    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        if (this.ship != null) {
            float base = 0.0f;
            switch (this.ship.getHullSize()) {
                case CAPITAL_SHIP: {
                    base = Global.getSettings().getFloat("blueprintBasePriceCapital");
                    break;
                }
                case CRUISER: {
                    base = Global.getSettings().getFloat("blueprintBasePriceCruiser");
                    break;
                }
                case DESTROYER: {
                    base = Global.getSettings().getFloat("blueprintBasePriceDestroyer");
                    break;
                }
                case FIGHTER: 
                case FRIGATE: {
                    base = Global.getSettings().getFloat("blueprintBasePriceFrigate");
                }
            }
            return (int)(base + this.ship.getBaseValue() * this.getItemPriceMult());
        }
        return super.getPrice(market, submarket);
    }

    @Override
    protected float getItemPriceMult() {
        return Global.getSettings().getFloat("blueprintPriceOriginalShipMult");
    }

    @Override
    public String getName() {
        if (this.ship != null) {
            return String.valueOf(this.ship.getNameWithDesignationWithDashClass()) + " Blueprint";
        }
        return super.getName();
    }

    @Override
    public String getDesignType() {
        if (this.ship != null) {
            return this.ship.getManufacturer();
        }
        return null;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        super.createTooltip(tooltip, expanded, transferHandler, stackSource);
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        String hullId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsShip(hullId);
        ArrayList<String> hulls = new ArrayList<String>();
        hulls.add(hullId);
        this.addShipList(tooltip, "Ship hulls:", hulls, 1, opad);
        Description desc = Global.getSettings().getDescription(this.ship.getDescriptionId(), Description.Type.SHIP);
        String prefix = "";
        if (this.ship.getDescriptionPrefix() != null) {
            prefix = String.valueOf(this.ship.getDescriptionPrefix()) + "\n\n";
        }
        tooltip.addPara(String.valueOf(prefix) + desc.getText1FirstPara(), opad);
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        if (known) {
            tooltip.addPara("Already known", g, opad);
        } else {
            tooltip.addPara("Right-click to learn", b, opad);
        }
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        String hullId = this.stack.getSpecialDataIfSpecial().getData();
        return !Global.getSector().getPlayerFaction().knowsShip(hullId);
    }

    @Override
    public void performRightClickAction() {
        String hullId = this.stack.getSpecialDataIfSpecial().getData();
        if (Global.getSector().getPlayerFaction().knowsShip(hullId)) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.ship.getNameWithDesignationWithDashClass() + ": blueprint already known");
        } else {
            Global.getSoundPlayer().playUISound("ui_acquired_blueprint", 1.0f, 1.0f);
            Global.getSector().getPlayerFaction().addKnownShip(hullId, true);
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired blueprint: " + this.ship.getNameWithDesignationWithDashClass());
        }
    }

    @Override
    public String resolveDropParamsToSpecificItemData(String params, Random random) throws JSONException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (!params.startsWith("{")) {
            return params;
        }
        JSONObject json = new JSONObject(params);
        HashSet<String> tags = new HashSet<String>();
        if (json.has("tags")) {
            JSONArray tagsArray = json.getJSONArray("tags");
            int i = 0;
            while (i < tagsArray.length()) {
                tags.add(tagsArray.getString(i));
                ++i;
            }
        }
        return ShipBlueprintItemPlugin.pickShip(tags, random);
    }

    public static String pickShip(Set<String> tags, Random random) {
        List<ShipHullSpecAPI> specs = Global.getSettings().getAllShipHullSpecs();
        Iterator<ShipHullSpecAPI> iter = specs.iterator();
        if (!tags.isEmpty()) {
            iter = specs.iterator();
            block0: while (iter.hasNext()) {
                ShipHullSpecAPI curr = iter.next();
                for (String tag : tags) {
                    boolean not;
                    tag = (not = tag.startsWith("!")) ? tag.substring(1) : tag;
                    boolean has = curr.hasTag(tag);
                    if (not != has) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
        WeightedRandomPicker<ShipHullSpecAPI> picker = new WeightedRandomPicker<ShipHullSpecAPI>(random);
        for (ShipHullSpecAPI spec : specs) {
            picker.add(spec, 1.0f * spec.getRarity());
        }
        ShipHullSpecAPI pick = (ShipHullSpecAPI)picker.pick();
        if (pick == null) {
            return null;
        }
        return pick.getHullId();
    }
}

