/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.AICoreAdminPlugin;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.BaseCampaignPlugin;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BattleAutoresolverPlugin;
import com.fs.starfarer.api.campaign.BattleCreationPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainPlugin;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.FleetStubConverterPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.ai.AbilityAIPlugin;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.ImmigrationPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.AICoreAdminPluginImpl;
import com.fs.starfarer.api.impl.campaign.AICoreOfficerPluginImpl;
import com.fs.starfarer.api.impl.campaign.BattleAutoresolverPluginImpl;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.FleetStubConverterPluginImpl;
import com.fs.starfarer.api.impl.campaign.GateEntityPlugin;
import com.fs.starfarer.api.impl.campaign.JumpPointInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.OrbitalStationInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.PlanetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialRespawnDialogPluginImpl;
import com.fs.starfarer.api.impl.combat.BattleCreationPluginImpl;
import com.fs.starfarer.api.plugins.AutofitPlugin;
import com.fs.starfarer.api.plugins.impl.CoreAutofitPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashSet;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreCampaignPluginImpl
extends BaseCampaignPlugin {
    @Override
    public String getId() {
        return "coreCampaignPluginImpl";
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public PluginPick<InteractionDialogPlugin> pickInteractionDialogPlugin(SectorEntityToken interactionTarget) {
        if (interactionTarget.hasTag("objective") || interactionTarget.getMarket() != null) {
            return new PluginPick<InteractionDialogPlugin>(new RuleBasedInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget.hasTag("gate")) {
            return new PluginPick<InteractionDialogPlugin>(new RuleBasedInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget.hasTag("station")) {
            return new PluginPick<InteractionDialogPlugin>(new RuleBasedInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget.hasTag("has_interaction_dialog")) {
            return new PluginPick<InteractionDialogPlugin>(new RuleBasedInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget.getMarket() != null) {
            return new PluginPick<InteractionDialogPlugin>(new OrbitalStationInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget instanceof CampaignFleetAPI) {
            return new PluginPick<InteractionDialogPlugin>(new FleetInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget instanceof JumpPointAPI) {
            return new PluginPick<InteractionDialogPlugin>(new JumpPointInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        if (interactionTarget instanceof PlanetAPI) {
            return new PluginPick<InteractionDialogPlugin>(new PlanetInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public PluginPick<InteractionDialogPlugin> pickInteractionDialogPlugin(Object param, SectorEntityToken interactionTarget) {
        return null;
    }

    @Override
    public PluginPick<AbilityAIPlugin> pickAbilityAI(AbilityPlugin ability, ModularFleetAIAPI ai) {
        if (ability == null) {
            return null;
        }
        String id = ability.getId();
        if (id == null) {
            return null;
        }
        if (ability.getSpec().getAIPluginClass() != null) {
            return new PluginPick<AbilityAIPlugin>(ability.getSpec().getNewAIPluginInstance(ability), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public PluginPick<BattleCreationPlugin> pickBattleCreationPlugin(SectorEntityToken opponent) {
        if (opponent instanceof CampaignFleetAPI) {
            return new PluginPick<BattleCreationPlugin>(new BattleCreationPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public PluginPick<BattleAutoresolverPlugin> pickBattleAutoresolverPlugin(BattleAPI battle) {
        return new PluginPick<BattleAutoresolverPlugin>(new BattleAutoresolverPluginImpl(battle), CampaignPlugin.PickPriority.CORE_GENERAL);
    }

    @Override
    public PluginPick<ReputationActionResponsePlugin> pickReputationActionResponsePlugin(Object action, String factionId) {
        if (action instanceof CoreReputationPlugin.RepActions || action instanceof CoreReputationPlugin.RepActionEnvelope) {
            return new PluginPick<ReputationActionResponsePlugin>(new CoreReputationPlugin(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public PluginPick<ReputationActionResponsePlugin> pickReputationActionResponsePlugin(Object action, PersonAPI person) {
        if (action instanceof CoreReputationPlugin.RepActions || action instanceof CoreReputationPlugin.RepActionEnvelope) {
            return new PluginPick<ReputationActionResponsePlugin>(new CoreReputationPlugin(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public void updateEntityFacts(SectorEntityToken entity, MemoryAPI memory) {
        MarketAPI market;
        for (String tag : entity.getTags()) {
            memory.set("$tag:" + tag, true, 0.0f);
        }
        String onOrAt = "on";
        if (entity.hasTag("station")) {
            onOrAt = "at";
        }
        memory.set("$onOrAt", onOrAt, 0.0f);
        if (entity.getStarSystem() != null && entity.getStarSystem().hasTag("system_cut_off_from_hyper")) {
            memory.set("$systemCutOffFromHyper", true, 0.0f);
        }
        if (entity.getContainingLocation() != null) {
            memory.set("$locationId", entity.getContainingLocation().getId(), 0.0f);
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        memory.set("$id", entity.getId(), 0.0f);
        memory.set("$transponderOn", entity.isTransponderOn(), 0.0f);
        memory.set("$name", entity.getName(), 0.0f);
        memory.set("$fullName", entity.getFullName(), 0.0f);
        memory.set("$inHyperspace", entity.isInHyperspace(), 0.0f);
        if (entity.getCustomEntityType() != null) {
            memory.set("$customType", entity.getCustomEntityType(), 0.0f);
            if (entity.getCustomEntitySpec() != null) {
                CustomEntitySpecAPI spec = entity.getCustomEntitySpec();
                memory.set("$nameInText", spec.getNameInText(), 0.0f);
                memory.set("$shortName", spec.getShortName(), 0.0f);
                memory.set("$isOrAre", spec.getIsOrAre(), 0.0f);
                memory.set("$aOrAn", spec.getAOrAn(), 0.0f);
            }
        }
        if (entity instanceof CampaignTerrainAPI) {
            CampaignTerrainAPI terrain = (CampaignTerrainAPI)entity;
            CampaignTerrainPlugin plugin = terrain.getPlugin();
            memory.set("$terrainId", plugin.getSpec().getId(), 0.0f);
        }
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            if (fleet.getAI() instanceof CampaignFleetAIAPI) {
                CampaignFleetAIAPI ai = fleet.getAI();
                CampaignFleetAIAPI.EncounterOption option = ai.pickEncounterOption(null, playerFleet, true);
                BattleAPI b = fleet.getBattle();
                if (b != null && b.isPlayerInvolved()) {
                    b.genCombined();
                    option = b.getCombinedFor(fleet).getAI().pickEncounterOption(null, b.getCombinedFor(Global.getSector().getPlayerFleet()), true);
                }
                switch (option) {
                    case DISENGAGE: {
                        memory.set("$relativeStrength", -1, 0.0f);
                        break;
                    }
                    case ENGAGE: {
                        memory.set("$relativeStrength", 1, 0.0f);
                        break;
                    }
                    case HOLD: {
                        memory.set("$relativeStrength", 0, 0.0f);
                        break;
                    }
                    case HOLD_VS_STRONGER: {
                        memory.set("$weakerThanPlayerButHolding", true, 0.0f);
                        memory.set("$relativeStrength", -1, 0.0f);
                    }
                }
                memory.set("$isHostile", ai.isHostileTo(playerFleet), 0.0f);
                memory.set("$fleetPoints", fleet.getFleetPoints(), 0.0f);
            }
            memory.set("$isStation", fleet.isStationMode(), 0.0f);
            memory.set("$supplies", Float.valueOf(fleet.getCargo().getSupplies()), 0.0f);
            memory.set("$fuel", Float.valueOf(fleet.getCargo().getFuel()), 0.0f);
            memory.set("$knowsWhoPlayerIs", fleet.knowsWhoPlayerIs(), 0.0f);
            if (!playerFleet.isTransponderOn() && !memory.contains("$sawPlayerTransponderOff")) {
                memory.set("$sawPlayerTransponderOff", true, 0.0f);
            }
            if (!Misc.isPermaKnowsWhoPlayerIs(fleet) && playerFleet.isTransponderOn()) {
                memory.set("$sawPlayerTransponderOn", true, 7.0f + (float)Math.random() * 7.0f);
            }
        }
        if (entity.getFaction() != null && !memory.contains("$isHostile")) {
            float rel = entity.getFaction().getRelationship("player");
            RepLevel level = RepLevel.getLevelFor(rel);
            if (level.isAtWorst(RepLevel.INHOSPITABLE)) {
                memory.set("$isHostile", false, 0.0f);
            } else {
                memory.set("$isHostile", true, 0.0f);
            }
        }
        if ((market = entity.getMarket()) != null) {
            if (!market.isPlanetConditionMarketOnly()) {
                memory.set("$hasMarket", true, 0.0f);
            }
            if (Misc.getStationFleet(market) != null) {
                memory.set("$hasStation", true, 0.0f);
            }
            memory.set("$marketSize", market.getSize(), 0.0f);
            memory.set("$stability", (int)market.getStabilityValue(), 0.0f);
        }
        if (entity instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)entity;
            memory.set("$planetType", planet.getTypeId(), 0.0f);
        }
    }

    @Override
    public void updateMarketFacts(MarketAPI market, MemoryAPI memory) {
        if (market != null) {
            for (String tag : market.getTags()) {
                memory.set("$tag:" + tag, true, 0.0f);
            }
            for (MarketConditionAPI mc : market.getConditions()) {
                memory.set("$mc:" + mc.getId(), true, 0.0f);
            }
            for (Industry ind : market.getIndustries()) {
                memory.set("$ind:" + ind.getId(), true, 0.0f);
            }
            memory.set("$id", market.getId(), 0.0f);
            memory.set("$size", market.getSize(), 0.0f);
            memory.set("$stability", (int)market.getStabilityValue(), 0.0f);
            memory.set("$isSurveyed", market.getSurveyLevel() == MarketAPI.SurveyLevel.FULL, 0.0f);
            memory.set("$surveyLevel", market.getSurveyLevel().name(), 0.0f);
            memory.set("$isPlanetConditionMarketOnly", market.isPlanetConditionMarketOnly(), 0.0f);
            memory.set("$isHidden", market.isHidden(), 0.0f);
            memory.set("$isPlayerOwned", market.isPlayerOwned(), 0.0f);
            boolean hasRuins = false;
            if (Misc.hasRuins(market)) {
                memory.set("$hasRuins", true, 0.0f);
                hasRuins = true;
            }
            memory.set("$hasUnexploredRuins", Misc.hasUnexploredRuins(market), 0.0f);
            float suspicionLevel = CoreCampaignPluginImpl.computeSmugglingSuspicionLevel(market);
            memory.set("$smugglingSuspicion", Float.valueOf(suspicionLevel), 0.0f);
        }
    }

    public static final float computeSmugglingSuspicionLevel(MarketAPI market) {
        float smugglingTotal = 0.0f;
        float tradeTotal = 0.0f;
        for (SubmarketAPI submarket : market.getSubmarketsCopy()) {
            SubmarketPlugin plugin = submarket.getPlugin();
            if (!plugin.isParticipatesInEconomy()) continue;
            PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
            if (submarket.getFaction().isHostileTo(market.getFaction()) || submarket.getPlugin().isBlackMarket()) {
                smugglingTotal += tradeData.getTotalPlayerTradeValue();
                continue;
            }
            tradeTotal += tradeData.getTotalPlayerTradeValue();
        }
        float suspicionLevel = 0.0f;
        if (smugglingTotal + tradeTotal > 0.0f) {
            suspicionLevel = smugglingTotal / (smugglingTotal + tradeTotal);
            float threshold = 10000.0f * (float)market.getSize();
            suspicionLevel *= Math.min(1.0f, (smugglingTotal + tradeTotal) / threshold);
        }
        float extra = market.getMemoryWithoutUpdate().getFloat("$marketExtraSuspicion");
        suspicionLevel += extra;
        suspicionLevel = Math.min(1.0f, suspicionLevel);
        return suspicionLevel;
    }

    @Override
    public void updatePersonFacts(PersonAPI person, MemoryAPI memory) {
        memory.set("$id", person.getId(), 0.0f);
        for (String tag : person.getTags()) {
            memory.set("$tag:" + tag, true, 0.0f);
        }
        float rel = person.getRelToPlayer().getRel();
        memory.set("$rel", Float.valueOf(rel), 0.0f);
        if (Misc.isMercenary(person)) {
            memory.set("$mercContractDur", (int)Global.getSettings().getFloat("officerMercContractDur"), 0.0f);
            memory.set("$mercContractDurStr", "" + (int)Global.getSettings().getFloat("officerMercContractDur"), 0.0f);
        }
        memory.set("$isPerson", true, 0.0f);
        memory.set("$name", person.getName().getFullName(), 0.0f);
        memory.set("$personName", person.getName().getFullName(), 0.0f);
        memory.set("$isContact", ContactIntel.playerHasContact(person, false), 0.0f);
        memory.set("$rankId", person.getRankId(), 0.0f);
        memory.set("$postId", person.getPostId(), 0.0f);
        if (person.isAICore()) {
            memory.set("$aiCoreId", person.getAICoreId(), 0.0f);
            memory.set("$isAICore", true, 0.0f);
        }
        memory.set("$rankAOrAn", person.getRankArticle(), 0.0f);
        memory.set("$postAOrAn", person.getPostArticle(), 0.0f);
        if (person.getRank() != null) {
            memory.set("$rank", person.getRank().toLowerCase(), 0.0f);
            memory.set("$Rank", Misc.ucFirst(person.getRank()), 0.0f);
        }
        if (person.getPost() != null) {
            memory.set("$post", person.getPost().toLowerCase(), 0.0f);
            memory.set("$Post", Misc.ucFirst(person.getPost()), 0.0f);
        }
        memory.set("$importance", person.getImportance().name(), 0.0f);
        memory.set("$level", person.getStats().getLevel(), 0.0f);
        memory.set("$personality", person.getPersonalityAPI().getId(), 0.0f);
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        ImportantPeopleAPI.PersonDataAPI data = ip.getData(person);
        if (data != null && data.getLocation().getMarket() != null) {
            MarketAPI market = data.getLocation().getMarket();
            memory.set("$hostileToMarket", person.getFaction().isHostileTo(market.getFaction()), 0.0f);
        }
    }

    @Override
    public void updateFactionFacts(FactionAPI faction, MemoryAPI memory) {
        memory.set("$id", faction.getId(), 0.0f);
        float rel = faction.getRelationship("player");
        RepLevel level = RepLevel.getLevelFor(rel);
        if (level.isAtWorst(RepLevel.FAVORABLE)) {
            memory.set("$friendlyToPlayer", true, 0.0f);
        } else if (level.isAtBest(RepLevel.HOSTILE)) {
            memory.set("$hostileToPlayer", true, 0.0f);
        } else {
            memory.set("$neutralToPlayer", true, 0.0f);
        }
        if (level.isAtWorst(RepLevel.INHOSPITABLE)) {
            memory.set("$isHostile", false, 0.0f);
        } else {
            memory.set("$isHostile", true, 0.0f);
        }
        if (JSONObject.getNames((JSONObject)faction.getCustom()) != null) {
            String[] stringArray = JSONObject.getNames((JSONObject)faction.getCustom());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String val = faction.getCustom().optString(key);
                memory.set("$c:" + key, val, 0.0f);
                ++n2;
            }
        }
        Color c = faction.getColor();
        memory.set("$color", String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha(), 0.0f);
        c = faction.getBaseUIColor();
        memory.set("$baseColor", String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha(), 0.0f);
        c = faction.getBrightUIColor();
        memory.set("$brightColor", String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha(), 0.0f);
        c = faction.getDarkUIColor();
        memory.set("$darkColor", String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha(), 0.0f);
        c = faction.getGridUIColor();
        memory.set("$gridColor", String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha(), 0.0f);
        memory.set("$isNeutralFaction", faction.isNeutralFaction(), 0.0f);
        memory.set("$relValue", Float.valueOf(rel), 0.0f);
        memory.set("$rel", level.name(), 0.0f);
    }

    @Override
    public void updateGlobalFacts(MemoryAPI memory) {
        if (Global.getSettings().isDevMode()) {
            memory.set("$isDevMode", true, 0.0f);
        }
        if (TutorialMissionIntel.isTutorialInProgress()) {
            memory.set("$isInTutorial", true, 0.0f);
        }
        if (!memory.getBoolean(GateEntityPlugin.PLAYER_CAN_USE_GATES)) {
            memory.set(GateEntityPlugin.PLAYER_CAN_USE_GATES, GateEntityPlugin.canUseGates(), 0.0f);
        }
        memory.set("$daysSinceStart", Float.valueOf(PirateBaseManager.getInstance().getUnadjustedDaysSinceStart()), 0.0f);
    }

    @Override
    public void updatePlayerFacts(MemoryAPI memory) {
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        PersonAPI person = Global.getSector().getPlayerPerson();
        memory.set("$firstName", person.getName().getFirst(), 0.0f);
        memory.set("$lastName", person.getName().getLast(), 0.0f);
        memory.set("$name", person.getName().getFullName(), 0.0f);
        if (Misc.getCommissionFactionId() != null) {
            memory.set("$commissionFactionId", Misc.getCommissionFactionId(), 0.0f);
        }
        if (fleet.getContainingLocation() != null) {
            memory.set("$locationId", fleet.getContainingLocation().getId(), 0.0f);
            for (String tag : fleet.getContainingLocation().getTags()) {
                memory.set("$locTag:" + tag, true, 0.0f);
            }
        }
        memory.set("$fleetId", fleet.getId(), 0.0f);
        memory.set("$transponderOn", fleet.isTransponderOn(), 0.0f);
        memory.set("$supplies", (int)fleet.getCargo().getSupplies(), 0.0f);
        memory.set("$fuel", (int)fleet.getCargo().getFuel(), 0.0f);
        memory.set("$machinery", (int)fleet.getCargo().getCommodityQuantity("heavy_machinery"), 0.0f);
        memory.set("$marines", fleet.getCargo().getMarines(), 0.0f);
        memory.set("$crew", fleet.getCargo().getCrew(), 0.0f);
        memory.set("$crewRoom", (int)(fleet.getCargo().getMaxPersonnel() - (float)fleet.getCargo().getTotalPersonnel()), 0.0f);
        memory.set("$fuelRoom", (int)fleet.getCargo().getMaxFuel() - (int)fleet.getCargo().getFuel(), 0.0f);
        memory.set("$cargoRoom", (int)fleet.getCargo().getMaxCapacity() - (int)fleet.getCargo().getSpaceUsed(), 0.0f);
        memory.set("$crewRoomStr", Misc.getWithDGS((int)(fleet.getCargo().getMaxPersonnel() - (float)fleet.getCargo().getTotalPersonnel())), 0.0f);
        memory.set("$fuelRoomStr", Misc.getWithDGS((int)fleet.getCargo().getMaxFuel() - (int)fleet.getCargo().getFuel()), 0.0f);
        memory.set("$cargoRoomStr", Misc.getWithDGS((int)fleet.getCargo().getMaxCapacity() - (int)fleet.getCargo().getSpaceUsed()), 0.0f);
        memory.set("$credits", (int)fleet.getCargo().getCredits().get(), 0.0f);
        memory.set("$creditsStr", Misc.getWithDGS((int)fleet.getCargo().getCredits().get()), 0.0f);
        memory.set("$creditsStrC", String.valueOf(Misc.getWithDGS((int)fleet.getCargo().getCredits().get())) + "\u00a2", 0.0f);
        HashSet<String> seen = new HashSet<String>();
        for (CargoStackAPI stack : fleet.getCargo().getStacksCopy()) {
            String id = stack.getCommodityId();
            if (id == null || seen.contains(id)) continue;
            seen.add(id);
            int quantity = (int)fleet.getCargo().getCommodityQuantity(id);
            String key = "$" + id;
            if (memory.contains(key)) continue;
            memory.set(key, quantity, 0.0f);
        }
        MonthlyReport report = SharedData.getData().getPreviousReport();
        boolean debt = report.getDebt() > 0;
        boolean longDebt = report.getDebt() > 0 && report.getPreviousDebt() > 0;
        memory.set("$inDebt", debt, 0.0f);
        memory.set("$inLongDebt", longDebt, 0.0f);
        int fleetSizeCount = fleet.getFleetSizeCount();
        int maxSize = 0;
        int maxCombatSize = 0;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            ShipAPI.HullSize size = member.getHullSpec().getHullSize();
            int val = 1;
            switch (size) {
                case CAPITAL_SHIP: {
                    val = 4;
                    break;
                }
                case CRUISER: {
                    val = 3;
                    break;
                }
                case DESTROYER: {
                    val = 2;
                    break;
                }
                case DEFAULT: 
                case FIGHTER: 
                case FRIGATE: {
                    val = 1;
                }
            }
            if (val > maxSize) {
                maxSize = val;
            }
            if (val <= maxCombatSize || member.isCivilian()) continue;
            maxCombatSize = val;
        }
        memory.set("$maxHullSize", maxSize, 0.0f);
        memory.set("$maxCombatHullSize", maxCombatSize, 0.0f);
        memory.set("$fleetSizeCount", fleetSizeCount, 0.0f);
        memory.set("$numShips", fleet.getFleetData().getMembersListCopy().size(), 0.0f);
        memory.set("$fleetPoints", fleet.getFleetPoints(), 0.0f);
        memory.set("$numColonies", Misc.getPlayerMarkets(true).size(), 0.0f);
        if (fleet.getFlagship() != null) {
            memory.set("$flagshipName", fleet.getFlagship().getShipName(), 0.0f);
        }
        for (String id : fleet.getAbilities().keySet()) {
            memory.set("$ability:" + id, true, 0.0f);
        }
    }

    @Override
    public PluginPick<FleetStubConverterPlugin> pickStubConverter(CampaignFleetAPI fleet) {
        return new PluginPick<FleetStubConverterPlugin>(new FleetStubConverterPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
    }

    @Override
    public PluginPick<FleetStubConverterPlugin> pickStubConverter(FleetStubAPI stub) {
        return null;
    }

    @Override
    public PluginPick<AutofitPlugin> pickAutofitPlugin(FleetMemberAPI member) {
        PersonAPI commander = null;
        if (member != null && (commander = member.getFleetCommanderForStats()) == null) {
            commander = member.getFleetCommander();
        }
        return new PluginPick<AutofitPlugin>(new CoreAutofitPlugin(commander), CampaignPlugin.PickPriority.CORE_GENERAL);
    }

    @Override
    public PluginPick<InteractionDialogPlugin> pickRespawnPlugin() {
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean("$tutorialRespawn")) {
            return new PluginPick<InteractionDialogPlugin>(new TutorialRespawnDialogPluginImpl(), CampaignPlugin.PickPriority.MOD_SPECIFIC);
        }
        return null;
    }

    @Override
    public PluginPick<ImmigrationPlugin> pickImmigrationPlugin(MarketAPI market) {
        return new PluginPick<ImmigrationPlugin>(new CoreImmigrationPluginImpl(market), CampaignPlugin.PickPriority.CORE_GENERAL);
    }

    @Override
    public PluginPick<AICoreAdminPlugin> pickAICoreAdminPlugin(String commodityId) {
        if ("alpha_core".equals(commodityId)) {
            return new PluginPick<AICoreAdminPlugin>(new AICoreAdminPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public PluginPick<AICoreOfficerPlugin> pickAICoreOfficerPlugin(String commodityId) {
        if ("omega_core".equals(commodityId) || "alpha_core".equals(commodityId) || "beta_core".equals(commodityId) || "gamma_core".equals(commodityId)) {
            return new PluginPick<AICoreOfficerPlugin>(new AICoreOfficerPluginImpl(), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }

    @Override
    public PluginPick<FleetInflater> pickFleetInflater(CampaignFleetAPI fleet, Object params) {
        if (params instanceof DefaultFleetInflaterParams) {
            DefaultFleetInflaterParams p = (DefaultFleetInflaterParams)params;
            return new PluginPick<FleetInflater>(new DefaultFleetInflater(p), CampaignPlugin.PickPriority.CORE_GENERAL);
        }
        return null;
    }
}

