/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CombatDamageData;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.combat.FighterLaunchBayAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.RepairGantry;
import com.fs.starfarer.api.impl.campaign.intel.PromoteOfficerIntel;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetEncounterContext
implements FleetEncounterContextPlugin {
    protected List<FleetEncounterContextPlugin.DataForEncounterSide> sideData = new ArrayList<FleetEncounterContextPlugin.DataForEncounterSide>();
    protected boolean engagedInHostilities = false;
    protected boolean engagedInActualBattle = false;
    protected boolean playerOnlyRetreated = true;
    protected boolean playerPursued = false;
    protected boolean playerDidSeriousDamage = false;
    protected BattleAPI battle;
    protected boolean otherFleetHarriedPlayer = false;
    protected boolean ongoingBattle = false;
    protected boolean isAutoresolve = false;
    protected CombatDamageData runningDamageTotal = null;
    protected boolean alreadyAdjustedRep = false;
    public TextPanelAPI textPanelForXPGain = null;
    protected boolean noHarryBecauseOfStation = false;
    protected FleetEncounterContextPlugin.EngagementOutcome lastOutcome = null;
    public static final float SELF_DESTRUCT_CHANCE = 0.25f;
    public static final float CIV_SELF_DESTRUCT_CHANCE = 0.05f;
    public static final float ENGAGE_ESCAPE_CHANCE = 0.25f;
    public static final float ENGAGE_DISABLE_CHANCE = 0.5f;
    public static final float ENGAGE_DESTROY_CHANCE = 0.25f;
    public static final float LAUNCH_CLEAN_ESCAPE_CHANCE = 0.5f;
    public static final float DOCK_SUCCESS_CHANCE = 0.5f;
    public static final float LAUNCH_SUCCESS_CHANCE = 0.25f;
    protected List<FleetMemberAPI> recoverableShips = new ArrayList<FleetMemberAPI>();
    protected List<FleetMemberAPI> storyRecoverableShips = new ArrayList<FleetMemberAPI>();
    protected float playerFPHullDamageToEnemies = 0.0f;
    protected float allyFPHullDamageToEnemies = 0.0f;
    protected float playerFPHullDamageToAllies = 0.0f;
    protected Map<FactionAPI, Float> playerFPHullDamageToAlliesByFaction = new HashMap<FactionAPI, Float>();
    protected float xpGained = 0.0f;
    protected CargoAPI loot = Global.getFactory().createCargo(false);
    protected int creditsLooted = 0;
    private Random salvageRandom = null;
    protected Map<FleetMemberAPI, Float> preEngagementCRForWinner = new HashMap<FleetMemberAPI, Float>();
    public static float MAX_XP_MULT = 6.0f;
    protected float difficulty = 1.0f;
    protected boolean computedDifficulty = false;

    public boolean isAutoresolve() {
        return this.isAutoresolve;
    }

    public void setAutoresolve(boolean isAutoresolve) {
        this.isAutoresolve = isAutoresolve;
    }

    @Override
    public BattleAPI getBattle() {
        return this.battle;
    }

    public void setBattle(BattleAPI battle) {
        this.battle = battle;
    }

    @Override
    public FleetEncounterContextPlugin.DataForEncounterSide getDataFor(CampaignFleetAPI participantOrCombined) {
        CampaignFleetAPI combined = this.battle.getCombinedFor(participantOrCombined);
        if (combined == null) {
            return new FleetEncounterContextPlugin.DataForEncounterSide(participantOrCombined);
        }
        for (FleetEncounterContextPlugin.DataForEncounterSide curr : this.sideData) {
            if (curr.getFleet() != combined) continue;
            return curr;
        }
        FleetEncounterContextPlugin.DataForEncounterSide dfes = new FleetEncounterContextPlugin.DataForEncounterSide(combined);
        this.sideData.add(dfes);
        return dfes;
    }

    @Override
    public FleetEncounterContextPlugin.DataForEncounterSide getWinnerData() {
        for (FleetEncounterContextPlugin.DataForEncounterSide curr : this.sideData) {
            if (curr.disengaged()) continue;
            return curr;
        }
        return null;
    }

    @Override
    public FleetEncounterContextPlugin.DataForEncounterSide getLoserData() {
        for (FleetEncounterContextPlugin.DataForEncounterSide curr : this.sideData) {
            if (!curr.disengaged()) continue;
            return curr;
        }
        return null;
    }

    @Override
    public boolean isEngagedInHostilities() {
        return this.engagedInHostilities;
    }

    public void setEngagedInHostilities(boolean engagedInHostilities) {
        this.engagedInHostilities = engagedInHostilities;
    }

    @Override
    public void setOtherFleetHarriedPlayer(boolean otherFleetHarriedPlayer) {
        this.otherFleetHarriedPlayer = otherFleetHarriedPlayer;
    }

    @Override
    public boolean isOtherFleetHarriedPlayer() {
        return this.otherFleetHarriedPlayer;
    }

    protected void updateDeployedMap(EngagementResultForFleetAPI result) {
        FleetEncounterContextPlugin.DataForEncounterSide data = this.getDataFor(result.getFleet());
        data.getMemberToDeployedMap().clear();
        List<DeployedFleetMemberAPI> deployed = result.getAllEverDeployedCopy();
        if (deployed != null && !deployed.isEmpty()) {
            for (DeployedFleetMemberAPI dfm : deployed) {
                if (dfm.getMember() == null) continue;
                FleetMemberAPI member = dfm.getMember();
                data.getMemberToDeployedMap().put(member, dfm);
                if (dfm == null || dfm.getShip() == null || dfm.getShip().getOriginalCaptain() == null || dfm.getShip().getOriginalCaptain().isDefault()) continue;
                data.getMembersWithOfficerOrPlayerAsOrigCaptain().add(member);
            }
        }
    }

    protected void clearNoSourceMembers(EngagementResultForFleetAPI result) {
        FleetMemberAPI member;
        Iterator<FleetMemberAPI> iter = result.getDeployed().iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (this.battle.getSourceFleet(member) != null) continue;
            iter.remove();
        }
        iter = result.getReserves().iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (this.battle.getSourceFleet(member) != null) continue;
            iter.remove();
        }
        iter = result.getDestroyed().iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (this.battle.getSourceFleet(member) != null) continue;
            iter.remove();
        }
        iter = result.getDisabled().iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (this.battle.getSourceFleet(member) != null) continue;
            iter.remove();
        }
        iter = result.getRetreated().iterator();
        while (iter.hasNext()) {
            member = iter.next();
            if (this.battle.getSourceFleet(member) != null) continue;
            iter.remove();
        }
    }

    public boolean isEngagedInActualBattle() {
        return this.engagedInActualBattle;
    }

    public void setEngagedInActualBattle(boolean engagedInActualBattle) {
        this.engagedInActualBattle = engagedInActualBattle;
    }

    public void processEngagementResults(EngagementResultAPI result) {
        this.engagedInHostilities = true;
        this.engagedInActualBattle = true;
        EngagementResultForFleetAPI winnerResult = result.getWinnerResult();
        EngagementResultForFleetAPI loserResult = result.getLoserResult();
        this.clearNoSourceMembers(winnerResult);
        this.clearNoSourceMembers(loserResult);
        CombatDamageData currDamageData = result.getLastCombatDamageData();
        if (currDamageData != null) {
            if (this.runningDamageTotal == null) {
                this.runningDamageTotal = currDamageData;
            } else {
                this.runningDamageTotal.add(currDamageData);
            }
            this.computeFPHullDamage();
        }
        if (this.battle.isPlayerInvolved()) {
            Global.getSector().reportPlayerEngagement(result);
        }
        this.updateDeployedMap(winnerResult);
        this.updateDeployedMap(loserResult);
        this.applyResultToFleets(result);
        if (this.battle.isPlayerSide(winnerResult) && winnerResult.getGoal() != FleetGoal.ESCAPE) {
            this.playerOnlyRetreated = false;
            if (loserResult.getGoal() == FleetGoal.ESCAPE) {
                this.playerPursued = true;
            }
        } else if (this.battle.isPlayerSide(loserResult) && loserResult.getGoal() != FleetGoal.ESCAPE) {
            this.playerOnlyRetreated = false;
            if (winnerResult.getGoal() == FleetGoal.ESCAPE) {
                this.playerPursued = true;
            }
        }
        FleetEncounterContextPlugin.DataForEncounterSide winnerData = this.getDataFor(winnerResult.getFleet());
        FleetEncounterContextPlugin.DataForEncounterSide loserData = this.getDataFor(loserResult.getFleet());
        winnerData.setWonLastEngagement(true);
        winnerData.setEnemyCanCleanDisengage(winnerResult.enemyCanCleanDisengage());
        loserData.setWonLastEngagement(false);
        loserData.setEnemyCanCleanDisengage(loserResult.enemyCanCleanDisengage());
        winnerData.setDidEnoughToDisengage(true);
        float damageInFP = 0.0f;
        for (FleetMemberAPI member : winnerResult.getDisabled()) {
            damageInFP += (float)member.getFleetPointCost();
        }
        for (FleetMemberAPI member : winnerResult.getDestroyed()) {
            damageInFP += (float)member.getFleetPointCost();
        }
        for (FleetMemberAPI member : winnerResult.getRetreated()) {
            damageInFP += (float)member.getFleetPointCost();
        }
        loserData.setDidEnoughToDisengage(winnerResult.enemyCanCleanDisengage());
        winnerData.setLastGoal(winnerResult.getGoal());
        loserData.setLastGoal(loserResult.getGoal());
        winnerData.getDeployedInLastEngagement().clear();
        winnerData.getRetreatedFromLastEngagement().clear();
        winnerData.getInReserveDuringLastEngagement().clear();
        winnerData.getDisabledInLastEngagement().clear();
        winnerData.getDestroyedInLastEngagement().clear();
        winnerData.getDeployedInLastEngagement().addAll(winnerResult.getDeployed());
        winnerData.getRetreatedFromLastEngagement().addAll(winnerResult.getRetreated());
        winnerData.getInReserveDuringLastEngagement().addAll(winnerResult.getReserves());
        winnerData.getDisabledInLastEngagement().addAll(winnerResult.getDisabled());
        winnerData.getDestroyedInLastEngagement().addAll(winnerResult.getDestroyed());
        loserData.getDeployedInLastEngagement().clear();
        loserData.getRetreatedFromLastEngagement().clear();
        loserData.getInReserveDuringLastEngagement().clear();
        loserData.getDisabledInLastEngagement().clear();
        loserData.getDestroyedInLastEngagement().clear();
        loserData.getDeployedInLastEngagement().addAll(loserResult.getDeployed());
        loserData.getRetreatedFromLastEngagement().addAll(loserResult.getRetreated());
        loserData.getInReserveDuringLastEngagement().addAll(loserResult.getReserves());
        loserData.getDisabledInLastEngagement().addAll(loserResult.getDisabled());
        loserData.getDestroyedInLastEngagement().addAll(loserResult.getDestroyed());
        for (FleetMemberAPI member : loserResult.getDestroyed()) {
            loserData.addOwn(member, FleetEncounterContextPlugin.Status.DESTROYED);
        }
        for (FleetMemberAPI member : loserResult.getDisabled()) {
            loserData.addOwn(member, FleetEncounterContextPlugin.Status.DISABLED);
        }
        for (FleetMemberAPI member : winnerResult.getDestroyed()) {
            winnerData.addOwn(member, FleetEncounterContextPlugin.Status.DESTROYED);
        }
        for (FleetMemberAPI member : winnerResult.getDisabled()) {
            winnerData.addOwn(member, FleetEncounterContextPlugin.Status.DISABLED);
        }
        if (result.getWinnerResult().getAllEverDeployedCopy() != null) {
            this.tallyOfficerTime(winnerData, winnerResult);
        }
        if (result.getLoserResult().getAllEverDeployedCopy() != null) {
            this.tallyOfficerTime(loserData, loserResult);
        }
        winnerResult.resetAllEverDeployed();
        this.getDataFor(winnerResult.getFleet()).getMemberToDeployedMap().clear();
        loserResult.resetAllEverDeployed();
        this.getDataFor(loserResult.getFleet()).getMemberToDeployedMap().clear();
        for (FleetMemberAPI member : winnerResult.getDestroyed()) {
            loserData.addEnemy(member, FleetEncounterContextPlugin.Status.DESTROYED);
        }
        for (FleetMemberAPI member : winnerResult.getDisabled()) {
            loserData.addEnemy(member, FleetEncounterContextPlugin.Status.DISABLED);
        }
        for (FleetMemberAPI member : loserResult.getDestroyed()) {
            winnerData.addEnemy(member, FleetEncounterContextPlugin.Status.DESTROYED);
        }
        for (FleetMemberAPI member : loserResult.getDisabled()) {
            winnerData.addEnemy(member, FleetEncounterContextPlugin.Status.DISABLED);
        }
        FleetGoal winnerGoal = winnerResult.getGoal();
        FleetGoal loserGoal = loserResult.getGoal();
        boolean totalWin = loserData.getFleet().getFleetData().getMembersListCopy().isEmpty();
        boolean playerOut = result.isPlayerOutBeforeEnd();
        if (playerOut) {
            FleetGoal playerGoal = null;
            FleetGoal otherGoal = null;
            if (this.battle.isPlayerSide(this.battle.getSideFor(winnerResult.getFleet()))) {
                playerGoal = winnerGoal;
                otherGoal = loserGoal;
            } else {
                playerGoal = loserGoal;
                otherGoal = winnerGoal;
            }
            this.lastOutcome = playerGoal == FleetGoal.ATTACK ? (otherGoal == FleetGoal.ATTACK ? (winnerResult.isPlayer() ? FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_WIN : FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_LOSS) : (winnerResult.isPlayer() ? FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_WIN : FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_LOSS)) : (winnerResult.isPlayer() ? FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_WIN : FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_LOSS);
        } else if (totalWin && winnerData.getFleet().getFleetData().getMembersListCopy().isEmpty()) {
            this.lastOutcome = FleetEncounterContextPlugin.EngagementOutcome.MUTUAL_DESTRUCTION;
        } else if (this.battle.isPlayerSide(this.battle.getSideFor(winnerResult.getFleet()))) {
            if (winnerGoal == FleetGoal.ATTACK && loserGoal == FleetGoal.ATTACK) {
                this.lastOutcome = totalWin ? FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN_TOTAL : FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN;
            } else if (winnerGoal == FleetGoal.ESCAPE) {
                this.lastOutcome = totalWin ? FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_WIN_TOTAL : FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_WIN;
            } else if (loserGoal == FleetGoal.ESCAPE) {
                this.lastOutcome = totalWin ? FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_LOSS_TOTAL : FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_SUCCESS;
            }
        } else if (winnerGoal == FleetGoal.ATTACK && loserGoal == FleetGoal.ATTACK) {
            this.lastOutcome = totalWin ? FleetEncounterContextPlugin.EngagementOutcome.BATTLE_ENEMY_WIN_TOTAL : FleetEncounterContextPlugin.EngagementOutcome.BATTLE_ENEMY_WIN;
        } else if (winnerGoal == FleetGoal.ESCAPE) {
            this.lastOutcome = totalWin ? FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_WIN_TOTAL : FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_WIN;
        } else if (loserGoal == FleetGoal.ESCAPE) {
            this.lastOutcome = totalWin ? FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_LOSS_TOTAL : FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_SUCCESS;
        }
        this.battle.uncombine();
        this.battle.genCombined();
    }

    protected void tallyOfficerTime(FleetEncounterContextPlugin.DataForEncounterSide data, EngagementResultForFleetAPI result) {
        float maxTime = 0.0f;
        for (DeployedFleetMemberAPI dfm : result.getAllEverDeployedCopy()) {
            FleetEncounterContextPlugin.DataForEncounterSide.OfficerEngagementData oed;
            float time = dfm.getShip().getFullTimeDeployed();
            if (time > maxTime) {
                maxTime = time;
            }
            if ((time -= dfm.getShip().getTimeDeployedUnderPlayerControl()) <= 0.0f) continue;
            PersonAPI person = dfm.getMember().getCaptain();
            CampaignFleetAPI source = this.battle.getSourceFleet(dfm.getMember());
            if (source == null) continue;
            if (source.getFleetData().getOfficerData(person) == null) {
                oed = data.getFleetMemberDeploymentData().get(dfm.getMember());
                if (oed == null) {
                    oed = new FleetEncounterContextPlugin.DataForEncounterSide.OfficerEngagementData(source);
                    oed.person = null;
                    data.getFleetMemberDeploymentData().put(dfm.getMember(), oed);
                }
                oed.timeDeployed += (time += dfm.getShip().getTimeDeployedUnderPlayerControl());
                continue;
            }
            oed = data.getOfficerData().get(person);
            if (oed == null) {
                oed = new FleetEncounterContextPlugin.DataForEncounterSide.OfficerEngagementData(source);
                oed.person = person;
                data.getOfficerData().put(person, oed);
            }
            oed.timeDeployed += time;
        }
        data.setMaxTimeDeployed(data.getMaxTimeDeployed() + maxTime);
    }

    @Override
    public FleetEncounterContextPlugin.PursueAvailability getPursuitAvailability(CampaignFleetAPI fleet, CampaignFleetAPI otherFleet) {
        FleetEncounterContextPlugin.DataForEncounterSide otherData = this.getDataFor(otherFleet);
        if (otherData.isWonLastEngagement()) {
            return FleetEncounterContextPlugin.PursueAvailability.LOST_LAST_ENGAGEMENT;
        }
        if (this.canOutrunOtherFleet(otherFleet, fleet)) {
            return FleetEncounterContextPlugin.PursueAvailability.TOO_SLOW;
        }
        if (fleet.getFleetData().getCombatReadyMembersListCopy().isEmpty()) {
            return FleetEncounterContextPlugin.PursueAvailability.NO_READY_SHIPS;
        }
        if (otherData.isDidEnoughToDisengage()) {
            return FleetEncounterContextPlugin.PursueAvailability.TOOK_SERIOUS_LOSSES;
        }
        return FleetEncounterContextPlugin.PursueAvailability.AVAILABLE;
    }

    @Override
    public FleetEncounterContextPlugin.DisengageHarryAvailability getDisengageHarryAvailability(CampaignFleetAPI fleet, CampaignFleetAPI otherFleet) {
        FleetEncounterContextPlugin.DataForEncounterSide otherData = this.getDataFor(otherFleet);
        if (otherData.isWonLastEngagement()) {
            return FleetEncounterContextPlugin.DisengageHarryAvailability.LOST_LAST_ENGAGEMENT;
        }
        if (fleet.getFleetData().getCombatReadyMembersListCopy().isEmpty()) {
            return FleetEncounterContextPlugin.DisengageHarryAvailability.NO_READY_SHIPS;
        }
        return FleetEncounterContextPlugin.DisengageHarryAvailability.AVAILABLE;
    }

    public float getDeployCost(FleetMemberAPI member) {
        return member.getDeployCost();
    }

    public boolean isLowRepImpact() {
        boolean lowImpact = this.getBattle() != null && this.getBattle().getNonPlayerSide() != null && this.getBattle().getPrimary(this.getBattle().getNonPlayerSide()) != null && this.getBattle().getPrimary(this.getBattle().getNonPlayerSide()).getMemoryWithoutUpdate().getBoolean("$lowRepImpact");
        return lowImpact;
    }

    public boolean isNoRepImpact() {
        boolean noImpact = this.getBattle() != null && this.getBattle().getNonPlayerSide() != null && this.getBattle().getPrimary(this.getBattle().getNonPlayerSide()) != null && this.getBattle().getPrimary(this.getBattle().getNonPlayerSide()).getMemoryWithoutUpdate().getBoolean("$noRepImpact");
        return noImpact;
    }

    @Override
    public boolean adjustPlayerReputation(InteractionDialogAPI dialog, String ffText) {
        return this.adjustPlayerReputation(dialog, ffText, true, true);
    }

    public boolean adjustPlayerReputation(InteractionDialogAPI dialog, String ffText, boolean okToAdjustAlly, boolean okToAdjustEnemy) {
        if (this.alreadyAdjustedRep) {
            return false;
        }
        if (this.battle != null && this.battle.isPlayerInvolved() && this.engagedInHostilities) {
            this.alreadyAdjustedRep = true;
            boolean printedAdjustmentText = false;
            boolean playerWon = this.didPlayerWinMostRecentBattleOfEncounter();
            List<CampaignFleetAPI> playerSide = this.battle.getPlayerSide();
            List<CampaignFleetAPI> enemySide = this.battle.getNonPlayerSide();
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            pf.setMoveDestination(pf.getLocation().x, pf.getLocation().y);
            boolean playerWasAggressive = this.playerDidSeriousDamage || !this.playerOnlyRetreated;
            CoreReputationPlugin.RepActions action = null;
            boolean knowsWhoPlayerIs = this.battle.knowsWhoPlayerIs(enemySide);
            boolean lowImpact = this.isLowRepImpact();
            if (lowImpact) {
                for (CampaignFleetAPI enemy : this.battle.getSnapshotFor(enemySide)) {
                    Misc.makeLowRepImpact(enemy, "battleOnLowImpactSide");
                }
            }
            if (this.playerPursued && playerWon) {
                action = knowsWhoPlayerIs && !lowImpact ? CoreReputationPlugin.RepActions.COMBAT_AGGRESSIVE : CoreReputationPlugin.RepActions.COMBAT_AGGRESSIVE_TOFF;
            } else if (playerWasAggressive) {
                action = knowsWhoPlayerIs && !lowImpact ? CoreReputationPlugin.RepActions.COMBAT_NORMAL : CoreReputationPlugin.RepActions.COMBAT_NORMAL_TOFF;
            }
            if (this.isNoRepImpact()) {
                action = null;
            }
            if (!okToAdjustEnemy) {
                action = null;
            }
            HashSet<String> seen = new HashSet<String>();
            if (action != null) {
                for (CampaignFleetAPI enemy : this.battle.getSnapshotFor(enemySide)) {
                    String factionId = enemy.getFaction().getId();
                    if (seen.contains(factionId)) continue;
                    seen.add(factionId);
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, null, dialog.getTextPanel()), factionId);
                    printedAdjustmentText = true;
                }
            }
            action = CoreReputationPlugin.RepActions.COMBAT_HELP_MINOR;
            float playerFP = 0.0f;
            float allyFP = 0.0f;
            float enemyFP = 0.0f;
            for (CampaignFleetAPI fleet : this.battle.getSnapshotFor(playerSide)) {
                for (FleetMemberAPI fleetMemberAPI : fleet.getFleetData().getSnapshot()) {
                    if (fleet.isPlayerFleet()) {
                        playerFP += (float)fleetMemberAPI.getFleetPointCost();
                        continue;
                    }
                    allyFP += (float)fleetMemberAPI.getFleetPointCost();
                }
            }
            for (CampaignFleetAPI fleet : this.battle.getSnapshotFor(enemySide)) {
                for (FleetMemberAPI fleetMemberAPI : fleet.getFleetData().getSnapshot()) {
                    enemyFP += (float)fleetMemberAPI.getFleetPointCost();
                }
            }
            action = allyFP > enemyFP || !playerWon ? CoreReputationPlugin.RepActions.COMBAT_HELP_MINOR : (allyFP < enemyFP * 0.5f ? CoreReputationPlugin.RepActions.COMBAT_HELP_CRITICAL : CoreReputationPlugin.RepActions.COMBAT_HELP_MAJOR);
            float f = this.computePlayerContribFraction();
            if (f <= 0.0f) {
                action = null;
            } else if (f < 0.1f) {
                action = CoreReputationPlugin.RepActions.COMBAT_HELP_MINOR;
            }
            if (action != null) {
                float totalDam = this.allyFPHullDamageToEnemies + this.playerFPHullDamageToEnemies;
                if (totalDam < 10.0f) {
                    action = CoreReputationPlugin.RepActions.COMBAT_HELP_MINOR;
                } else if (totalDam < 20.0f && action == CoreReputationPlugin.RepActions.COMBAT_HELP_CRITICAL) {
                    action = CoreReputationPlugin.RepActions.COMBAT_HELP_MAJOR;
                }
            }
            if (this.battle.isPlayerInvolvedAtStart() && action != null) {
                action = null;
            }
            if (!okToAdjustAlly) {
                action = null;
            }
            seen.clear();
            for (CampaignFleetAPI ally : this.battle.getSnapshotFor(playerSide)) {
                String factionId;
                if (ally.isPlayerFleet() || seen.contains(factionId = ally.getFaction().getId())) continue;
                seen.add(factionId);
                Float friendlyFPHull = this.playerFPHullDamageToAlliesByFaction.get(ally.getFaction());
                float threshold = 2.0f;
                if (action == CoreReputationPlugin.RepActions.COMBAT_HELP_MAJOR) {
                    threshold = 5.0f;
                } else if (action == CoreReputationPlugin.RepActions.COMBAT_HELP_CRITICAL) {
                    threshold = 10.0f;
                }
                if (friendlyFPHull != null && friendlyFPHull.floatValue() > threshold || action == null || !playerSide.contains(ally)) continue;
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, null, dialog.getTextPanel()), factionId);
                printedAdjustmentText = true;
            }
            if (okToAdjustAlly) {
                boolean first = true;
                seen.clear();
                for (CampaignFleetAPI campaignFleetAPI : this.battle.getSnapshotFor(playerSide)) {
                    String factionId;
                    if (campaignFleetAPI.isPlayerFleet() || "player".equals(factionId = campaignFleetAPI.getFaction().getId()) || seen.contains(factionId)) continue;
                    seen.add(factionId);
                    Float friendlyFPHull = this.playerFPHullDamageToAlliesByFaction.get(campaignFleetAPI.getFaction());
                    float threshold = 2.0f;
                    if (action == CoreReputationPlugin.RepActions.COMBAT_HELP_MAJOR) {
                        threshold = 5.0f;
                    } else if (action == CoreReputationPlugin.RepActions.COMBAT_HELP_CRITICAL) {
                        threshold = 10.0f;
                    }
                    if (friendlyFPHull != null && friendlyFPHull.floatValue() > threshold) {
                        if (first && ffText != null) {
                            first = false;
                            dialog.getTextPanel().addParagraph(ffText);
                        }
                        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.COMBAT_FRIENDLY_FIRE, Float.valueOf(friendlyFPHull.floatValue() - threshold), dialog.getTextPanel()), factionId);
                        printedAdjustmentText = true;
                        continue;
                    }
                    if (action == null) continue;
                    playerSide.contains(campaignFleetAPI);
                }
            }
            return printedAdjustmentText;
        }
        return false;
    }

    public TextPanelAPI getTextPanelForXPGain() {
        return this.textPanelForXPGain;
    }

    public void setTextPanelForXPGain(TextPanelAPI textPanelForXPGain) {
        this.textPanelForXPGain = textPanelForXPGain;
    }

    public boolean isNoHarryBecauseOfStation() {
        return this.noHarryBecauseOfStation;
    }

    public void setNoHarryBecauseOfStation(boolean noHarryBecauseOfStation) {
        this.noHarryBecauseOfStation = noHarryBecauseOfStation;
    }

    public void applyAfterBattleEffectsIfThereWasABattle() {
        if (!this.hasWinnerAndLoser() || !this.engagedInHostilities) {
            List<CampaignFleetAPI> otherSide;
            CampaignFleetAPI fleet;
            for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
                member.getStatus().resetAmmoState();
            }
            if (this.noHarryBecauseOfStation && this.battle != null && (fleet = this.battle.getPrimary(otherSide = this.battle.getNonPlayerSide())).getAI() != null && !fleet.getAI().isCurrentAssignment(FleetAssignment.STANDING_DOWN)) {
                fleet.getAI().addAssignmentAtStart(FleetAssignment.STANDING_DOWN, fleet, 0.5f + 0.5f * (float)Math.random(), null);
            }
            Global.getSector().getPlayerFleet().setNoEngaging(3.0f);
            return;
        }
        this.gainXP();
        this.addPotentialOfficer();
        List<CampaignFleetAPI> winners = this.battle.getSnapshotSideFor(this.getWinnerData().getFleet());
        List<CampaignFleetAPI> losers = this.battle.getSnapshotSideFor(this.getLoserData().getFleet());
        if (winners == null || losers == null) {
            return;
        }
        for (CampaignFleetAPI loser : losers) {
            for (FleetMemberAPI member : loser.getFleetData().getMembersListCopy()) {
                member.getStatus().resetAmmoState();
            }
            loser.getVelocity().set(0.0f, 0.0f);
            if (loser.isPlayerFleet() || !loser.isPlayerFleet()) continue;
            loser.setNoEngaging(3.0f);
        }
        for (CampaignFleetAPI winner : winners) {
            for (FleetMemberAPI member : winner.getFleetData().getMembersListCopy()) {
                member.getStatus().resetAmmoState();
            }
            winner.getVelocity().set(0.0f, 0.0f);
            if (winner.isPlayerFleet() || !winner.isPlayerFleet()) continue;
            winner.setNoEngaging(3.0f);
        }
        if (this.battle.isPlayerSide(winners)) {
            for (CampaignFleetAPI fleet : this.battle.getPlayerSide()) {
                if (fleet.isPlayerFleet()) continue;
                Misc.forgetAboutTransponder(fleet);
            }
        }
        this.battle.setPlayerInvolvementFraction(this.computePlayerContribFraction());
        if (!this.isAutoresolve && this.engagedInActualBattle) {
            Global.getSector().reportBattleOccurred(this.battle.getPrimary(winners), this.battle);
            Global.getSector().reportBattleFinished(this.battle.getPrimary(winners), this.battle);
        }
        CampaignFleetAPI largestWinner = this.battle.getPrimary(winners);
        for (CampaignFleetAPI loser : losers) {
            if (!loser.getFleetData().getMembersListCopy().isEmpty()) continue;
            loser.despawn(CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE, this.battle);
        }
        for (CampaignFleetAPI winner : winners) {
            if (!winner.getFleetData().getMembersListCopy().isEmpty()) continue;
            winner.despawn(CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE, this.battle);
        }
        for (CampaignFleetAPI enemy : this.battle.getBothSides()) {
            if (!(enemy.getAI() instanceof ModularFleetAIAPI)) continue;
            ModularFleetAIAPI mAI = (ModularFleetAIAPI)enemy.getAI();
            mAI.getTacticalModule().forceTargetReEval();
        }
    }

    @Override
    public float performPostVictoryRecovery(EngagementResultAPI result) {
        EngagementResultForFleetAPI winnerResult = result.getWinnerResult();
        EngagementResultForFleetAPI loserResult = result.getLoserResult();
        return this.performPostVictoryRecovery(winnerResult, loserResult);
    }

    public float performPostEngagementRecoveryBoth(EngagementResultAPI result) {
        EngagementResultForFleetAPI winnerResult = result.getWinnerResult();
        EngagementResultForFleetAPI loserResult = result.getLoserResult();
        float f = this.performPostVictoryRecovery(winnerResult, loserResult);
        f += this.performPostVictoryRecovery(loserResult, winnerResult);
        return f /= 2.0f;
    }

    public float performPostVictoryRecovery(EngagementResultForFleetAPI winnerResult, EngagementResultForFleetAPI loserResult) {
        FleetEncounterContextPlugin.DataForEncounterSide winnerData = this.getDataFor(winnerResult.getFleet());
        FleetEncounterContextPlugin.DataForEncounterSide loserData = this.getDataFor(loserResult.getFleet());
        float loserDepDestroyed = 0.0f;
        float loserDepLeft = 0.0f;
        for (FleetMemberAPI member : loserData.getRetreatedFromLastEngagement()) {
            loserDepLeft += member.getDeploymentPointsCost();
        }
        for (FleetMemberAPI member : loserData.getInReserveDuringLastEngagement()) {
            loserDepLeft += member.getDeploymentPointsCost();
        }
        for (FleetMemberAPI member : loserData.getDestroyedInLastEngagement()) {
            loserDepDestroyed += member.getDeploymentPointsCost();
        }
        for (FleetMemberAPI member : loserData.getDisabledInLastEngagement()) {
            loserDepDestroyed += member.getDeploymentPointsCost();
        }
        for (FleetMemberAPI member : loserData.getRetreatedFromLastEngagement()) {
            float finalCR;
            float deploymentCR;
            DeployedFleetMemberAPI dfm;
            if (!member.isFighterWing() || (dfm = this.getDataFor(loserData.getFleet()).getMemberToDeployedMap().get(member)) == null || dfm.getMember() != member || !(deploymentCR > (finalCR = (deploymentCR = dfm.getShip().getWingCRAtDeployment())))) continue;
            float crPer = dfm.getMember().getStats().getCRPerDeploymentPercent().computeEffective(dfm.getMember().getVariant().getHullSpec().getCRToDeploy()) / 100.0f;
            float extraCraftLost = (deploymentCR - finalCR) / crPer;
            float wingSize = dfm.getMember().getNumFightersInWing();
            if (!(extraCraftLost >= 1.0f)) continue;
            loserDepDestroyed += Math.min(1.0f, extraCraftLost / wingSize) * member.getDeploymentPointsCost();
        }
        float totalRecovery = 0.0f;
        float count = 0.0f;
        for (FleetMemberAPI member : winnerData.getDeployedInLastEngagement()) {
            float prevCR;
            float dp = member.getDeploymentPointsCost();
            float recoveryFraction = Math.max(0.0f, dp * 1.25f - loserDepDestroyed) / dp;
            if (loserDepDestroyed > loserDepLeft * 2.0f) {
                recoveryFraction = Math.max(0.0f, dp * 0.75f - loserDepDestroyed) / dp;
            }
            if (recoveryFraction > 1.0f) {
                recoveryFraction = 1.0f;
            }
            if (loserDepDestroyed <= 0.0f) {
                recoveryFraction = 1.0f;
            }
            float deployCost = this.getDeployCost(member);
            if (this.preEngagementCRForWinner.containsKey(member) && (prevCR = this.preEngagementCRForWinner.get(member).floatValue()) < deployCost) {
                prevCR = deployCost;
            }
            float recoveryAmount = (float)Math.round(deployCost * recoveryFraction * 100.0f) / 100.0f;
            totalRecovery += recoveryAmount;
            count += 1.0f;
            if (recoveryAmount <= 0.0f) continue;
            member.getRepairTracker().applyCREvent(recoveryAmount, "Post engagement recovery");
        }
        if (count <= 0.0f) {
            return 0.0f;
        }
        return (float)Math.round(totalRecovery / count * 100.0f) / 100.0f;
    }

    public void applyPursuitOption(CampaignFleetAPI pursuingFleet, CampaignFleetAPI otherFleet, CampaignFleetAIAPI.PursuitOption pursuitOption) {
        if (Misc.isPlayerOrCombinedPlayerPrimary(pursuingFleet) && pursuitOption != CampaignFleetAIAPI.PursuitOption.LET_THEM_GO) {
            this.playerOnlyRetreated = false;
        }
        FleetEncounterContextPlugin.DataForEncounterSide pursuer = this.getDataFor(pursuingFleet);
        FleetEncounterContextPlugin.DataForEncounterSide other = this.getDataFor(otherFleet);
        if (pursuitOption == CampaignFleetAIAPI.PursuitOption.HARRY) {
            for (FleetMemberAPI member : otherFleet.getFleetData().getMembersListCopy()) {
                float deployCost = this.getDeployCost(member);
                float harryCost = deployCost * 1.0f;
                member.getRepairTracker().applyCREvent(-harryCost, "harried while disengaging");
            }
        }
    }

    @Override
    public FleetEncounterContextPlugin.EngagementOutcome getLastEngagementOutcome() {
        return this.lastOutcome;
    }

    public boolean isBattleOver() {
        if (this.hasWinnerAndLoser()) {
            return true;
        }
        return this.lastOutcome != null && this.lastOutcome != FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_WIN && this.lastOutcome != FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_LOSS && this.lastOutcome != FleetEncounterContextPlugin.EngagementOutcome.BATTLE_ENEMY_WIN && this.lastOutcome != FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN;
    }

    public boolean wasLastEngagementEscape() {
        return this.lastOutcome != null && this.lastOutcome != FleetEncounterContextPlugin.EngagementOutcome.BATTLE_ENEMY_WIN && this.lastOutcome != FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN;
    }

    public boolean didPlayerWinLastEngagement() {
        return this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN_TOTAL || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_WIN || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_WIN || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_WIN || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_LOSS_TOTAL || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_SUCCESS || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_WIN || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_WIN_TOTAL;
    }

    public boolean didPlayerWinMostRecentBattleOfEncounter() {
        if (this.getDataFor(Global.getSector().getPlayerFleet()).disengaged()) {
            return false;
        }
        return this.didPlayerWinEncounterOutright() || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN;
    }

    public boolean didPlayerWinEncounterOutright() {
        if (this.getDataFor(Global.getSector().getPlayerFleet()).disengaged()) {
            return false;
        }
        if ((this.lastOutcome == null || this.hasWinnerAndLoser()) && this.battle.isPlayerSide(this.battle.getSideFor(this.getWinner()))) {
            return true;
        }
        return this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN_TOTAL || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_LOSS_TOTAL || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_SUCCESS || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_WIN || this.lastOutcome == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_WIN_TOTAL;
    }

    public int getCreditsLooted() {
        return this.creditsLooted;
    }

    public float getSalvageMult(FleetEncounterContextPlugin.Status status) {
        float mult = 1.0f;
        switch (status) {
            case DESTROYED: {
                mult = 1.0f;
                break;
            }
            case DISABLED: {
                mult = 1.0f;
                break;
            }
            case REPAIRED: {
                mult = 1.0f;
                break;
            }
            case CAPTURED: {
                mult = 0.1f;
            }
        }
        return mult;
    }

    public float getCargoLootMult(FleetEncounterContextPlugin.Status status) {
        float mult = 1.0f;
        switch (status) {
            case DESTROYED: {
                mult = 1.0f;
                break;
            }
            case DISABLED: {
                mult = 1.0f;
                break;
            }
            case REPAIRED: {
                mult = 1.0f;
                break;
            }
            case CAPTURED: {
                mult = 1.0f;
            }
        }
        return mult;
    }

    public EngageBoardableOutcome engageBoardableShip(FleetMemberAPI toBoard, CampaignFleetAPI fleetItBelongsTo, CampaignFleetAPI attackingFleet) {
        float r = (float)Math.random();
        if (r < 0.75f) {
            FleetEncounterContextPlugin.DataForEncounterSide attackerSide = this.getDataFor(attackingFleet);
            attackerSide.changeEnemy(toBoard, FleetEncounterContextPlugin.Status.DISABLED);
            toBoard.getStatus().disable();
            return EngageBoardableOutcome.DISABLED;
        }
        FleetEncounterContextPlugin.DataForEncounterSide attackerSide = this.getDataFor(attackingFleet);
        attackerSide.changeEnemy(toBoard, FleetEncounterContextPlugin.Status.DESTROYED);
        toBoard.getStatus().disable();
        return EngageBoardableOutcome.DESTROYED;
    }

    public BoardingResult boardShip(FleetMemberAPI member, CampaignFleetAPI attacker, CampaignFleetAPI defender) {
        FleetEncounterContextPlugin.DataForEncounterSide attackerSide = this.getDataFor(attacker);
        FleetEncounterContextPlugin.DataForEncounterSide defenderSide = this.getDataFor(defender);
        float attackerMarineMult = attacker.getCommanderStats().getMarineEffectivnessMult().getModifiedValue();
        float defenderMarineMult = defender.getCommanderStats().getMarineEffectivnessMult().getModifiedValue();
        float crewMult = 2.0f;
        float marineMult = 7.0f;
        float attackerStr = (float)attacker.getCargo().getMarines() * marineMult;
        attackerStr *= attackerMarineMult;
        CrewCompositionAPI defenderCrew = member.getCrewComposition();
        float defenderStr = defenderCrew.getCrew() * crewMult + defenderCrew.getMarines() * marineMult;
        defenderStr *= defenderMarineMult;
        Random rand = new Random(1300000 * (member.getId().hashCode() + defender.getId().hashCode() + Global.getSector().getClock().getDay()));
        boolean attackerWin = (attackerStr *= 0.75f + 0.25f * rand.nextFloat()) > (defenderStr *= 0.75f + 0.25f * rand.nextFloat());
        boolean defenderWin = !attackerWin;
        BoardingResult result = new BoardingResult();
        result.setMember(member);
        BoardingOutcome outcome = BoardingOutcome.SUCCESS;
        if (defenderWin) {
            outcome = BoardingOutcome.SHIP_ESCAPED;
        }
        CrewCompositionAPI boardingParty = Global.getFactory().createCrewComposition();
        boardingParty.addMarines(attacker.getCargo().getMarines());
        result.setOutcome(outcome);
        switch (outcome) {
            case SHIP_ESCAPED: {
                this.computeCrewLossFromBoarding(result, member, boardingParty, attackerStr, defenderStr);
                result.getAttackerLosses().removeFromCargo(attacker.getCargo());
                member.getCrewComposition().removeAll(result.getDefenderLosses());
                this.letBoardableGo(member, defender, attacker);
                break;
            }
            case SUCCESS: {
                this.computeCrewLossFromBoarding(result, member, boardingParty, attackerStr, defenderStr);
                result.getAttackerLosses().removeFromCargo(attacker.getCargo());
                member.getCrewComposition().removeAll(result.getDefenderLosses());
                attacker.getFleetData().addFleetMember(member);
                this.getBattle().getCombinedFor(attacker).getFleetData().addFleetMember(member);
                member.getRepairTracker().setMothballed(true);
                attackerSide.changeEnemy(member, FleetEncounterContextPlugin.Status.CAPTURED);
                defenderSide.changeOwn(member, FleetEncounterContextPlugin.Status.CAPTURED);
                attackerSide.getInReserveDuringLastEngagement().add(member);
                defenderSide.getDestroyedInLastEngagement().remove(member);
                defenderSide.getDisabledInLastEngagement().remove(member);
                member.setOwner(0);
                member.setCaptain(Global.getFactory().createPerson());
            }
        }
        return result;
    }

    public float getBoardingSuccessPercent(FleetMemberAPI member, CampaignFleetAPI attacker, CampaignFleetAPI defender) {
        FleetEncounterContextPlugin.DataForEncounterSide attackerSide = this.getDataFor(attacker);
        FleetEncounterContextPlugin.DataForEncounterSide defenderSide = this.getDataFor(defender);
        float attackerMarineMult = attacker.getCommanderStats().getMarineEffectivnessMult().getModifiedValue();
        float defenderMarineMult = defender.getCommanderStats().getMarineEffectivnessMult().getModifiedValue();
        float crewMult = 2.0f;
        float marineMult = 7.0f;
        Random rand = new Random();
        float wins = 0.0f;
        float losses = 0.0f;
        int i = 0;
        while (i < 100) {
            boolean attackerWin;
            float attackerStr = (float)attacker.getCargo().getMarines() * marineMult;
            attackerStr *= attackerMarineMult;
            CrewCompositionAPI defenderCrew = member.getCrewComposition();
            float defenderStr = defenderCrew.getCrew() * crewMult + defenderCrew.getMarines() * marineMult;
            defenderStr *= defenderMarineMult;
            boolean bl = attackerWin = (attackerStr *= 0.75f + 0.25f * rand.nextFloat()) > (defenderStr *= 0.75f + 0.25f * rand.nextFloat());
            if (attackerWin) {
                wins += 1.0f;
            } else {
                losses += 1.0f;
            }
            ++i;
        }
        return wins;
    }

    protected void computeMissedLaunchLosses(BoardingResult result, CrewCompositionAPI boardingParty) {
        result.getAttackerLosses().addAll(boardingParty);
        result.getAttackerLosses().multiplyBy((float)Math.random() * 0.2f);
    }

    protected void computeCrewLossFromBoarding(BoardingResult result, FleetMemberAPI member, CrewCompositionAPI boardingParty, float attackerStr, float defenderStr) {
        if (attackerStr < 1.0f) {
            attackerStr = 1.0f;
        }
        if (defenderStr < 1.0f) {
            defenderStr = 1.0f;
        }
        float cap = 2.0f;
        float attackerExtraStr = 0.0f;
        if (attackerStr > defenderStr * cap) {
            attackerExtraStr = attackerStr - defenderStr * cap;
            attackerStr = defenderStr * cap;
        }
        if (defenderStr > attackerStr * cap) {
            defenderStr = attackerStr * cap;
        }
        float attackerLosses = defenderStr / (attackerStr + defenderStr);
        float defenderLosses = attackerStr / (attackerStr + defenderStr);
        if (attackerStr > defenderStr) {
            result.getAttackerLosses().addAll(boardingParty);
            result.getAttackerLosses().multiplyBy(attackerLosses * attackerStr / (attackerExtraStr + attackerStr));
            result.getDefenderLosses().addAll(member.getCrewComposition());
            result.getDefenderLosses().multiplyBy(defenderLosses);
        } else {
            result.getAttackerLosses().addAll(boardingParty);
            result.getAttackerLosses().multiplyBy(attackerLosses);
            result.getDefenderLosses().addAll(member.getCrewComposition());
            result.getDefenderLosses().multiplyBy(defenderLosses);
        }
    }

    protected void applyBoardingSelfDestruct(FleetMemberAPI member, CrewCompositionAPI boardingParty, BoardingAttackType attackType, List<FleetMemberAPI> boardingTaskForce, CampaignFleetAPI attacker, CampaignFleetAPI defender, BoardingResult result) {
        FleetEncounterContextPlugin.DataForEncounterSide attackerSide = this.getDataFor(attacker);
        FleetEncounterContextPlugin.DataForEncounterSide defenderSide = this.getDataFor(defender);
        attackerSide.changeEnemy(member, FleetEncounterContextPlugin.Status.DESTROYED);
        defenderSide.changeOwn(member, FleetEncounterContextPlugin.Status.DESTROYED);
        CrewCompositionAPI total = Global.getFactory().createCrewComposition();
        if (attackType == BoardingAttackType.SHIP_TO_SHIP) {
            for (FleetMemberAPI fm : boardingTaskForce) {
                float damage = member.getStats().getFluxCapacity().getModifiedValue() * (1.0f + (float)Math.random() * 0.5f);
                float hull = fm.getStatus().getHullFraction();
                float hullDamageFactor = 0.0f;
                fm.getStatus().applyDamage(damage);
                if (fm.getStatus().getHullFraction() <= 0.0f) {
                    fm.getStatus().disable();
                    attacker.getFleetData().removeFleetMember(fm);
                    attackerSide.addOwn(fm, FleetEncounterContextPlugin.Status.DESTROYED);
                    attackerSide.getRetreatedFromLastEngagement().remove(fm);
                    attackerSide.getInReserveDuringLastEngagement().remove(fm);
                    attackerSide.getDeployedInLastEngagement().remove(fm);
                    attackerSide.getDestroyedInLastEngagement().add(fm);
                    result.getLostInSelfDestruct().add(fm);
                    hullDamageFactor = 1.0f;
                } else {
                    float newHull = fm.getStatus().getHullFraction();
                    float diff = hull - newHull;
                    if (diff < 0.0f) {
                        diff = 0.0f;
                    }
                    hullDamageFactor = diff;
                }
                CrewCompositionAPI temp = Global.getFactory().createCrewComposition();
                temp.addAll(fm.getCrewComposition());
                float lossFraction = this.computeLossFraction(fm, null, fm.getStatus().getHullFraction(), hullDamageFactor);
                temp.multiplyBy(lossFraction);
                total.addAll(temp);
            }
        }
        float lossFraction = this.computeLossFraction(null, null, 0.0f, 1.0f);
        total.setMarines(Math.round(Math.max(total.getMarines(), boardingParty.getMarines() * lossFraction)));
        total.setCrew(Math.round(Math.max(total.getCrew(), boardingParty.getCrew() * lossFraction)));
        result.getAttackerLosses().addAll(total);
        result.getDefenderLosses().addAll(member.getCrewComposition());
    }

    public void letBoardableGo(FleetMemberAPI toBoard, CampaignFleetAPI fleetItBelongsTo, CampaignFleetAPI attackingFleet) {
        FleetEncounterContextPlugin.DataForEncounterSide attackerSide = this.getDataFor(attackingFleet);
        attackerSide.removeEnemyCasualty(toBoard);
        FleetEncounterContextPlugin.DataForEncounterSide defenderSide = this.getDataFor(fleetItBelongsTo);
        defenderSide.removeOwnCasualty(toBoard);
        defenderSide.getDestroyedInLastEngagement().remove(toBoard);
        defenderSide.getDisabledInLastEngagement().remove(toBoard);
        defenderSide.getRetreatedFromLastEngagement().add(toBoard);
        if (!fleetItBelongsTo.isValidPlayerFleet()) {
            fleetItBelongsTo.getCargo().removeCrew(fleetItBelongsTo.getCargo().getCrew());
            fleetItBelongsTo.getCargo().removeMarines(fleetItBelongsTo.getCargo().getMarines());
        }
        FleetDataAPI data = fleetItBelongsTo.getFleetData();
        data.addFleetMember(toBoard);
        this.getBattle().getCombinedFor(fleetItBelongsTo).getFleetData().addFleetMember(toBoard);
        toBoard.getCrewComposition().addToCargo(fleetItBelongsTo.getCargo());
    }

    public List<FleetMemberAPI> getStoryRecoverableShips() {
        return this.storyRecoverableShips;
    }

    public List<FleetMemberAPI> getRecoverableShips(BattleAPI battle, CampaignFleetAPI winningFleet, CampaignFleetAPI otherFleet) {
        this.storyRecoverableShips.clear();
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        if (Misc.isPlayerOrCombinedContainingPlayer(otherFleet)) {
            return result;
        }
        FleetEncounterContextPlugin.DataForEncounterSide winnerData = this.getDataFor(winningFleet);
        FleetEncounterContextPlugin.DataForEncounterSide loserData = this.getDataFor(otherFleet);
        float playerContribMult = this.computePlayerContribFraction();
        List<FleetEncounterContextPlugin.FleetMemberData> enemyCasualties = winnerData.getEnemyCasualties();
        List<FleetEncounterContextPlugin.FleetMemberData> ownCasualties = winnerData.getOwnCasualties();
        ArrayList<FleetEncounterContextPlugin.FleetMemberData> all = new ArrayList<FleetEncounterContextPlugin.FleetMemberData>();
        all.addAll(ownCasualties);
        Collections.sort(all, new Comparator<FleetEncounterContextPlugin.FleetMemberData>(){

            @Override
            public int compare(FleetEncounterContextPlugin.FleetMemberData o1, FleetEncounterContextPlugin.FleetMemberData o2) {
                int result = o2.getMember().getVariant().getSMods().size() - o1.getMember().getVariant().getSMods().size();
                if (result == 0) {
                    result = o2.getMember().getHullSpec().getHullSize().ordinal() - o1.getMember().getHullSpec().getHullSize().ordinal();
                }
                return result;
            }
        });
        Random random = Misc.getRandom(Global.getSector().getPlayerBattleSeed(), 11);
        WeightedRandomPicker<FleetEncounterContextPlugin.FleetMemberData> enemyPicker = new WeightedRandomPicker<FleetEncounterContextPlugin.FleetMemberData>(random);
        ArrayList<FleetEncounterContextPlugin.FleetMemberData> enemy = new ArrayList<FleetEncounterContextPlugin.FleetMemberData>(enemyCasualties);
        Collections.sort(enemy, new Comparator<FleetEncounterContextPlugin.FleetMemberData>(){

            @Override
            public int compare(FleetEncounterContextPlugin.FleetMemberData o1, FleetEncounterContextPlugin.FleetMemberData o2) {
                int result = o2.getMember().getId().hashCode() - o1.getMember().getId().hashCode();
                return result;
            }
        });
        for (FleetEncounterContextPlugin.FleetMemberData curr : enemy) {
            float base = 10.0f;
            switch (curr.getMember().getHullSpec().getHullSize()) {
                case CAPITAL_SHIP: {
                    base = 40.0f;
                    break;
                }
                case CRUISER: {
                    base = 20.0f;
                    break;
                }
                case DESTROYER: {
                    base = 10.0f;
                    break;
                }
                case FRIGATE: {
                    base = 5.0f;
                }
            }
            float w = curr.getMember().getUnmodifiedDeploymentPointsCost() / base;
            enemyPicker.add(curr, w);
        }
        ArrayList<FleetEncounterContextPlugin.FleetMemberData> sortedEnemy = new ArrayList<FleetEncounterContextPlugin.FleetMemberData>();
        while (!enemyPicker.isEmpty()) {
            sortedEnemy.add((FleetEncounterContextPlugin.FleetMemberData)enemyPicker.pickAndRemove());
        }
        all.addAll(sortedEnemy);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int maxRecoverablePerType = 24;
        float probLessDModsOnNext = Global.getSettings().getFloat("baseProbLessDModsOnRecoverableEnemyShip");
        float lessDmodsOnNextMult = Global.getSettings().getFloat("lessDModsOnRecoverableEnemyShipMultNext");
        boolean count = false;
        for (FleetEncounterContextPlugin.FleetMemberData data : all) {
            CampaignFleetAPI fleet;
            boolean own;
            if (Misc.isUnboardable(data.getMember()) || data.getStatus() != FleetEncounterContextPlugin.Status.DISABLED && data.getStatus() != FleetEncounterContextPlugin.Status.DESTROYED || (own = ownCasualties.contains(data)) && data.getMember().isAlly()) continue;
            float mult = 1.0f;
            if (data.getStatus() == FleetEncounterContextPlugin.Status.DESTROYED) {
                mult = 0.5f;
            }
            if (!own) {
                mult *= playerContribMult;
            }
            boolean useOfficerRecovery = false;
            if (own && (useOfficerRecovery = winnerData.getMembersWithOfficerOrPlayerAsOrigCaptain().contains(data.getMember()))) {
                mult = 1.0f;
            }
            boolean noRecovery = false;
            if (battle != null && battle.getSourceFleet(data.getMember()) != null && (fleet = battle.getSourceFleet(data.getMember())).getMemoryWithoutUpdate().getBoolean("$noShipRecovery")) {
                noRecovery = true;
            }
            boolean normalRecovery = !noRecovery && Misc.isShipRecoverable(data.getMember(), playerFleet, own, useOfficerRecovery, 1.0f * mult);
            boolean storyRecovery = !noRecovery && !normalRecovery;
            boolean alwaysRec = data.getMember().getVariant().hasTag("always_recoverable");
            float shipRecProb = data.getMember().getStats().getDynamic().getMod("individual_ship_recovery_mod").computeEffective(0.0f);
            if (!own && !alwaysRec && (storyRecovery || normalRecovery) && shipRecProb < 1.0f) {
                float per = Global.getSettings().getFloat("probNonOwnNonRecoverablePerDMod");
                float perAlready = Global.getSettings().getFloat("probNonOwnNonRecoverablePerAlreadyRecoverable");
                float max = Global.getSettings().getFloat("probNonOwnNonRecoverableMax");
                int dmods = DModManager.getNumDMods(data.getMember().getVariant());
                float assumedAddedDmods = 3.0f;
                assumedAddedDmods -= Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("ship_dmod_reduction_mod", 0.0f) * 0.5f;
                assumedAddedDmods = Math.min(assumedAddedDmods, (float)(5 - dmods));
                float recoveredSoFar = 0.0f;
                recoveredSoFar = storyRecovery ? (float)this.storyRecoverableShips.size() : (float)result.size();
                if (random.nextFloat() < Math.min(max, ((float)dmods + assumedAddedDmods) * per) + recoveredSoFar * perAlready) {
                    noRecovery = true;
                }
            }
            if (noRecovery || !normalRecovery && !storyRecovery) continue;
            if (!own || !Misc.isUnremovable(data.getMember().getCaptain())) {
                boolean keepCaptain;
                String aiCoreId = null;
                if (own && data.getMember().getCaptain() != null && data.getMember().getCaptain().isAICore()) {
                    aiCoreId = data.getMember().getCaptain().getAICoreId();
                }
                if (!(keepCaptain = false)) {
                    data.getMember().setCaptain(Global.getFactory().createPerson());
                    if (aiCoreId != null) {
                        data.getMember().getCaptain().getMemoryWithoutUpdate().set("$aiCoreIdForRecovery", aiCoreId);
                    }
                }
            }
            ShipVariantAPI variant = data.getMember().getVariant();
            variant = variant.clone();
            variant.setSource(VariantSource.REFIT);
            variant.setOriginalVariant(null);
            data.getMember().setVariant(variant, false, true);
            boolean lessDmods = false;
            if (!own && data.getStatus() != FleetEncounterContextPlugin.Status.DESTROYED && random.nextFloat() < probLessDModsOnNext) {
                lessDmods = true;
                probLessDModsOnNext *= lessDmodsOnNextMult;
            }
            Random dModRandom = new Random((long)(1000000 * data.getMember().getId().hashCode()) + Global.getSector().getPlayerBattleSeed());
            dModRandom = Misc.getRandom(dModRandom.nextLong(), 5);
            if (lessDmods) {
                DModManager.reduceNextDmodsBy = 3;
            }
            float probAvoidDmods = data.getMember().getStats().getDynamic().getMod("dmod_avoid_prob_mod").computeEffective(0.0f);
            float probAcquireDmods = data.getMember().getStats().getDynamic().getMod("dmod_acquire_prob_mod").computeEffective(1.0f);
            if (dModRandom.nextFloat() >= probAvoidDmods && dModRandom.nextFloat() < probAcquireDmods) {
                DModManager.addDMods(data, own, Global.getSector().getPlayerFleet(), dModRandom);
                if (DModManager.getNumDMods(variant) > 0) {
                    DModManager.setDHull(variant);
                }
            }
            float weaponProb = Global.getSettings().getFloat("salvageWeaponProb");
            float wingProb = Global.getSettings().getFloat("salvageWingProb");
            if (own) {
                weaponProb = Global.getSettings().getFloat("salvageOwnWeaponProb");
                wingProb = Global.getSettings().getFloat("salvageOwnWingProb");
                weaponProb = playerFleet.getStats().getDynamic().getValue("own_weapon_recovery_mod", weaponProb);
                wingProb = playerFleet.getStats().getDynamic().getValue("own_wing_recovery_mod", wingProb);
            }
            boolean retain = data.getMember().getHullSpec().hasTag("retain_smods_on_recovery") || data.getMember().getVariant().hasTag("retain_smods_on_recovery");
            FleetEncounterContext.prepareShipForRecovery(data.getMember(), own, true, !own && !retain, weaponProb, wingProb, this.salvageRandom);
            if (normalRecovery) {
                if (result.size() >= maxRecoverablePerType) continue;
                result.add(data.getMember());
                continue;
            }
            if (!storyRecovery || this.storyRecoverableShips.size() >= maxRecoverablePerType) continue;
            this.storyRecoverableShips.add(data.getMember());
        }
        this.recoverableShips.clear();
        this.recoverableShips.addAll(result);
        return result;
    }

    public static void recoverShips(List<FleetMemberAPI> ships, FleetEncounterContext context, CampaignFleetAPI winningFleet, CampaignFleetAPI otherFleet) {
        if (!Misc.isPlayerOrCombinedContainingPlayer(winningFleet)) {
            return;
        }
        FleetEncounterContextPlugin.DataForEncounterSide winnerData = null;
        FleetEncounterContextPlugin.DataForEncounterSide loserData = null;
        if (context != null) {
            winnerData = context.getDataFor(winningFleet);
            loserData = context.getDataFor(otherFleet);
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        for (FleetMemberAPI member : ships) {
            float max;
            if (member.getStatus().getNumStatuses() <= 1) {
                member.getStatus().repairDisabledABit();
            }
            float minHull = playerFleet.getStats().getDynamic().getValue("ship_recovery_hull_min", 0.0f);
            float maxHull = playerFleet.getStats().getDynamic().getValue("ship_recovery_hull_max", 0.0f);
            float minCR = playerFleet.getStats().getDynamic().getValue("ship_recovery_cr_min", 0.0f);
            float maxCR = playerFleet.getStats().getDynamic().getValue("ship_recovery_cr_max", 0.0f);
            minHull += member.getStats().getDynamic().getValue("ship_recovery_hull_min", 0.0f);
            maxHull += member.getStats().getDynamic().getValue("ship_recovery_hull_max", 0.0f);
            minCR += member.getStats().getDynamic().getValue("ship_recovery_cr_min", 0.0f);
            maxCR += member.getStats().getDynamic().getValue("ship_recovery_cr_max", 0.0f);
            float hull = (float)Math.random() * (maxHull - minHull) + minHull;
            if (hull < 0.01f) {
                hull = 0.01f;
            }
            if (hull > 1.0f) {
                hull = 1.0f;
            }
            member.getStatus().setHullFraction(hull);
            float cr = (float)Math.random() * (maxCR - minCR) + minCR;
            if (cr < 0.0f) {
                cr = 0.0f;
            }
            float f = max = member.getRepairTracker() == null ? 1.0f : member.getRepairTracker().getMaxCR();
            if (cr > max) {
                cr = max;
            }
            member.getRepairTracker().setCR(cr);
            if (winnerData != null) {
                winnerData.getInReserveDuringLastEngagement().add(member);
            }
            playerFleet.getFleetData().addFleetMember(member);
            if (context != null) {
                context.getBattle().getCombinedFor(playerFleet).getFleetData().addFleetMember(member);
                context.getBattle().getMemberSourceMap().put(member, playerFleet);
            }
            member.setFleetCommanderForStats(null, null);
            member.setOwner(0);
            if (!Misc.isUnremovable(member.getCaptain())) {
                member.setCaptain(Global.getFactory().createPerson());
                member.getCaptain().setFaction("player");
            }
            if (winnerData != null) {
                winnerData.changeEnemy(member, FleetEncounterContextPlugin.Status.REPAIRED);
                winnerData.changeOwn(member, FleetEncounterContextPlugin.Status.REPAIRED);
                winnerData.getDestroyedInLastEngagement().remove(member);
                winnerData.getDisabledInLastEngagement().remove(member);
            }
            if (loserData == null) continue;
            loserData.changeEnemy(member, FleetEncounterContextPlugin.Status.REPAIRED);
            loserData.changeOwn(member, FleetEncounterContextPlugin.Status.REPAIRED);
            loserData.getDestroyedInLastEngagement().remove(member);
            loserData.getDisabledInLastEngagement().remove(member);
        }
    }

    public static void prepareShipForRecovery(FleetMemberAPI member, boolean retainAllHullmods, boolean retainKnownHullmods, boolean clearSMods, float weaponRetainProb, float wingRetainProb, Random salvageRandom) {
        ShipVariantAPI variant = member.getVariant().clone();
        variant.setOriginalVariant(null);
        if (!retainAllHullmods) {
            if (retainKnownHullmods) {
                for (String modId : new ArrayList<String>(variant.getHullMods())) {
                    if (Global.getSector().getPlayerFaction().knowsHullMod(modId)) continue;
                    variant.removeMod(modId);
                }
            } else {
                variant.clearHullMods();
                variant.setNumFluxCapacitors(0);
                variant.setNumFluxVents(0);
            }
        }
        if (clearSMods && !variant.hasTag("variant_always_retain_smods_on_salvage")) {
            for (String id : new ArrayList<String>(variant.getSMods())) {
                variant.removePermaMod(id);
            }
        }
        variant.setSource(VariantSource.REFIT);
        member.setVariant(variant, false, false);
        ArrayList<String> remove = new ArrayList<String>();
        Random random = new Random();
        if (salvageRandom != null) {
            random = salvageRandom;
        }
        if (!member.isFighterWing()) {
            for (String slotId : variant.getNonBuiltInWeaponSlots()) {
                if (!(random.nextFloat() > weaponRetainProb)) continue;
                remove.add(slotId);
            }
            for (String slotId : remove) {
                variant.clearSlot(slotId);
            }
            int index = 0;
            for (String id : variant.getFittedWings()) {
                if (random.nextFloat() > wingRetainProb) {
                    variant.setWingId(index, null);
                }
                ++index;
            }
        }
        for (String slotId : variant.getStationModules().keySet()) {
            FleetEncounterContext.prepareModuleForRecovery(member, slotId, retainAllHullmods, retainKnownHullmods, clearSMods, weaponRetainProb, wingRetainProb, salvageRandom);
        }
        int i = 1;
        while (i < member.getStatus().getNumStatuses()) {
            if (random.nextFloat() > 0.5f) {
                member.getStatus().setDetached(i, false);
                member.getStatus().setHullFraction(i, 0.1f + 0.1f * random.nextFloat());
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            member.getBuffManager().advance(1.0f);
            ++i;
        }
        variant.addTag("ship_recoverable");
    }

    public static void prepareModuleForRecovery(FleetMemberAPI member, String moduleSlotId, boolean retainAllHullmods, boolean retainKnownHullmods, boolean clearSMods, float weaponRetainProb, float wingRetainProb, Random salvageRandom) {
        ShipVariantAPI moduleCurrent = member.getVariant().getModuleVariant(moduleSlotId);
        if (moduleCurrent == null) {
            return;
        }
        moduleCurrent = moduleCurrent.clone();
        moduleCurrent.setOriginalVariant(null);
        if (!retainAllHullmods) {
            if (retainKnownHullmods) {
                for (String modId : new ArrayList<String>(moduleCurrent.getHullMods())) {
                    if (Global.getSector().getPlayerFaction().knowsHullMod(modId)) continue;
                    moduleCurrent.removeMod(modId);
                }
            } else {
                moduleCurrent.clearHullMods();
                moduleCurrent.setNumFluxCapacitors(0);
                moduleCurrent.setNumFluxVents(0);
            }
        }
        if (clearSMods && !moduleCurrent.hasTag("variant_always_retain_smods_on_salvage")) {
            for (String id : new ArrayList<String>(moduleCurrent.getSMods())) {
                moduleCurrent.removePermaMod(id);
            }
        }
        moduleCurrent.setSource(VariantSource.REFIT);
        member.getVariant().setModuleVariant(moduleSlotId, moduleCurrent);
        ArrayList<String> remove = new ArrayList<String>();
        Random random = Misc.random;
        if (salvageRandom != null) {
            random = salvageRandom;
        }
        for (String slotId : moduleCurrent.getNonBuiltInWeaponSlots()) {
            if (!(random.nextFloat() > weaponRetainProb)) continue;
            remove.add(slotId);
        }
        for (String slotId : remove) {
            moduleCurrent.clearSlot(slotId);
        }
        int index = 0;
        for (String id : moduleCurrent.getFittedWings()) {
            if (random.nextFloat() > wingRetainProb) {
                moduleCurrent.setWingId(index, null);
            }
            ++index;
        }
    }

    public void gainXP() {
        if (this.sideData.size() != 2) {
            return;
        }
        if (!this.battle.isPlayerInvolved()) {
            return;
        }
        FleetEncounterContextPlugin.DataForEncounterSide sideOne = this.sideData.get(0);
        FleetEncounterContextPlugin.DataForEncounterSide sideTwo = this.sideData.get(1);
        if (this.battle.isPlayerSide(this.battle.getSideFor(sideOne.getFleet()))) {
            this.gainXP(sideOne, sideTwo);
        } else if (this.battle.isPlayerSide(this.battle.getSideFor(sideTwo.getFleet()))) {
            this.gainXP(sideTwo, sideOne);
        }
    }

    protected void gainOfficerXP(FleetEncounterContextPlugin.DataForEncounterSide data, float xp) {
        float num;
        float max = data.getMaxTimeDeployed();
        if (max < 1.0f) {
            max = 1.0f;
        }
        if ((num = (float)data.getOfficerData().size()) < 1.0f) {
            num = 1.0f;
        }
        for (PersonAPI person : data.getOfficerData().keySet()) {
            OfficerDataAPI od;
            FleetEncounterContextPlugin.DataForEncounterSide.OfficerEngagementData oed = data.getOfficerData().get(person);
            if (oed.sourceFleet == null || !oed.sourceFleet.isPlayerFleet() || (od = oed.sourceFleet.getFleetData().getOfficerData(person)) == null) continue;
            float f = oed.timeDeployed / max;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            od.addXP((long)(f * xp / num), this.textPanelForXPGain);
        }
    }

    public float getPlayerFPHullDamageToEnemies() {
        return this.playerFPHullDamageToEnemies;
    }

    public void setPlayerFPHullDamageToEnemies(float playerFPHullDamageToEnemies) {
        this.playerFPHullDamageToEnemies = playerFPHullDamageToEnemies;
    }

    public float getAllyFPHullDamageToEnemies() {
        return this.allyFPHullDamageToEnemies;
    }

    public void setAllyFPHullDamageToEnemies(float allyFPHullDamageToEnemies) {
        this.allyFPHullDamageToEnemies = allyFPHullDamageToEnemies;
    }

    protected void computeFPHullDamage() {
        if (this.runningDamageTotal == null) {
            return;
        }
        for (FleetMemberAPI member : this.runningDamageTotal.getDealt().keySet()) {
            if (member.getOwner() != 0) continue;
            CombatDamageData.DealtByFleetMember dealt = this.runningDamageTotal.getDealt().get(member);
            for (FleetMemberAPI target : dealt.getDamage().keySet()) {
                CampaignFleetAPI fleet;
                if (this.battle.getSourceFleet(target) == null) continue;
                CombatDamageData.DamageToFleetMember damage = dealt.getDamageTo(target);
                float maxHull = target.getStats().getHullBonus().computeEffective(target.getHullSpec().getHitpoints());
                if (maxHull <= 0.0f) continue;
                if (target.isFighterWing()) {
                    maxHull *= (float)target.getNumFightersInWing();
                }
                float currDam = Math.min(damage.hullDamage, maxHull) / maxHull * (float)target.getFleetPointCost();
                if (target.getOwner() == 1) {
                    fleet = this.battle != null ? this.battle.getSourceFleet(member) : null;
                    boolean ally = member.isAlly();
                    if (ally && fleet != null && fleet.getFaction() != null && fleet.getFaction().isPlayerFaction()) {
                        ally = false;
                    }
                    if (ally) {
                        this.allyFPHullDamageToEnemies += currDam;
                        continue;
                    }
                    this.playerFPHullDamageToEnemies += currDam;
                    continue;
                }
                if (member.isAlly() || !target.isAlly() || target.isFighterWing()) continue;
                this.playerFPHullDamageToAllies += currDam;
                CampaignFleetAPI campaignFleetAPI = fleet = this.battle != null ? this.battle.getSourceFleet(target) : null;
                if (fleet == null) continue;
                float curr = currDam;
                if (this.playerFPHullDamageToAlliesByFaction.containsKey(fleet.getFaction())) {
                    curr += this.playerFPHullDamageToAlliesByFaction.get(fleet.getFaction()).floatValue();
                }
                this.playerFPHullDamageToAlliesByFaction.put(fleet.getFaction(), Float.valueOf(curr));
            }
        }
        this.runningDamageTotal = null;
    }

    @Override
    public float computePlayerContribFraction() {
        float total = this.playerFPHullDamageToEnemies + this.allyFPHullDamageToEnemies;
        if (total <= 0.0f) {
            if (this.battle == null) {
                return 1.0f;
            }
            if (this.battle.isPlayerInvolved() && (this.battle.getPlayerSideSnapshot().size() <= 1 || this.battle.getPlayerSide().size() <= 1)) {
                return 1.0f;
            }
            return 0.0f;
        }
        boolean hasAllies = false;
        boolean startedWithAllies = false;
        if (this.battle != null) {
            hasAllies = this.battle.getPlayerSide().size() <= 1;
            boolean bl = startedWithAllies = this.battle.getPlayerSideSnapshot().size() > 1;
        }
        if (startedWithAllies) {
            return Math.min(1.0f, this.playerFPHullDamageToEnemies / total);
        }
        return 1.0f;
    }

    protected void gainXP(FleetEncounterContextPlugin.DataForEncounterSide side, FleetEncounterContextPlugin.DataForEncounterSide otherSide) {
        float bonusXP = 0.0f;
        float points = 0.0f;
        for (FleetEncounterContextPlugin.FleetMemberData data : side.getOwnCasualties()) {
            if (data.getStatus() != FleetEncounterContextPlugin.Status.DISABLED && data.getStatus() != FleetEncounterContextPlugin.Status.DESTROYED) continue;
            float[] bonus = Misc.getBonusXPForScuttling(data.getMember());
            points += bonus[0];
            bonusXP += bonus[1];
        }
        if (bonusXP > 0.0f && points > 0.0f) {
            Global.getSector().getPlayerStats().setOnlyAddBonusXPDoNotSpendStoryPoints(true);
            Global.getSector().getPlayerStats().setBonusXPGainReason("from losing s-modded ships");
            Global.getSector().getPlayerStats().spendStoryPoints(Math.round(points), true, this.textPanelForXPGain, false, bonusXP, null);
            Global.getSector().getPlayerStats().setOnlyAddBonusXPDoNotSpendStoryPoints(false);
            Global.getSector().getPlayerStats().setBonusXPGainReason(null);
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        int fpTotal = 0;
        for (FleetEncounterContextPlugin.FleetMemberData data : otherSide.getOwnCasualties()) {
            float fp = data.getMember().getFleetPointCost();
            fpTotal = (int)((float)fpTotal + (fp *= 1.0f + (float)data.getMember().getCaptain().getStats().getLevel() / 5.0f));
        }
        float xp = (float)fpTotal * 250.0f;
        xp *= 2.0f;
        float difficultyMult = Math.max(1.0f, this.difficulty);
        xp *= difficultyMult;
        xp *= this.computePlayerContribFraction();
        if ((xp *= Global.getSettings().getFloat("xpGainMult")) > 0.0f) {
            this.gainOfficerXP(side, xp);
            fleet.getCommander().getStats().addXP((long)xp, this.textPanelForXPGain);
            fleet.getCommander().getStats().levelUpIfNeeded(this.textPanelForXPGain);
            this.xpGained = xp;
        }
    }

    public void addPotentialOfficer() {
        float fp;
        if (!this.isEngagedInHostilities()) {
            return;
        }
        if (this.xpGained <= 0.0f) {
            return;
        }
        if (this.sideData.size() != 2) {
            return;
        }
        if (!this.battle.isPlayerInvolved()) {
            return;
        }
        FleetEncounterContextPlugin.DataForEncounterSide sideOne = this.sideData.get(0);
        FleetEncounterContextPlugin.DataForEncounterSide sideTwo = this.sideData.get(1);
        FleetEncounterContextPlugin.DataForEncounterSide player = sideOne;
        FleetEncounterContextPlugin.DataForEncounterSide enemy = sideTwo;
        if (this.battle.isPlayerSide(this.battle.getSideFor(sideTwo.getFleet()))) {
            player = sideTwo;
            enemy = sideOne;
        }
        float fpDestroyed = 0.0f;
        for (FleetEncounterContextPlugin.FleetMemberData data : enemy.getOwnCasualties()) {
            fp = data.getMember().getFleetPointCost();
            fpDestroyed += (fp *= 1.0f + (float)data.getMember().getCaptain().getStats().getLevel() / 5.0f);
        }
        fpDestroyed *= this.computePlayerContribFraction();
        for (FleetEncounterContextPlugin.FleetMemberData data : player.getOwnCasualties()) {
            if (data.getMember().isAlly()) continue;
            fp = data.getMember().getFleetPointCost();
            fpDestroyed += (fp *= 1.0f + (float)data.getMember().getCaptain().getStats().getLevel() / 5.0f);
        }
        float fpInFleet = 0.0f;
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            float fp2 = member.getFleetPointCost();
            fpInFleet += (fp2 *= 1.0f + (float)member.getCaptain().getStats().getLevel() / 5.0f);
        }
        float maxProb = Global.getSettings().getFloat("maxOfficerPromoteProb");
        float probMult = Global.getSettings().getFloat("officerPromoteProbMult");
        int max = Misc.getMaxOfficers(Global.getSector().getPlayerFleet());
        int curr = Misc.getNumNonMercOfficers(Global.getSector().getPlayerFleet());
        float prob = fpDestroyed / Math.max(1.0f, fpInFleet);
        prob *= probMult;
        if (curr >= max) {
            prob *= 0.5f;
        }
        if (prob > maxProb) {
            prob = maxProb;
        }
        Random random = Misc.random;
        if (this.salvageRandom != null) {
            random = this.salvageRandom;
        }
        if (TutorialMissionIntel.isTutorialInProgress()) {
            prob = 0.0f;
        }
        if (random.nextFloat() < prob) {
            PromoteOfficerIntel intel = new PromoteOfficerIntel(this.textPanelForXPGain);
            Global.getSector().getIntelManager().addIntel(intel, false, this.textPanelForXPGain);
        }
    }

    public void generateLoot(List<FleetMemberAPI> recoveredShips, boolean withCredits) {
        this.creditsLooted = 0;
        this.loot.clear();
        if (this.battle.isPlayerSide(this.battle.getSideFor(this.getWinner()))) {
            this.generatePlayerLoot(recoveredShips, withCredits);
        } else {
            this.handleCargoLooting(recoveredShips, true);
        }
        this.loot.sort();
    }

    public Random getSalvageRandom() {
        return this.salvageRandom;
    }

    public void setSalvageRandom(Random salvageRandom) {
        this.salvageRandom = salvageRandom;
    }

    protected void generatePlayerLoot(List<FleetMemberAPI> recoveredShips, boolean withCredits) {
        MemoryAPI memory;
        float mult;
        FleetEncounterContextPlugin.DataForEncounterSide winner = this.getWinnerData();
        FleetEncounterContextPlugin.DataForEncounterSide loser = this.getLoserData();
        if (winner == null || loser == null) {
            return;
        }
        float adjustedFPSalvage = 0.0f;
        float playerContribMult = this.computePlayerContribFraction();
        for (FleetEncounterContextPlugin.FleetMemberData data : winner.getEnemyCasualties()) {
            if (data.getStatus() == FleetEncounterContextPlugin.Status.REPAIRED) continue;
            mult = this.getSalvageMult(data.getStatus()) * playerContribMult;
            this.lootWeapons(data.getMember(), data.getMember().getVariant(), false, mult, false);
            this.lootHullMods(data.getMember(), data.getMember().getVariant(), mult);
            this.lootWings(data.getMember(), data.getMember().getVariant(), false, mult);
            adjustedFPSalvage += (float)data.getMember().getFleetPointCost() * mult;
        }
        for (FleetEncounterContextPlugin.FleetMemberData data : winner.getOwnCasualties()) {
            if (data.getMember().isAlly() || data.getStatus() == FleetEncounterContextPlugin.Status.CAPTURED || data.getStatus() == FleetEncounterContextPlugin.Status.REPAIRED) continue;
            mult = this.getSalvageMult(data.getStatus());
            this.lootWeapons(data.getMember(), data.getMember().getVariant(), true, mult, false);
            this.lootWings(data.getMember(), data.getMember().getVariant(), true, mult);
            adjustedFPSalvage += (float)data.getMember().getFleetPointCost() * mult;
        }
        if (recoveredShips != null) {
            for (FleetMemberAPI member : recoveredShips) {
                mult = this.getSalvageMult(FleetEncounterContextPlugin.Status.CAPTURED);
                adjustedFPSalvage += (float)member.getFleetPointCost() * mult;
            }
        }
        Random random = Misc.random;
        if (this.salvageRandom != null) {
            random = this.salvageRandom;
        } else if (this.getBattle() != null && (memory = this.getBattle().getNonPlayerCombined().getMemoryWithoutUpdate()).contains("$salvageSeed")) {
            random = new Random(memory.getLong("$salvageSeed"));
        }
        float minCreditsFraction = Global.getSettings().getFloat("salvageFractionCreditsMin");
        float maxCreditsFraction = Global.getSettings().getFloat("salvageFractionCreditsMax");
        float creditsFraction = minCreditsFraction + (maxCreditsFraction - minCreditsFraction) * random.nextFloat();
        creditsFraction *= playerContribMult;
        float maxSalvageValue = adjustedFPSalvage * Global.getSettings().getFloat("salvageValuePerFP");
        if (Misc.isEasy()) {
            maxSalvageValue *= Global.getSettings().getFloat("easySalvageMult");
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float valueMultFleet = playerFleet.getStats().getDynamic().getValue("battle_salvage_value_bonus_fleet");
        float valueModShips = this.getSalvageValueModPlayerShips();
        this.creditsLooted = Math.round((maxSalvageValue *= valueMultFleet + valueModShips) * creditsFraction);
        if (!withCredits) {
            this.creditsLooted = 0;
        }
        maxSalvageValue -= (float)this.creditsLooted;
        float salvageValue = 0.0f;
        WeightedRandomPicker<String> lootPicker = new WeightedRandomPicker<String>(random);
        lootPicker.add("metals", 20.0f);
        lootPicker.add("supplies", 10.0f);
        lootPicker.add("fuel", 10.0f);
        lootPicker.add("heavy_machinery", 1.0f);
        while (salvageValue < maxSalvageValue) {
            String commodityId = (String)lootPicker.pick();
            if (commodityId == null) break;
            CommoditySpecAPI spec = Global.getSector().getEconomy().getCommoditySpec(commodityId);
            float qty = 1.0f;
            salvageValue += spec.getBasePrice() * qty;
            this.loot.addCommodity(commodityId, qty);
        }
        float fuelMult = playerFleet.getStats().getDynamic().getValue("fuel_salvage_value_mult_fleet");
        float fuel = this.loot.getFuel();
        if (fuelMult > 1.0f) {
            this.loot.addFuel(Math.round(fuel * (fuelMult - 1.0f)));
        }
        if (this.getBattle().getSnapshotSideFor(loser.getFleet()) == null) {
            return;
        }
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        ArrayList<SalvageEntityGenDataSpec.DropData> dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        for (CampaignFleetAPI other : this.getBattle().getSnapshotSideFor(loser.getFleet())) {
            dropRandom.addAll(other.getDropRandom());
            dropValue.addAll(other.getDropValue());
            other.getDropRandom().clear();
            other.getDropValue().clear();
            CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(other);
            this.loot.addAll(extra);
            BaseSalvageSpecial.clearExtraSalvage(other);
            if (extra.isEmpty()) continue;
            ListenerUtil.reportExtraSalvageShown(other);
        }
        CargoAPI extra = SalvageEntity.generateSalvage(random, valueMultFleet + valueModShips, 1.0f, fuelMult, dropValue, dropRandom);
        for (CargoStackAPI stack : extra.getStacksCopy()) {
            this.loot.addFromStack(stack);
        }
        this.handleCargoLooting(recoveredShips, false);
    }

    public float getSalvageValueModPlayerShips() {
        return RepairGantry.getAdjustedGantryModifierForPostCombatSalvage(Global.getSector().getPlayerFleet());
    }

    protected void handleCargoLooting(List<FleetMemberAPI> recoveredShips, boolean takingFromPlayer) {
        List<CampaignFleetAPI> losers;
        FleetEncounterContextPlugin.DataForEncounterSide winner = this.getWinnerData();
        FleetEncounterContextPlugin.DataForEncounterSide loser = this.getLoserData();
        if (winner == null || loser == null) {
            return;
        }
        loser.getFleet().getFleetData().updateCargoCapacities();
        CargoAPI loserCargo = loser.getFleet().getCargo();
        float maxCargo = loserCargo.getMaxCapacity();
        float maxFuel = loserCargo.getMaxFuel();
        Random random = Misc.random;
        if (this.salvageRandom != null) {
            random = this.salvageRandom;
        }
        HashMap<CargoAPI, LossFraction> fractions = new HashMap<CargoAPI, LossFraction>();
        float lostCargo = 0.0f;
        float lostFuel = 0.0f;
        float totalLoss = 0.0f;
        for (FleetEncounterContextPlugin.FleetMemberData data : winner.getEnemyCasualties()) {
            CampaignFleetAPI source = this.battle.getSourceFleet(data.getMember());
            if (source != null) {
                CargoAPI c = source.getCargo();
                LossFraction loss = (LossFraction)fractions.get(c);
                if (loss == null) {
                    loss = new LossFraction();
                    loss.maxCargo = c.getMaxCapacity();
                    loss.maxFuel = c.getMaxFuel();
                    fractions.put(c, loss);
                }
                loss.lostCargo += data.getMember().getCargoCapacity();
                loss.lostFuel += data.getMember().getFuelCapacity();
                loss.maxCargo += data.getMember().getCargoCapacity();
                loss.maxFuel += data.getMember().getFuelCapacity();
                totalLoss += loss.maxCargo + loss.maxFuel;
                continue;
            }
            lostCargo += data.getMember().getCargoCapacity();
            lostFuel += data.getMember().getFuelCapacity();
            totalLoss += (maxCargo += data.getMember().getCargoCapacity()) + (maxFuel += data.getMember().getFuelCapacity());
        }
        if (totalLoss <= 0.0f) {
            return;
        }
        if (maxCargo < 1.0f) {
            maxCargo = 1.0f;
        }
        if (maxFuel < 1.0f) {
            maxFuel = 1.0f;
        }
        float recoveryFraction = Global.getSettings().getFloat("salvageCargoFraction");
        if (this.battle.isPlayerSide(this.battle.getSideFor(winner.getFleet()))) {
            float playerContribMult = this.computePlayerContribFraction();
            recoveryFraction *= playerContribMult;
        }
        float cargoFractionLost = lostCargo / maxCargo;
        float fuelFractionLost = lostFuel / maxFuel;
        if (lostCargo > maxCargo) {
            cargoFractionLost = 1.0f;
        }
        if (lostFuel > maxFuel) {
            fuelFractionLost = 1.0f;
        }
        if ((losers = this.battle.getSnapshotSideFor(loser.getFleet())) == null) {
            return;
        }
        ArrayList<LootableCargoStack> stacks = new ArrayList<LootableCargoStack>();
        for (CampaignFleetAPI curr : losers) {
            for (CargoStackAPI stack : curr.getCargo().getStacksCopy()) {
                stacks.add(new LootableCargoStack(curr.getCargo(), stack));
            }
        }
        for (LootableCargoStack stack : stacks) {
            CommoditySpecAPI spec;
            if (stack.stack.isNull() || stack.stack.isPersonnelStack() || stack.stack.getSize() < 1.0f) continue;
            float actualCargoFractionLost = cargoFractionLost;
            float actualFuelFractionLost = fuelFractionLost;
            LossFraction loss = (LossFraction)fractions.get(stack.source);
            if (loss != null) {
                actualCargoFractionLost = loss.lostCargo / loss.maxCargo;
                actualFuelFractionLost = loss.lostFuel / loss.maxFuel;
                if (loss.lostCargo > loss.maxCargo) {
                    actualCargoFractionLost = 1.0f;
                }
                if (loss.lostFuel > loss.maxFuel) {
                    actualFuelFractionLost = 1.0f;
                }
            }
            if (takingFromPlayer && (stack.stack.isSpecialStack() || stack.stack.isCommodityStack() && (spec = stack.stack.getResourceIfResource()) != null && spec.hasTag("no_loss_from_combat"))) continue;
            float numLost = 0.0f;
            float numTaken = 0.0f;
            if (stack.stack.isFuelStack()) {
                numLost = actualFuelFractionLost * stack.stack.getSize();
                numTaken = Math.round(numLost * (0.5f + random.nextFloat() * 0.5f));
            } else {
                numLost = actualCargoFractionLost * stack.stack.getSize();
                numTaken = Math.round(numLost * (0.5f + random.nextFloat() * 0.5f));
            }
            if (numLost < 1.0f) {
                if (random.nextFloat() < numLost) {
                    numLost = 1.0f;
                } else {
                    numLost = 0.0f;
                    numTaken = 0.0f;
                }
            }
            if (numLost <= 0.0f) continue;
            stack.stack.add(-numLost);
            if (!(numTaken * recoveryFraction >= 1.0f)) continue;
            this.loot.addItems(stack.stack.getType(), stack.stack.getData(), numTaken * recoveryFraction);
        }
        for (CampaignFleetAPI fleet : this.battle.getSideFor(loser.getFleet())) {
            if (!fleet.isPlayerFleet()) continue;
            fleet.getCargo().sort();
            break;
        }
    }

    public CargoAPI getLoot() {
        return this.loot;
    }

    protected void lootHullMods(FleetMemberAPI member, ShipVariantAPI variant, float mult) {
        if (variant == null) {
            return;
        }
        if (member.isFighterWing()) {
            return;
        }
        Random random = Misc.random;
        if (this.salvageRandom != null) {
            random = this.salvageRandom;
        }
        float p = Global.getSettings().getFloat("salvageHullmodProb");
        for (String id : variant.getHullMods()) {
            if (random.nextFloat() > mult || random.nextFloat() > p) continue;
            HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
            boolean known = Global.getSector().getPlayerFaction().knowsHullMod(id);
            if (DebugFlags.ALLOW_KNOWN_HULLMOD_DROPS) {
                known = false;
            }
            if (known || spec.isHidden() || spec.isHiddenEverywhere() || spec.hasTag("no_drop")) continue;
            this.loot.addHullmods(id, 1);
        }
        for (String slotId : variant.getModuleSlots()) {
            ShipVariantAPI module;
            WeaponSlotAPI slot = variant.getSlot(slotId);
            if (!slot.isStationModule() || (module = variant.getModuleVariant(slotId)) == null) continue;
            this.lootHullMods(member, module, mult);
        }
    }

    protected void lootWings(FleetMemberAPI member, ShipVariantAPI variant, boolean own, float mult) {
        if (variant == null) {
            return;
        }
        if (member.isFighterWing()) {
            return;
        }
        Random random = Misc.random;
        if (this.salvageRandom != null) {
            random = this.salvageRandom;
        }
        float p = Global.getSettings().getFloat("salvageWingProb");
        if (own) {
            p = Global.getSettings().getFloat("salvageOwnWingProb");
            p = Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("own_wing_recovery_mod", p);
        } else {
            p = Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("enemy_wing_recovery_mod", p);
        }
        boolean alreadyStripped = this.recoverableShips.contains(member);
        for (String id : variant.getNonBuiltInWings()) {
            FighterWingSpecAPI spec;
            if (!alreadyStripped && (random.nextFloat() > mult || random.nextFloat() > p) || (spec = Global.getSettings().getFighterWingSpec(id)).hasTag("no_drop")) continue;
            this.loot.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, id, 1.0f);
        }
        for (String slotId : variant.getModuleSlots()) {
            ShipVariantAPI module;
            WeaponSlotAPI slot = variant.getSlot(slotId);
            if (!slot.isStationModule() || (module = variant.getModuleVariant(slotId)) == null) continue;
            this.lootWings(member, module, own, mult);
        }
    }

    protected void lootWeapons(FleetMemberAPI member, ShipVariantAPI variant, boolean own, float mult, boolean lootingModule) {
        WeaponSpecAPI spec;
        String weaponId;
        CommoditySpecAPI spec2;
        String cid;
        if (variant == null) {
            return;
        }
        if (member.isFighterWing()) {
            return;
        }
        if (own && !lootingModule && member.getCaptain() != null && member.getCaptain().getMemoryWithoutUpdate().contains("$aiCoreIdForRecovery") && !Misc.isUnremovable(member.getCaptain())) {
            this.loot.addItems(CargoAPI.CargoItemType.RESOURCES, member.getCaptain().getMemoryWithoutUpdate().getString("$aiCoreIdForRecovery"), 1.0f);
        }
        Random random = Misc.random;
        if (this.salvageRandom != null) {
            random = this.salvageRandom;
        }
        if (!(own || lootingModule || !member.getCaptain().isAICore() || variant.hasTag("no_ai_core_drop") || (cid = member.getCaptain().getAICoreId()) == null || (spec2 = Global.getSettings().getCommoditySpec(cid)).hasTag("no_drop"))) {
            float prob = Global.getSettings().getFloat("drop_prob_officer_" + cid);
            if (member.isStation()) {
                prob *= Global.getSettings().getFloat("drop_prob_mult_ai_core_station");
            } else if (member.isFrigate()) {
                prob *= Global.getSettings().getFloat("drop_prob_mult_ai_core_frigate");
            } else if (member.isDestroyer()) {
                prob *= Global.getSettings().getFloat("drop_prob_mult_ai_core_destroyer");
            } else if (member.isCruiser()) {
                prob *= Global.getSettings().getFloat("drop_prob_mult_ai_core_cruiser");
            } else if (member.isCapital()) {
                prob *= Global.getSettings().getFloat("drop_prob_mult_ai_core_capital");
            }
            if (prob > 0.0f && random.nextFloat() < prob) {
                this.loot.addItems(CargoAPI.CargoItemType.RESOURCES, cid, 1.0f);
            }
        }
        float p = Global.getSettings().getFloat("salvageWeaponProb");
        if (own) {
            p = Global.getSettings().getFloat("salvageOwnWeaponProb");
            p = Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("own_weapon_recovery_mod", p);
        } else {
            p = Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("enemy_weapon_recovery_mod", p);
        }
        boolean alreadyStripped = this.recoverableShips.contains(member);
        HashSet<String> remove = new HashSet<String>();
        if (variant.hasTag("consistent_weapon_drops")) {
            for (String slotId : variant.getNonBuiltInWeaponSlots()) {
                weaponId = variant.getWeaponId(slotId);
                if (weaponId == null || this.loot.getNumWeapons(weaponId) > 0 || (spec = Global.getSettings().getWeaponSpec(weaponId)).hasTag("no_drop")) continue;
                this.loot.addWeapons(weaponId, 1);
                remove.add(slotId);
            }
        }
        for (String slotId : variant.getNonBuiltInWeaponSlots()) {
            if (remove.contains(slotId) || !alreadyStripped && (random.nextFloat() > mult || random.nextFloat() > p)) continue;
            weaponId = variant.getWeaponId(slotId);
            spec = Global.getSettings().getWeaponSpec(weaponId);
            if (spec.hasTag("no_drop")) continue;
            this.loot.addItems(CargoAPI.CargoItemType.WEAPONS, weaponId, 1.0f);
            remove.add(slotId);
        }
        for (String slotId : variant.getModuleSlots()) {
            ShipVariantAPI module;
            WeaponSlotAPI slot = variant.getSlot(slotId);
            if (!slot.isStationModule() || (module = variant.getModuleVariant(slotId)) == null) continue;
            this.lootWeapons(member, module, own, mult, true);
        }
    }

    public void autoLoot() {
        float maxUnits;
        float spacePerUnit;
        float spaceLeft;
        CargoAPI winnerCargo;
        CampaignFleetAPI pick;
        FleetEncounterContextPlugin.DataForEncounterSide winner = this.getWinnerData();
        FleetEncounterContextPlugin.DataForEncounterSide loser = this.getLoserData();
        if (winner == null || loser == null) {
            return;
        }
        List<CampaignFleetAPI> winners = this.battle.getSideFor(winner.getFleet());
        WeightedRandomPicker<CampaignFleetAPI> picker = new WeightedRandomPicker<CampaignFleetAPI>();
        for (CampaignFleetAPI curr : winners) {
            picker.add(curr, curr.getFleetPoints());
        }
        for (CargoStackAPI stack : this.loot.getStacksCopy()) {
            if (stack.isNull() || stack.isFuelStack()) continue;
            pick = (CampaignFleetAPI)picker.pick();
            if (pick == null) break;
            winnerCargo = pick.getCargo();
            spaceLeft = winnerCargo.getSpaceLeft();
            if (spaceLeft <= 0.0f) {
                picker.remove(pick);
                continue;
            }
            spacePerUnit = stack.getCargoSpacePerUnit();
            maxUnits = (int)(spaceLeft / spacePerUnit);
            if (maxUnits > stack.getSize()) {
                maxUnits = stack.getSize();
            }
            maxUnits = Math.round((double)maxUnits * (Math.random() * 0.5 + 0.5));
            winnerCargo.addItems(stack.getType(), stack.getData(), maxUnits);
        }
        picker.clear();
        for (CampaignFleetAPI curr : winners) {
            picker.add(curr, curr.getFleetPoints());
        }
        for (CargoStackAPI stack : this.loot.getStacksCopy()) {
            if (stack.isNull() || !stack.isFuelStack()) continue;
            pick = (CampaignFleetAPI)picker.pick();
            if (pick == null) break;
            winnerCargo = pick.getCargo();
            spaceLeft = winnerCargo.getMaxCapacity() - winnerCargo.getFuel();
            if (spaceLeft <= 0.0f) {
                picker.remove(pick);
                continue;
            }
            spacePerUnit = stack.getCargoSpacePerUnit();
            maxUnits = (int)(spaceLeft / spacePerUnit);
            if (maxUnits > stack.getSize()) {
                maxUnits = stack.getSize();
            }
            maxUnits = Math.round((double)maxUnits * (Math.random() * 0.5 + 0.5));
            winnerCargo.addItems(stack.getType(), stack.getData(), maxUnits);
        }
    }

    public boolean hasWinnerAndLoser() {
        return this.getWinner() != null && this.getLoser() != null;
    }

    @Override
    public CampaignFleetAPI getWinner() {
        return this.getWinnerData() != null ? this.getWinnerData().getFleet() : null;
    }

    @Override
    public CampaignFleetAPI getLoser() {
        return this.getLoserData() != null ? this.getLoserData().getFleet() : null;
    }

    public boolean canOutrunOtherFleet(CampaignFleetAPI fleet, CampaignFleetAPI other) {
        return fleet.getFleetData().getMinBurnLevel() >= other.getFleetData().getMaxBurnLevel() + 1.0f;
    }

    protected void applyResultToFleets(EngagementResultAPI result) {
        this.applyShipLosses(result);
        this.applyCrewLosses(result);
    }

    public void fixFighters(EngagementResultForFleetAPI result) {
        HashSet<CampaignFleetAPI> fleetsWithDecks = new HashSet<CampaignFleetAPI>();
        for (FleetMemberAPI curr : result.getReserves()) {
            if (this.battle.getSourceFleet(curr) == null || curr.isMothballed() || curr.getNumFlightDecks() <= 0) continue;
            fleetsWithDecks.add(this.battle.getSourceFleet(curr));
        }
        for (FleetMemberAPI curr : result.getDeployed()) {
            if (this.battle.getSourceFleet(curr) == null || curr.isMothballed() || curr.getNumFlightDecks() <= 0) continue;
            fleetsWithDecks.add(this.battle.getSourceFleet(curr));
        }
        for (FleetMemberAPI curr : result.getRetreated()) {
            if (this.battle.getSourceFleet(curr) == null || curr.isMothballed() || curr.getNumFlightDecks() <= 0) continue;
            fleetsWithDecks.add(this.battle.getSourceFleet(curr));
        }
        ArrayList<FleetMemberAPI> saved = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI curr : result.getDestroyed()) {
            if (this.battle.getSourceFleet(curr) == null || !fleetsWithDecks.contains(this.battle.getSourceFleet(curr)) || !curr.isFighterWing()) continue;
            saved.add(curr);
        }
        result.getDestroyed().removeAll(saved);
        result.getRetreated().addAll(saved);
        ArrayList<FleetMemberAPI> toRepair = new ArrayList<FleetMemberAPI>();
        toRepair.addAll(result.getDeployed());
        toRepair.addAll(result.getRetreated());
        for (FleetMemberAPI curr : toRepair) {
            if (this.battle.getSourceFleet(curr) == null || !curr.isFighterWing()) continue;
            if (fleetsWithDecks.contains(this.battle.getSourceFleet(curr))) {
                curr.getStatus().repairFully();
                continue;
            }
            curr.getStatus().repairFullyNoNewFighters();
        }
    }

    protected void applyCrewLosses(EngagementResultAPI result) {
        EngagementResultForFleetAPI winner = result.getWinnerResult();
        EngagementResultForFleetAPI loser = result.getLoserResult();
        boolean playerInvolved = this.battle.isPlayerInvolved();
        this.calculateAndApplyCrewLosses(winner, playerInvolved);
        this.calculateAndApplyCrewLosses(loser, playerInvolved);
    }

    protected void applyShipLosses(EngagementResultAPI result) {
        EngagementResultForFleetAPI winner = result.getWinnerResult();
        EngagementResultForFleetAPI loser = result.getLoserResult();
        this.applyShipLosses(winner);
        this.applyShipLosses(loser);
        this.applyCREffect(winner);
        this.applyCREffect(loser);
    }

    protected void applyCREffect(EngagementResultForFleetAPI result) {
        float mult;
        boolean wonBattle = result.isWinner();
        if (wonBattle) {
            this.preEngagementCRForWinner.clear();
            for (FleetMemberAPI member : result.getFleet().getFleetData().getMembersListCopy()) {
                this.preEngagementCRForWinner.put(member, Float.valueOf(member.getRepairTracker().getCR()));
            }
        }
        ArrayList<FleetMemberAPI> applyDeployCostTo = new ArrayList<FleetMemberAPI>(result.getDeployed());
        for (FleetMemberAPI member : result.getDisabled()) {
            mult = 1.0f;
            if (mult > 0.0f) {
                member.getRepairTracker().applyCREvent(-1.0f * mult, "disabled in combat");
            }
            if (!(mult < 1.0f)) continue;
            applyDeployCostTo.add(member);
        }
        for (FleetMemberAPI member : result.getDestroyed()) {
            mult = 1.0f;
            if (mult > 0.0f) {
                member.getRepairTracker().applyCREvent(-1.0f * mult, "disabled in combat");
            }
            if (!(mult < 1.0f)) continue;
            applyDeployCostTo.add(member);
        }
        for (FleetMemberAPI member : applyDeployCostTo) {
            float deployCost = this.getDeployCost(member);
            if (member.isFighterWing()) {
                member.getRepairTracker().applyCREvent(-deployCost, "wing deployed in combat");
            } else {
                member.getRepairTracker().applyCREvent(-deployCost, "deployed in combat");
            }
            this.applyExtendedCRLossIfNeeded(result, member);
        }
        float retreatLossMult = Global.getSettings().getFloat("crLossMultForRetreatInLoss");
        for (FleetMemberAPI member : result.getRetreated()) {
            float retreatCost;
            float deployCost = this.getDeployCost(member);
            if (member.isFighterWing()) {
                member.getRepairTracker().applyCREvent(-deployCost, "wing deployed in combat");
            } else {
                member.getRepairTracker().applyCREvent(-deployCost, "deployed in combat");
            }
            this.applyExtendedCRLossIfNeeded(result, member);
            if (wonBattle || result.getGoal() == FleetGoal.ESCAPE || !((retreatCost = deployCost * retreatLossMult) > 0.0f)) continue;
            member.getRepairTracker().applyCREvent(-retreatCost, "retreated from lost engagement");
        }
    }

    protected void applyExtendedCRLossIfNeeded(EngagementResultForFleetAPI result, FleetMemberAPI member) {
        DeployedFleetMemberAPI dfm = this.getDataFor(result.getFleet()).getMemberToDeployedMap().get(member);
        if (dfm == null) {
            return;
        }
        if (this.battle != null && this.battle.getSourceFleet(member) == null) {
            return;
        }
        if (member.getFleetCommander() == null) {
            return;
        }
        if (dfm.getMember() == member && dfm.isFighterWing()) {
            float cr;
            float finalCR = cr = member.getRepairTracker().getBaseCR();
            if (cr > finalCR) {
                member.getRepairTracker().applyCREvent(-(cr - finalCR), "deployed replacement chassis in combat");
            }
            return;
        }
        if (dfm.getMember() == member && !dfm.isFighterWing()) {
            float deployCost = this.getDeployCost(member);
            float endOfCombatCR = dfm.getShip().getCurrentCR() - deployCost;
            float cr = member.getRepairTracker().getCR();
            if (cr > endOfCombatCR) {
                member.getRepairTracker().applyCREvent(-(cr - endOfCombatCR), "extended deployment");
            }
            ShipAPI ship = dfm.getShip();
            if (dfm.getShip() != null && !dfm.isFighterWing()) {
                float damageBasedCRLoss;
                float wMult = Global.getSettings().getFloat("crLossMultForWeaponDisabled");
                float eMult = Global.getSettings().getFloat("crLossMultForFlameout");
                float mMult = Global.getSettings().getFloat("crLossMultForMissilesFired");
                float hMult = Global.getSettings().getFloat("crLossMultForHullDamage");
                float hullDamageFraction = ship.getHullLevelAtDeployment() - ship.getLowestHullLevelReached();
                float hullDamageCRLoss = hullDamageFraction * hMult;
                if ((hullDamageCRLoss *= ship.getMutableStats().getDynamic().getValue("hull_damage_cr_loss")) > 0.0f) {
                    member.getRepairTracker().applyCREvent(-hullDamageCRLoss, "hull damage sustained");
                }
                member.getStatus().setHullFraction(ship.getLowestHullLevelReached());
                float instaRepairFraction = member.getStats().getDynamic().getValue("insta_repair_fraction", 0.0f);
                if (instaRepairFraction > 0.0f) {
                    float hullDamage = member.getStatus().getHullDamageTaken();
                    float armorDamage = member.getStatus().getArmorDamageTaken();
                    member.getStatus().repairArmorAllCells(armorDamage * instaRepairFraction);
                    member.getStatus().repairHullFraction(hullDamage * instaRepairFraction);
                }
                float totalDisabled = 0.0f;
                MutableCharacterStatsAPI stats = member.getFleetCommander().getStats();
                float maxOP = ship.getVariant().getHullSpec().getOrdnancePoints(stats);
                if (maxOP <= 1.0f) {
                    maxOP = 1.0f;
                }
                for (WeaponAPI w : ship.getDisabledWeapons()) {
                    totalDisabled += w.getSpec().getOrdnancePointCost(stats, ship.getVariant().getStatsForOpCosts()) * wMult;
                }
                if (ship.getNumFlameouts() > 0) {
                    totalDisabled += maxOP * eMult;
                }
                if ((damageBasedCRLoss = Math.min(1.0f, totalDisabled / maxOP)) > 0.0f) {
                    member.getRepairTracker().applyCREvent(-damageBasedCRLoss, "weapon and engine damage sustained");
                }
                float missileReloadOP = 0.0f;
                for (WeaponAPI w : ship.getAllWeapons()) {
                    if (w.getType() != WeaponAPI.WeaponType.MISSILE || !w.usesAmmo()) continue;
                    missileReloadOP += (1.0f - (float)w.getAmmo() / (float)w.getMaxAmmo()) * w.getSpec().getOrdnancePointCost(stats, ship.getVariant().getStatsForOpCosts()) * mMult;
                }
                float missileReloadLoss = Math.min(1.0f, missileReloadOP / maxOP);
                if (missileReloadLoss > 0.0f) {
                    member.getRepairTracker().applyCREvent(-missileReloadLoss, "missile weapons used in combat");
                }
            }
            return;
        }
    }

    protected void applyShipLosses(EngagementResultForFleetAPI result) {
        for (FleetMemberAPI member : result.getDestroyed()) {
            if (this.battle.getSourceFleet(member) == null) continue;
            this.battle.getSourceFleet(member).removeFleetMemberWithDestructionFlash(member);
            result.getFleet().getFleetData().removeFleetMember(member);
        }
        for (FleetMemberAPI member : result.getDisabled()) {
            if (this.battle.getSourceFleet(member) == null) continue;
            this.battle.getSourceFleet(member).removeFleetMemberWithDestructionFlash(member);
            result.getFleet().getFleetData().removeFleetMember(member);
        }
    }

    protected float computeLossFraction(FleetMemberAPI member, EngagementResultForFleetAPI result, float hullFraction, float hullDamage) {
        DeployedFleetMemberAPI dfm;
        if (member == null && hullFraction == 0.0f) {
            return 0.75f + (float)Math.random() * 0.25f;
        }
        if (member.isFighterWing() && result != null) {
            float finalCR;
            float cr;
            float extraLossMult = hullDamage;
            DeployedFleetMemberAPI dfm2 = this.getDataFor(result.getFleet()).getMemberToDeployedMap().get(member);
            if (dfm2 != null && dfm2.getMember() == member && cr > (finalCR = (cr = member.getRepairTracker().getCR()))) {
                float crPer = dfm2.getMember().getStats().getCRPerDeploymentPercent().computeEffective(dfm2.getMember().getVariant().getHullSpec().getCRToDeploy()) / 100.0f;
                float extraCraftLost = (cr - finalCR) / crPer;
                float wingSize = dfm2.getMember().getNumFightersInWing();
                if (extraCraftLost >= 1.0f) {
                    extraLossMult = hullDamage + extraCraftLost / wingSize;
                }
            }
            return (0.25f + (float)Math.random() * 0.75f * (float)Math.random()) * member.getStats().getCrewLossMult().getModifiedValue() * extraLossMult;
        }
        float extraFromFighters = 0.0f;
        if (!member.isFighterWing() && result != null && (dfm = this.getDataFor(result.getFleet()).getMemberToDeployedMap().get(member)) != null && dfm.getMember() == member) {
            float craftCrewLoss = 0.0f;
            for (FighterLaunchBayAPI bay : dfm.getShip().getLaunchBaysCopy()) {
                if (bay.getWing() == null || bay.getWing().getLeader() == null) continue;
                float baseCrew = bay.getWing().getLeader().getHullSpec().getMinCrew();
                float perCraft = bay.getWing().getLeader().getMutableStats().getMinCrewMod().computeEffective(baseCrew);
                craftCrewLoss += (perCraft *= bay.getWing().getLeader().getMutableStats().getDynamic().getValue("fighter_crew_loss_mult")) * (float)bay.getNumLost();
            }
            float baseLossFraction = Global.getSettings().getFloat("fighterCrewLossBase");
            craftCrewLoss *= baseLossFraction;
            float memberCrew = member.getMinCrew();
            if (memberCrew > 0.0f) {
                float threshold = memberCrew * 0.33f;
                float actualLost = 0.0f;
                float mult = 1.0f;
                do {
                    float curr = Math.min(craftCrewLoss, threshold);
                    craftCrewLoss -= curr;
                    actualLost += (curr *= mult);
                    mult /= 2.0f;
                } while (craftCrewLoss > 0.0f);
                extraFromFighters = actualLost / memberCrew;
                extraFromFighters *= member.getStats().getDynamic().getValue("fighter_crew_loss_mult");
            }
        }
        if (hullFraction == 0.0f) {
            return Math.min(1.0f, (0.75f + (float)Math.random() * 0.25f) * member.getStats().getCrewLossMult().getModifiedValue() + extraFromFighters);
        }
        return Math.min(1.0f, hullDamage * hullDamage * (0.5f + (float)Math.random() * 0.5f) * member.getStats().getCrewLossMult().getModifiedValue() + extraFromFighters);
    }

    protected float computeRecoverableFraction(FleetMemberAPI member, EngagementResultForFleetAPI result, float hullFraction, float hullDamage) {
        float f = 1.0f - this.computeLossFraction(member, result, hullFraction, hullDamage);
        if (f < 0.0f) {
            f = 0.0f;
        }
        return f;
    }

    public void calculateAndApplyCrewLosses(EngagementResultForFleetAPI result, boolean playerInvolved) {
        boolean wonBattle = result.isWinner();
        FleetEncounterContextPlugin.DataForEncounterSide data = this.getDataFor(result.getFleet());
        CrewCompositionAPI recoverable = data.getRecoverableCrewLosses();
        ArrayList<FleetMemberAPI> all = new ArrayList<FleetMemberAPI>();
        all.addAll(result.getDisabled());
        all.addAll(result.getDeployed());
        all.addAll(result.getDestroyed());
        all.addAll(result.getRetreated());
        all.addAll(result.getReserves());
        for (FleetMemberAPI member : result.getReserves()) {
            member.getStatus().resetDamageTaken();
        }
        CrewCompositionAPI playerLosses = data.getCrewLossesDuringLastEngagement();
        playerLosses.removeAllCrew();
        CrewCompositionAPI crewLosses = Global.getFactory().createCrewComposition();
        crewLosses.removeAllCrew();
        CampaignFleetAPI playerFleet = null;
        float playerCapacityLost = 0.0f;
        for (FleetMemberAPI member : all) {
            if (this.battle.getSourceFleet(member) == null) continue;
            boolean player = this.battle.getSourceFleet(member) != null && this.battle.getSourceFleet(member).isPlayerFleet();
            CrewCompositionAPI c = member.getCrewComposition();
            float hullDamage = member.getStatus().getHullDamageTaken();
            float hullFraction = member.getStatus().getHullFraction();
            member.getStatus().resetDamageTaken();
            float f1 = this.computeLossFraction(member, result, hullFraction, hullDamage);
            if (result.getDisabled().contains(member) || result.getDestroyed().contains(member)) {
                if (playerInvolved && !this.battle.getPlayerSide().contains(this.battle.getSourceFleet(member))) {
                    this.playerDidSeriousDamage = true;
                }
                if (player) {
                    if (f1 < 1.0f) {
                        recoverable.addCrew((1.0f - f1) * c.getCrew());
                    }
                    playerLosses.addCrew(c.getCrew() * 1.0f);
                    playerCapacityLost += member.getMaxCrew();
                }
                crewLosses.addCrew(c.getCrew() * 1.0f);
                c.setCrew(0.0f);
            } else {
                if (f1 > 1.0f) {
                    crewLosses.addCrew((f1 - 1.0f) * c.getCrew());
                }
                float lost = c.getCrew() * f1;
                c.transfer(lost, crewLosses);
                if (player) {
                    playerLosses.addCrew(lost);
                    playerCapacityLost += member.getMaxCrew() * f1;
                }
            }
            if (this.battle.getSourceFleet(member).isPlayerFleet() && (crewLosses.getCrew() > 0.0f || crewLosses.getMarines() > 0.0f)) {
                playerFleet = this.battle.getSourceFleet(member);
            }
            CargoAPI cargo = this.battle.getSourceFleet(member).getCargo();
            cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, "crew", (int)crewLosses.getCrew());
            cargo.removeMarines((int)crewLosses.getMarines());
            crewLosses.clear();
        }
        if (playerFleet != null) {
            float toLose;
            playerFleet.getFleetData().updateCargoCapacities();
            CargoAPI cargo = playerFleet.getCargo();
            float maxCrew = cargo.getMaxPersonnel();
            float totalCrew = cargo.getTotalCrew();
            float marines = cargo.getMarines();
            float recoverableTotal = recoverable.getCrew() + recoverable.getMarines();
            float total = totalCrew + marines + recoverableTotal;
            if (maxCrew + playerCapacityLost > 0.0f) {
                total *= playerCapacityLost / (maxCrew + playerCapacityLost);
            }
            if (total > maxCrew && (toLose = total - maxCrew) > 0.0f) {
                recoverable.transfer(Math.min(recoverableTotal, toLose), null);
                toLose -= recoverableTotal;
                total -= recoverableTotal;
                if (toLose > 0.0f && total > 0.0f) {
                    float crew = cargo.getCrew();
                    crewLosses.clear();
                    crewLosses.addCrew((int)Math.ceil(crew / total * toLose));
                    crewLosses.addMarines((int)Math.ceil(marines / total * toLose));
                    playerLosses.addCrew(crewLosses.getCrew() * 1.0f);
                    playerLosses.addMarines(crewLosses.getMarines() * 1.0f);
                    cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, "crew", (int)crewLosses.getCrew());
                    cargo.removeMarines((int)crewLosses.getMarines());
                    crewLosses.clear();
                }
            }
        }
    }

    public void recoverCrew(CampaignFleetAPI fleet) {
        if (this.battle.isPlayerSide(this.battle.getSideFor(fleet))) {
            FleetEncounterContextPlugin.DataForEncounterSide data = this.getDataFor(fleet);
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            CrewCompositionAPI rec = data.getRecoverableCrewLosses();
            cargo.addItems(CargoAPI.CargoItemType.RESOURCES, "crew", rec.getCrew());
            cargo.addMarines((int)rec.getMarines());
        }
    }

    public float getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(float difficulty) {
        this.difficulty = difficulty;
    }

    public boolean isComputedDifficulty() {
        return this.computedDifficulty;
    }

    public void setComputedDifficulty(boolean computedDifficulty) {
        this.computedDifficulty = computedDifficulty;
    }

    public float computeBattleDifficulty() {
        if (this.computedDifficulty) {
            return this.difficulty;
        }
        this.computedDifficulty = true;
        if (this.battle == null || !this.battle.isPlayerInvolved()) {
            this.difficulty = 1.0f;
            return this.difficulty;
        }
        float scorePlayer = 0.0f;
        float scoreEnemy = 0.0f;
        float officerBase = 30.0f;
        float officerPerLevel = 15.0f;
        float baseMult = 2.0f;
        float dModMult = 0.9f;
        for (FleetMemberAPI member : this.battle.getNonPlayerCombined().getFleetData().getMembersListCopy()) {
            if (member.isMothballed()) continue;
            float mult = baseMult;
            if (member.isStation()) {
                mult *= 2.0f;
            } else if (member.isCivilian()) {
                mult *= 0.25f;
            }
            if (member.getCaptain() != null && !member.getCaptain().isDefault()) {
                scoreEnemy += officerBase + officerPerLevel * Math.max(1.0f, (float)member.getCaptain().getStats().getLevel());
            }
            int dMods = DModManager.getNumDMods(member.getVariant());
            int i = 0;
            while (i < dMods) {
                mult *= dModMult;
                ++i;
            }
            scoreEnemy += member.getUnmodifiedDeploymentPointsCost() * mult;
        }
        scoreEnemy *= 0.67f;
        float maxPlayserShipScore = 0.0f;
        officerBase *= 0.5f;
        officerPerLevel *= 0.5f;
        HashSet<PersonAPI> seenOfficers = new HashSet<PersonAPI>();
        int unofficeredShips = 0;
        for (FleetMemberAPI member : this.battle.getPlayerCombined().getFleetData().getMembersListCopy()) {
            if (member.isMothballed()) continue;
            float mult = baseMult;
            if (member.isStation()) {
                mult *= 2.0f;
            } else if (member.isCivilian()) {
                mult *= 0.25f;
            }
            if (member.getCaptain() != null && !member.getCaptain().isDefault()) {
                scorePlayer += officerBase + officerPerLevel * Math.max(1.0f, (float)member.getCaptain().getStats().getLevel());
                seenOfficers.add(member.getCaptain());
            } else if (!member.isCivilian()) {
                ++unofficeredShips;
            }
            int dMods = DModManager.getNumDMods(member.getVariant());
            int i = 0;
            while (i < dMods) {
                mult *= dModMult;
                ++i;
            }
            float currShipBaseScore = member.getUnmodifiedDeploymentPointsCost() * mult;
            scorePlayer += currShipBaseScore;
            if (this.battle.getSourceFleet(member) == null || !this.battle.getSourceFleet(member).isPlayerFleet()) continue;
            maxPlayserShipScore = Math.max(maxPlayserShipScore, currShipBaseScore);
        }
        for (OfficerDataAPI od : Global.getSector().getPlayerFleet().getFleetData().getOfficersCopy()) {
            if (seenOfficers.contains(od.getPerson()) || od.getPerson().isPlayer()) continue;
            if (unofficeredShips <= 0) break;
            --unofficeredShips;
            scorePlayer += officerBase + officerPerLevel * Math.max(1.0f, (float)od.getPerson().getStats().getLevel());
        }
        scorePlayer = Math.max(scorePlayer, Math.min(scoreEnemy * 0.5f, maxPlayserShipScore * 6.0f));
        if (scorePlayer < 1.0f) {
            scorePlayer = 1.0f;
        }
        if (scoreEnemy < 1.0f) {
            scoreEnemy = 1.0f;
        }
        this.difficulty = scoreEnemy / scorePlayer;
        if (this.difficulty < 0.0f) {
            this.difficulty = 0.0f;
        }
        if (this.difficulty > MAX_XP_MULT) {
            this.difficulty = MAX_XP_MULT;
        }
        return this.difficulty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoardingAttackType {
        SHIP_TO_SHIP,
        LAUNCH_FROM_DISTANCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoardingOutcome {
        SUCCESS,
        SELF_DESTRUCT,
        SUCCESS_TOO_DAMAGED,
        SHIP_ESCAPED,
        SHIP_ESCAPED_CLEAN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoardingResult {
        private BoardingOutcome outcome;
        private CrewCompositionAPI attackerLosses = Global.getFactory().createCrewComposition();
        private CrewCompositionAPI defenderLosses = Global.getFactory().createCrewComposition();
        private FleetMemberAPI member;
        private List<FleetMemberAPI> lostInSelfDestruct = new ArrayList<FleetMemberAPI>();

        public BoardingOutcome getOutcome() {
            return this.outcome;
        }

        public List<FleetMemberAPI> getLostInSelfDestruct() {
            return this.lostInSelfDestruct;
        }

        public void setOutcome(BoardingOutcome outcome) {
            this.outcome = outcome;
        }

        public CrewCompositionAPI getAttackerLosses() {
            return this.attackerLosses;
        }

        public void setAttackerLosses(CrewCompositionAPI attackerLosses) {
            this.attackerLosses = attackerLosses;
        }

        public CrewCompositionAPI getDefenderLosses() {
            return this.defenderLosses;
        }

        public void setDefenderLosses(CrewCompositionAPI defenderLosses) {
            this.defenderLosses = defenderLosses;
        }

        public FleetMemberAPI getMember() {
            return this.member;
        }

        public void setMember(FleetMemberAPI member) {
            this.member = member;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EngageBoardableOutcome {
        ESCAPED,
        DISABLED,
        DESTROYED;

    }

    protected static class LootableCargoStack {
        public CargoAPI source;
        public CargoStackAPI stack;

        public LootableCargoStack(CargoAPI source, CargoStackAPI stack) {
            this.source = source;
            this.stack = stack;
        }
    }

    protected static class LossFraction {
        public float maxCargo;
        public float maxFuel;
        public float lostCargo;
        public float lostFuel;

        protected LossFraction() {
        }
    }
}

