/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.FleetMemberPickerListener;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.RuleAPI;
import com.fs.starfarer.api.campaign.rules.RulesAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.BattleAutoresolverPluginImpl;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.ExampleCustomUIPanel;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.combat.CRPluginImpl;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetInteractionDialogPluginImpl
implements InteractionDialogPlugin,
RuleBasedDialog {
    public static float EMERGENCY_REPAIRS_MAX_DP = Global.getSettings().getFloat("emergencyRepairsMaxDPValue");
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected CampaignFleetAPI otherFleet;
    protected FleetGoal playerGoal = FleetGoal.ATTACK;
    protected FleetGoal otherGoal = FleetGoal.ATTACK;
    protected VisualType currVisualType = VisualType.FLEET_INFO;
    protected FleetEncounterContext context = new FleetEncounterContext();
    protected static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    protected static final Color FRIEND_COLOR = Global.getSettings().getColor("textFriendColor");
    protected static final Color ENEMY_COLOR = Misc.getNegativeHighlightColor();
    protected RuleBasedInteractionDialogPluginImpl conversationDelegate;
    protected boolean ongoingBattle = false;
    protected boolean firstEngagement = true;
    protected boolean joinedBattle = false;
    protected boolean forceEngage = false;
    protected boolean shownTooLargeToRetreatMessage = false;
    public static boolean inConversation = false;
    public static boolean directToComms = false;
    protected FIDConfig config;
    protected List<FleetMemberAPI> membersInOrderPreEncounter = new ArrayList<FleetMemberAPI>();
    private boolean skipAttitudeOnInit = false;
    protected List<CampaignFleetAPI> pulledIn = new ArrayList<CampaignFleetAPI>();
    protected EngagementResultAPI lastResult = null;
    protected boolean cleanedUp = false;
    protected boolean okToLeave = false;
    protected boolean didRepairs = false;
    protected boolean didBoardingCheck = false;
    protected boolean didRecoveryCheck = false;
    protected boolean pickedMemberToBoard = false;
    protected FleetMemberAPI toBoard = null;
    protected String repairedShipList = null;
    protected int boardingPhase = 0;
    protected float boardingPercentSuccess = 0.0f;
    protected String crashMothballList = null;
    protected CrewCompositionAPI maxBoardingParty = null;
    protected CrewCompositionAPI boardingParty = null;
    protected FleetEncounterContext.BoardingResult boardingResult = null;
    protected FleetMemberAPI selectedFlagship = null;
    protected FleetMemberAPI origFlagship = null;
    protected Map<FleetMemberAPI, PersonAPI> origCaptains = new HashMap<FleetMemberAPI, PersonAPI>();
    protected CampaignFleetAIAPI.InitialBoardingResponse aiBoardingResponse = null;
    protected boolean shownKnownStatus = false;
    protected boolean recoveredCrew = false;
    protected boolean lootedCredits = false;
    protected boolean firedVictoryTriggers = false;
    protected String creditsLooted = null;
    protected OptionId lastOptionMousedOver = null;
    protected boolean allyEngagementChoiceNoBattle = false;
    protected boolean harryEndedBattle = false;
    private List<FleetMemberAPI> recoverableShips;
    private List<FleetMemberAPI> storyRecoverableShips;
    private List<FleetMemberAPI> recoveredShips = new ArrayList<FleetMemberAPI>();

    public FleetInteractionDialogPluginImpl() {
        this(null);
    }

    public FleetInteractionDialogPluginImpl(FIDConfig params) {
        this.config = params;
        if (this.origFlagship == null) {
            this.origFlagship = Global.getSector().getPlayerFleet().getFlagship();
        }
        if (this.origCaptains.isEmpty()) {
            for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
                this.origCaptains.put(member, member.getCaptain());
            }
            this.membersInOrderPreEncounter = new ArrayList<FleetMemberAPI>(Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy());
        }
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.conversationDelegate == null ? null : this.conversationDelegate.getMemoryMap();
    }

    @Override
    public void reinit(boolean withContinueOnRuleFound) {
        RulesAPI rules = Global.getSector().getRules();
        RuleAPI rule = rules.getBestMatching(null, "BeginFleetEncounter", this.dialog, this.conversationDelegate.getMemoryMap());
        if (rule == null || !withContinueOnRuleFound) {
            this.reinitPostContinue();
        } else {
            this.options.clearOptions();
            this.options.addOption("Continue", (Object)OptionId.REINIT_CONTINUE, null);
            if (Global.getSettings().isDevMode()) {
                DevMenuOptions.addOptions(this.dialog);
            }
        }
    }

    public void reinitPostContinue() {
        inConversation = false;
        directToComms = false;
        boolean cont = this.conversationDelegate.getMemoryMap().get("local").getBoolean("$fidpi_addContinue");
        this.conversationDelegate.getMemoryMap().get("local").unset("$fidpi_addContinue");
        if (cont) {
            this.conversationDelegate.fireBest("BeginFleetEncounter2");
        } else {
            this.conversationDelegate.fireBest("BeginFleetEncounter");
        }
        if (this.conversationDelegate.getMemoryMap().get("local").getBoolean("$fidpi_addContinue")) {
            this.options.clearOptions();
            this.options.addOption("Continue", (Object)OptionId.BEGIN_FLEET_ENCOUNTER_2);
        } else if (directToComms) {
            this.optionSelected(null, (Object)OptionId.OPEN_COMM);
        } else {
            this.optionSelected(null, (Object)OptionId.INIT);
        }
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        if (this.config == null) {
            MemoryAPI memory = dialog.getInteractionTarget().getMemoryWithoutUpdate();
            this.config = memory.contains("$fidConifgGen") ? ((FIDConfigGen)memory.get("$fidConifgGen")).createConfig() : new FIDConfig();
        }
        if (Global.getSettings().isDevMode()) {
            dialog.setOptionOnEscape("dev mode exit", (Object)OptionId.DEV_MODE_ESCAPE);
            dialog.setOptionOnConfirm("dev mode exit", (Object)OptionId.DEV_MODE_ESCAPE);
        }
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.otherFleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        if (this.context.getBattle() == null) {
            if (this.otherFleet.getBattle() == null || this.otherFleet.getBattle().isDone()) {
                this.ongoingBattle = false;
                BattleAPI battle = Global.getFactory().createBattle(this.playerFleet, this.otherFleet);
                this.context.setBattle(battle);
                this.pullInNearbyFleets();
            } else {
                this.ongoingBattle = true;
                this.context.setBattle(this.otherFleet.getBattle());
                if (this.context.getBattle().canJoin(this.playerFleet)) {
                    this.pullInNearbyFleets();
                }
            }
        }
        for (CampaignFleetAPI fleet : this.context.getBattle().getBothSides()) {
            fleet.inflateIfNeeded();
        }
        this.context.getBattle().genCombined();
        this.visual.setVisualFade(0.25f, 0.25f);
        if (!this.config.straightToEngage) {
            if (this.ongoingBattle && !this.joinedBattle) {
                BattleAPI b = this.context.getBattle();
                String titleOne = b.getPrimary(b.getSideOne()).getNameWithFactionKeepCase();
                if (b.getSideOne().size() > 1) {
                    titleOne = String.valueOf(titleOne) + ", with allies";
                }
                String titleTwo = b.getPrimary(b.getSideTwo()).getNameWithFactionKeepCase();
                if (b.getSideTwo().size() > 1) {
                    titleTwo = String.valueOf(titleTwo) + ", with allies";
                }
                this.visual.showPreBattleJoinInfo(null, this.playerFleet, Misc.ucFirst(titleOne), Misc.ucFirst(titleTwo), this.context);
            } else {
                this.showFleetInfo();
            }
        }
        inConversation = false;
        directToComms = false;
        this.conversationDelegate = new RuleBasedInteractionDialogPluginImpl();
        this.conversationDelegate.setEmbeddedMode(true);
        this.conversationDelegate.init(dialog);
        if (!this.config.justShowFleets) {
            this.conversationDelegate.getMemoryMap().get("local").set("$ongoingBattle", this.ongoingBattle, 0.0f);
            boolean cont = this.conversationDelegate.getMemoryMap().get("local").getBoolean("$fidpi_addContinue");
            this.conversationDelegate.getMemoryMap().get("local").unset("$fidpi_addContinue");
            if (!this.ongoingBattle && !this.config.straightToEngage) {
                if (cont) {
                    this.conversationDelegate.fireBest("BeginFleetEncounter2");
                } else {
                    this.conversationDelegate.fireBest("BeginFleetEncounter");
                }
            }
            if (this.conversationDelegate.getMemoryMap().get("local").getBoolean("$fidpi_addContinue")) {
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.BEGIN_FLEET_ENCOUNTER_2);
            } else if (directToComms) {
                this.optionSelected(null, (Object)OptionId.OPEN_COMM);
            } else {
                this.optionSelected(null, (Object)OptionId.INIT);
            }
            if (this.config.straightToEngage) {
                if (this.ongoingBattle) {
                    this.optionSelected(null, (Object)OptionId.JOIN_ONGOING_BATTLE);
                } else {
                    this.optionSelected(null, (Object)OptionId.ENGAGE);
                }
            }
        }
    }

    public void printOngoingBattleInfo() {
        this.optionSelected(null, (Object)OptionId.PRINT_ONGOING_BATTLE_INFO);
    }

    protected void pullInNearbyFleets() {
        boolean hostile;
        BattleAPI b = this.context.getBattle();
        if (!this.ongoingBattle) {
            b.join(Global.getSector().getPlayerFleet());
        }
        BattleAPI.BattleSide playerSide = b.pickSide(Global.getSector().getPlayerFleet());
        boolean bl = hostile = this.otherFleet.getAI() != null && this.otherFleet.getAI().isHostileTo(this.playerFleet);
        if (this.ongoingBattle) {
            hostile = true;
        }
        CampaignFleetAPI actualPlayer = Global.getSector().getPlayerFleet();
        CampaignFleetAPI actualOther = (CampaignFleetAPI)this.dialog.getInteractionTarget();
        this.pulledIn.clear();
        if (this.config.pullInStations && !b.isStationInvolved()) {
            SectorEntityToken closestEntity = null;
            CampaignFleetAPI closest = null;
            Pair<SectorEntityToken, CampaignFleetAPI> p = Misc.getNearestStationInSupportRange(actualOther);
            if (p != null) {
                closestEntity = (SectorEntityToken)p.one;
                closest = (CampaignFleetAPI)p.two;
            }
            if (closest != null) {
                boolean canJoin;
                BattleAPI.BattleSide joiningSide = b.pickSide(closest, true);
                boolean bl2 = canJoin = joiningSide != BattleAPI.BattleSide.NO_JOIN;
                if (!this.config.pullInAllies && joiningSide == playerSide) {
                    canJoin = false;
                }
                if (!this.config.pullInEnemies && joiningSide != playerSide) {
                    canJoin = false;
                }
                if (b == closest.getBattle()) {
                    canJoin = false;
                }
                if (closest.getBattle() != null) {
                    canJoin = false;
                }
                if (canJoin) {
                    if (closestEntity != null) {
                        closestEntity.getMarket().reapplyIndustries();
                    }
                    b.join(closest);
                    this.pulledIn.add(closest);
                    if (!this.config.straightToEngage && this.config.showPullInText) {
                        if (b.getSide(playerSide) == b.getSideFor(closest)) {
                            this.textPanel.addParagraph(String.valueOf(Misc.ucFirst(closest.getNameWithFactionKeepCase())) + ": supporting your forces.");
                        } else if (hostile) {
                            this.textPanel.addParagraph(String.valueOf(Misc.ucFirst(closest.getNameWithFactionKeepCase())) + ": supporting the enemy.");
                        } else {
                            this.textPanel.addParagraph(String.valueOf(Misc.ucFirst(closest.getNameWithFactionKeepCase())) + ": supporting the opposing side.");
                        }
                        this.textPanel.highlightFirstInLastPara(String.valueOf(closest.getNameWithFactionKeepCase()) + ":", closest.getFaction().getBaseUIColor());
                    }
                }
            }
        }
        for (CampaignFleetAPI fleet : actualPlayer.getContainingLocation().getFleets()) {
            boolean ignore;
            if (b == fleet.getBattle() || fleet.getBattle() != null || fleet.isStationMode()) continue;
            float dist = Misc.getDistance(actualOther.getLocation(), fleet.getLocation());
            dist -= actualOther.getRadius();
            dist -= fleet.getRadius();
            if (fleet.getFleetData().getNumMembers() <= 0) continue;
            float baseSensorRange = this.playerFleet.getBaseSensorRangeToDetect(fleet.getSensorProfile());
            boolean visible = fleet.isVisibleToPlayerFleet();
            SectorEntityToken.VisibilityLevel level = fleet.getVisibilityLevelToPlayerFleet();
            float joinRange = Misc.getBattleJoinRange();
            if (fleet.getFaction().isPlayerFaction() && !fleet.isStationMode()) {
                joinRange += Global.getSettings().getFloat("battleJoinRangePlayerFactionBonus");
            }
            if (!(dist < joinRange) || !(dist < baseSensorRange) && (!visible || level == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) || (fleet.getAI() == null || !fleet.getAI().wantsToJoin(b, true)) && !fleet.isStationMode()) continue;
            boolean bl3 = ignore = fleet.getMemoryWithoutUpdate() != null && fleet.getMemoryWithoutUpdate().getBoolean("$cfai_ignoreOtherFleets");
            if (ignore) continue;
            BattleAPI.BattleSide joiningSide = b.pickSide(fleet, true);
            if (!this.config.pullInAllies && joiningSide == playerSide || !this.config.pullInEnemies && joiningSide != playerSide) continue;
            b.join(fleet);
            this.pulledIn.add(fleet);
            if (this.config.straightToEngage || !this.config.showPullInText) continue;
            if (b.getSide(playerSide) == b.getSideFor(fleet)) {
                this.textPanel.addParagraph(String.valueOf(Misc.ucFirst(fleet.getNameWithFactionKeepCase())) + ": supporting your forces.");
            } else if (hostile) {
                this.textPanel.addParagraph(String.valueOf(Misc.ucFirst(fleet.getNameWithFactionKeepCase())) + ": joining the enemy.");
            } else {
                this.textPanel.addParagraph(String.valueOf(Misc.ucFirst(fleet.getNameWithFactionKeepCase())) + ": supporting the opposing side.");
            }
            this.textPanel.highlightFirstInLastPara(String.valueOf(fleet.getNameWithFactionKeepCase()) + ":", fleet.getFaction().getBaseUIColor());
        }
        if (this.otherFleet != null) {
            this.otherFleet.inflateIfNeeded();
        }
        for (CampaignFleetAPI curr : this.pulledIn) {
            curr.inflateIfNeeded();
        }
        if (!this.ongoingBattle) {
            b.genCombined();
            b.takeSnapshots();
            this.playerFleet = b.getPlayerCombined();
            this.otherFleet = b.getNonPlayerCombined();
            if (!this.config.straightToEngage) {
                this.showFleetInfo();
            }
        }
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
        if (this.playerGoal == null && this.otherGoal == null) {
            EngagementResultForFleetAPI other;
            EngagementResultForFleetAPI player = result.didPlayerWin() ? result.getWinnerResult() : result.getLoserResult();
            EngagementResultForFleetAPI engagementResultForFleetAPI = other = result.didPlayerWin() ? result.getLoserResult() : result.getWinnerResult();
            if (player.getDeployed().isEmpty()) {
                this.playerGoal = FleetGoal.ATTACK;
                this.otherGoal = FleetGoal.ATTACK;
            } else {
                this.playerGoal = FleetGoal.ATTACK;
                this.otherGoal = FleetGoal.ATTACK;
            }
            player.setGoal(this.playerGoal);
            other.setGoal(this.otherGoal);
        }
        if (!this.ongoingBattle && !this.otherFleet.getMemoryWithoutUpdate().contains("$ignorePlayerCommRequests")) {
            this.otherFleet.getMemoryWithoutUpdate().set("$ignorePlayerCommRequests", true, 0.0f);
        }
        result.setBattle(this.context.getBattle());
        this.context.processEngagementResults(result);
        this.lastResult = result;
        boolean startedWithAllies = false;
        if (this.context.getBattle() != null) {
            boolean bl = startedWithAllies = this.context.getBattle().getPlayerSideSnapshot().size() > 1;
        }
        if (!Global.getSector().getPlayerFleet().isValidPlayerFleet() && startedWithAllies && this.context.getBattle().getPlayerSide().size() > 1) {
            this.showFleetInfo();
            this.addText(this.getString("battleFleetLost"));
            this.addText(this.getString("finalOutcomeNoShipsLeft"));
            this.options.clearOptions();
            this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
            this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
            return;
        }
        this.restoreOrigCaptains();
        if (this.origFlagship != null) {
            PersonAPI captain;
            if (this.selectedFlagship != null && (captain = this.origFlagship.getCaptain()) != null && !captain.isPlayer()) {
                this.selectedFlagship.setCaptain(captain);
            }
            Global.getSector().getPlayerFleet().getFleetData().setFlagship(this.origFlagship);
        }
        if (this.context.getLastEngagementOutcome() == null) {
            return;
        }
        boolean totalDefeat = !this.playerFleet.isValidPlayerFleet();
        boolean mutualDestruction = this.context.getLastEngagementOutcome() == FleetEncounterContextPlugin.EngagementOutcome.MUTUAL_DESTRUCTION;
        FleetEncounterContextPlugin.DataForEncounterSide playerSide = this.context.getDataFor(this.playerFleet);
        CrewCompositionAPI crewLosses = playerSide.getCrewLossesDuringLastEngagement();
        if (crewLosses.getCrewInt() + (int)crewLosses.getMarines() > 0 && !totalDefeat && !mutualDestruction) {
            String marinesLostStr;
            this.addText(this.getString("casualtyReport"));
            FleetEncounterContextPlugin.DataForEncounterSide data = this.context.getDataFor(this.playerFleet);
            int crewLost = data.getCrewLossesDuringLastEngagement().getCrewInt();
            int marinesLost = (int)data.getCrewLossesDuringLastEngagement().getMarines();
            String crewLostStr = this.getApproximate(crewLost);
            if (crewLostStr.equals("no")) {
                crewLostStr = "";
            }
            if (crewLostStr.indexOf(" ") >= 0) {
                crewLostStr = crewLostStr.substring(crewLostStr.indexOf(" ") + 1);
            }
            if ((marinesLostStr = this.getApproximate(marinesLost)).equals("no")) {
                marinesLostStr = "";
            }
            if (marinesLostStr.indexOf(" ") >= 0) {
                marinesLostStr = marinesLostStr.substring(marinesLostStr.indexOf(" ") + 1);
            }
            this.textPanel.highlightInLastPara(HIGHLIGHT_COLOR, crewLostStr, marinesLostStr);
        }
        boolean showFleetInfo = false;
        switch (this.context.getLastEngagementOutcome()) {
            case PURSUIT_PLAYER_OUT_FIRST_WIN: {
                this.addText(this.getString("playerOutFirstPursuitWin"));
                showFleetInfo = true;
                break;
            }
            case PURSUIT_PLAYER_OUT_FIRST_LOSS: {
                this.addText(this.getString("playerOutFirstPursuitLoss"));
                showFleetInfo = true;
                break;
            }
            case BATTLE_PLAYER_OUT_FIRST_WIN: {
                this.addText(this.getString("playerOutFirstEngageWin"));
                showFleetInfo = true;
                break;
            }
            case BATTLE_PLAYER_OUT_FIRST_LOSS: {
                this.addText(this.getString("playerOutFirstEngageLoss"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_PLAYER_OUT_FIRST_WIN: {
                this.addText(this.getString("playerOutFirstEscapeWin"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_PLAYER_OUT_FIRST_LOSS: {
                this.addText(this.getString("playerOutFirstEscapeLoss"));
                showFleetInfo = true;
                break;
            }
            case BATTLE_ENEMY_WIN: {
                this.addText(this.getString("battleDefeat"));
                showFleetInfo = true;
                break;
            }
            case BATTLE_ENEMY_WIN_TOTAL: {
                this.addText(this.getString("battleTotalDefeat"));
                showFleetInfo = true;
                break;
            }
            case BATTLE_PLAYER_WIN: {
                if (this.config.showVictoryText) {
                    this.addText(this.getString("battleVictory"));
                }
                showFleetInfo = true;
                break;
            }
            case BATTLE_PLAYER_WIN_TOTAL: {
                if (this.config.showVictoryText) {
                    this.addText(this.getString("battleTotalVictory"));
                }
                showFleetInfo = true;
                break;
            }
            case ESCAPE_ENEMY_LOSS_TOTAL: {
                if (this.config.showVictoryText) {
                    this.addText(this.getString("pursuitTotalVictory"));
                }
                showFleetInfo = true;
                break;
            }
            case ESCAPE_ENEMY_SUCCESS: {
                if (result.getLoserResult().getDisabled().isEmpty() && result.getLoserResult().getDestroyed().isEmpty()) {
                    this.addText(this.getString("pursuitVictoryNoLosses"));
                } else {
                    this.addText(this.getString("pursuitVictoryLosses"));
                }
                showFleetInfo = true;
                break;
            }
            case ESCAPE_ENEMY_WIN: {
                this.addText(this.getString("pursuitDefeat"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_ENEMY_WIN_TOTAL: {
                this.addText(this.getString("pursuitTotalDefeat"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_PLAYER_LOSS_TOTAL: {
                this.addText(this.getString("escapeTotalDefeat"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_PLAYER_SUCCESS: {
                this.addText(this.getString("escapeDefeat"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_PLAYER_WIN: {
                this.addText(this.getString("escapeVictory"));
                showFleetInfo = true;
                break;
            }
            case ESCAPE_PLAYER_WIN_TOTAL: {
                this.addText(this.getString("escapeTotalVictory"));
                showFleetInfo = true;
                break;
            }
            case MUTUAL_DESTRUCTION: {
                this.addText(this.getString("engagementMutualDestruction"));
                if (!mutualDestruction) break;
                FleetEncounterContextPlugin.DataForEncounterSide otherData = this.context.getDataFor(this.otherFleet);
                for (FleetMemberAPI member : result.getLoserResult().getDisabled()) {
                    otherData.addEnemy(member, FleetEncounterContextPlugin.Status.DISABLED);
                }
                break;
            }
        }
        FleetEncounterContextPlugin.EngagementOutcome last = this.context.getLastEngagementOutcome();
        if (last == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_LOSS || last == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_WIN) {
            float recoveryFraction = this.context.performPostEngagementRecoveryBoth(result);
            if (recoveryFraction > 0.0f) {
                this.addText(this.getString("bothRecovery"));
            }
        } else {
            float recoveryFraction = this.context.performPostVictoryRecovery(result);
            if (recoveryFraction > 0.0f) {
                if (this.context.didPlayerWinLastEngagement()) {
                    this.addText(this.getString("playerRecovery"));
                } else {
                    this.addText(this.getString("enemyRecovery"));
                }
            }
        }
        if (showFleetInfo) {
            this.showFleetInfo();
        }
        this.addPostBattleAttitudeText();
        if (this.config.straightToEngage) {
            this.goToEncounterEndPath();
        } else if (this.ongoingBattle) {
            this.options.clearOptions();
            this.updateEngagementChoice(true);
        } else {
            this.updateMainState(true);
        }
        if (this.isFightingOver() && this.context.isEngagedInHostilities()) {
            this.context.getDataFor(this.playerFleet).setDisengaged(!this.context.didPlayerWinMostRecentBattleOfEncounter());
            this.context.getDataFor(this.otherFleet).setDisengaged(this.context.didPlayerWinMostRecentBattleOfEncounter());
        }
    }

    protected void addPostBattleAttitudeText() {
        if (!this.config.showFleetAttitude) {
            return;
        }
        if (!this.ongoingBattle && !this.context.wasLastEngagementEscape()) {
            boolean otherWantsToRun;
            boolean bl = otherWantsToRun = this.otherFleetWantsToDisengage() && this.otherCanDisengage();
            if (!otherWantsToRun) {
                if (this.context.didPlayerWinLastEngagement()) {
                    this.addText(this.getString("cleanDisengageOpportunity"), this.getString("highlightCleanDisengage"), Misc.getPositiveHighlightColor());
                } else if (this.didEnoughToDisengage(this.playerFleet)) {
                    this.addText(this.getString("playerDisruptedEnemy"), this.getString("highlghtDisruptedEnemy"), Misc.getPositiveHighlightColor());
                }
            }
        }
        if (!this.isFightingOver()) {
            String side = "";
            if (this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide().size() > 1) {
                side = "Side";
            }
            if (this.otherFleetWantsToFight()) {
                this.addText(this.getString("postBattleAggressive" + side));
            } else if (this.otherFleetWantsToDisengage()) {
                if (!this.otherCanDisengage()) {
                    this.addText(this.getString("postBattleAggressive" + side));
                } else {
                    this.addText(this.getString("postBattleDisengage" + side));
                }
            } else if (this.otherFleetHoldingVsStrongerEnemy()) {
                this.addText(this.getString("postBattleHoldVsStrongerEnemy" + side));
            } else {
                this.addText(this.getString("postBattleNeutral" + side));
            }
        }
    }

    public List<FleetMemberAPI> getPursuitCapablePlayerShips() {
        ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            if (member.isAlly() || member.isCivilian()) continue;
            members.add(member);
        }
        return members;
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        if (inConversation && optionData instanceof String) {
            this.conversationDelegate.optionSelected(text, optionData);
            return;
        }
        if (optionData == "DumpMemory.option_dump_memory") {
            new DumpMemory().execute(null, this.dialog, null, this.getMemoryMap());
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        if (optionData instanceof String) {
            this.optionSelected(null, (Object)OptionId.CUT_COMM);
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case PRINT_ONGOING_BATTLE_INFO: {
                if (!this.ongoingBattle) break;
                if (!this.config.straightToEngage) {
                    this.addText(this.getString("ongoingBattleEncounter"));
                }
                BattleAPI b = this.context.getBattle();
                b.genCombined();
                BattleAPI.BattleSide side = b.pickSide(this.playerFleet);
                BattleAPI.BattleSide sideAssumingTransponderOn = b.pickSide(this.playerFleet, false);
                if (this.config.straightToEngage) break;
                if (side == sideAssumingTransponderOn && side == BattleAPI.BattleSide.NO_JOIN) {
                    this.addText(this.getString("ongoingBattleNoJoin"));
                    break;
                }
                if (side != sideAssumingTransponderOn && side == BattleAPI.BattleSide.NO_JOIN) {
                    this.addText(this.getString("ongoingBattleNoJoinTransponder"));
                    break;
                }
                this.addText(this.getString("ongoingBattleShareIFF"));
                break;
            }
            case INIT: {
                if (this.ongoingBattle) {
                    if (!this.config.straightToEngage) {
                        this.addText(this.getString("ongoingBattleEncounter"));
                    }
                    BattleAPI b = this.context.getBattle();
                    b.genCombined();
                    BattleAPI.BattleSide side = b.pickSide(this.playerFleet);
                    BattleAPI.BattleSide sideAssumingTransponderOn = b.pickSide(this.playerFleet, false);
                    if (!this.config.straightToEngage) {
                        if (side == sideAssumingTransponderOn && side == BattleAPI.BattleSide.NO_JOIN) {
                            this.addText(this.getString("ongoingBattleNoJoin"));
                        } else if (side != sideAssumingTransponderOn && side == BattleAPI.BattleSide.NO_JOIN) {
                            this.addText(this.getString("ongoingBattleNoJoinTransponder"));
                        } else {
                            this.addText(this.getString("ongoingBattleShareIFF"));
                        }
                    }
                } else {
                    String side;
                    boolean hostile = this.otherFleet.getAI() != null && this.otherFleet.getAI().isHostileTo(this.playerFleet);
                    hostile |= this.context.isEngagedInHostilities();
                    if (!this.skipAttitudeOnInit) {
                        side = "";
                        if (this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide().size() > 1) {
                            side = "Side";
                        }
                        if (this.config.showFleetAttitude) {
                            boolean hasStation = false;
                            boolean allStation = true;
                            for (CampaignFleetAPI curr : this.context.getBattle().getSideFor(this.otherFleet)) {
                                allStation &= curr.isStationMode();
                                hasStation |= curr.isStationMode();
                            }
                            if (this.otherFleetWantsToFight() && !FleetInteractionDialogPluginImpl.canDisengage() && hasStation && !allStation) {
                                this.addText(this.getString("initialWithStationVsLargeFleet"));
                            } else if (this.otherFleetWantsToFight()) {
                                this.addText(this.getString("initialAggressive" + side));
                            } else if (this.otherFleetWantsToDisengage()) {
                                if (!this.otherCanDisengage()) {
                                    if (hostile) {
                                        this.addText(this.getString("initialNeutral" + side));
                                    } else {
                                        this.addText(this.getString("initialNeutral" + side));
                                    }
                                } else if (hostile) {
                                    this.addText(this.getString("initialDisengage" + side));
                                } else {
                                    this.addText(this.getString("initialCareful" + side));
                                }
                            } else if (this.otherFleetHoldingVsStrongerEnemy()) {
                                this.addText(this.getString("initialHoldVsStrongerEnemy" + side));
                            } else {
                                this.addText(this.getString("initialNeutral" + side));
                            }
                        }
                    }
                    if (!this.shownKnownStatus && this.config.showTransponderStatus && !this.otherFleet.getFaction().isNeutralFaction()) {
                        this.shownKnownStatus = true;
                        side = "";
                        if (this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide().size() > 1) {
                            side = "Side";
                        }
                        if (!this.otherFleet.getMemoryWithoutUpdate().getBoolean("$skipTInfo")) {
                            boolean knows;
                            boolean bl = knows = this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide() != null && this.context.getBattle().knowsWhoPlayerIs(this.context.getBattle().getNonPlayerSide());
                            if (!knows) {
                                this.addText(this.getString("initialDoesntKnow" + side));
                            } else {
                                CampaignFleetAPI actualPlayer = Global.getSector().getPlayerFleet();
                                if (actualPlayer.isTransponderOn()) {
                                    this.addText(this.getString("initialKnows" + side));
                                } else if (actualPlayer.hasShipsWithUniqueSig()) {
                                    this.addText(this.getString("initialKnowsUnique" + side));
                                } else {
                                    this.addText(this.getString("initialKnowsTOff" + side));
                                }
                            }
                        }
                    }
                }
                this.updateMainState(true);
                break;
            }
            case REINIT_CONTINUE: {
                this.reinitPostContinue();
                break;
            }
            case INITIATE_BATTLE: {
                this.updateMainState(true);
                break;
            }
            case JOIN_ONGOING_BATTLE: {
                if (this.context.getBattle().canJoin(this.playerFleet)) {
                    BattleAPI b = this.context.getBattle();
                    for (CampaignFleetAPI fleet : b.getBothSides()) {
                        fleet.inflateIfNeeded();
                    }
                    b.genCombined();
                    BattleAPI.BattleSide playerSide = b.pickSide(this.playerFleet);
                    CampaignFleetAPI prePlayerAllies = b.getCombined(playerSide);
                    CampaignFleetAPI enemies = b.getOtherSideCombined(playerSide);
                    boolean alliedWantsToFightBefore = this.fleetWantsToFight(prePlayerAllies, enemies);
                    boolean alliedWantsToDisengageBefore = this.fleetWantsToDisengage(prePlayerAllies, enemies) && this.fleetCanDisengage(prePlayerAllies);
                    boolean alliedHoldingBefore = this.fleetHoldingVsStrongerEnemy(prePlayerAllies, enemies);
                    boolean otherWantsToFightBefore = this.fleetWantsToFight(enemies, prePlayerAllies);
                    boolean otherWantsToDisengageBefore = this.fleetWantsToDisengage(enemies, prePlayerAllies) && this.fleetCanDisengage(enemies);
                    boolean otherHoldingBefore = this.fleetHoldingVsStrongerEnemy(enemies, prePlayerAllies);
                    b.join(this.playerFleet);
                    b.genCombined();
                    this.showFleetInfo();
                    this.joinedBattle = true;
                    this.playerFleet = b.getPlayerCombined();
                    this.otherFleet = b.getNonPlayerCombined();
                    boolean alliedWantsToFight = this.alliedFleetWantsToFight();
                    boolean alliedWantsToDisengage = this.alliedFleetWantsToDisengage() && this.alliedCanDisengage();
                    boolean alliedHolding = this.alliedFleetHoldingVsStrongerEnemy();
                    boolean otherWantsToFight = this.otherFleetWantsToFight();
                    boolean otherWantsToDisengage = this.otherFleetWantsToDisengage() && this.otherCanDisengage();
                    boolean otherHolding = this.otherFleetHoldingVsStrongerEnemy();
                    b.takeSnapshots();
                    this.options.clearOptions();
                    this.updateEngagementChoice(true);
                    if (this.allyEngagementChoiceNoBattle) break;
                    this.updatePreCombat();
                    break;
                }
                this.addText("Failed to join battle; shouldn't happen.");
                this.updateMainState(true);
                break;
            }
            case CONTINUE_ONGOING_BATTLE: {
                this.updatePreCombat();
                break;
            }
            case FORCE_ENGAGE: {
                if (this.config.showEngageText) {
                    this.addText(this.getString("engageForce"));
                }
            }
            case ENGAGE: {
                boolean forceEngage;
                boolean bl = forceEngage = option == OptionId.FORCE_ENGAGE;
                if (this.otherFleetWantsToDisengage() && this.otherCanDisengage() && !forceEngage) {
                    this.playerGoal = FleetGoal.ATTACK;
                    this.otherGoal = FleetGoal.ESCAPE;
                    if (this.config.showEngageText) {
                        this.addText(this.getString("engagePursuit"));
                    }
                } else {
                    this.playerGoal = FleetGoal.ATTACK;
                    this.otherGoal = FleetGoal.ATTACK;
                    if (this.config.showEngageText) {
                        this.addText(this.getString("engageMutual"));
                    }
                }
                this.updatePreCombat();
                break;
            }
            case CONTINUE_INTO_BATTLE: {
                CampaignFleetAIAPI ai;
                BattleCreationContext bcc;
                if (this.config.alwaysAttackVsAttack) {
                    this.playerGoal = FleetGoal.ATTACK;
                    this.otherGoal = FleetGoal.ATTACK;
                }
                if (this.context.getBattle() != null) {
                    BattleAPI b = this.context.getBattle();
                    if (b.isStationInvolved()) {
                        boolean regen = false;
                        if (b.isStationInvolvedOnPlayerSide()) {
                            if (this.otherGoal == FleetGoal.ESCAPE) {
                                regen = true;
                            }
                        } else if (this.playerGoal == FleetGoal.ESCAPE) {
                            regen = true;
                        }
                        if (regen) {
                            b.genCombined(false);
                        }
                    }
                    CampaignFleetAPI combinedPlayer = b.getPlayerCombined();
                    CampaignFleetAPI combinedEnemy = b.getNonPlayerCombined();
                    bcc = new BattleCreationContext(combinedPlayer, this.playerGoal, combinedEnemy, this.otherGoal);
                    bcc.setPlayerCommandPoints((int)Global.getSector().getPlayerFleet().getCommanderStats().getCommandPoints().getModifiedValue());
                    if (b.isStationInvolved() && this.playerGoal != FleetGoal.ESCAPE && this.otherGoal != FleetGoal.ESCAPE) {
                        bcc.objectivesAllowed = false;
                    }
                    if (this.config.delegate != null) {
                        this.config.delegate.battleContextCreated(this.dialog, bcc);
                    }
                    if (this.firstEngagement) {
                        if (this.playerGoal != FleetGoal.ESCAPE && this.ongoingBattle) {
                            bcc.setInitialStepSize(1.5f);
                            bcc.setInitialNumSteps(10.0f + (float)Math.random() * 30.0f);
                        }
                        this.firstEngagement = false;
                    } else if (this.playerGoal != FleetGoal.ESCAPE && this.ongoingBattle) {
                        bcc.setInitialStepSize(1.5f);
                        bcc.setInitialNumSteps(5.0f + (float)Math.random() * 5.0f);
                    }
                } else {
                    bcc = new BattleCreationContext(this.playerFleet, this.playerGoal, this.otherFleet, this.otherGoal);
                    bcc.setPlayerCommandPoints((int)Global.getSector().getPlayerFleet().getCommanderStats().getCommandPoints().getModifiedValue());
                    if (this.config.delegate != null) {
                        this.config.delegate.battleContextCreated(this.dialog, bcc);
                    }
                }
                if (this.playerGoal == FleetGoal.ESCAPE) {
                    ai = this.playerFleet.getAI();
                    if (ai != null) {
                        ai.performCrashMothballingPriorToEscape(this.context, this.otherFleet);
                    }
                } else if (this.otherGoal == FleetGoal.ESCAPE && (ai = this.otherFleet.getAI()) != null) {
                    ai.performCrashMothballingPriorToEscape(this.context, this.playerFleet);
                }
                this.visual.fadeVisualOut();
                this.dialog.startBattle(bcc);
                break;
            }
            case DISENGAGE: 
            case CLEAN_DISENGAGE: {
                CampaignFleetAIAPI.PursuitOption po = this.pickPursuitOption(this.otherFleet, this.playerFleet, this.context);
                if (this.otherFleetHoldingVsStrongerEnemy() || !this.otherFleetWantsToFight() || this.canDisengageCleanly(this.playerFleet)) {
                    po = CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
                }
                this.context.applyPursuitOption(this.otherFleet, this.playerFleet, po);
                this.context.getDataFor(this.playerFleet).setDisengaged(true);
                this.context.getDataFor(this.otherFleet).setDisengaged(false);
                switch (po) {
                    case PURSUE: 
                    case HARRY: {
                        this.context.applyPursuitOption(this.otherFleet, this.playerFleet, CampaignFleetAIAPI.PursuitOption.HARRY);
                        this.addText(this.getString("enemyHarass"));
                        this.context.setEngagedInHostilities(true);
                        this.context.setOtherFleetHarriedPlayer(true);
                        this.context.getDataFor(this.playerFleet).setDisengaged(true);
                        this.context.getDataFor(this.otherFleet).setDisengaged(false);
                        break;
                    }
                    case LET_THEM_GO: {
                        if (this.canDisengageCleanly(this.playerFleet)) {
                            this.context.setEngagedInHostilities(true);
                            this.addText(this.getString("enemyUnableToPursue"));
                            break;
                        }
                        this.addText(this.getString("enemyDecidesNotToPursue"));
                    }
                }
                this.updateMainState(true);
                break;
            }
            case ATTEMPT_TO_DISENGAGE: {
                boolean letGo = true;
                if (this.otherFleetWantsToFight()) {
                    CampaignFleetAIAPI.PursuitOption pursuitOption = this.pickPursuitOption(this.otherFleet, this.playerFleet, this.context);
                    if (pursuitOption == CampaignFleetAIAPI.PursuitOption.PURSUE) {
                        this.playerGoal = FleetGoal.ESCAPE;
                        this.otherGoal = FleetGoal.ATTACK;
                        this.addText(this.getString("enemyPursuit"));
                        letGo = false;
                        this.updatePreCombat();
                    } else if (pursuitOption == CampaignFleetAIAPI.PursuitOption.HARRY) {
                        this.context.applyPursuitOption(this.otherFleet, this.playerFleet, CampaignFleetAIAPI.PursuitOption.HARRY);
                        this.addText(this.getString("enemyHarass"));
                        this.context.setEngagedInHostilities(true);
                        this.context.getDataFor(this.playerFleet).setDisengaged(true);
                        this.context.getDataFor(this.otherFleet).setDisengaged(false);
                        this.updateMainState(true);
                        letGo = false;
                    } else {
                        letGo = true;
                    }
                }
                if (!letGo) break;
                FleetEncounterContextPlugin.PursueAvailability pa = this.getPursuitAvailability(this.otherFleet);
                FleetEncounterContextPlugin.DisengageHarryAvailability dha = this.context.getDisengageHarryAvailability(this.otherFleet, this.playerFleet);
                if (dha == FleetEncounterContextPlugin.DisengageHarryAvailability.AVAILABLE || pa == FleetEncounterContextPlugin.PursueAvailability.AVAILABLE) {
                    this.addText(this.getString("enemyDecidesNotToPursue"));
                } else {
                    this.addText(this.getString("enemyUnableToPursue"));
                }
                this.context.getDataFor(this.playerFleet).setDisengaged(true);
                this.context.getDataFor(this.otherFleet).setDisengaged(!this.context.isEngagedInHostilities());
                this.updateMainState(true);
                break;
            }
            case BEGIN_FLEET_ENCOUNTER_2: {
                this.reinitPostContinue();
                break;
            }
            case OPEN_COMM: {
                CampaignFleetAPI actualOther = (CampaignFleetAPI)this.dialog.getInteractionTarget();
                this.dialog.showTextPanel();
                this.dialog.flickerStatic(0.1f, 0.1f);
                inConversation = true;
                this.conversationDelegate = new RuleBasedInteractionDialogPluginImpl();
                this.conversationDelegate.setEmbeddedMode(true);
                this.conversationDelegate.init(this.dialog);
                this.dialog.getInteractionTarget().setActivePerson(actualOther.getCommander());
                this.conversationDelegate.notifyActivePersonChanged();
                boolean otherWantsToRun = this.otherFleetWantsToDisengage() && this.otherCanDisengage();
                MemoryAPI mem = this.conversationDelegate.getMemoryMap().get("local");
                if (otherWantsToRun) {
                    mem.unset("$weakerThanPlayerButHolding");
                }
                if (!this.conversationDelegate.fireBest("OpenCommLink")) {
                    this.addText("You try to establish a comm link, but only get static.");
                    this.dialog.getInteractionTarget().setActivePerson(null);
                    this.conversationDelegate.notifyActivePersonChanged();
                    inConversation = false;
                }
                if (!inConversation) break;
                this.visual.showPersonInfo(actualOther.getCommander());
                break;
            }
            case CUT_COMM: {
                this.dialog.showTextPanel();
                this.dialog.flickerStatic(0.1f, 0.1f);
                inConversation = false;
                this.showFleetInfo();
                this.optionSelected(null, (Object)OptionId.INIT);
                break;
            }
            case PURSUE: {
                this.playerGoal = FleetGoal.ATTACK;
                this.otherGoal = FleetGoal.ESCAPE;
                this.addText(this.getString("pursue"));
                this.updatePreCombat();
                break;
            }
            case AUTORESOLVE_PURSUE: {
                List<FleetMemberAPI> members = this.getPursuitCapablePlayerShips();
                this.dialog.showFleetMemberPickerDialog("Select craft to send in pursuit", "Ok", "Cancel", 4, 8, 58.0f, false, true, members, new FleetMemberPickerListener(){

                    @Override
                    public void pickedFleetMembers(List<FleetMemberAPI> members) {
                        if (members != null && !members.isEmpty()) {
                            BattleAutoresolverPluginImpl resolver = new BattleAutoresolverPluginImpl(FleetInteractionDialogPluginImpl.this.context.getBattle());
                            resolver.resolvePlayerPursuit(FleetInteractionDialogPluginImpl.this.context, members);
                            if (resolver.getResult() != null) {
                                FleetInteractionDialogPluginImpl.this.addText(FleetInteractionDialogPluginImpl.this.getString("pursuitAutoresolve"));
                                if (FleetInteractionDialogPluginImpl.this.context.getBattle() != null) {
                                    CampaignFleetAPI player = Global.getSector().getPlayerFleet();
                                    CampaignFleetAPI ally = null;
                                    float alliedFP = 0.0f;
                                    for (CampaignFleetAPI curr : FleetInteractionDialogPluginImpl.this.context.getBattle().getPlayerSide()) {
                                        if (curr.isPlayerFleet() || curr.getFleetData().getMembersListCopy().isEmpty() || curr.isStationMode()) continue;
                                        if (ally == null) {
                                            ally = curr;
                                        }
                                        alliedFP += (float)ally.getFleetPoints();
                                    }
                                    float playerFP = 0.0f;
                                    for (FleetMemberAPI member : members) {
                                        playerFP += (float)member.getFleetPointCost();
                                    }
                                    float damage = 0.0f;
                                    for (FleetMemberAPI member : resolver.getResult().getLoserResult().getDisabled()) {
                                        damage += (float)member.getFleetPointCost();
                                    }
                                    for (FleetMemberAPI member : resolver.getResult().getLoserResult().getDestroyed()) {
                                        damage += (float)member.getFleetPointCost();
                                    }
                                    float total = playerFP + alliedFP;
                                    if (total < 1.0f) {
                                        total = 1.0f;
                                    }
                                    FleetInteractionDialogPluginImpl.this.context.setPlayerFPHullDamageToEnemies(FleetInteractionDialogPluginImpl.this.context.getPlayerFPHullDamageToEnemies() + damage * playerFP / total);
                                    if (ally != null && alliedFP > 0.0f) {
                                        FleetInteractionDialogPluginImpl.this.context.setAllyFPHullDamageToEnemies(FleetInteractionDialogPluginImpl.this.context.getAllyFPHullDamageToEnemies() + damage * alliedFP / total);
                                    }
                                }
                                FleetInteractionDialogPluginImpl.this.backFromEngagement(resolver.getResult());
                            }
                        }
                    }

                    @Override
                    public void cancelledFleetMemberPicking() {
                    }
                });
                break;
            }
            case CRASH_MOTHBALL: {
                List<FleetMemberAPI> choices = this.getCrashMothballable(this.playerFleet.getFleetData().getCombatReadyMembersListCopy());
                this.dialog.showFleetMemberPickerDialog("Select craft to crash-mothball", "Ok", "Cancel", 3, 7, 58.0f, false, true, choices, new FleetMemberPickerListener(){

                    @Override
                    public void pickedFleetMembers(List<FleetMemberAPI> members) {
                        for (FleetMemberAPI member : FleetInteractionDialogPluginImpl.this.playerFleet.getFleetData().getMembersListCopy()) {
                            member.getRepairTracker().setCrashMothballed(false);
                        }
                        if (members != null && !members.isEmpty()) {
                            for (FleetMemberAPI member : members) {
                                member.getRepairTracker().setCrashMothballed(true);
                            }
                            FleetInteractionDialogPluginImpl.this.crashMothballList = FleetInteractionDialogPluginImpl.this.createShipNameListString(members);
                            if (members.size() == 1) {
                                FleetInteractionDialogPluginImpl.this.addText(FleetInteractionDialogPluginImpl.this.getString("crashMothballSelectedOneShip"));
                            } else {
                                FleetInteractionDialogPluginImpl.this.addText(FleetInteractionDialogPluginImpl.this.getString("crashMothballSelectedMultiple"));
                            }
                        }
                    }

                    @Override
                    public void cancelledFleetMemberPicking() {
                    }
                });
                break;
            }
            case SCUTTLE: {
                break;
            }
            case GO_TO_PRE_BATTLE: {
                this.updateEngagementChoice(false);
                break;
            }
            case GO_TO_MAIN: {
                if (this.config.straightToEngage) {
                    this.optionSelected(null, (Object)OptionId.LEAVE);
                    break;
                }
                List<CampaignFleetAPI> playerSide = this.context.getBattle().getPlayerSide();
                List<CampaignFleetAPI> otherSide = this.context.getBattle().getNonPlayerSide();
                if (this.joinedBattle) {
                    this.joinedBattle = false;
                }
                if (this.ongoingBattle) {
                    this.playerFleet = Global.getSector().getPlayerFleet();
                    this.otherFleet = (CampaignFleetAPI)this.dialog.getInteractionTarget();
                    this.context.getBattle().leave(this.playerFleet, this.context.isEngagedInHostilities() || this.context.isOtherFleetHarriedPlayer());
                    BattleAPI b = this.context.getBattle();
                    String titleOne = b.getPrimary(b.getSideOne()).getNameWithFactionKeepCase();
                    if (b.getSideOne().size() > 1) {
                        titleOne = String.valueOf(titleOne) + ", with allies";
                    }
                    String titleTwo = b.getPrimary(b.getSideTwo()).getNameWithFactionKeepCase();
                    if (b.getSideTwo().size() > 1) {
                        titleTwo = String.valueOf(titleTwo) + ", with allies";
                    }
                    this.visual.showPreBattleJoinInfo(null, this.playerFleet, Misc.ucFirst(titleOne), Misc.ucFirst(titleTwo), this.context);
                }
                this.updateMainState(false);
                break;
            }
            case CONTINUE: {
                this.visual.showCustomPanel(810.0f, 400.0f, new ExampleCustomUIPanel());
                this.dialog.hideTextPanel();
                break;
            }
            case DEV_MODE_ESCAPE: {
                this.context.applyAfterBattleEffectsIfThereWasABattle();
                BattleAPI b = this.context.getBattle();
                if (b.isPlayerInvolved()) {
                    this.cleanUpBattle();
                }
            }
            case LOOT_THEN_LEAVE: {
                this.winningPath();
                break;
            }
            case LEAVE: 
            case CONTINUE_LEAVE: {
                if (option != OptionId.CONTINUE_LEAVE && this.context.adjustPlayerReputation(this.dialog, this.getString("friendlyFireRepLoss"), this.config.impactsAllyReputation, this.config.impactsEnemyReputation)) {
                    this.options.clearOptions();
                    this.options.addOption("Continue", (Object)OptionId.CONTINUE_LEAVE, null);
                    if (this.config.straightToEngage) break;
                    this.options.setShortcut((Object)OptionId.CONTINUE_LEAVE, 1, false, false, false, true);
                    break;
                }
                if (this.isFightingOver()) {
                    if (!this.context.hasWinnerAndLoser()) {
                        if (this.context.getDataFor(this.playerFleet).isWonLastEngagement()) {
                            this.context.getDataFor(this.playerFleet).setDisengaged(false);
                            this.context.getDataFor(this.otherFleet).setDisengaged(true);
                        } else {
                            this.context.getDataFor(this.playerFleet).setDisengaged(true);
                            this.context.getDataFor(this.otherFleet).setDisengaged(false);
                        }
                    }
                } else if (this.context.isEngagedInHostilities()) {
                    this.context.getDataFor(this.playerFleet).setDisengaged(true);
                    this.context.getDataFor(this.otherFleet).setDisengaged(false);
                } else {
                    this.context.getDataFor(this.playerFleet).setDisengaged(true);
                    this.context.getDataFor(this.otherFleet).setDisengaged(true);
                }
                if (this.config.printXPToDialog) {
                    this.context.setTextPanelForXPGain(this.textPanel);
                    this.textPanel.setFontSmallInsignia();
                }
                this.context.applyAfterBattleEffectsIfThereWasABattle();
                this.context.setTextPanelForXPGain(null);
                this.textPanel.setFontInsignia();
                this.cleanUpBattle();
                if (this.config.dismissOnLeave) {
                    this.dialog.dismiss();
                } else {
                    this.dialog.setOptionOnEscape("", null);
                    this.dialog.setOptionOnConfirm("", null);
                }
                if (this.config.delegate == null) break;
                this.config.delegate.notifyLeave(this.dialog);
                break;
            }
            case HARRY_PURSUE: {
                this.addText(this.getString("playerHarass"));
                this.context.applyPursuitOption(this.playerFleet, this.otherFleet, CampaignFleetAIAPI.PursuitOption.HARRY);
                this.context.setEngagedInHostilities(true);
                this.context.getDataFor(this.playerFleet).setDisengaged(false);
                this.context.getDataFor(this.otherFleet).setDisengaged(true);
                this.context.setEngagedInHostilities(true);
                this.goToEncounterEndPath();
                break;
            }
            case LET_THEM_GO: {
                this.addText(this.getString("playerLetGo"));
                this.context.getDataFor(this.playerFleet).setDisengaged(false);
                this.context.getDataFor(this.otherFleet).setDisengaged(true);
                this.goToEncounterEndPath();
                break;
            }
            case RECOVERY_CONTINUE: {
                this.goToEncounterEndPath();
                break;
            }
            case RECOVERY_SELECT: {
                if (this.recoverableShips.isEmpty() && this.storyRecoverableShips.isEmpty()) break;
                this.dialog.showFleetMemberRecoveryDialog("Select ships to recover", this.recoverableShips, this.storyRecoverableShips, new FleetMemberPickerListener(){

                    @Override
                    public void pickedFleetMembers(List<FleetMemberAPI> members) {
                        if (members != null && !members.isEmpty()) {
                            FleetInteractionDialogPluginImpl.this.recoveredShips.clear();
                            FleetInteractionDialogPluginImpl.this.recoveredShips.addAll(members);
                            FleetEncounterContext.recoverShips(members, FleetInteractionDialogPluginImpl.this.context, FleetInteractionDialogPluginImpl.this.playerFleet, FleetInteractionDialogPluginImpl.this.otherFleet);
                            ListenerUtil.reportShipsRecovered(members, FleetInteractionDialogPluginImpl.this.dialog);
                            CampaignFleetAPI player = Global.getSector().getPlayerFleet();
                            FleetInteractionDialogPluginImpl.this.restoreOrigCaptains();
                            player.getFleetData().sortToMatchOrder(FleetInteractionDialogPluginImpl.this.membersInOrderPreEncounter);
                            FleetInteractionDialogPluginImpl.this.showFleetInfo();
                            FleetInteractionDialogPluginImpl.this.winningPath();
                        }
                    }

                    @Override
                    public void cancelledFleetMemberPicking() {
                    }
                });
                break;
            }
            case CONTINUE_FROM_VICTORY_TRIGGERS: {
                this.winningPath();
                break;
            }
            case CONTINUE_LOOT: {
                this.visual.setVisualFade(0.0f, 0.0f);
                this.dialog.hideTextPanel();
                this.dialog.hideVisualPanel();
                Global.getSector().reportEncounterLootGenerated(this.context, this.context.getLoot());
                this.visual.showLoot("Salvaged", this.context.getLoot(), true, new CoreInteractionListener(){

                    public void coreUIDismissed() {
                        if (FleetInteractionDialogPluginImpl.this.config.printXPToDialog) {
                            FleetInteractionDialogPluginImpl.this.context.setTextPanelForXPGain(FleetInteractionDialogPluginImpl.this.textPanel);
                            FleetInteractionDialogPluginImpl.this.textPanel.setFontSmallInsignia();
                        }
                        FleetInteractionDialogPluginImpl.this.context.applyAfterBattleEffectsIfThereWasABattle();
                        FleetInteractionDialogPluginImpl.this.context.setTextPanelForXPGain(null);
                        FleetInteractionDialogPluginImpl.this.textPanel.setFontInsignia();
                        FleetInteractionDialogPluginImpl.this.cleanUpBattle();
                        if (FleetInteractionDialogPluginImpl.this.config.dismissOnLeave) {
                            FleetInteractionDialogPluginImpl.this.dialog.dismiss();
                            FleetInteractionDialogPluginImpl.this.dialog.hideTextPanel();
                            FleetInteractionDialogPluginImpl.this.dialog.hideVisualPanel();
                        } else {
                            FleetInteractionDialogPluginImpl.this.dialog.showTextPanel();
                            FleetInteractionDialogPluginImpl.this.dialog.showVisualPanel();
                            FleetInteractionDialogPluginImpl.this.dialog.setOptionOnEscape("", null);
                            FleetInteractionDialogPluginImpl.this.dialog.setOptionOnConfirm("", null);
                        }
                        if (FleetInteractionDialogPluginImpl.this.config.delegate != null) {
                            FleetInteractionDialogPluginImpl.this.config.delegate.notifyLeave(FleetInteractionDialogPluginImpl.this.dialog);
                        }
                    }
                });
                this.options.clearOptions();
                this.dialog.setPromptText("");
                break;
            }
            case CONTINUE_INTO_BOARDING: {
                this.goToEncounterEndPath();
                break;
            }
            case BOARDING_ACTION: {
                ++this.boardingPhase;
                CampaignFleetAPI sourceFleet = this.context.getBattle().getSourceFleet(this.toBoard);
                this.boardingResult = this.context.boardShip(this.toBoard, Global.getSector().getPlayerFleet(), sourceFleet);
                this.goToEncounterEndPath();
                break;
            }
            case SELECT_FLAGSHIP: {
                ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
                for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
                    if (!this.isValidTransferCommandTarget(member)) continue;
                    members.add(member);
                }
                if (members.isEmpty()) break;
                this.dialog.showFleetMemberPickerDialog("Select flagship for this engagement", "Ok", "Cancel", 3, 7, 58.0f, false, false, members, new FleetMemberPickerListener(){

                    @Override
                    public void pickedFleetMembers(List<FleetMemberAPI> members) {
                        if (members != null && !members.isEmpty() && !members.get(0).isFlagship()) {
                            FleetInteractionDialogPluginImpl.this.restoreOrigCaptains();
                            FleetInteractionDialogPluginImpl.this.selectedFlagship = members.get(0);
                            PersonAPI captain = FleetInteractionDialogPluginImpl.this.selectedFlagship.getCaptain();
                            Global.getSector().getPlayerFleet().getFleetData().setFlagship(FleetInteractionDialogPluginImpl.this.selectedFlagship);
                            if (FleetInteractionDialogPluginImpl.this.origFlagship != null && captain != null && !captain.isPlayer()) {
                                FleetInteractionDialogPluginImpl.this.origFlagship.setCaptain(captain);
                            }
                            FleetInteractionDialogPluginImpl.this.addText(FleetInteractionDialogPluginImpl.this.getString("selectedFlagship"));
                        }
                    }

                    @Override
                    public void cancelledFleetMemberPicking() {
                    }
                });
                break;
            }
            case ENGAGE_BOARDABLE: {
                FleetEncounterContext.EngageBoardableOutcome outcome = this.context.engageBoardableShip(this.toBoard, this.otherFleet, this.playerFleet);
                switch (outcome) {
                    case DESTROYED: {
                        this.addText(this.getString("engageBoardableDestroyed"));
                        break;
                    }
                    case DISABLED: {
                        this.addText(this.getString("engageBoardableDisabled"));
                        break;
                    }
                    case ESCAPED: {
                        this.addText(this.getString("engageBoardableEscaped"));
                    }
                }
                this.toBoard = null;
                this.goToEncounterEndPath();
                break;
            }
            case LET_IT_GO: {
                this.context.letBoardableGo(this.toBoard, this.otherFleet, this.playerFleet);
                this.addText(this.getString("letBoardableGo"));
                this.toBoard = null;
                this.goToEncounterEndPath();
            }
        }
    }

    protected void rememberWasBeaten() {
        if (this.context.getBattle() == null) {
            return;
        }
        for (CampaignFleetAPI other : this.context.getBattle().getNonPlayerSide()) {
            MemoryAPI mem = other.getMemoryWithoutUpdate();
            if (mem.getBoolean("$cfai_recentlyDefeatedByPlayer")) continue;
            mem.set("$cfai_recentlyDefeatedByPlayer", true, 0.5f);
        }
    }

    protected void restoreOrigCaptains() {
        if (this.origCaptains != null) {
            for (FleetMemberAPI member : this.origCaptains.keySet()) {
                PersonAPI captain = this.origCaptains.get(member);
                if (captain == null) continue;
                member.setCaptain(captain);
            }
        }
    }

    public void cleanUpBattle() {
        BattleAPI.BattleSide winner;
        if (this.cleanedUp) {
            return;
        }
        this.cleanedUp = true;
        BattleAPI b = this.context.getBattle();
        FleetEncounterContextPlugin.DataForEncounterSide enemyData = this.context.getDataFor(b.getNonPlayerCombined());
        FleetEncounterContextPlugin.DataForEncounterSide playerData = this.context.getDataFor(b.getPlayerCombined());
        if (enemyData != null && playerData != null && enemyData.disengaged() && !playerData.disengaged()) {
            this.rememberWasBeaten();
        }
        b.leave(Global.getSector().getPlayerFleet(), this.context.isEngagedInHostilities() || this.context.isOtherFleetHarriedPlayer());
        BattleAPI.BattleSide playerSide = b.getPlayerSide() == b.getSideOne() ? BattleAPI.BattleSide.ONE : BattleAPI.BattleSide.TWO;
        BattleAPI.BattleSide otherSide = b.getPlayerSide() == b.getSideOne() ? BattleAPI.BattleSide.TWO : BattleAPI.BattleSide.ONE;
        BattleAPI.BattleSide battleSide = winner = this.context.didPlayerWinMostRecentBattleOfEncounter() ? playerSide : otherSide;
        if (!this.context.isEngagedInHostilities() && !this.context.isOtherFleetHarriedPlayer()) {
            winner = BattleAPI.BattleSide.NO_JOIN;
        }
        if (!this.ongoingBattle) {
            b.finish(winner, this.context.isEngagedInHostilities() || this.context.isOtherFleetHarriedPlayer());
            Global.getSector().getPlayerFleet().getFleetData().setSyncNeeded();
            Global.getSector().getPlayerFleet().getFleetData().syncIfNeeded();
        } else if (this.ongoingBattle) {
            FleetEncounterContextPlugin.EngagementOutcome last = this.context.getLastEngagementOutcome();
            if (last == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_ENEMY_SUCCESS || last == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_SUCCESS || this.harryEndedBattle || this.context.isOtherFleetHarriedPlayer() || this.allyEngagementChoiceNoBattle) {
                b.finish(winner, true);
            } else {
                for (CampaignFleetAPI curr : this.pulledIn) {
                    b.leave(curr, this.context.isEngagedInHostilities() || this.context.isOtherFleetHarriedPlayer());
                }
            }
        }
        if (this.context.isEngagedInHostilities()) {
            b.applyVisibilityMod(Global.getSector().getPlayerFleet());
        }
    }

    protected void goToEncounterEndPath() {
        if (this.context.didPlayerWinMostRecentBattleOfEncounter() || this.config.straightToEngage && this.context.getLastEngagementOutcome() == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_WIN) {
            this.winningPath();
        } else {
            this.losingPath();
        }
    }

    protected void losingPath() {
        boolean mutualDestruction;
        this.options.clearOptions();
        this.context.getDataFor(this.playerFleet).setDisengaged(true);
        if (!this.recoveredCrew) {
            this.recoveredCrew = true;
            this.context.recoverCrew(this.otherFleet);
        }
        boolean playerHasReadyShips = !this.playerFleet.getFleetData().getCombatReadyMembersListCopy().isEmpty();
        boolean otherHasReadyShips = !this.otherFleet.getFleetData().getCombatReadyMembersListCopy().isEmpty();
        boolean totalDefeat = !this.playerFleet.isValidPlayerFleet();
        boolean bl = mutualDestruction = this.context.getLastEngagementOutcome() == FleetEncounterContextPlugin.EngagementOutcome.MUTUAL_DESTRUCTION;
        if (this.toBoard != null && this.aiBoardingResponse == null) {
            this.visual.showFleetMemberInfo(this.toBoard);
            if (mutualDestruction) {
                this.addText(this.getString("mutualDestructionRepairs"));
                this.aiBoardingResponse = CampaignFleetAIAPI.InitialBoardingResponse.LET_IT_GO;
            } else {
                if (totalDefeat) {
                    this.addText(this.getString("lastFriendlyShipRepairs"));
                } else {
                    this.addText(this.getString("friendlyShipBoardable"));
                }
                this.aiBoardingResponse = this.otherFleet.getAI().pickBoardingResponse(this.context, this.toBoard, this.playerFleet);
            }
            if (!otherHasReadyShips) {
                this.aiBoardingResponse = CampaignFleetAIAPI.InitialBoardingResponse.LET_IT_GO;
            }
            this.options.addOption("Continue", (Object)OptionId.CONTINUE_INTO_BOARDING, null);
            return;
        }
        if (this.toBoard != null && this.aiBoardingResponse != null) {
            switch (this.aiBoardingResponse) {
                case BOARD: {
                    break;
                }
                case ENGAGE: {
                    FleetEncounterContext.EngageBoardableOutcome outcome = this.context.engageBoardableShip(this.toBoard, this.playerFleet, this.otherFleet);
                    switch (outcome) {
                        case DESTROYED: {
                            if (totalDefeat) {
                                this.addText(this.getString("lastFriendlyBoardableDestroyed"));
                                break;
                            }
                            this.addText(this.getString("engageFriendlyBoardableDestroyed"));
                            break;
                        }
                        case DISABLED: {
                            if (totalDefeat) {
                                this.addText(this.getString("lastFriendlyBoardableDisabled"));
                                break;
                            }
                            this.addText(this.getString("engageFriendlyBoardableDisabled"));
                            break;
                        }
                        case ESCAPED: {
                            if (totalDefeat) {
                                this.addText(this.getString("lastFriendlyBoardableEscaped"));
                                break;
                            }
                            this.addText(this.getString("engageFriendlyBoardableEscaped"));
                        }
                    }
                    break;
                }
                case LET_IT_GO: {
                    this.context.letBoardableGo(this.toBoard, this.playerFleet, this.otherFleet);
                    if (mutualDestruction) break;
                    if (totalDefeat) {
                        this.addText(this.getString("engageFriendlyBoardableLetGo"));
                        break;
                    }
                    this.addText(this.getString("lastFriendlyBoardableLetGo"));
                }
            }
        }
        boolean bl2 = totalDefeat = !this.playerFleet.isValidPlayerFleet();
        if (totalDefeat) {
            this.addText(this.getString("finalOutcomeNoShipsLeft"));
        }
        if (this.pickedMemberToBoard) {
            this.showFleetInfo();
        }
        if (this.config.salvageRandom != null) {
            this.context.setSalvageRandom(this.config.salvageRandom);
        }
        this.context.generateLoot(null, this.config.lootCredits);
        this.context.autoLoot();
        String leave = "Leave";
        if (this.config.straightToEngage) {
            leave = "Continue";
        }
        this.options.addOption(leave, (Object)OptionId.LEAVE, null);
        if (!this.config.straightToEngage) {
            this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        } else {
            this.optionSelected(null, (Object)OptionId.LEAVE);
        }
    }

    protected void winningPath() {
        boolean playerHasReadyShips;
        CampaignFleetAPI actualPlayer;
        this.options.clearOptions();
        FleetEncounterContextPlugin.DataForEncounterSide playerData = this.context.getDataFor(this.playerFleet);
        this.context.getDataFor(this.otherFleet).setDisengaged(true);
        if (!this.firedVictoryTriggers) {
            SectorEntityToken prev = this.dialog.getInteractionTarget();
            RuleBasedInteractionDialogPluginImpl plugin = new RuleBasedInteractionDialogPluginImpl();
            plugin.setEmbeddedMode(true);
            this.dialog.setPlugin(plugin);
            BattleAPI battle = this.context.getBattle();
            boolean firedAnyTriggers = false;
            for (CampaignFleetAPI other : battle.getNonPlayerSide()) {
                this.dialog.setInteractionTarget(other);
                plugin.init(this.dialog);
                MemoryAPI mem = other.getMemoryWithoutUpdate();
                List<FleetMemberAPI> losses = Misc.getSnapshotMembersLost(other);
                List<FleetMemberAPI> remaining = other.getFleetData().getMembersListCopy();
                int fpTotal = 0;
                int fpLost = 0;
                int fpRemaining = 0;
                for (FleetMemberAPI curr : losses) {
                    fpLost += curr.getFleetPointCost();
                    fpTotal += curr.getFleetPointCost();
                }
                for (FleetMemberAPI curr : remaining) {
                    fpRemaining += curr.getFleetPointCost();
                    fpTotal += curr.getFleetPointCost();
                }
                mem.set("$someShipsDestroyed", !losses.isEmpty(), 0.0f);
                mem.set("$fpLost", fpLost, 0.0f);
                mem.set("$fpRemaining", fpRemaining, 0.0f);
                mem.set("$fpLostFraction", Float.valueOf((float)fpLost / (float)Math.max(1, fpTotal)), 0.0f);
                mem.set("$battle", battle, 0.0f);
                List<String> triggers = Misc.getDefeatTriggers(other, false);
                if (triggers != null) {
                    for (String trigger : new ArrayList<String>(triggers)) {
                        boolean fired = FireBest.fire(null, this.dialog, plugin.getMemoryMap(), trigger);
                        if (!fired) continue;
                        triggers.remove(trigger);
                        firedAnyTriggers = true;
                    }
                }
                Misc.clearDefeatTriggersIfNeeded(other);
            }
            this.dialog.setInteractionTarget(prev);
            this.dialog.setPlugin(this);
            this.firedVictoryTriggers = true;
            if (firedAnyTriggers) {
                this.options.addOption("Continue", (Object)OptionId.CONTINUE_FROM_VICTORY_TRIGGERS, null);
                return;
            }
        }
        if (!this.recoveredCrew) {
            this.recoveredCrew = true;
            if (playerData.getRecoverableCrewLosses().getCrewInt() + (int)playerData.getRecoverableCrewLosses().getMarines() > 0) {
                this.addText(this.getString("recoveryReport"));
                FleetEncounterContextPlugin.DataForEncounterSide data = this.context.getDataFor(this.playerFleet);
                int crewRecovered = (int)data.getRecoverableCrewLosses().getCrew();
                int marinesRecovered = (int)data.getRecoverableCrewLosses().getMarines();
                String crewRecStr = "" + crewRecovered;
                if (crewRecovered <= 0) {
                    crewRecStr = "";
                }
                String marinesRecStr = "" + marinesRecovered;
                if (marinesRecovered <= 0) {
                    marinesRecStr = "";
                }
                this.textPanel.highlightInLastPara(HIGHLIGHT_COLOR, crewRecStr, marinesRecStr);
                this.context.recoverCrew(this.playerFleet);
            }
        }
        boolean playerHasPersonnel = (actualPlayer = Global.getSector().getPlayerFleet()).getCargo().getMarines() > 0;
        boolean bl = playerHasReadyShips = !actualPlayer.getFleetData().getCombatReadyMembersListCopy().isEmpty();
        if (!this.didRecoveryCheck) {
            this.didRecoveryCheck = true;
            this.recoverableShips = this.context.getRecoverableShips(this.context.getBattle(), this.playerFleet, this.otherFleet);
            this.storyRecoverableShips = this.context.getStoryRecoverableShips();
            if (this.recoverableShips == null) {
                this.recoverableShips = new ArrayList<FleetMemberAPI>();
            }
            if (this.storyRecoverableShips == null) {
                this.storyRecoverableShips = new ArrayList<FleetMemberAPI>();
            }
            if (!this.recoverableShips.isEmpty() || !this.storyRecoverableShips.isEmpty()) {
                boolean onlyDifficultRecovery;
                int crew = actualPlayer.getCargo().getCrew();
                int needed = (int)actualPlayer.getFleetData().getMinCrew();
                int num = this.recoverableShips.size() + this.storyRecoverableShips.size();
                String numString = "several ships disabled or destroyed";
                if (num == 1) {
                    numString = "a ship disabled";
                }
                String pre = "The salvage chief reports that " + numString + " during the battle " + "can be restored to basic functionalty. Recovering ships instead of breaking " + "them for salvage will greatly reduce the salvage gained from these ships.";
                this.textPanel.addParagraph(pre);
                boolean playerShipsRecoverable = false;
                for (FleetMemberAPI member : this.recoverableShips) {
                    if (member.getOwner() != 0 || member.isAlly()) continue;
                    playerShipsRecoverable = true;
                    break;
                }
                for (FleetMemberAPI member : this.storyRecoverableShips) {
                    if (member.getOwner() != 0 || member.isAlly()) continue;
                    playerShipsRecoverable = true;
                    break;
                }
                boolean bl2 = onlyDifficultRecovery = this.recoverableShips.isEmpty() && !this.storyRecoverableShips.isEmpty();
                if (playerShipsRecoverable) {
                    this.textPanel.setFontSmallInsignia();
                    this.textPanel.addParagraph("Disabled ships from your fleet are available for recovery", Misc.getHighlightColor());
                    this.textPanel.setFontInsignia();
                    this.options.addOption("Consider ship recovery", (Object)OptionId.RECOVERY_SELECT, Misc.getHighlightColor(), "Disabled ships from your fleet are available for recovery.");
                } else {
                    Color color = Misc.getButtonTextColor();
                    if (onlyDifficultRecovery) {
                        color = Misc.getStoryOptionColor();
                    }
                    this.options.addOption("Consider ship recovery", (Object)OptionId.RECOVERY_SELECT, color, null);
                }
                this.options.addOption("Continue", (Object)OptionId.RECOVERY_CONTINUE, null);
                if (playerShipsRecoverable) {
                    this.options.addOptionConfirmation((Object)OptionId.RECOVERY_CONTINUE, "Disabled ships from your fleet are available for recovery.\n\nIf you proceed without recovering them, they will be lost permanently.", "Proceed", "Cancel");
                }
                return;
            }
        }
        this.context.adjustPlayerReputation(this.dialog, this.getString("friendlyFireRepLoss"), this.config.impactsAllyReputation, this.config.impactsEnemyReputation);
        boolean validFleet = this.playerFleet.isValidPlayerFleet();
        BattleAPI battle = this.context.getBattle();
        boolean hasAllies = false;
        boolean startedWithAllies = false;
        if (battle != null) {
            hasAllies = this.context.getBattle().getPlayerSide().size() <= 1;
            boolean bl3 = startedWithAllies = this.context.getBattle().getPlayerSideSnapshot().size() > 1;
        }
        if (!this.lootedCredits && this.config.withSalvage) {
            if (this.config.salvageRandom != null) {
                this.context.setSalvageRandom(this.config.salvageRandom);
            }
            this.context.generateLoot(this.recoveredShips, this.config.lootCredits);
            if (this.config.delegate != null) {
                this.config.delegate.postPlayerSalvageGeneration(this.dialog, this.context, this.context.getLoot());
            }
            this.lootedCredits = true;
            float credits = this.context.getCreditsLooted();
            if (this.context.isEngagedInHostilities() && this.context.getLastEngagementOutcome() != null && validFleet) {
                if (credits <= 0.0f && this.context.getLoot().isEmpty()) {
                    if (startedWithAllies) {
                        this.addText(this.getString("noSalvageReportPlayerDidNothing"));
                    } else {
                        this.addText(this.getString("noSalvageReport"));
                    }
                } else if (startedWithAllies) {
                    this.addText(this.getString("salvageReportPlayer"));
                }
            }
            this.creditsLooted = Misc.getWithDGS((int)credits);
            if (credits > 0.0f && validFleet) {
                this.addText(this.getString("creditsLootedReport"));
                this.textPanel.highlightLastInLastPara(this.creditsLooted, HIGHLIGHT_COLOR);
                Global.getSector().getPlayerFleet().getCargo().getCredits().add(credits);
            }
        }
        if (!this.context.getLoot().isEmpty() && validFleet) {
            this.options.addOption("Pick through the wreckage", (Object)OptionId.CONTINUE_LOOT, null);
        } else {
            if (!validFleet) {
                this.addText(this.getString("finalOutcomeNoShipsLeft"));
            }
            String leave = "Leave";
            boolean withEscape = true;
            if (this.config.noSalvageLeaveOptionText != null && validFleet && this.context.getLoot().isEmpty()) {
                leave = this.config.noSalvageLeaveOptionText;
                withEscape = false;
            }
            this.options.addOption(leave, (Object)OptionId.LEAVE, null);
            if (withEscape) {
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
            }
        }
    }

    protected List<FleetMemberAPI> getCrashMothballable(List<FleetMemberAPI> all) {
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        CombatReadinessPlugin crPlugin = Global.getSettings().getCRPlugin();
        for (FleetMemberAPI member : all) {
            if (member.isAlly() || member.isFighterWing() || !(member.getRepairTracker().getCR() < crPlugin.getMalfunctionThreshold(member.getStats()))) continue;
            result.add(member);
        }
        return result;
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
        if (inConversation) {
            this.conversationDelegate.optionMousedOver(optionText, optionData);
            return;
        }
        if (optionData instanceof String) {
            return;
        }
        if (optionData == null) {
            if (this.currVisualType != VisualType.FLEET_INFO) {
                this.showFleetInfo();
                this.currVisualType = VisualType.FLEET_INFO;
            }
            this.lastOptionMousedOver = null;
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (option == this.lastOptionMousedOver) {
            return;
        }
        this.lastOptionMousedOver = option;
    }

    protected void showFleetInfo() {
        BattleAPI b = this.context.getBattle();
        if (b != null && b.isPlayerInvolved()) {
            String titleOne = "Your forces";
            if (b.isPlayerInvolved() && b.getPlayerSide().size() > 1) {
                titleOne = String.valueOf(titleOne) + ", with allies";
            }
            if (!Global.getSector().getPlayerFleet().isValidPlayerFleet() && b.getPlayerSide().size() > 1) {
                titleOne = "Allied forces";
            }
            String titleTwo = null;
            if (b.getPrimary(b.getNonPlayerSide()) != null) {
                titleTwo = b.getPrimary(b.getNonPlayerSide()).getNameWithFactionKeepCase();
            }
            if (b.getNonPlayerSide().size() > 1) {
                titleTwo = String.valueOf(titleTwo) + ", with allies";
            }
            this.visual.showFleetInfo(titleOne, b.getPlayerCombined(), Misc.ucFirst(titleTwo), b.getNonPlayerCombined(), this.context);
        } else {
            this.visual.showFleetInfo(null, this.playerFleet, null, this.otherFleet, this.context);
        }
    }

    @Override
    public void advance(float amount) {
    }

    protected void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    protected void addText(String text, Color color) {
        this.textPanel.addParagraph(text, color);
    }

    protected void addText(String text, String hl, Color hlColor) {
        LabelAPI label = this.textPanel.addParagraph(text);
        label.setHighlight(hl);
        label.setHighlightColor(hlColor);
    }

    protected void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    protected void updateDialogState() {
        this.options.clearOptions();
        this.options.addOption("Cut the comm link", (Object)OptionId.CUT_COMM, null);
    }

    protected boolean isValidTransferCommandTarget(FleetMemberAPI member) {
        if (member.isFighterWing() || member.isAlly()) {
            return false;
        }
        if (Misc.isAutomated(member)) {
            return false;
        }
        return !Misc.isUnremovable(member.getCaptain());
    }

    protected void updatePreCombat() {
        boolean canGoBack;
        float diff;
        if (!this.context.isComputedDifficulty()) {
            this.context.computeBattleDifficulty();
        }
        if ((diff = this.context.getDifficulty()) >= 1.0f) {
            String percent = "+" + Math.round((diff - 1.0f) * 100.0f) + "%";
            this.textPanel.setFontSmallInsignia();
            this.textPanel.addPara("Additional XP due to overall battle difficulty: %s", Misc.getGrayColor(), Misc.getHighlightColor(), percent);
            this.textPanel.setFontInsignia();
        }
        this.options.clearOptions();
        boolean canTransfer = false;
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            if (member.isFlagship() || !this.isValidTransferCommandTarget(member)) continue;
            canTransfer = true;
            break;
        }
        if (this.playerGoal == FleetGoal.ATTACK && this.otherGoal == FleetGoal.ESCAPE) {
            String tooltipText = this.getString("tooltipPursueAutoresolve");
            this.options.addOption("Order your second-in-command to handle it", (Object)OptionId.AUTORESOLVE_PURSUE, tooltipText);
            this.options.addOption("Transfer command for this engagement", (Object)OptionId.SELECT_FLAGSHIP, this.getString("tooltipSelectFlagship"));
            if (!canTransfer) {
                this.options.setEnabled((Object)OptionId.SELECT_FLAGSHIP, false);
            }
            this.options.addOption("Take command of the action", (Object)OptionId.CONTINUE_INTO_BATTLE, null);
        } else {
            this.options.addOption("Transfer command for this engagement", (Object)OptionId.SELECT_FLAGSHIP, this.getString("tooltipSelectFlagship"));
            if (!canTransfer) {
                this.options.setEnabled((Object)OptionId.SELECT_FLAGSHIP, false);
            }
            if (this.playerGoal == FleetGoal.ESCAPE) {
                List<FleetMemberAPI> choices = this.getCrashMothballable(this.playerFleet.getFleetData().getCombatReadyMembersListCopy());
                this.options.addOption("Crash-mothball some of your ships to prevent malfunctions", (Object)OptionId.CRASH_MOTHBALL, null);
                if (choices.isEmpty()) {
                    this.options.setEnabled((Object)OptionId.CRASH_MOTHBALL, false);
                    this.options.setTooltip((Object)OptionId.CRASH_MOTHBALL, this.getString("tooltipCrashMothballUnavailable"));
                } else {
                    this.options.setTooltip((Object)OptionId.CRASH_MOTHBALL, this.getString("tooltipCrashMothball"));
                }
            }
            if (this.config.straightToEngage) {
                this.options.addOption("Continue into battle", (Object)OptionId.CONTINUE_INTO_BATTLE, null);
            } else {
                this.options.addOption("Continue", (Object)OptionId.CONTINUE_INTO_BATTLE, null);
            }
        }
        boolean bl = canGoBack = this.ongoingBattle || this.otherGoal == FleetGoal.ESCAPE || Global.getSettings().isDevMode();
        if (canGoBack) {
            this.options.addOption("Go back", (Object)OptionId.GO_TO_MAIN, null);
            this.options.setShortcut((Object)OptionId.GO_TO_MAIN, 1, false, false, false, true);
        }
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    protected String createShipNameListString(List<FleetMemberAPI> members) {
        String str = "";
        int fighters = 0;
        int ships = 0;
        for (FleetMemberAPI member : members) {
            boolean last = members.indexOf(member) == members.size() - 1;
            boolean secondToLast = members.indexOf(member) == members.size() - 2;
            boolean fighter = member.isFighterWing();
            if (fighter) {
                ++fighters;
            } else {
                str = last && fighters == 0 && ++ships > 1 ? (members.size() > 2 ? String.valueOf(str) + ", and the " + member.getShipName() : String.valueOf(str) + " and the " + member.getShipName()) : String.valueOf(str) + "the " + member.getShipName();
            }
            if (!(last || secondToLast || fighter)) {
                str = String.valueOf(str) + ", ";
            }
            if (!last || fighters <= 0) continue;
            if (fighters == 1) {
                if (ships == 0) {
                    str = String.valueOf(str) + "a fighter wing";
                    continue;
                }
                if (ships > 1) {
                    str = String.valueOf(str) + ", and a fighter wing";
                    continue;
                }
                str = String.valueOf(str) + " and a fighter wing";
                continue;
            }
            str = ships == 0 ? String.valueOf(str) + "several fighter wings" : (ships > 1 ? String.valueOf(str) + ", and several fighter wings" : String.valueOf(str) + " and several fighter wings");
        }
        return str;
    }

    protected void updateMainState(boolean withText) {
        this.options.clearOptions();
        if (this.isFightingOver()) {
            this.goToEncounterEndPath();
            return;
        }
        if (this.ongoingBattle) {
            BattleAPI battle = this.context.getBattle();
            boolean playerHasReadyShips = false;
            for (FleetMemberAPI member : this.playerFleet.getFleetData().getCombatReadyMembersListCopy()) {
                if (member.isAlly()) continue;
                playerHasReadyShips = true;
            }
            if (!this.joinedBattle && battle.canJoin(this.playerFleet)) {
                this.options.addOption("Join the battle", (Object)OptionId.JOIN_ONGOING_BATTLE, null);
                if (!playerHasReadyShips) {
                    this.options.setEnabled((Object)OptionId.JOIN_ONGOING_BATTLE, false);
                }
            }
            this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
            this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
            if (Global.getSettings().isDevMode()) {
                DevMenuOptions.addOptions(this.dialog);
            }
        } else {
            if (this.config.showCommLinkOption) {
                if (this.otherFleet.getMemoryWithoutUpdate().is("$hailing", true)) {
                    this.options.addOption("Accept the comm request", (Object)OptionId.OPEN_COMM, Misc.getHighlightedOptionColor(), null);
                    this.otherFleet.getMemoryWithoutUpdate().unset("$hailing");
                } else if (this.otherFleet.getMemoryWithoutUpdate().is("$highlightComms", true)) {
                    this.options.addOption("Open a comm link", (Object)OptionId.OPEN_COMM, Misc.getHighlightedOptionColor(), null);
                    this.otherFleet.getMemoryWithoutUpdate().unset("$highlightComms");
                } else {
                    this.options.addOption("Open a comm link", (Object)OptionId.OPEN_COMM, null);
                }
            }
            boolean smuggler = this.otherFleet.getMemoryWithoutUpdate().getBoolean("$isSmuggler");
            if (this.otherFleet.getFaction().isPlayerFaction() && !smuggler) {
                this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
            } else {
                this.updateEngagementChoice(withText);
            }
        }
    }

    protected void updateEngagementChoice(boolean withText) {
        this.allyEngagementChoiceNoBattle = false;
        if (this.isFightingOver()) {
            this.goToEncounterEndPath();
            return;
        }
        BattleAPI b = this.context.getBattle();
        if (this.ongoingBattle && b.getPlayerSide() != null && b.getPlayerSide().size() <= 1) {
            this.ongoingBattle = false;
            if (this.config.showCommLinkOption) {
                this.options.addOption("Open a comm link", (Object)OptionId.OPEN_COMM, null);
            }
        }
        this.playerGoal = null;
        this.otherGoal = null;
        boolean alliedWantsToFight = this.alliedFleetWantsToFight();
        boolean alliedWantsToRun = this.alliedFleetWantsToDisengage() && this.alliedCanDisengage();
        boolean alliedHolding = this.alliedFleetHoldingVsStrongerEnemy();
        boolean otherWantsToFight = this.otherFleetWantsToFight();
        boolean otherWantsToRun = this.otherFleetWantsToDisengage() && this.otherCanDisengage();
        boolean otherHolding = this.otherFleetHoldingVsStrongerEnemy();
        boolean playerHasReadyShips = false;
        boolean allyHasReadyShips = false;
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getCombatReadyMembersListCopy()) {
            if (member.isAlly() && !member.isStation()) {
                allyHasReadyShips = true;
                continue;
            }
            playerHasReadyShips = true;
        }
        if (otherWantsToRun && this.canDisengageCleanly(this.otherFleet)) {
            if (this.context.getBattle().getPlayerSide().size() > 1) {
                if (withText) {
                    this.addText(this.getString("enemyCleanDisengageSide"));
                }
            } else if (withText) {
                this.addText(this.getString("enemyCleanDisengage"));
            }
            this.goToEncounterEndPath();
        } else if (otherWantsToRun) {
            String pursueTooltip = "tooltipPursue";
            String harassTooltip = "tooltipHarassRetreat";
            String letThemGoTooltip = "tooltipLetThemGo";
            if (!this.context.isEngagedInHostilities()) {
                letThemGoTooltip = "tooltipLetThemGoNoPenalty";
            }
            boolean canPursue = false;
            boolean canHasass = false;
            FleetEncounterContextPlugin.PursueAvailability pa = this.getPursuitAvailability(this.playerFleet);
            FleetEncounterContextPlugin.DisengageHarryAvailability dha = this.context.getDisengageHarryAvailability(this.playerFleet, this.otherFleet);
            switch (pa) {
                case AVAILABLE: {
                    canPursue = true;
                    break;
                }
                case LOST_LAST_ENGAGEMENT: {
                    pursueTooltip = "tooltipPursueLostLast";
                    break;
                }
                case NO_READY_SHIPS: {
                    pursueTooltip = "tooltipNoReadyShips";
                    break;
                }
                case TOOK_SERIOUS_LOSSES: {
                    if (this.context.getBattle().getPlayerSide().size() > 1) {
                        if (withText) {
                            this.addText(this.getString("enemyDisruptedPlayerSide"), this.getString("highlightDisruptedPlayer"), Misc.getNegativeHighlightColor());
                        }
                    } else if (withText) {
                        this.addText(this.getString("enemyDisruptedPlayer"), this.getString("highlightDisruptedPlayer"), Misc.getNegativeHighlightColor());
                    }
                    pursueTooltip = "tooltipPursueSeriousLosses";
                    break;
                }
                case TOO_SLOW: {
                    pursueTooltip = "tooltipPursueTooSlow";
                }
            }
            switch (dha) {
                case AVAILABLE: {
                    canHasass = true;
                    break;
                }
                case NO_READY_SHIPS: {
                    harassTooltip = "tooltipNoReadyShips";
                }
            }
            if (this.ongoingBattle) {
                boolean letGo;
                boolean station = false;
                if (this.playerFleet != null) {
                    for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
                        if (!member.isStation()) continue;
                        station = true;
                        break;
                    }
                }
                boolean bl = letGo = !canPursue && !canHasass || !allyHasReadyShips;
                if (station) {
                    letGo = false;
                    alliedWantsToFight = true;
                }
                CampaignFleetAIAPI.PursuitOption po = this.pickPursuitOption(this.playerFleet, this.otherFleet, this.context);
                po = CampaignFleetAIAPI.PursuitOption.PURSUE;
                if (alliedWantsToRun || alliedHolding || !alliedWantsToFight || letGo) {
                    po = CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
                }
                if (!canPursue && canHasass) {
                    po = CampaignFleetAIAPI.PursuitOption.HARRY;
                }
                switch (po) {
                    case PURSUE: {
                        if (withText) {
                            this.addText(this.getString("ongoingBattlePursue"));
                        }
                        this.playerGoal = FleetGoal.ATTACK;
                        this.otherGoal = FleetGoal.ESCAPE;
                        this.options.addOption("Join the pursuit", (Object)OptionId.CONTINUE_ONGOING_BATTLE, this.getString(pursueTooltip));
                        if (canPursue && playerHasReadyShips) break;
                        this.options.setEnabled((Object)OptionId.CONTINUE_ONGOING_BATTLE, false);
                        break;
                    }
                    case HARRY: {
                        this.context.applyPursuitOption(this.playerFleet, this.otherFleet, po);
                        if (withText) {
                            this.addText(this.getString("ongoingBattleHarass"));
                        }
                        this.context.setEngagedInHostilities(true);
                        this.context.getDataFor(this.playerFleet).setDisengaged(false);
                        this.context.getDataFor(this.otherFleet).setDisengaged(true);
                        this.allyEngagementChoiceNoBattle = true;
                        this.harryEndedBattle = true;
                        break;
                    }
                    case LET_THEM_GO: {
                        letGo = true;
                        if (this.context.isEngagedInHostilities()) {
                            this.context.getDataFor(this.playerFleet).setDisengaged(false);
                            this.context.getDataFor(this.otherFleet).setDisengaged(true);
                        }
                        this.allyEngagementChoiceNoBattle = true;
                    }
                }
                if (letGo) {
                    if (withText) {
                        this.addText(this.getString("ongoingBattleLetGo"));
                    }
                    this.allyEngagementChoiceNoBattle = true;
                }
                if (this.context.isEngagedInHostilities() && this.context.isBattleOver()) {
                    this.goToEncounterEndPath();
                } else if (this.context.isEngagedInHostilities()) {
                    this.options.addOption("Perform a salvage operation, then leave", (Object)OptionId.LOOT_THEN_LEAVE, null);
                    this.options.setShortcut((Object)OptionId.LOOT_THEN_LEAVE, 1, false, false, false, true);
                } else {
                    this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                    this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                }
            } else {
                FactionAPI nonHostile;
                boolean lowImpact;
                boolean knows;
                CampaignFleetAIAPI ai = this.otherFleet.getAI();
                boolean hostile = false;
                if (ai != null) {
                    hostile = ai.isHostileTo(this.playerFleet) || this.context.isEngagedInHostilities();
                }
                this.options.addOption("Pursue them", (Object)OptionId.PURSUE, this.getString(pursueTooltip));
                if (playerHasReadyShips) {
                    this.options.addOption("Maneuver to force a pitched battle", (Object)OptionId.FORCE_ENGAGE, "Outmaneuver the opposing fleet, forcing them to fight you head on.");
                    knows = this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide() != null && this.context.getBattle().knowsWhoPlayerIs(this.context.getBattle().getNonPlayerSide());
                    lowImpact = this.context.isLowRepImpact() || this.context.isNoRepImpact();
                    nonHostile = this.getNonHostileOtherFaction();
                    if (nonHostile != null && knows && !lowImpact && !this.context.isEngagedInHostilities() && this.config.showWarningDialogWhenNotHostile) {
                        this.options.addOptionConfirmation((Object)OptionId.FORCE_ENGAGE, "The " + nonHostile.getDisplayNameLong() + " " + nonHostile.getDisplayNameIsOrAre() + " not currently hostile, and you have been positively identified. Are you sure you want to attack one of their fleets?", "Yes", "Never mind");
                    }
                } else {
                    this.options.addOption("Maneuver to force a pitched battle", (Object)OptionId.ENGAGE, this.getString("tooltipNoReadyShips"));
                    this.options.setEnabled((Object)OptionId.FORCE_ENGAGE, false);
                }
                SetStoryOption.set(this.dialog, 1, (Object)OptionId.FORCE_ENGAGE, "forceBattle", Sounds.STORY_POINT_SPEND_COMBAT, "Maneuvered to force pitched battle with " + this.otherFleet.getNameWithFactionKeepCase());
                this.options.addOption("Harry their retreat", (Object)OptionId.HARRY_PURSUE, this.getString(harassTooltip));
                knows = this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide() != null && this.context.getBattle().knowsWhoPlayerIs(this.context.getBattle().getNonPlayerSide());
                lowImpact = this.context.isLowRepImpact() || this.context.isNoRepImpact();
                nonHostile = this.getNonHostileOtherFaction();
                if (nonHostile != null && knows && !lowImpact && !this.context.isEngagedInHostilities() && this.config.showWarningDialogWhenNotHostile) {
                    this.options.addOptionConfirmation((Object)OptionId.HARRY_PURSUE, "The " + nonHostile.getDisplayNameLong() + " " + nonHostile.getDisplayNameIsOrAre() + " not currently hostile, and you have been positively identified. Are you sure you want to engage in hostilities with one of their fleets?", "Yes", "Never mind");
                    this.options.addOptionConfirmation((Object)OptionId.PURSUE, "The " + nonHostile.getDisplayNameLong() + " " + nonHostile.getDisplayNameIsOrAre() + " not currently hostile, and you have been positively identified. Are you sure you want to engage in hostilities with one of their fleets?", "Yes", "Never mind");
                }
                if (hostile) {
                    this.options.addOption("Let them go", (Object)OptionId.LET_THEM_GO, this.getString(letThemGoTooltip));
                } else {
                    this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                    this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                }
                if (!canPursue || !playerHasReadyShips) {
                    this.options.setEnabled((Object)OptionId.PURSUE, false);
                }
                if (!canHasass || !playerHasReadyShips) {
                    this.options.setEnabled((Object)OptionId.HARRY_PURSUE, false);
                }
            }
        } else if (this.ongoingBattle) {
            if (alliedWantsToRun) {
                if (withText && !this.config.straightToEngage) {
                    this.addText(this.getString("ongoingBattleDisengage"));
                }
                this.playerGoal = FleetGoal.ESCAPE;
                this.otherGoal = FleetGoal.ATTACK;
                this.options.addOption("Join the disengage attempt", (Object)OptionId.CONTINUE_ONGOING_BATTLE, null);
            } else {
                boolean station = false;
                if (this.playerFleet != null) {
                    for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
                        if (!member.isStation()) continue;
                        station = true;
                        break;
                    }
                }
                if (withText && !this.config.straightToEngage) {
                    if (station) {
                        this.addText(this.getString("ongoingBattleStation"));
                    } else {
                        this.addText(this.getString("ongoingBattleEngage"));
                    }
                }
                this.playerGoal = FleetGoal.ATTACK;
                this.otherGoal = FleetGoal.ATTACK;
                if (playerHasReadyShips) {
                    this.options.addOption("Join the engagement", (Object)OptionId.CONTINUE_ONGOING_BATTLE, null);
                } else {
                    this.options.addOption("Join the engagement", (Object)OptionId.CONTINUE_ONGOING_BATTLE, this.getString("tooltipNoReadyShips"));
                    this.options.setEnabled((Object)OptionId.CONTINUE_ONGOING_BATTLE, false);
                }
                this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
            }
        } else {
            String engageText = "Move in to engage";
            if (this.config.firstTimeEngageOptionText != null && !this.context.isEngagedInHostilities()) {
                engageText = this.config.firstTimeEngageOptionText;
            }
            if (this.config.afterFirstTimeEngageOptionText != null && this.context.isEngagedInHostilities()) {
                engageText = this.config.afterFirstTimeEngageOptionText;
            }
            if (playerHasReadyShips) {
                this.options.addOption(engageText, (Object)OptionId.ENGAGE, this.getString("tooltipEngage"));
                boolean knows = this.context.getBattle() != null && this.context.getBattle().getNonPlayerSide() != null && this.context.getBattle().knowsWhoPlayerIs(this.context.getBattle().getNonPlayerSide());
                boolean lowImpact = this.context.isLowRepImpact() || this.context.isNoRepImpact();
                FactionAPI nonHostile = this.getNonHostileOtherFaction();
                if (nonHostile != null && knows && !lowImpact && !this.context.isEngagedInHostilities() && this.config.showWarningDialogWhenNotHostile) {
                    this.options.addOptionConfirmation((Object)OptionId.ENGAGE, "The " + nonHostile.getDisplayNameLong() + " " + nonHostile.getDisplayNameIsOrAre() + " not currently hostile, and you have been positively identified. Are you sure you want to attack one of their fleets?", "Yes", "Never mind");
                }
            } else {
                this.options.addOption(engageText, (Object)OptionId.ENGAGE, this.getString("tooltipNoReadyShips"));
                this.options.setEnabled((Object)OptionId.ENGAGE, false);
            }
            CampaignFleetAIAPI ai = this.otherFleet.getAI();
            boolean hostile = false;
            if (ai != null) {
                boolean bl = hostile = ai.isHostileTo(this.playerFleet) || this.context.isEngagedInHostilities();
            }
            if (!this.config.leaveAlwaysAvailable && (this.otherFleetWantsToFight() || hostile && !this.otherFleetWantsToDisengage())) {
                if (this.canDisengageCleanly(this.playerFleet)) {
                    this.options.addOption("Disengage", (Object)OptionId.DISENGAGE, this.getString("tooltipCleanDisengage"));
                } else if (this.canDisengageWithoutPursuit(this.playerFleet) && (this.otherFleetWantsToFight() || this.otherFleetWantsToDisengage())) {
                    this.options.addOption("Disengage", (Object)OptionId.DISENGAGE, this.getString("tooltipHarrassableDisengage"));
                } else if (this.otherFleetHoldingVsStrongerEnemy() || !this.otherFleetWantsToFight() && !this.otherFleetWantsToDisengage()) {
                    this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                    this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                } else {
                    boolean addSPDisengage = true;
                    if (FleetInteractionDialogPluginImpl.canDisengage() || !playerHasReadyShips) {
                        this.options.addOption("Attempt to disengage", (Object)OptionId.ATTEMPT_TO_DISENGAGE, this.getString("tootipAttemptToDisengage"));
                        addSPDisengage = true;
                    } else {
                        boolean hasStation = false;
                        boolean allStation = true;
                        for (CampaignFleetAPI curr : this.context.getBattle().getSideFor(this.otherFleet)) {
                            allStation &= curr.isStationMode();
                            hasStation |= curr.isStationMode();
                        }
                        if (hasStation) {
                            if (allStation) {
                                this.options.addOption("Disengage", (Object)OptionId.DISENGAGE, this.getString("tooltipCleanDisengage"));
                            } else {
                                this.options.addOption("Disengage", (Object)OptionId.DISENGAGE, this.getString("tooltipHarrassableDisengage"));
                            }
                            addSPDisengage = false;
                        } else if (withText && !this.shownTooLargeToRetreatMessage) {
                            this.shownTooLargeToRetreatMessage = true;
                            LabelAPI label = this.textPanel.addParagraph(this.getString("playerTooLargeToDisengage"));
                            label.setHighlight(this.getString("highlightTooLarge"), this.getString("highlightDisengage"));
                            label.setHighlightColors(Misc.getNegativeHighlightColor(), Misc.getHighlightColor());
                        }
                    }
                    if (addSPDisengage) {
                        this.options.addOption("Disengage by executing a series of special maneuvers", (Object)OptionId.CLEAN_DISENGAGE, "Allows your fleet to disengage without being pursued.");
                        SetStoryOption.set(this.dialog, 1, (Object)OptionId.CLEAN_DISENGAGE, "cleanDisengage", Sounds.STORY_POINT_SPEND_COMBAT, "Maneuvered to disengage from " + this.otherFleet.getNameWithFactionKeepCase());
                        this.addEmergencyRepairsOption();
                    }
                }
            } else {
                this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
            }
        }
        if (this.playerOutBeforeAllies() && !this.options.hasOption((Object)OptionId.LEAVE) && !this.options.hasOption((Object)OptionId.LET_THEM_GO) && !this.options.hasOption((Object)OptionId.DISENGAGE)) {
            this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
            this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        }
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    protected void addEmergencyRepairsOption() {
        if (this.didRepairs) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        final ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
        final float crThreshold = CRPluginImpl.MALFUNCTION_START;
        float hullThreshold = 0.4f;
        float bonusRepairAmount = 0.1f;
        FleetMemberAPI flagship = fleet.getFlagship();
        if (flagship != null && !flagship.isMothballed() && (flagship.getStatus().getHullFraction() < 0.4f || flagship.getRepairTracker().getBaseCR() < crThreshold)) {
            members.add(flagship);
        }
        for (FleetMemberAPI curr : fleet.getFleetData().getMembersListCopy()) {
            if (curr == flagship || curr.isMothballed()) continue;
            if (!curr.getCaptain().isDefault() && (curr.getStatus().getHullFraction() < 0.4f || curr.getRepairTracker().getBaseCR() < crThreshold)) {
                members.add(curr);
            }
            if (members.size() > 12) break;
        }
        if (members.isEmpty()) {
            return;
        }
        this.options.addOption("Perform limited emergency repairs", (Object)OptionId.EMERGENCY_REPAIRS, "Brings your flagship and a few officer-controlled ships back up to reasonable combat readiness and repairs some hull damage.");
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams((Object)OptionId.EMERGENCY_REPAIRS, 1, "emergencyRepairs", Sounds.STORY_POINT_SPEND_COMBAT, "Performed emergency repairs when facing " + this.otherFleet.getNameWithFactionKeepCase());
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                float dpUsed = 0.0f;
                for (FleetMemberAPI member : members) {
                    float repairedHull;
                    float hull;
                    float repairedCR;
                    float dpRemaining = EMERGENCY_REPAIRS_MAX_DP - dpUsed;
                    float shipDP = member.getDeploymentPointsCost();
                    dpUsed += shipDP;
                    float fraction = dpRemaining / shipDP;
                    if (fraction >= 0.99f) {
                        fraction = 1.0f;
                    }
                    float baseRepairCRLevel = crThreshold + 0.1f * (float)Math.random();
                    float baseRepairHullLevel = 0.4f + 0.1f * (float)Math.random();
                    float cr = member.getRepairTracker().getBaseCR();
                    if (cr < (repairedCR = cr + (baseRepairCRLevel - cr) * fraction)) {
                        member.getRepairTracker().applyCREvent(repairedCR - cr, "Emergency repairs");
                    }
                    if ((hull = member.getStatus().getHullFraction()) < (repairedHull = hull + (baseRepairHullLevel - hull) * fraction)) {
                        member.getStatus().setHullFraction(repairedHull);
                    }
                    String str = BaseSkillEffectDescription.getValueLabelForMember(member);
                    FleetInteractionDialogPluginImpl.this.textPanel.setFontSmallInsignia();
                    FleetInteractionDialogPluginImpl.this.textPanel.addPara(String.valueOf(str) + " performed emergency repairs", Misc.getPositiveHighlightColor());
                    FleetInteractionDialogPluginImpl.this.textPanel.highlightFirstInLastPara(str, Misc.getHighlightColor());
                    FleetInteractionDialogPluginImpl.this.textPanel.setFontInsignia();
                    if (fraction < 1.0f) break;
                }
                FleetInteractionDialogPluginImpl.this.didRepairs = true;
                FleetInteractionDialogPluginImpl.this.playerFleet.getFleetData().setSyncNeeded();
                FleetInteractionDialogPluginImpl.this.playerFleet.getFleetData().syncIfNeeded();
                this.dialog.getOptionPanel().setEnabled((Object)OptionId.EMERGENCY_REPAIRS, false);
            }

            public void createDescription(TooltipMakerAPI info) {
                super.createDescription(info);
                info.setParaFontDefault();
                float opad = 10.0f;
                float pad = 3.0f;
                info.addPara("Will bring up to %s deployment points worth of ships up to approximately %s combat readiness and %s hull integrity. Starts with the flagship and then goes on to officer-controlled ships, in the order they are placed in the fleet. Does not affect other ships.", 0.0f, Misc.getHighlightColor(), "" + (int)EMERGENCY_REPAIRS_MAX_DP, Math.round((crThreshold + 0.1f) * 100.0f) + "%", Math.round(50.0f) + "%");
                info.addPara("The repairs will affect:", opad);
                info.setBulletedListMode("      ");
                float initPad = 10.0f;
                float dpUsed = 0.0f;
                for (FleetMemberAPI member : members) {
                    float dpRemaining = EMERGENCY_REPAIRS_MAX_DP - dpUsed;
                    float shipDP = member.getDeploymentPointsCost();
                    dpUsed += shipDP;
                    dpUsed += shipDP;
                    float fraction = dpRemaining / shipDP;
                    if (fraction >= 0.99f) {
                        fraction = 1.0f;
                    }
                    String str = BaseSkillEffectDescription.getValueLabelForMember(member);
                    String post = " (full effect)";
                    if (fraction < 1.0f) {
                        post = " (partial effect)";
                    }
                    info.addPara(String.valueOf(str) + post, initPad);
                    initPad = 0.0f;
                    if (dpUsed >= EMERGENCY_REPAIRS_MAX_DP) break;
                }
                info.setBulletedListMode(null);
                info.addSpacer(20.0f);
            }
        });
    }

    protected CampaignFleetAIAPI.PursuitOption pickPursuitOption(CampaignFleetAPI fleet, CampaignFleetAPI other, FleetEncounterContext context) {
        context.setNoHarryBecauseOfStation(false);
        if (fleet.getAI() == null) {
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        if (this.config.alwaysPursue) {
            return CampaignFleetAIAPI.PursuitOption.PURSUE;
        }
        boolean allStation = false;
        boolean hasStation = false;
        if (context.getBattle() != null) {
            allStation = true;
            for (CampaignFleetAPI curr : context.getBattle().getSideFor(fleet)) {
                allStation &= curr.isStationMode();
                hasStation |= curr.isStationMode();
            }
        }
        CampaignFleetAIAPI.PursuitOption option = fleet.getAI().pickPursuitOption(context, other);
        if (hasStation && option == CampaignFleetAIAPI.PursuitOption.HARRY) {
            context.setNoHarryBecauseOfStation(true);
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        return option;
    }

    public FactionAPI getNonHostileOtherFaction() {
        if (this.context.getBattle() == null) {
            return null;
        }
        FactionAPI player = Global.getSector().getPlayerFaction();
        int max = -1;
        SectorEntityToken result = null;
        List<CampaignFleetAPI> otherSide = this.context.getBattle().getNonPlayerSide();
        if (otherSide != null) {
            for (CampaignFleetAPI other : otherSide) {
                if (player.isHostileTo(other.getFaction()) || other.getFleetPoints() <= max) continue;
                result = other;
                max = other.getFleetPoints();
            }
        }
        return result == null ? null : result.getFaction();
    }

    protected boolean playerOutBeforeAllies() {
        FleetEncounterContextPlugin.EngagementOutcome last = this.context.getLastEngagementOutcome();
        return last == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_WIN || last == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_LOSS || last == FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_WIN || last == FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_LOSS || last == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_WIN || last == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_LOSS;
    }

    public static boolean canDisengage() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float total = 0.0f;
        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat()) continue;
            total += member.getDeploymentPointsCost();
        }
        return total <= FleetInteractionDialogPluginImpl.getDisengageSize();
    }

    protected boolean otherCanDisengage() {
        return this.fleetCanDisengage(this.otherFleet);
    }

    protected boolean alliedCanDisengage() {
        return this.fleetCanDisengage(this.playerFleet);
    }

    protected boolean fleetCanDisengage(CampaignFleetAPI fleet) {
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat()) continue;
            total += member.getDeploymentPointsCost();
        }
        return total <= FleetInteractionDialogPluginImpl.getDisengageSize();
    }

    public static float getDisengageSize() {
        float abs = Global.getSettings().getFloat("maxDisengageSize");
        float fraction = Global.getSettings().getFloat("maxDisengageFraction") * (float)Global.getSettings().getBattleSize();
        return Math.min(abs, fraction);
    }

    protected boolean didEnoughToDisengage(CampaignFleetAPI fleet) {
        FleetEncounterContextPlugin.DataForEncounterSide data = this.context.getDataFor(fleet);
        return data.isDidEnoughToDisengage();
    }

    protected boolean canDisengageCleanly(CampaignFleetAPI fleet) {
        FleetEncounterContextPlugin.DataForEncounterSide data = this.context.getDataFor(fleet);
        if (data.isWonLastEngagement()) {
            return true;
        }
        if (data.isDidEnoughToDisengage()) {
            return true;
        }
        if (fleet == this.playerFleet) {
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                if (!member.isStation()) continue;
                return true;
            }
        }
        FleetEncounterContextPlugin.EngagementOutcome last = this.context.getLastEngagementOutcome();
        return fleet == this.playerFleet && !this.ongoingBattle && (last == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_WIN || last == FleetEncounterContextPlugin.EngagementOutcome.BATTLE_PLAYER_OUT_FIRST_LOSS || last == FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_WIN || last == FleetEncounterContextPlugin.EngagementOutcome.PURSUIT_PLAYER_OUT_FIRST_LOSS || last == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_WIN || last == FleetEncounterContextPlugin.EngagementOutcome.ESCAPE_PLAYER_OUT_FIRST_LOSS);
    }

    protected boolean canDisengageWithoutPursuit(CampaignFleetAPI fleet) {
        FleetEncounterContextPlugin.PursueAvailability pa;
        CampaignFleetAPI other = this.playerFleet;
        if (other == fleet) {
            other = this.otherFleet;
        }
        return (pa = this.getPursuitAvailability(other)) != FleetEncounterContextPlugin.PursueAvailability.AVAILABLE;
    }

    protected FleetEncounterContextPlugin.PursueAvailability getPursuitAvailability(CampaignFleetAPI fleet) {
        FleetEncounterContextPlugin.PursueAvailability pa;
        CampaignFleetAPI other = this.playerFleet;
        if (other == fleet) {
            other = this.otherFleet;
        }
        if ((pa = this.context.getPursuitAvailability(fleet, other)) == FleetEncounterContextPlugin.PursueAvailability.TOO_SLOW && fleet == this.playerFleet) {
            pa = FleetEncounterContextPlugin.PursueAvailability.AVAILABLE;
        }
        return pa;
    }

    protected String getString(String id) {
        BattleAPI b;
        FleetEncounterContextPlugin.DataForEncounterSide data;
        String str = Global.getSettings().getString("fleetInteractionDialog", id);
        String faction = this.otherFleet.getFaction().getEntityNamePrefix();
        if (faction == null || faction.isEmpty()) {
            faction = this.otherFleet.getFaction().getDisplayName();
        }
        if (this.otherFleet.getFaction().isNeutralFaction()) {
            faction = "opposing";
        }
        String fleetName = this.otherFleet.getName();
        String firstName = this.otherFleet.getCommander().getName().getFirst();
        String lastName = this.otherFleet.getCommander().getName().getLast();
        String fleetOrShip = "fleet";
        if (this.otherFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.otherFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        String playerFleetOrShip = "fleet";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            playerFleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                playerFleetOrShip = "fighter wing";
            }
        }
        if ((data = this.context.getDataFor(this.playerFleet)) != null) {
            int crewLost = data.getCrewLossesDuringLastEngagement().getCrewInt();
            String crewLostStr = this.getApproximate(crewLost);
            int marinesLost = (int)data.getCrewLossesDuringLastEngagement().getMarines();
            String marinesLostStr = this.getApproximate(marinesLost);
            int crewRecovered = data.getRecoverableCrewLosses().getCrewInt();
            int marinesRecovered = (int)data.getRecoverableCrewLosses().getMarines();
            String crewRecStr = "" + crewRecovered;
            if (crewRecovered <= 0) {
                crewRecStr = "no";
            }
            String marinesRecStr = "" + marinesRecovered;
            if (marinesRecovered <= 0) {
                marinesRecStr = "no";
            }
            str = str.replaceAll("\\$crewLost", crewLostStr);
            str = str.replaceAll("\\$marinesLost", marinesLostStr);
            str = str.replaceAll("\\$crewLost", crewLostStr);
            str = str.replaceAll("\\$crewRecovered", crewRecStr);
            str = str.replaceAll("\\$marinesRecovered", marinesRecStr);
        }
        if (this.toBoard != null) {
            int numLifeSigns = (int)(this.toBoard.getCrewComposition().getCrew() + this.toBoard.getCrewComposition().getMarines());
            str = str.replaceAll("\\$numLifeSigns", this.getApproximate(numLifeSigns));
            str = str.replaceAll("\\$boardableShipName", this.toBoard.getShipName());
        }
        str = str.replaceAll("\\$faction", faction);
        str = str.replaceAll("\\$fleetName", fleetName);
        str = str.replaceAll("\\$firstName", firstName);
        str = str.replaceAll("\\$lastName", lastName);
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        str = str.replaceAll("\\$playerFleetOrShip", playerFleetOrShip);
        if (this.selectedFlagship != null) {
            str = str.replaceAll("\\$flagship", "the " + this.selectedFlagship.getShipName());
        }
        str = str.replaceAll("\\$creditsLooted", this.creditsLooted);
        if (this.crashMothballList != null) {
            str = str.replaceAll("\\$crashMothballList", this.crashMothballList);
        }
        if (this.repairedShipList != null) {
            str = str.replaceAll("\\$repairedShipList", this.repairedShipList);
        }
        int marines = Global.getSector().getPlayerFleet().getCargo().getMarines();
        str = str.replaceAll("\\$marines", "" + marines);
        str = str.replaceAll("\\$boardingSuccessChance", (int)this.boardingPercentSuccess + "%");
        if (this.boardingResult != null) {
            str = str.replaceAll("\\$boardingCrewLost", this.getIntOrNo(this.boardingResult.getAttackerLosses().getCrew()));
            str = str.replaceAll("\\$boardingMarinesLost", this.getIntOrNo(this.boardingResult.getAttackerLosses().getMarines()));
            str = str.replaceAll("\\$boardingEnemyCrewLost", this.getIntOrNo(this.boardingResult.getDefenderLosses().getCrew()));
            str = str.replaceAll("\\$boardingEnemyMarinesLost", this.getIntOrNo(this.boardingResult.getDefenderLosses().getMarines()));
        }
        if ((b = this.context.getBattle()) != null) {
            BattleAPI.BattleSide playerSide = b.pickSide(Global.getSector().getPlayerFleet());
            CampaignFleetAPI sideOnePrimary = b.getPrimary(b.getSideOne());
            CampaignFleetAPI sideTwoPrimary = b.getPrimary(b.getSideTwo());
            if (playerSide != BattleAPI.BattleSide.NO_JOIN) {
                sideOnePrimary = b.getPrimary(b.getSide(playerSide));
                sideTwoPrimary = b.getPrimary(b.getOtherSide(playerSide));
            }
            if (sideOnePrimary != null) {
                String strOne = String.valueOf(sideOnePrimary.getFaction().getEntityNamePrefix()) + " forces";
                if (strOne.startsWith(" ")) {
                    strOne = String.valueOf(sideOnePrimary.getFaction().getDisplayName()) + " forces";
                }
                for (CampaignFleetAPI fleet : b.getSideFor(sideOnePrimary)) {
                    if (fleet.getFaction() == sideOnePrimary.getFaction() || fleet.isPlayerFleet()) continue;
                    strOne = String.valueOf(strOne) + " and their allies";
                    break;
                }
                str = str.replaceAll("\\$alliedFactionAndTheirAllies", strOne);
            }
            if (sideTwoPrimary != null) {
                String strTwo = String.valueOf(sideTwoPrimary.getFaction().getEntityNamePrefix()) + " forces";
                if (strTwo.startsWith(" ")) {
                    strTwo = String.valueOf(sideTwoPrimary.getFaction().getDisplayName()) + " forces";
                }
                for (CampaignFleetAPI fleet : b.getSideFor(sideTwoPrimary)) {
                    if (fleet.getFaction() == sideTwoPrimary.getFaction() || fleet.isPlayerFleet()) continue;
                    strTwo = String.valueOf(strTwo) + " and their allies";
                    break;
                }
                str = str.replaceAll("\\$enemyFactionAndTheirAllies", strTwo);
            }
            String yourForcesWere = "Your forces were";
            if (b.getPlayerSide() != null && b.getPlayerSide().size() > 1) {
                yourForcesWere = "Your side was";
            }
            str = str.replaceAll("\\$yourForcesWereOrYourSideWas", yourForcesWere);
        }
        return str;
    }

    protected String getIntOrNo(float value) {
        if (value < 1.0f) {
            return "no";
        }
        return "" + (int)value;
    }

    protected String getApproximate(float value) {
        int v = (int)value;
        String str = "multiple";
        if (v <= 0) {
            str = "no";
        } else if (v < 10) {
            str = "" + v;
        } else if (v < 100) {
            v = Math.round((float)v / 10.0f) * 10;
            str = "approximately " + v;
        } else if (v < 1000) {
            v = Math.round((float)v / 10.0f) * 10;
            str = "approximately " + v;
        } else {
            v = Math.round((float)v / 100.0f) * 100;
            str = "" + v;
        }
        return str;
    }

    protected String getApproximateNumOnly(float value) {
        int v = (int)value;
        String str = "";
        if (v <= 0) {
            str = "asdasd";
        } else if (v < 10) {
            str = "" + v;
        } else if (v < 100) {
            v = Math.round((float)v / 10.0f) * 10;
            str = "" + v;
        } else if (v < 1000) {
            v = Math.round((float)v / 10.0f) * 10;
            str = "" + v;
        } else {
            v = Math.round((float)v / 100.0f) * 100;
            str = "" + v;
        }
        return str;
    }

    protected boolean isFightingOver() {
        return this.context.isBattleOver() || this.context.getDataFor(this.otherFleet).disengaged() && this.context.getDataFor(this.playerFleet).disengaged();
    }

    public boolean alliedFleetWantsToFight() {
        return this.fleetWantsToFight(this.playerFleet, this.otherFleet);
    }

    public boolean otherFleetWantsToFight() {
        return this.fleetWantsToFight(this.otherFleet, this.playerFleet);
    }

    public boolean otherFleetWantsToFight(boolean assumeHostile) {
        return this.fleetWantsToFight(this.otherFleet, this.playerFleet, assumeHostile);
    }

    protected boolean fleetWantsToFight(CampaignFleetAPI fleet, CampaignFleetAPI other) {
        return this.fleetWantsToFight(fleet, other, false);
    }

    protected boolean fleetWantsToFight(CampaignFleetAPI fleet, CampaignFleetAPI other, boolean assumeHostile) {
        if (this.config.alwaysAttackVsAttack) {
            return true;
        }
        boolean hasNonCivReserves = false;
        for (FleetMemberAPI member : this.context.getDataFor(fleet).getInReserveDuringLastEngagement()) {
            if (member.isCivilian()) continue;
            hasNonCivReserves = true;
            break;
        }
        if (this.context.isEngagedInHostilities() && !this.context.getDataFor(fleet).isWonLastEngagement() && !hasNonCivReserves) {
            return false;
        }
        CampaignFleetAIAPI ai = fleet.getAI();
        if (ai == null) {
            return false;
        }
        CampaignFleetAIAPI.EncounterOption option = ai.pickEncounterOption(this.context, other);
        if (fleet.getMemoryWithoutUpdate().getBoolean("$cfai_makeAllowDisengage")) {
            return false;
        }
        return (ai.isHostileTo(other) || this.context.isEngagedInHostilities() || assumeHostile || fleet.getMemoryWithoutUpdate().getBoolean("$cfai_makePreventDisengage")) && (option == CampaignFleetAIAPI.EncounterOption.ENGAGE || option == CampaignFleetAIAPI.EncounterOption.HOLD && this.ongoingBattle);
    }

    protected boolean alliedFleetHoldingVsStrongerEnemy() {
        return this.fleetHoldingVsStrongerEnemy(this.playerFleet, this.otherFleet);
    }

    protected boolean otherFleetHoldingVsStrongerEnemy() {
        return this.fleetHoldingVsStrongerEnemy(this.otherFleet, this.playerFleet);
    }

    protected boolean fleetHoldingVsStrongerEnemy(CampaignFleetAPI fleet, CampaignFleetAPI other) {
        boolean hostile;
        CampaignFleetAIAPI ai = fleet.getAI();
        if (ai == null) {
            return false;
        }
        boolean bl = hostile = ai.isHostileTo(other) || other.getAI() != null && other.getAI().isHostileTo(fleet) || this.context.isEngagedInHostilities();
        if (!hostile) {
            return false;
        }
        if (ai.pickEncounterOption(this.context, other) == CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER) {
            return true;
        }
        return this.fleetWantsToDisengage(fleet, other) && !this.fleetCanDisengage(fleet);
    }

    protected boolean alliedFleetWantsToDisengage() {
        return this.fleetWantsToDisengage(this.playerFleet, this.otherFleet);
    }

    protected boolean otherFleetWantsToDisengage() {
        return this.fleetWantsToDisengage(this.otherFleet, this.playerFleet);
    }

    protected boolean fleetWantsToDisengage(CampaignFleetAPI fleet, CampaignFleetAPI other) {
        if (this.config.alwaysAttackVsAttack) {
            return false;
        }
        boolean hasNonCivReserves = false;
        for (FleetMemberAPI member : this.context.getDataFor(fleet).getInReserveDuringLastEngagement()) {
            if (member.isCivilian()) continue;
            hasNonCivReserves = true;
            break;
        }
        if (this.context.isEngagedInHostilities() && !this.context.getDataFor(fleet).isWonLastEngagement() && !hasNonCivReserves) {
            return true;
        }
        CampaignFleetAIAPI ai = fleet.getAI();
        if (ai == null) {
            return false;
        }
        return ai.pickEncounterOption(this.context, other) == CampaignFleetAIAPI.EncounterOption.DISENGAGE;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void updateMemory() {
        if (this.conversationDelegate != null) {
            this.conversationDelegate.updateMemory();
        }
    }

    @Override
    public void notifyActivePersonChanged() {
        if (this.conversationDelegate != null) {
            this.conversationDelegate.notifyActivePersonChanged();
        }
    }

    @Override
    public void setActiveMission(CampaignEventPlugin mission) {
        if (mission == null) {
            this.conversationDelegate.getMemoryMap().remove("mission");
        } else {
            MemoryAPI memory = mission.getMemory();
            if (memory != null) {
                this.conversationDelegate.getMemoryMap().put("mission", memory);
            } else {
                this.conversationDelegate.getMemoryMap().remove("mission");
            }
        }
    }

    public void setPlayerFleet(CampaignFleetAPI playerFleet) {
        this.playerFleet = playerFleet;
    }

    public static class BaseFIDDelegate
    implements FIDDelegate {
        public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
        }

        public void notifyLeave(InteractionDialogAPI dialog) {
        }

        public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
        }
    }

    public static class FIDConfig {
        public boolean showCommLinkOption = true;
        public boolean leaveAlwaysAvailable = false;
        public boolean showWarningDialogWhenNotHostile = true;
        public boolean showTransponderStatus = true;
        public boolean showFleetAttitude = true;
        public boolean showEngageText = true;
        public boolean alwaysAttackVsAttack = false;
        public boolean alwaysPursue = false;
        public boolean dismissOnLeave = true;
        public boolean withSalvage = true;
        public boolean lootCredits = true;
        public boolean showVictoryText = true;
        public boolean impactsEnemyReputation = true;
        public boolean impactsAllyReputation = true;
        public boolean pullInAllies = true;
        public boolean pullInEnemies = true;
        public boolean pullInStations = true;
        public String noSalvageLeaveOptionText = null;
        public String firstTimeEngageOptionText = null;
        public String afterFirstTimeEngageOptionText = null;
        public FIDDelegate delegate = null;
        public boolean printXPToDialog = false;
        public boolean justShowFleets = false;
        public boolean showPullInText = true;
        public boolean straightToEngage = false;
        public boolean playerAttackingStation = false;
        public boolean playerDefendingStation = false;
        public Random salvageRandom = null;
    }

    public static interface FIDConfigGen {
        public FIDConfig createConfig();
    }

    public static interface FIDDelegate {
        public void postPlayerSalvageGeneration(InteractionDialogAPI var1, FleetEncounterContext var2, CargoAPI var3);

        public void battleContextCreated(InteractionDialogAPI var1, BattleCreationContext var2);

        public void notifyLeave(InteractionDialogAPI var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        PRINT_ONGOING_BATTLE_INFO,
        BEGIN_FLEET_ENCOUNTER_2,
        OPEN_COMM,
        CUT_COMM,
        ENGAGE,
        FORCE_ENGAGE,
        ATTEMPT_TO_DISENGAGE,
        DISENGAGE,
        CLEAN_DISENGAGE,
        SCUTTLE,
        PURSUE,
        AUTORESOLVE_PURSUE,
        HARRY_PURSUE,
        LET_THEM_GO,
        LEAVE,
        LOOT_THEN_LEAVE,
        CONTINUE_LEAVE,
        CONTINUE,
        GO_TO_MAIN,
        GO_TO_PRE_BATTLE,
        RECOVERY_SELECT,
        RECOVERY_CONTINUE,
        CONTINUE_FROM_VICTORY_TRIGGERS,
        CONTINUE_LOOT,
        CONTINUE_INTO_BATTLE,
        CONTINUE_INTO_BOARDING,
        BOARDING_ACTION,
        SELECT_FLAGSHIP,
        CRASH_MOTHBALL,
        ENGAGE_BOARDABLE,
        ABORT_BOARDING_ACTION,
        HARD_DOCK,
        LAUNCH_ASSAULT_TEAMS,
        LET_IT_GO,
        SELECTOR_MARINES,
        SELECTOR_CREW,
        REINIT_CONTINUE,
        INITIATE_BATTLE,
        JOIN_ONGOING_BATTLE,
        CONTINUE_ONGOING_BATTLE,
        EMERGENCY_REPAIRS,
        DEV_MODE_ESCAPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VisualType {
        FLEET_INFO,
        OTHER;

    }
}

