/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.ExplosionEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GateEntityPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class GateExplosionScript
implements EveryFrameScript {
    public static float UNSTABLE_DAYS_MIN = 200.0f;
    public static float UNSTABLE_DAYS_MAX = 400.0f;
    protected boolean done = false;
    protected boolean playedWindup = false;
    protected SectorEntityToken explosion = null;
    protected float delay = 0.5f;
    protected float delay2 = 1.0f;
    protected SectorEntityToken gate;

    public GateExplosionScript(SectorEntityToken gate) {
        this.gate = gate;
        StarSystemAPI system = gate.getStarSystem();
        if (system != null) {
            system.addTag("system_cut_off_from_hyper");
            system.addScript(new SystemCutOffRemoverScript(system));
        }
        this.delay = 1.2f;
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        if (!this.playedWindup) {
            if (this.gate.isInCurrentLocation()) {
                Global.getSoundPlayer().playSound("gate_explosion_windup", 1.0f, 1.0f, this.gate.getLocation(), Misc.ZERO);
            }
            this.playedWindup = true;
        }
        GateEntityPlugin plugin = (GateEntityPlugin)this.gate.getCustomPlugin();
        plugin.jitter();
        if (plugin.getJitterLevel() > 0.9f) {
            this.delay -= amount;
        }
        if (this.delay <= 0.0f && this.explosion == null) {
            LocationAPI cl = this.gate.getContainingLocation();
            Vector2f loc = this.gate.getLocation();
            Vector2f vel = this.gate.getVelocity();
            float size = this.gate.getRadius() + 2000.0f;
            Color color = new Color(255, 165, 100);
            color = new Color(100, 255, 165);
            color = new Color(150, 255, 200);
            color = new Color(100, 200, 150, 255);
            color = new Color(255, 255, 100, 255);
            color = new Color(100, 255, 150, 255);
            ExplosionEntityPlugin.ExplosionParams params = new ExplosionEntityPlugin.ExplosionParams(color, cl, loc, size, 2.0f);
            params.damage = ExplosionEntityPlugin.ExplosionFleetDamage.HIGH;
            this.explosion = cl.addCustomEntity(Misc.genUID(), "Gate Explosion", "explosion", "neutral", params);
            this.explosion.setLocation(loc.x, loc.y);
        }
        if (this.explosion != null) {
            this.delay2 -= amount;
            if (!this.explosion.isAlive() || this.delay2 <= 0.0f) {
                this.done = true;
                StarSystemAPI system = this.gate.getStarSystem();
                if (system != null) {
                    for (SectorEntityToken jp : system.getJumpPoints()) {
                        float days = UNSTABLE_DAYS_MIN + (UNSTABLE_DAYS_MAX - UNSTABLE_DAYS_MIN) * (float)Math.random();
                        jp.getMemoryWithoutUpdate().set("$unstable", true, days);
                    }
                }
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static class SystemCutOffRemoverScript
    implements EveryFrameScript {
        public StarSystemAPI system;
        public IntervalUtil interval = new IntervalUtil(0.5f, 1.5f);
        public boolean done;
        public float elapsed = 0.0f;

        public SystemCutOffRemoverScript(StarSystemAPI system) {
            this.system = system;
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return false;
        }

        public void advance(float amount) {
            if (this.done) {
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.elapsed += days;
            this.interval.advance(days);
            if (this.interval.intervalElapsed() && this.elapsed > 10.0f) {
                boolean allJPUsable = true;
                for (SectorEntityToken jp : this.system.getJumpPoints()) {
                    allJPUsable &= !jp.getMemoryWithoutUpdate().getBoolean("$unstable");
                }
                if (allJPUsable) {
                    this.system.removeTag("system_cut_off_from_hyper");
                    this.done = true;
                }
            }
        }
    }
}

