/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.abilities.TransponderAbility;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumpPointInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static final String UNSTABLE_KEY = "$unstable";
    public static final String CAN_STABILIZE = "$canStabilize";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private CampaignFleetAPI playerFleet;
    private JumpPointAPI jumpPoint;
    protected boolean shownConfirm = false;
    protected boolean canAfford;
    protected OptionId beingConfirmed = null;
    private List<OptionId> jumpOptions = Arrays.asList(OptionId.JUMP_1, OptionId.JUMP_2, OptionId.JUMP_3, OptionId.JUMP_4, OptionId.JUMP_5, OptionId.JUMP_6, OptionId.JUMP_7, OptionId.JUMP_8, OptionId.JUMP_9);
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private EngagementResultAPI lastResult = null;
    private Map<OptionId, JumpPointAPI.JumpDestination> destinationMap = new HashMap<OptionId, JumpPointAPI.JumpDestination>();
    protected OptionId lastOptionMousedOver = null;
    protected float fuelCost;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.jumpPoint = (JumpPointAPI)dialog.getInteractionTarget();
        this.fuelCost = this.playerFleet.getLogistics().getFuelCostPerLightYear();
        float rounded = Math.round(this.fuelCost);
        if (this.fuelCost > 0.0f && rounded <= 0.0f) {
            rounded = 1.0f;
        }
        this.fuelCost = rounded;
        if (this.jumpPoint.isInHyperspace()) {
            this.fuelCost = 0.0f;
        }
        this.canAfford = this.fuelCost <= this.playerFleet.getCargo().getFuel();
        this.visual.setVisualFade(0.25f, 0.25f);
        if (this.jumpPoint.getCustomInteractionDialogImageVisual() != null) {
            this.visual.showImageVisual(this.jumpPoint.getCustomInteractionDialogImageVisual());
        } else if (this.playerFleet.getContainingLocation().isHyperspace()) {
            this.visual.showImagePortion("illustrations", "jump_point_hyper", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        } else {
            this.visual.showImagePortion("illustrations", "jump_point_normal", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        }
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        JumpPointAPI.JumpDestination dest;
        if (optionData == null) {
            return;
        }
        if ("DumpMemory.option_dump_memory" == optionData) {
            HashMap<String, MemoryAPI> memoryMap = new HashMap<String, MemoryAPI>();
            MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
            memoryMap.put("local", memory);
            if (this.dialog.getInteractionTarget().getFaction() != null) {
                memoryMap.put("faction", this.dialog.getInteractionTarget().getFaction().getMemory());
            } else {
                memoryMap.put("faction", Global.getFactory().createMemory());
            }
            memoryMap.put("global", Global.getSector().getMemory());
            memoryMap.put("player", Global.getSector().getCharacterData().getMemory());
            if (this.dialog.getInteractionTarget().getMarket() != null) {
                memoryMap.put("market", this.dialog.getInteractionTarget().getMarket().getMemory());
            }
            new DumpMemory().execute(null, this.dialog, null, memoryMap);
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        boolean unstable = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(UNSTABLE_KEY);
        boolean stabilizing = this.jumpPoint.getMemoryWithoutUpdate().getExpire(UNSTABLE_KEY) > 0.0f;
        boolean canStabilize = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(CAN_STABILIZE);
        boolean canTransverseJump = Global.getSector().getPlayerFleet().hasAbility("fracture_jump");
        boolean tutorialInProgress = TutorialMissionIntel.isTutorialInProgress();
        switch (option) {
            case INIT: {
                this.addText(this.getString("approach"));
                Description desc = Global.getSettings().getDescription(this.jumpPoint.getCustomDescriptionId(), Description.Type.CUSTOM);
                if (desc != null && desc.hasText3()) {
                    this.addText(desc.getText3());
                }
                if (unstable) {
                    if (stabilizing && !canTransverseJump) {
                        if (tutorialInProgress) {
                            this.addText("This jump-point is stabilizing and should be usable within a day at the most.");
                        } else {
                            this.addText("This jump-point is stabilizing but will not be usable for some time.");
                        }
                    } else {
                        this.addText("This jump-point is unstable and can not be used.");
                    }
                    if (canTransverseJump && !tutorialInProgress) {
                        this.addText("Until it restabilizes, hyperspace is only accessible via Transverse Jump.");
                    }
                } else {
                    if (!this.jumpPoint.isInHyperspace()) {
                        if (this.canAfford) {
                            this.textPanel.addParagraph("Activating this jump point to let your fleet pass through will cost " + (int)this.fuelCost + " fuel.");
                            this.textPanel.highlightInLastPara(Misc.getHighlightColor(), "" + (int)this.fuelCost);
                        } else {
                            int fuel = (int)this.playerFleet.getCargo().getFuel();
                            if (fuel == 0) {
                                this.textPanel.addParagraph("Activating this jump point to let your fleet pass through will cost " + (int)this.fuelCost + " fuel. You have no fuel.");
                            } else {
                                this.textPanel.addParagraph("Activating this jump point to let your fleet pass through will cost " + (int)this.fuelCost + " fuel. You only have " + fuel + " fuel.");
                            }
                            this.textPanel.highlightInLastPara(Misc.getNegativeHighlightColor(), "" + (int)this.fuelCost, "" + fuel);
                        }
                    }
                    if (this.canAfford) {
                        this.showWarningIfNeeded();
                    }
                }
                this.createInitialOptions();
                break;
            }
            case STABILIZE: {
                this.jumpPoint.getMemoryWithoutUpdate().unset(CAN_STABILIZE);
                this.jumpPoint.getMemoryWithoutUpdate().expire(UNSTABLE_KEY, 1.0f);
                this.addText("You load the stabilization algorithm into your jump program and the drive field goes through a series of esoteric fluctuations, their resonance gradually cancelling out the instability in this jump-point.");
                this.addText("The jump-point should be stable enough to use within a day or so.");
                this.createInitialOptions();
                break;
            }
            case JUMP_CONFIRM_TURN_TRANSPONDER_ON: {
                AbilityPlugin t = Global.getSector().getPlayerFleet().getAbility("transponder");
                if (t != null && !t.isActive()) {
                    t.activate();
                }
                this.optionSelected(null, (Object)this.beingConfirmed);
                break;
            }
            case JUMP_CONFIRM: {
                this.optionSelected(null, (Object)this.beingConfirmed);
                break;
            }
            case LEAVE: {
                Global.getSector().getCampaignUI().setFollowingDirectCommand(true);
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
        if (this.jumpOptions.contains((Object)option) && (dest = this.destinationMap.get((Object)option)) != null) {
            if (!this.shownConfirm) {
                SectorEntityToken target = dest.getDestination();
                CampaignFleetAPI player = Global.getSector().getPlayerFleet();
                if (target != null && target.getContainingLocation() != null && !target.getContainingLocation().isHyperspace() && !player.isTransponderOn()) {
                    List<FactionAPI> wouldBecomeHostile = TransponderAbility.getFactionsThatWouldBecomeHostile(player);
                    boolean wouldMindTOff = false;
                    boolean isPopulated = false;
                    for (MarketAPI market : Global.getSector().getEconomy().getMarkets(target.getContainingLocation())) {
                        if (market.isHidden() || market.getFaction().isPlayerFaction()) continue;
                        isPopulated = true;
                        if (market.getFaction().isHostileTo("player") || market.isFreePort() || market.getFaction().getCustomBoolean("allowsTransponderOffTrade")) continue;
                        wouldMindTOff = true;
                    }
                    if (isPopulated) {
                        if (wouldMindTOff) {
                            this.textPanel.addPara("Your transponder is off, and patrols in the " + target.getContainingLocation().getNameWithLowercaseType() + " are likely to give you trouble over the fact, if you're spotted.");
                        } else {
                            this.textPanel.addPara("Your transponder is off, but any patrols in the " + target.getContainingLocation().getNameWithLowercaseType() + " are unlikely to raise the issue.");
                        }
                        if (!wouldBecomeHostile.isEmpty()) {
                            String str = "Turning the transponder on now would reveal your hostile actions to";
                            boolean first = true;
                            boolean last = false;
                            for (FactionAPI faction : wouldBecomeHostile) {
                                last = wouldBecomeHostile.indexOf(faction) == wouldBecomeHostile.size() - 1;
                                str = first || !last ? String.valueOf(str) + " " + faction.getDisplayNameWithArticle() + "," : String.valueOf(str) + " and " + faction.getDisplayNameWithArticle() + ",";
                            }
                            str = String.valueOf(str.substring(0, str.length() - 1)) + ".";
                            this.textPanel.addPara(str, Misc.getNegativeHighlightColor());
                        }
                        this.options.clearOptions();
                        this.options.addOption("Turn the transponder on and then jump", (Object)OptionId.JUMP_CONFIRM_TURN_TRANSPONDER_ON, null);
                        this.options.addOption("Jump, keeping the transponder off", (Object)OptionId.JUMP_CONFIRM, null);
                        this.beingConfirmed = option;
                        this.options.addOption("Abort the jump", (Object)OptionId.LEAVE, null);
                        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                        this.shownConfirm = true;
                        return;
                    }
                }
            }
            if (Global.getSector().getUIData().getCourseTarget() == this.dialog.getInteractionTarget()) {
                Global.getSector().getCampaignUI().clearLaidInCourse();
            }
            this.dialog.dismiss();
            Global.getSector().setPaused(false);
            Global.getSector().doHyperspaceTransition(this.playerFleet, this.jumpPoint, dest);
            this.playerFleet.getCargo().removeFuel(this.fuelCost);
            return;
        }
    }

    protected void showWarningIfNeeded() {
        if (this.jumpPoint.getDestinations().isEmpty()) {
            return;
        }
        JumpPointAPI.JumpDestination dest = this.jumpPoint.getDestinations().get(0);
        SectorEntityToken target = dest.getDestination();
        if (target == null || target.getContainingLocation() == null) {
            return;
        }
        ArrayList<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>();
        boolean hostile = false;
        float minDist = Float.MAX_VALUE;
        int maxDanger = 0;
        for (CampaignFleetAPI other : target.getContainingLocation().getFleets()) {
            float dist = Misc.getDistance(target, other);
            if (!(dist < 1000.0f)) continue;
            fleets.add(other);
            hostile = other.getAI() != null ? (hostile |= other.getAI().isHostileTo(Global.getSector().getPlayerFleet())) : (hostile |= other.getFaction().isHostileTo("player"));
            if (other.getMemoryWithoutUpdate().getBoolean("$isPirate")) {
                hostile = true;
            }
            if (hostile) {
                maxDanger = Math.max(maxDanger, Misc.getDangerLevel(other));
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        TextPanelAPI text = this.dialog.getTextPanel();
        if (maxDanger >= 2) {
            text.addPara("Warning!", Misc.getNegativeHighlightColor());
            Global.getSoundPlayer().playUISound("cr_playership_malfunction", 1.0f, 0.25f);
            String where = "a short distance away from the exit";
            String whereHL = "";
            if (minDist < 300.0f) {
                whereHL = where = "extremely close to the exit";
            }
            text.addPara("The jump-point exhibits fluctuations characteristic of drive field activity " + where + ".", Misc.getNegativeHighlightColor(), whereHL);
            text.addPara("A disposable probe sends back a microburst of information: forces near the exit are assesed likely hostile and a possible threat to your fleet.", Misc.getNegativeHighlightColor(), "hostile", "threat");
        }
    }

    private void createInitialOptions() {
        this.options.clearOptions();
        boolean dev = Global.getSettings().isDevMode();
        float navigation = Global.getSector().getPlayerFleet().getCommanderStats().getSkillLevel("navigation");
        boolean isStarAnchor = this.jumpPoint.isStarAnchor();
        boolean okToUseIfAnchor = isStarAnchor && navigation >= 7.0f;
        okToUseIfAnchor = true;
        if (isStarAnchor && !okToUseIfAnchor && dev) {
            this.addText("(Can always be used in dev mode)");
        }
        okToUseIfAnchor |= dev;
        boolean unstable = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(UNSTABLE_KEY);
        boolean canStabilize = this.jumpPoint.getMemoryWithoutUpdate().getBoolean(CAN_STABILIZE);
        if (unstable) {
            if (canStabilize) {
                this.options.addOption("Stabilize the jump-point", (Object)OptionId.STABILIZE, null);
            }
        } else if (this.jumpPoint.getDestinations().isEmpty()) {
            this.addText(this.getString("noExits"));
        } else if (!(this.playerFleet.getCargo().getFuel() <= 0.0f) || this.canAfford) {
            if (isStarAnchor && !okToUseIfAnchor) {
                this.addText(this.getString("starAnchorUnusable"));
            } else if (this.canAfford) {
                int index = 0;
                for (JumpPointAPI.JumpDestination dest : this.jumpPoint.getDestinations()) {
                    if (index >= this.jumpOptions.size()) break;
                    OptionId option = this.jumpOptions.get(index);
                    ++index;
                    this.options.addOption("Order a jump to " + dest.getLabelInInteractionDialog(), (Object)option, null);
                    this.destinationMap.put(option, dest);
                }
            }
        }
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        if (Global.getSettings().getBoolean("oneClickJumpPoints") && this.jumpPoint.getDestinations().size() == 1) {
            this.dialog.setOpacity(0.0f);
            this.dialog.setBackgroundDimAmount(0.0f);
            this.optionSelected(null, (Object)OptionId.JUMP_1);
        }
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    private String getString(String id) {
        String str = Global.getSettings().getString("jumpPointInteractionDialog", id);
        String fleetOrShip = "fleet";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        return str;
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        JUMP_1,
        JUMP_2,
        JUMP_3,
        JUMP_4,
        JUMP_5,
        JUMP_6,
        JUMP_7,
        JUMP_8,
        JUMP_9,
        JUMP_CONFIRM_TURN_TRANSPONDER_ON,
        JUMP_CONFIRM,
        STABILIZE,
        LEAVE;

    }
}

