/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class MilitaryResponseScript
implements EveryFrameScript {
    public static String RESPONSE_ASSIGNMENT = "response";
    protected IntervalUtil tracker = new IntervalUtil(0.05f, 0.15f);
    protected MilitaryResponseParams params;
    protected float elapsed;

    public MilitaryResponseScript(MilitaryResponseParams params) {
        this.params = params;
        this.addToResponseTotal();
        this.initiateResponse();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        this.elapsed += days;
        if (this.tracker.intervalElapsed()) {
            this.initiateResponse();
        }
    }

    public void initiateResponse() {
        if (this.params.target.getContainingLocation() == null) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.params.target.getContainingLocation().getFleets();
        for (CampaignFleetAPI fleet : fleets) {
            this.seeIfFleetShouldRespond(fleet);
        }
    }

    protected boolean isTemporarilyNotResponding(CampaignFleetAPI fleet) {
        if (fleet.getBattle() != null) {
            return true;
        }
        if (fleet.getMemoryWithoutUpdate().getBoolean("$core_fleetBusy")) {
            return true;
        }
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr != null && curr.getAssignment() == FleetAssignment.STANDING_DOWN) {
            return true;
        }
        MemoryAPI memory = fleet.getMemoryWithoutUpdate();
        return memory.getBoolean("$core_fleetMilitaryResponse");
    }

    protected void seeIfFleetShouldRespond(CampaignFleetAPI fleet) {
        if (!this.couldRespond(fleet)) {
            return;
        }
        if (this.isTemporarilyNotResponding(fleet)) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.params.target.getContainingLocation().getFleets();
        float potentialFP = 0.0f;
        float respondingFP = 0.0f;
        float closestDist = Float.MAX_VALUE;
        CampaignFleetAPI closestNonResponder = null;
        for (CampaignFleetAPI other : fleets) {
            float distOther;
            if (!this.couldRespond(other)) continue;
            float fp = other.getFleetPoints();
            potentialFP += fp;
            boolean responding = this.isResponding(other);
            if (responding) {
                respondingFP += fp;
            }
            if (responding || this.isTemporarilyNotResponding(other) || !((distOther = Misc.getDistance(this.params.target, other)) < closestDist)) continue;
            closestDist = distOther;
            closestNonResponder = other;
        }
        float fraction = this.params.responseFraction / this.getResponseTotal();
        if (potentialFP > 0.0f && respondingFP / potentialFP < fraction && closestNonResponder == fleet) {
            this.respond(fleet);
        }
    }

    protected void respond(CampaignFleetAPI fleet) {
        float dist;
        this.unrespond(fleet);
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetMilitaryResponse", this.params.responseReason, true, (1.5f + (float)Math.random()) * 0.2f);
        fleet.addAssignmentAtStart(FleetAssignment.PATROL_SYSTEM, this.params.target, 3.0f, this.params.actionText, null);
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(RESPONSE_ASSIGNMENT);
        }
        if ((dist = Misc.getDistance(this.params.target, fleet)) > 2000.0f) {
            fleet.addAssignmentAtStart(FleetAssignment.GO_TO_LOCATION, this.params.target, 3.0f, this.params.travelText, null);
            curr = fleet.getCurrentAssignment();
            if (curr != null) {
                curr.setCustom(RESPONSE_ASSIGNMENT);
            }
        }
    }

    protected void unrespond(CampaignFleetAPI fleet) {
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetMilitaryResponse", this.params.responseReason, false, 0.0f);
        boolean firstOrbitPassive = true;
        for (FleetAssignmentDataAPI curr : fleet.getAI().getAssignmentsCopy()) {
            if (RESPONSE_ASSIGNMENT.equals(curr.getCustom())) {
                fleet.getAI().removeAssignment(curr);
                continue;
            }
            if (curr.getAssignment() != FleetAssignment.ORBIT_PASSIVE || !firstOrbitPassive) continue;
            fleet.getAI().removeAssignment(curr);
            firstOrbitPassive = false;
        }
    }

    protected boolean isResponding(CampaignFleetAPI fleet) {
        return Misc.flagHasReason(fleet.getMemoryWithoutUpdate(), "$core_fleetMilitaryResponse", this.params.responseReason);
    }

    protected boolean couldRespond(CampaignFleetAPI fleet) {
        ModularFleetAIAPI ai;
        if (fleet.getFaction() != this.params.faction) {
            return false;
        }
        if (fleet.getAI() == null) {
            return false;
        }
        if (fleet.isPlayerFleet()) {
            return false;
        }
        if (fleet.isStationMode()) {
            return false;
        }
        if (fleet.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)fleet.getAI()).getAssignmentModule().areAssignmentsFrozen()) {
            return false;
        }
        if (fleet.getCurrentAssignment() != null && fleet.getCurrentAssignment().getAssignment() == FleetAssignment.GO_TO_LOCATION_AND_DESPAWN) {
            return false;
        }
        MemoryAPI memory = fleet.getMemoryWithoutUpdate();
        boolean patrol = memory.getBoolean("$isPatrol");
        boolean warFleet = memory.getBoolean("$isWarFleet");
        boolean pirate = memory.getBoolean("$isPirate");
        boolean noMilitary = memory.getBoolean("$core_fleetNoMilitaryResponse");
        return (patrol || warFleet || pirate) && !noMilitary;
    }

    protected String getResponseTotalKey() {
        return "$mrs_" + this.params.responseReason;
    }

    protected void addToResponseTotal() {
        MemoryAPI memory = this.params.faction.getMemoryWithoutUpdate();
        String key = this.getResponseTotalKey();
        float curr = memory.getFloat(key);
        memory.set(key, Float.valueOf(curr + this.params.responseFraction), 60.0f);
    }

    protected void removeFromResponseTotal() {
        String key;
        MemoryAPI memory = this.params.faction.getMemoryWithoutUpdate();
        float curr = memory.getFloat(key = this.getResponseTotalKey());
        if (curr > this.params.responseFraction) {
            memory.set(key, Float.valueOf(Math.max(0.0f, curr - this.params.responseFraction)), 60.0f);
        } else {
            memory.unset(key);
        }
    }

    protected float getResponseTotal() {
        String key;
        MemoryAPI memory = this.params.faction.getMemoryWithoutUpdate();
        float curr = memory.getFloat(key = this.getResponseTotalKey());
        if (curr < this.params.responseFraction) {
            curr = this.params.responseFraction;
        }
        if (curr < 1.0f) {
            curr = 1.0f;
        }
        return curr;
    }

    public void forceDone() {
        if (this.params != null) {
            this.elapsed = this.params.responseDuration;
        }
    }

    public boolean isDone() {
        if (this.params == null || this.elapsed >= this.params.responseDuration) {
            this.removeFromResponseTotal();
            this.params = null;
            return true;
        }
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public MilitaryResponseParams getParams() {
        return this.params;
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(float elapsed) {
        this.elapsed = elapsed;
    }

    public static class MilitaryResponseParams {
        public CampaignFleetAIAPI.ActionType type;
        public String responseReason;
        public FactionAPI faction;
        public SectorEntityToken actor;
        public SectorEntityToken target;
        public float responseFraction;
        public float responseDuration;
        public String travelText;
        public String actionText;

        public MilitaryResponseParams(CampaignFleetAIAPI.ActionType type, String responseReason, FactionAPI faction, SectorEntityToken target, float responseFraction, float responseDuration) {
            this.type = type;
            this.responseReason = responseReason;
            this.faction = faction;
            this.target = target;
            this.responseFraction = responseFraction;
            this.responseDuration = responseDuration;
        }
    }
}

