/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class MonthlyReportNodeTooltipCreator
implements TooltipMakerAPI.TooltipCreator {
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
        MonthlyReport.FDNode node = (MonthlyReport.FDNode)tooltipParam;
        float pad = 3.0f;
        float opad = 10.0f;
        int crewSalary = Global.getSettings().getInt("crewSalary");
        int marineSalary = Global.getSettings().getInt("marineSalary");
        int officerBase = Global.getSettings().getInt("officerSalaryBase");
        int officerPerLevel = Global.getSettings().getInt("officerSalaryPerLevel");
        float storageFreeFraction = Global.getSettings().getFloat("storageFreeFraction");
        Color h = Misc.getHighlightColor();
        FactionAPI faction = Global.getSector().getPlayerFaction();
        Color color = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        Color grid = faction.getGridUIColor();
        Color bright = faction.getBrightUIColor();
        if (MonthlyReport.FLEET.equals(node.custom)) {
            tooltip.addPara("Fleet-related income and expenses.", 0.0f);
        } else if (MonthlyReport.OUTPOSTS.equals(node.custom)) {
            tooltip.addPara("Colony-related income and expenses.", 0.0f);
        } else if (MonthlyReport.PRODUCTION_WEAPONS.equals(node.custom)) {
            tooltip.addPara("Weapons and fighter LPCs installed on produced ships.", 0.0f);
        } else if (MonthlyReport.PRODUCTION.equals(node.custom)) {
            FactionAPI pf;
            FactionProductionAPI prod;
            int accrued;
            float currPad = 0.0f;
            if (node.custom2 instanceof CargoAPI) {
                CargoAPI cargo = (CargoAPI)node.custom2;
                if (!cargo.isEmpty()) {
                    tooltip.addSectionHeading("Equipment", color, dark, Alignment.MID, currPad);
                    tooltip.showCargo(cargo, 10, true, opad);
                    currPad = opad;
                }
                ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
                ships.addAll(cargo.getMothballedShips().getMembersListCopy());
                if (!ships.isEmpty()) {
                    tooltip.addSectionHeading("Ships", color, dark, Alignment.MID, currPad);
                    tooltip.showShips(ships, 10, true, opad);
                }
            }
            if ((accrued = (prod = (pf = Global.getSector().getPlayerFaction()).getProduction()).getAccruedProduction()) > 0) {
                tooltip.addPara("A total of %s worth of production effort has been put into projects that have not yet been completed.", currPad, Misc.getHighlightColor(), Misc.getDGSCredits(accrued));
            }
        } else if (MonthlyReport.STOCKPILING.equals(node.custom)) {
            if (node.custom2 instanceof CargoAPI) {
                tooltip.addPara("Expenses incurred due to the use of local stockpiles to counter shortages.", 0.0f);
                CargoAPI cargo = (CargoAPI)node.custom2;
                if (!cargo.isEmpty()) {
                    tooltip.addSectionHeading("Resources", color, dark, Alignment.MID, opad);
                    tooltip.showCargo(cargo, 10, true, opad);
                }
                ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
                ships.addAll(cargo.getMothballedShips().getMembersListCopy());
                if (!ships.isEmpty()) {
                    tooltip.addSectionHeading("Ships", color, dark, Alignment.MID, opad);
                    tooltip.showShips(ships, 10, true, opad);
                }
            }
        } else if (MonthlyReport.RESTOCKING.equals(node.custom)) {
            if (node.custom2 instanceof CargoAPI) {
                tooltip.addPara("Expenses incurred due to the need to restock local stockpiles to replace the resources drawn by your fleet.", 0.0f);
                CargoAPI cargo = (CargoAPI)node.custom2;
                if (!cargo.isEmpty()) {
                    tooltip.addSectionHeading("Resources", color, dark, Alignment.MID, opad);
                    tooltip.showCargo(cargo, 10, true, opad);
                }
                ArrayList<FleetMemberAPI> ships = new ArrayList<FleetMemberAPI>();
                ships.addAll(cargo.getMothballedShips().getMembersListCopy());
                if (!ships.isEmpty()) {
                    tooltip.addSectionHeading("Ships", color, dark, Alignment.MID, opad);
                    tooltip.showShips(ships, 10, true, opad);
                }
            }
        } else if (MonthlyReport.OFFICERS.equals(node.custom)) {
            tooltip.addPara("Each officer receives a base salary of %s credits per month, plus %s credits per officer level.", 0.0f, h, Misc.getWithDGS(officerBase), Misc.getWithDGS(officerPerLevel));
        } else if (MonthlyReport.ADMIN.equals(node.custom)) {
            float f = Global.getSettings().getFloat("idleAdminSalaryMult");
            tooltip.addPara("Each administrator receives a salary that depends on their skills. When not assigned to govern a colony, their salary is reduced to %s.", 0.0f, Misc.getHighlightColor(), Math.round(f * 100.0f) + "%");
        } else if (MonthlyReport.CREW.equals(node.custom)) {
            tooltip.addPara("Each crew member receives a monthly salary of %s credits.", 0.0f, h, Misc.getWithDGS(crewSalary));
        } else if (MonthlyReport.MARINES.equals(node.custom)) {
            tooltip.addPara("Each marine receives a monthly salary of %s credits.", 0.0f, h, Misc.getWithDGS(marineSalary));
        } else if (MonthlyReport.LAST_MONTH_DEBT.equals(node.custom)) {
            tooltip.addPara("Unpaid debt carried over from last month.", 0.0f);
        } else if (MonthlyReport.INDUSTRIES.equals(node.custom)) {
            tooltip.addPara("Upkeep and income from industries and structures located at the outpost or colony.", 0.0f);
        } else if (MonthlyReport.INCENTIVES.equals(node.custom)) {
            tooltip.addPara("Total spent on hazard pay and related growth incentives at the colony during the previous month.", 0.0f);
        } else if (MonthlyReport.EXPORTS.equals(node.custom)) {
            tooltip.addPara("Income from out-of-faction exports by this outpost or colony. Smuggling and in-faction exports do not produce income.", 0.0f);
        } else if (MonthlyReport.STORAGE.equals(node.custom)) {
            tooltip.addPara("Fees and expenses incurred by storing crew or materiel at a location. Includes rent, security, and other such.", 0.0f);
            String percent = (int)(storageFreeFraction * 100.0f) + "%";
            tooltip.addPara("The monthly expenses are generally %s of the base value of what's in storage.", 10.0f, h, percent);
            tooltip.addPara("Storage at a colony under your control does not incur any fees.", 10.0f);
        } else if (node.custom instanceof CommodityOnMarketAPI) {
            float quantity = 0.0f;
            if (node.custom2 instanceof Float && (quantity = ((Float)node.custom2).floatValue()) < 1.0f) {
                quantity = 1.0f;
            }
            String units = "units";
            if (quantity <= 1.0f) {
                units = "unit";
            }
            CommodityOnMarketAPI com = (CommodityOnMarketAPI)node.custom;
            tooltip.addPara("Approximately %s " + units + " of " + com.getCommodity().getName() + ".", 0.0f, h, Misc.getWithDGS(quantity));
        }
    }

    public float getTooltipWidth(Object tooltipParam) {
        return 450.0f;
    }

    public boolean isTooltipExpandable(Object tooltipParam) {
        return false;
    }
}

