/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class RepairGantry
extends BaseHullMod {
    private static Map mag = new HashMap();
    public static final float BATTLE_SALVAGE_MULT = 0.2f;
    public static final float MIN_CR = 0.1f;

    static {
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(10.0f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(25.0f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(30.0f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(40.0f));
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("salvage_value_bonus_ship").modifyFlat(id, ((Float)mag.get((Object)hullSize)).floatValue() * 0.01f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.FRIGATE)).intValue() + "%";
        }
        if (index == 1) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.DESTROYER)).intValue() + "%";
        }
        if (index == 2) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.CRUISER)).intValue() + "%";
        }
        if (index == 3) {
            return ((Float)mag.get((Object)ShipAPI.HullSize.CAPITAL_SHIP)).intValue() + "%";
        }
        if (index == 4) {
            return Math.round(20.0f) + "%";
        }
        return null;
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("Each additional ship with a salvage gantry provides diminishing returns. The higher the highest recovery bonus from a single ship in the fleet, the later diminishing returns kick in.", opad);
        if (isForModSpec || ship == null) {
            return;
        }
        if (Global.getSettings().getCurrentState() == GameState.TITLE) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        float fleetMod = RepairGantry.getAdjustedGantryModifier(fleet, null, 0.0f);
        float currShipMod = ((Float)mag.get((Object)hullSize)).floatValue() * 0.01f;
        float fleetModWithOneMore = RepairGantry.getAdjustedGantryModifier(fleet, null, currShipMod);
        float fleetModWithoutThisShip = RepairGantry.getAdjustedGantryModifier(fleet, ship.getFleetMemberId(), 0.0f);
        tooltip.addPara("The total resource recovery bonus for your fleet is %s.", opad, h, Math.round(fleetMod * 100.0f) + "%");
        float cr = ship.getCurrentCR();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!member.getId().equals(ship.getFleetMemberId())) continue;
            cr = member.getRepairTracker().getCR();
        }
        if (cr < 0.1f) {
            LabelAPI label = tooltip.addPara("This ship's combat readiness is below %s and the gantry can not be utilized. Bringing this ship into readiness would increase the fleetwide bonus to %s.", opad, h, Math.round(10.0f) + "%", Math.round(fleetModWithOneMore * 100.0f) + "%");
            label.setHighlightColors(bad, h);
            label.setHighlight(Math.round(10.0f) + "%", Math.round(fleetModWithOneMore * 100.0f) + "%");
        } else if (fleetMod > currShipMod) {
            tooltip.addPara("Removing this ship would decrease it to %s. Adding another ship of the same type would increase it to %s.", opad, h, Math.round(fleetModWithoutThisShip * 100.0f) + "%", Math.round(fleetModWithOneMore * 100.0f) + "%");
        } else {
            tooltip.addPara("Adding another ship of the same type would increase it to %s.", opad, h, Math.round(fleetModWithOneMore * 100.0f) + "%");
        }
        tooltip.addPara("The fleetwide post-battle salvage bonus is %s.", opad, h, Math.round(RepairGantry.getAdjustedGantryModifierForPostCombatSalvage(fleet) * 100.0f) + "%");
    }

    public static float getAdjustedGantryModifierForPostCombatSalvage(CampaignFleetAPI fleet) {
        return RepairGantry.getAdjustedGantryModifier(fleet, null, 0.0f) * 0.2f;
    }

    public static float getAdjustedGantryModifier(CampaignFleetAPI fleet, String skipId, float add) {
        float max = 0.0f;
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float v;
            if (member.isMothballed() || member.getRepairTracker().getCR() < 0.1f || member.getId().equals(skipId) || (v = member.getStats().getDynamic().getMod("salvage_value_bonus_ship").computeEffective(0.0f)) <= 0.0f) continue;
            if (v > max) {
                max = v;
            }
            total += v;
        }
        if (add > max) {
            max = add;
        }
        total += add;
        if (max <= 0.0f) {
            return 0.0f;
        }
        float units = total / max;
        if (units <= 1.0f) {
            return max;
        }
        float mult = Misc.logOfBase(2.5f, units) + 1.0f;
        float result = total * mult / units;
        if (result <= 0.0f) {
            result = 0.0f;
        } else {
            result = (float)Math.round(result * 100.0f) / 100.0f;
            result = Math.max(result, 0.01f);
        }
        return result;
    }
}

