/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.BaseCampaignObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoInDirection;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SensorArrayEntityPlugin
extends BaseCampaignObjectivePlugin {
    public static float SENSOR_BONUS = 700.0f;
    public static float SENSOR_BONUS_MAKESHIFT = 400.0f;
    public static String GHOST_RESPONSE = "ghost_response";

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        if (this.entity.getContainingLocation() == null || this.entity.isInHyperspace()) {
            return;
        }
        boolean reset = this.isReset();
        String id = this.getModId();
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            MutableStat.StatMod curr;
            if (fleet.isInHyperspaceTransition() || fleet.getFaction() != this.entity.getFaction() && (!this.isHacked().booleanValue() || !fleet.getFaction().isPlayerFaction())) continue;
            if (reset && !fleet.getFaction().isPlayerFaction()) {
                this.respondToFalseSensorReadings(fleet);
            } else if (reset && fleet.isPlayerFleet()) {
                this.spawnPlayerSensorReading(fleet);
            }
            String desc = "Sensor array";
            float bonus = SENSOR_BONUS;
            if (this.isMakeshift()) {
                desc = "Makeshift sensor array";
                bonus = SENSOR_BONUS_MAKESHIFT;
            }
            if ((curr = fleet.getStats().getSensorRangeMod().getFlatBonus(id)) != null && !(curr.value <= bonus)) continue;
            fleet.getStats().addTemporaryModFlat(0.1f, id, desc, bonus, fleet.getStats().getSensorRangeMod());
        }
    }

    protected boolean isMakeshift() {
        return this.entity.hasTag("makeshift");
    }

    public void printEffect(TooltipMakerAPI text, float pad) {
        int bonus = (int)SENSOR_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)SENSOR_BONUS_MAKESHIFT;
        }
        text.addPara("      %s sensor range for all same-faction fleets in system", pad, Misc.getHighlightColor(), "+" + bonus);
        if (this.isReset().booleanValue()) {
            text.addPara("      Generating false readings", 3.0f);
        }
    }

    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            text.addPara("This one, however, does not appear to be transmitting a sensor telemetry broadcast. The cause of its lack of function is unknown.");
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("You have a hack running on this sensor array.");
        }
    }

    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        int bonus = (int)SENSOR_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)SENSOR_BONUS_MAKESHIFT;
        }
        text.addPara("%s sensor range for in-system fleets", pad, Misc.getHighlightColor(), "+" + bonus);
        super.addHackStatusToTooltip(text, pad);
    }

    protected String getModId() {
        return "sensor_array";
    }

    protected void spawnPlayerSensorReading(CampaignFleetAPI fleet) {
        int maxBurn;
        boolean spawnReading;
        Random random = Misc.random;
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean("$core_fleetNotChasingGhost")) {
            return;
        }
        if (mem.getBoolean("$core_fleetChasingGhost")) {
            return;
        }
        boolean bl = spawnReading = random.nextFloat() < 0.5f;
        if (!spawnReading) {
            mem.set("$core_fleetNotChasingGhost", true, 1.0f + 2.0f * random.nextFloat());
            return;
        }
        float dur = 6.0f + random.nextFloat();
        mem.set("$core_fleetNotChasingGhost", true, dur * 0.5f);
        BaseSensorGhost g = new BaseSensorGhost(null, 0);
        float r = random.nextFloat();
        if (r < 0.25f) {
            g.initEntity(g.genMediumSensorProfile(), g.genSmallRadius(), 0, fleet.getContainingLocation());
            maxBurn = 9 + random.nextInt(3);
        } else if (r < 0.6f) {
            g.initEntity(g.genLargeSensorProfile(), g.genMediumRadius(), 0, fleet.getContainingLocation());
            maxBurn = 8 + random.nextInt(3);
        } else {
            g.initEntity(g.genLargeSensorProfile(), g.genLargeRadius(), 0, fleet.getContainingLocation());
            maxBurn = 7 + random.nextInt(3);
        }
        if (!g.placeNearPlayer()) {
            return;
        }
        float speed = Misc.getSpeedForBurnLevel(maxBurn);
        float accelMult = speed / Misc.getSpeedForBurnLevel(20.0f);
        if (accelMult < 0.1f) {
            accelMult = 0.1f;
        }
        g.setAccelMult(1.0f / accelMult);
        float dir = Misc.getAngleInDegrees(g.getEntity().getLocation(), fleet.getLocation());
        float sign = Math.signum(random.nextFloat() - 0.5f);
        g.addBehavior(new GBGoInDirection(dur, dir += sign * (30.0f + random.nextFloat() * 60.0f), maxBurn));
        fleet.getContainingLocation().addScript(g);
    }

    protected void respondToFalseSensorReadings(CampaignFleetAPI fleet) {
        boolean willRespond;
        if (fleet.isStationMode()) {
            return;
        }
        if (fleet.getAI() == null) {
            return;
        }
        if (fleet.getAI().getAssignmentsCopy() == null) {
            return;
        }
        MemoryAPI mem = fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean("$core_fleetNotChasingGhost")) {
            return;
        }
        if (mem.getBoolean("$core_fleetChasingGhost")) {
            return;
        }
        if (mem.getBoolean("$core_fleetBusy")) {
            return;
        }
        boolean patrol = mem.getBoolean("$isPatrol");
        boolean warFleet = mem.getBoolean("$isWarFleet");
        boolean pirate = mem.getBoolean("$isPirate");
        if (!(patrol || warFleet || pirate)) {
            return;
        }
        Random random = (Random)mem.get("$core_fleetChasingGhostRandom");
        if (random == null) {
            random = Misc.getRandom(Misc.getSalvageSeed(fleet), 7);
            mem.set("$core_fleetChasingGhostRandom", random, 30.0f);
        }
        boolean bl = willRespond = random.nextFloat() < 0.5f;
        if (!willRespond) {
            mem.set("$core_fleetNotChasingGhost", true, 2.0f + 2.0f * random.nextFloat());
            Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetChasingGhost", GHOST_RESPONSE, false, 0.0f);
            for (FleetAssignmentDataAPI curr : fleet.getAI().getAssignmentsCopy()) {
                if (!GHOST_RESPONSE.equals(curr.getCustom())) continue;
                fleet.getAI().removeAssignment(curr);
            }
            return;
        }
        float chaseDur = (1.5f + (float)Math.random()) * 1.0f;
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetChasingGhost", GHOST_RESPONSE, true, chaseDur);
        mem.set("$core_fleetBusy", true, chaseDur);
        mem.set("$core_fleetNotChasingGhost", true, chaseDur + 8.0f + 4.0f * random.nextFloat());
        float angle = Misc.getAngleInDegrees(fleet.getLocation());
        float arc = 270.0f;
        float dist = 2000.0f + 2000.0f * random.nextFloat();
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle += arc / 2.0f - arc * random.nextFloat());
        loc.scale(dist);
        Vector2f.add((Vector2f)loc, (Vector2f)fleet.getLocation(), (Vector2f)loc);
        String actionText = "investigating anomalous sensor reading";
        SectorEntityToken target = fleet.getContainingLocation().createToken(loc);
        fleet.addAssignmentAtStart(FleetAssignment.PATROL_SYSTEM, target, 3.0f, actionText, null);
        FleetAssignmentDataAPI curr = fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(GHOST_RESPONSE);
        }
        if (dist > 2000.0f) {
            fleet.addAssignmentAtStart(FleetAssignment.GO_TO_LOCATION, target, 3.0f, actionText, null);
            curr = fleet.getCurrentAssignment();
            if (curr != null) {
                curr.setCustom(GHOST_RESPONSE);
            }
        }
    }
}

