/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GenericFieldItemManager;

public class SupplyCacheEntityPlugin
extends BaseCustomEntityPlugin {
    private transient GenericFieldItemManager manager;

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        this.manager = new GenericFieldItemManager(this.entity);
        this.manager.category = "misc";
        this.manager.key = "cargoPods";
        this.manager.cellSize = 32;
        this.manager.minSize = 10.0f;
        this.manager.maxSize = 10.0f;
        return this;
    }

    public void advance(float amount) {
        if (this.entity.isInCurrentLocation()) {
            int minPieces;
            float totalCapacity = this.entity.getRadius();
            int numPieces = (int)(totalCapacity / 4.0f);
            if (numPieces < (minPieces = 5)) {
                numPieces = minPieces;
            }
            if (numPieces > 40) {
                numPieces = 40;
            }
            this.manager.numPieces = numPieces;
        }
        this.manager.advance(amount);
    }

    public float getRenderRange() {
        return this.entity.getRadius() + 100.0f;
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.manager.render(layer, viewport);
    }
}

