/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.HullModEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TowCable
implements HullModEffect {
    public static final String HULLMOD_ID = "tow_cable";
    public static final String TOW_CABLE_KEY = "TowCable_PersistentBuffs";

    @Override
    public void init(HullModSpecAPI spec) {
    }

    @Override
    public void advanceInCampaign(FleetMemberAPI member, float amount) {
        if (member.getFleetData() == null) {
            return;
        }
        if (member.getFleetData().getFleet() == null) {
            return;
        }
        if (!member.getFleetData().getFleet().isPlayerFleet()) {
            return;
        }
        if (!member.getVariant().getHullMods().contains(HULLMOD_ID)) {
            this.cleanUpTowCableBuffBy(member);
            return;
        }
        if (!member.canBeDeployedForCombat()) {
            this.cleanUpTowCableBuffBy(member);
            return;
        }
        FleetDataAPI data = member.getFleetData();
        List<FleetMemberAPI> all = data.getMembersListCopy();
        int numCables = 0;
        int thisCableIndex = -1;
        for (FleetMemberAPI curr : all) {
            if (!curr.canBeDeployedForCombat() || !curr.getVariant().getHullMods().contains(HULLMOD_ID)) continue;
            if (curr == member) {
                thisCableIndex = numCables;
            }
            ++numCables;
        }
        if (numCables <= 0 || thisCableIndex == -1) {
            this.cleanUpTowCableBuffBy(member);
            return;
        }
        TowCableBuff buff = this.getTowCableBuffBy(member, true);
        HashMap<FleetMemberAPI, Integer> cables = new HashMap<FleetMemberAPI, Integer>();
        float towSpeed = member.getStats().getMaxBurnLevel().getModifiedValue();
        FleetMemberAPI thisCableTarget = null;
        int cableIndex = 0;
        while (cableIndex < numCables) {
            FleetMemberAPI slowest = this.getSlowest(all, towSpeed, cables);
            if (slowest == null) break;
            Integer bonus = (Integer)cables.get(slowest);
            if (bonus == null) {
                bonus = new Integer(0);
            }
            bonus = bonus + 1;
            cables.put(slowest, bonus);
            if (cableIndex == thisCableIndex) {
                thisCableTarget = slowest;
                BuffManagerAPI.Buff existing = slowest.getBuffManager().getBuff(buff.getId());
                if (existing == buff) {
                    buff.frames = 0;
                    break;
                }
                buff.frames = 0;
                slowest.getBuffManager().addBuff(buff);
                break;
            }
            ++cableIndex;
        }
        for (FleetMemberAPI curr : all) {
            if (curr == thisCableTarget) continue;
            curr.getBuffManager().removeBuff(buff.getId());
        }
    }

    private FleetMemberAPI getSlowest(List<FleetMemberAPI> all, float speedCutoff, Map<FleetMemberAPI, Integer> cables) {
        FleetMemberAPI slowest = null;
        float minLevel = Float.MAX_VALUE;
        for (FleetMemberAPI curr : all) {
            float burnLevel;
            if (!this.isSuitable(curr)) continue;
            float baseBurn = this.getMaxBurnWithoutCables(curr);
            Integer bonus = cables.get(curr);
            if (bonus == null) {
                bonus = new Integer(0);
            }
            if (bonus >= this.getMaxCablesFor(curr) || (burnLevel = baseBurn + (float)bonus.intValue()) >= speedCutoff || !(burnLevel < minLevel)) continue;
            minLevel = burnLevel;
            slowest = curr;
        }
        return slowest;
    }

    private int getMaxCablesFor(FleetMemberAPI member) {
        return 1;
    }

    private float getMaxBurnWithoutCables(FleetMemberAPI member) {
        MutableStat burn = member.getStats().getMaxBurnLevel();
        float val = burn.getModifiedValue();
        float sub = 0.0f;
        for (MutableStat.StatMod mod : burn.getFlatMods().values()) {
            if (!mod.getSource().startsWith(HULLMOD_ID)) continue;
            sub += 1.0f;
        }
        return Math.max(0.0f, val - sub);
    }

    private boolean isSuitable(FleetMemberAPI member) {
        return !member.isFighterWing();
    }

    private void cleanUpTowCableBuffBy(FleetMemberAPI member) {
        if (member.getFleetData() == null) {
            return;
        }
        FleetDataAPI data = member.getFleetData();
        TowCableBuff buff = this.getTowCableBuffBy(member, false);
        if (buff != null) {
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                curr.getBuffManager().removeBuff(buff.getId());
            }
        }
    }

    private TowCableBuff getTowCableBuffBy(FleetMemberAPI member, boolean createIfMissing) {
        Map<FleetMemberAPI, TowCableBuff> buffs;
        if (Global.getSector().getPersistentData().containsKey(TOW_CABLE_KEY)) {
            buffs = (Map)Global.getSector().getPersistentData().get(TOW_CABLE_KEY);
        } else {
            buffs = new HashMap();
            Global.getSector().getPersistentData().put(TOW_CABLE_KEY, buffs);
        }
        TowCableBuff buff = (TowCableBuff)buffs.get(member);
        if (buff == null && createIfMissing) {
            String id = "tow_cable_" + member.getId();
            buff = new TowCableBuff(id);
            buffs.put(member, buff);
        }
        return buff;
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return true;
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return null;
    }

    @Override
    public boolean affectsOPCosts() {
        return false;
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getDescriptionParam(index, hullSize);
    }

    @Override
    public boolean canBeAddedOrRemovedNow(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        return true;
    }

    @Override
    public String getCanNotBeInstalledNowReason(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        return null;
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
    }

    @Override
    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
    }

    @Override
    public Color getBorderColor() {
        return null;
    }

    @Override
    public Color getNameColor() {
        return null;
    }

    @Override
    public int getDisplaySortOrder() {
        return 100;
    }

    @Override
    public int getDisplayCategoryIndex() {
        return -1;
    }

    @Override
    public boolean hasSModEffectSection(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    public void addSModSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
    }

    @Override
    public void addSModEffectSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
    }

    @Override
    public void addSModSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
    }

    @Override
    public boolean hasSModEffect() {
        return false;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return null;
    }

    @Override
    public float getTooltipWidth() {
        return 0.0f;
    }

    @Override
    public boolean isSModEffectAPenalty() {
        return false;
    }

    @Override
    public boolean showInRefitScreenModPickerFor(ShipAPI ship) {
        return true;
    }

    public static class TowCableBuff
    implements BuffManagerAPI.Buff {
        private String buffId;
        private int frames = 0;

        public TowCableBuff(String buffId) {
            this.buffId = buffId;
        }

        public boolean isExpired() {
            return this.frames >= 2;
        }

        public String getId() {
            return this.buffId;
        }

        public void apply(FleetMemberAPI member) {
            member.getStats().getMaxBurnLevel().modifyFlat(this.buffId, 1.0f);
        }

        public void advance(float days) {
            ++this.frames;
        }
    }
}

