/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.terrain.CRRecoveryBuff;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmergencyBurnAbility
extends BaseDurationAbility {
    public static float SENSOR_RANGE_MULT = 0.5f;
    public static float DETECTABILITY_PERCENT = 50.0f;
    public static float MAX_BURN_MOD = 8.0f;
    public static float CR_COST_MULT = 0.25f;
    public static float FUEL_USE_MULT = 1.0f;
    public static float ACCELERATION_MULT = 4.0f;
    public static float ACTIVATION_DAMAGE_PROB = 0.33f;

    @Override
    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("emergency_burn_mult");
        if (crCostFleetMult > 0.0f) {
            for (FleetMemberAPI member : this.getNonReadyShips()) {
                if (!((float)Math.random() < ACTIVATION_DAMAGE_PROB)) continue;
                Misc.applyDamage(member, null, Misc.FleetMemberDamageLevel.LOW, false, null, null, true, null, String.valueOf(member.getShipName()) + " suffers damage from Emergency Burn activation");
            }
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                float crLoss = member.getDeployCost() * CR_COST_MULT * crCostFleetMult;
                member.getRepairTracker().applyCREvent(-crLoss, "Emergency burn");
            }
        }
        float cost = this.computeFuelCost();
        fleet.getCargo().removeFuel(cost);
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getSensorRangeMod().modifyMult(this.getModId(), 1.0f + (SENSOR_RANGE_MULT - 1.0f) * level, "Emergency burn");
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), DETECTABILITY_PERCENT * level, "Emergency burn");
        fleet.getStats().getFleetwideMaxBurnMod().modifyFlat(this.getModId(), (int)(MAX_BURN_MOD * level), "Emergency burn");
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f + (ACCELERATION_MULT - 1.0f) * level);
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), new Color(250, 150, 100, 255), 1.0f, 1.0f, 0.75f);
            view.getEngineGlowSizeMult().shift(this.getModId(), 2.0f, 1.0f, 1.0f, 1.0f);
            view.getEngineHeightMult().shift(this.getModId(), 5.0f, 1.0f, 1.0f, 1.0f);
            view.getEngineWidthMult().shift(this.getModId(), 3.0f, 1.0f, 1.0f, 1.0f);
        }
        String buffId = this.getModId();
        float buffDur = 0.1f;
        boolean needsSync = false;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (level <= 0.0f) {
                member.getBuffManager().removeBuff(buffId);
                needsSync = true;
                continue;
            }
            BuffManagerAPI.Buff test = member.getBuffManager().getBuff(buffId);
            if (test instanceof CRRecoveryBuff) {
                CRRecoveryBuff buff = (CRRecoveryBuff)test;
                buff.setDur(buffDur);
                continue;
            }
            member.getBuffManager().addBuff(new CRRecoveryBuff(buffId, 0.0f, buffDur));
            needsSync = true;
        }
        if (needsSync) {
            fleet.forceSync();
        }
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getSensorRangeMod().unmodify(this.getModId());
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    protected List<FleetMemberAPI> getNonReadyShips() {
        ArrayList<FleetMemberAPI> result = new ArrayList<FleetMemberAPI>();
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            float crLoss = EmergencyBurnAbility.getCRCost(member, fleet);
            if (Math.round(member.getRepairTracker().getCR() * 100.0f) >= Math.round(crLoss * 100.0f)) continue;
            result.add(member);
        }
        return result;
    }

    public static float getCRCost(FleetMemberAPI member, CampaignFleetAPI fleet) {
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("emergency_burn_mult");
        float crLoss = member.getDeployCost() * CR_COST_MULT * crCostFleetMult;
        return (float)Math.round(crLoss * 100.0f) / 100.0f;
    }

    protected float computeFuelCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float cost = fleet.getLogistics().getFuelCostPerLightYear() * FUEL_USE_MULT;
        return cost;
    }

    protected float computeSupplyCost() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return 0.0f;
        }
        float crCostFleetMult = fleet.getStats().getDynamic().getValue("emergency_burn_mult");
        float cost = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            cost += member.getDeploymentPointsCost() * CR_COST_MULT * crCostFleetMult;
        }
        return cost;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        List<FleetMemberAPI> nonReady;
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle("Emergency Burn");
        float pad = 10.0f;
        float fuelCost = this.computeFuelCost();
        float supplyCost = this.computeSupplyCost();
        tooltip.addPara("Increases the maximum burn level by %s. Reduces sensor range by %s and increases the range at which the fleet can be detected by %s.", pad, highlight, "" + (int)MAX_BURN_MOD, (int)((1.0f - SENSOR_RANGE_MULT) * 100.0f) + "%", (int)DETECTABILITY_PERCENT + "%");
        if (supplyCost > 0.0f) {
            tooltip.addPara("Consumes %s fuel and reduces the combat readiness of all ships, costing up to %s supplies to recover. Also prevents combat readiness recovery while active.", pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost), Misc.getRoundedValueMaxOneAfterDecimal(supplyCost));
        } else {
            tooltip.addPara("Consumes %s fuel and prevents combat readiness recovery while active.", pad, highlight, Misc.getRoundedValueMaxOneAfterDecimal(fuelCost));
        }
        if (fuelCost > fleet.getCargo().getFuel()) {
            tooltip.addPara("Not enough fuel.", bad, pad);
        }
        if (!(nonReady = this.getNonReadyShips()).isEmpty()) {
            tooltip.addPara("Some ships don't have enough combat readiness to safely initiate an emergency burn and may suffer damage if the ability is activated:", pad, Misc.getNegativeHighlightColor(), "may suffer damage");
            int j = 0;
            int max = 7;
            float initPad = 5.0f;
            for (FleetMemberAPI member : nonReady) {
                if (j >= max && nonReady.size() > max + 1) {
                    tooltip.addToGrid(0, j++, "... and several other ships", "", bad);
                    break;
                }
                String str = "";
                if (!member.isFighterWing()) {
                    str = String.valueOf(str) + member.getShipName() + ", ";
                    str = String.valueOf(str) + member.getHullSpec().getHullNameWithDashClass();
                } else {
                    str = String.valueOf(str) + member.getVariant().getFullDesignationWithHullName();
                }
                tooltip.addPara("      " + str, initPad);
                initPad = 0.0f;
            }
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
        if (engagedInHostilities) {
            this.deactivate();
        }
    }

    @Override
    public void fleetOpenedMarket(MarketAPI market) {
        this.deactivate();
    }

    protected boolean showAlarm() {
        return !this.getNonReadyShips().isEmpty() && !this.isOnCooldown() && !this.isActiveOrInProgress() && this.isUsable();
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && this.getFleet() != null && (this.getFleet().isAIMode() || this.computeFuelCost() <= this.getFleet().getCargo().getFuel());
    }

    @Override
    public float getCooldownFraction() {
        if (this.showAlarm()) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public boolean showCooldownIndicator() {
        return super.showCooldownIndicator();
    }

    @Override
    public boolean isOnCooldown() {
        return super.getCooldownFraction() < 1.0f;
    }

    @Override
    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return this.showAlarm();
    }
}

