/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SensorBurstAbility
extends BaseDurationAbility {
    public static final float SENSOR_RANGE_BONUS = 3000.0f;
    public static final float DETECTABILITY_RANGE_BONUS = 5000.0f;

    protected void activateImpl() {
        SectorEntityToken.VisibilityLevel level;
        if (this.entity.isInCurrentLocation() && (level = this.entity.getVisibilityLevelToPlayerFleet()) != SectorEntityToken.VisibilityLevel.NONE) {
            Global.getSector().addPing(this.entity, "sensor_burst");
        }
    }

    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (this.entity.isInCurrentLocation()) {
            Global.getSector().getMemoryWithoutUpdate().set("$sensorBurstJustUsed", true, 0.1f);
        }
        fleet.getMemoryWithoutUpdate().set("$justDidSensorBurst", true, 0.1f);
        fleet.getStats().getSensorRangeMod().modifyFlat(this.getModId(), 3000.0f * level, "Active sensor burst");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 5000.0f * level, "Active sensor burst");
        fleet.goSlowOneFrame();
    }

    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getSensorRangeMod().unmodify(this.getModId());
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        LabelAPI title = tooltip.addTitle(this.spec.getName());
        float pad = 10.0f;
        tooltip.addPara("Turn off engines to reduce interference and link all sensors in the fleet into a single network.", pad);
        tooltip.addPara("Increases sensor range by %s* units and increases the range at which the fleet can be detected by %s* units. The fleet is only able to %s** while the ability is active.", pad, highlight, "3000", "5000", "move slowly");
        tooltip.addPara("*2000 units = 1 map grid cell", gray, pad);
        tooltip.addPara("**A fleet is considered slow-moving at a burn level of half that of its slowest ship.", gray, 0.0f);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean hasTooltip() {
        return true;
    }
}

