/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class SustainedBurnAbility
extends BaseToggleAbility {
    public static String SB_NO_STOP = "$sb_active";
    public static String SB_NO_SLOW = "$sb_no_slow";
    public static float DETECTABILITY_PERCENT = 100.0f;
    public static float MAX_BURN_PERCENT = 100.0f;
    public static float ACCELERATION_MULT = 0.2f;

    protected String getActivationText() {
        return super.getActivationText();
    }

    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (!fleet.getMemoryWithoutUpdate().is(SB_NO_STOP, true)) {
            fleet.setVelocity(0.0f, 0.0f);
        }
    }

    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level > 0.0f && !fleet.isAIMode() && fleet.getCargo().getFuel() <= 0.0f && fleet.getContainingLocation() != null && fleet.getContainingLocation().isHyperspace()) {
            this.deactivate();
            return;
        }
        fleet.getMemoryWithoutUpdate().set(SB_NO_STOP, true, 0.3f);
        if (level > 0.0f && level < 1.0f && amount > 0.0f && !fleet.getMemoryWithoutUpdate().is(SB_NO_SLOW, true)) {
            float activateSeconds = this.getActivationDays() * Global.getSector().getClock().getSecondsPerDay();
            float speed = fleet.getVelocity().length();
            float acc = Math.max(speed, 200.0f) / activateSeconds + fleet.getAcceleration();
            float ds = acc * amount;
            if (ds > speed) {
                ds = speed;
            }
            Vector2f dv = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(fleet.getVelocity()));
            dv.scale(ds);
            fleet.setVelocity(fleet.getVelocity().x - dv.x, fleet.getVelocity().y - dv.y);
            return;
        }
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), DETECTABILITY_PERCENT * level, "Sustained burn");
        int burnModifier = 0;
        float burnMult = 1.0f;
        float b = fleet.getStats().getDynamic().getValue("sustained_burn_bonus", 0.0f);
        burnModifier = (int)(b * level);
        fleet.getStats().getFleetwideMaxBurnMod().modifyFlat(this.getModId(), burnModifier, "Sustained burn");
        fleet.getStats().getFleetwideMaxBurnMod().modifyMult(this.getModId(), burnMult, "Sustained burn");
        fleet.getStats().getFleetwideMaxBurnMod().modifyPercent(this.getModId(), MAX_BURN_PERCENT, "Sustained burn");
        float accImpact = 0.0f;
        float burn = Misc.getBurnLevelForSpeed(fleet.getVelocity().length());
        if (burn > 1.0f) {
            float dir = Misc.getDesiredMoveDir(fleet);
            float velDir = Misc.getAngleInDegrees(fleet.getVelocity());
            float diff = Misc.getAngleDiff(dir, velDir);
            float pad = 120.0f;
            if ((diff -= pad) < 0.0f) {
                diff = 0.0f;
            }
            accImpact = 1.0f - 0.5f * Math.min(1.0f, diff / (180.0f - pad));
        }
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f - (1.0f - ACCELERATION_MULT) * accImpact);
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), view.getEngineColor().getBase(), 1.0f, 1.0f, 0.5f * level);
            view.getEngineGlowSizeMult().shift(this.getModId(), 1.5f, 1.0f, 1.0f, 1.0f * level);
            view.getEngineHeightMult().shift(this.getModId(), 3.0f, 1.0f, 1.0f, 1.0f * level);
            view.getEngineWidthMult().shift(this.getModId(), 2.0f, 1.0f, 1.0f, 1.0f * level);
        }
        if (level <= 0.0f) {
            this.cleanupImpl();
        }
    }

    protected void deactivateImpl() {
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    public boolean showProgressIndicator() {
        return super.showProgressIndicator();
    }

    public boolean showActiveIndicator() {
        return this.isActive();
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (off)";
        if (this.turnedOn) {
            status = " (on)";
        }
        LabelAPI title = tooltip.addTitle("Sustained Burn" + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("Switch the drives of all ships in the fleet to a mode suited for long-distance travel. The fleet has to stop briefly to make the switch-over. ", pad);
        tooltip.addPara("Increases the maximum burn level by %s, at the expense of lower acceleration, especially in the direction of the fleet's movement. Also increases the range at which the fleet can be detected by %s.", pad, highlight, Math.round(MAX_BURN_PERCENT) + "%", (int)DETECTABILITY_PERCENT + "%");
        tooltip.addPara("The burn level increase does not apply to flat burn bonuses, such as those from Nav Buoys or tugs.", pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean hasTooltip() {
        return true;
    }

    public void fleetLeftBattle(BattleAPI battle, boolean engagedInHostilities) {
    }

    public void fleetJoinedBattle(BattleAPI battle) {
        if (!battle.isPlayerInvolved()) {
            this.deactivate();
        }
    }
}

