/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransponderAbility
extends BaseToggleAbility {
    public static final float DETECTABILITY_MULT = 1.0f;
    public static final float DETECTABILITY_FLAT = 1000.0f;
    private transient boolean showAlarm = false;
    public static final float CONFIRM_DURATION = 5.0f;
    transient float sinceWarning = 1000.0f;

    @Override
    protected String getActivationText() {
        return "Transponder on";
    }

    @Override
    protected String getDeactivationText() {
        return null;
    }

    @Override
    protected void activateImpl() {
        List<FactionAPI> factions;
        if (this.entity.isPlayerFleet() && !(factions = this.getFactionsThatWouldBecomeHostile()).isEmpty()) {
            Global.getSector().getCampaignUI().addMessage("Your identity is revealed and linked to your recent hostile actions!");
            for (FactionAPI faction : factions) {
                Global.getSector().adjustPlayerReputation((Object)CoreReputationPlugin.RepActions.COMBAT_NORMAL, faction.getId());
            }
        }
        this.entity.setTransponderOn(true);
        this.entity.getMemoryWithoutUpdate().set("$justToggledTransponder", true, 0.1f);
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level > 0.0f) {
            level = 1.0f;
        }
        fleet.getStats().getDetectedRangeMod().modifyMult(this.getModId(), 1.0f + 0.0f * level, "Transponder on");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 1000.0f * level, "Transponder on");
        if (level <= 0.0f) {
            this.cleanupImpl();
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.entity.isTransponderOn()) {
            this.entity.setTransponderOn(false);
            this.entity.getMemoryWithoutUpdate().set("$justToggledTransponder", true, 0.1f);
        }
    }

    @Override
    protected void deactivateImpl() {
        this.entity.setTransponderOn(false);
        this.entity.getMemoryWithoutUpdate().set("$justToggledTransponder", true, 0.1f);
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        String status = " (off)";
        if (this.entity.isTransponderOn()) {
            status = " (on)";
        }
        LabelAPI title = tooltip.addTitle(String.valueOf(this.spec.getName()) + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("Transponders transmit identifying information to all fleets within range.", pad);
        List<FactionAPI> factions = this.getFactionsThatWouldBecomeHostile();
        if (!factions.isEmpty()) {
            String text = "Turning the transponder on now would reveal your hostile actions to";
            boolean first = true;
            boolean last = false;
            for (FactionAPI faction : factions) {
                last = factions.indexOf(faction) == factions.size() - 1;
                text = first || !last ? String.valueOf(text) + " " + faction.getDisplayNameWithArticle() + "," : String.valueOf(text) + " and " + faction.getDisplayNameWithArticle() + ",";
            }
            text = String.valueOf(text.substring(0, text.length() - 1)) + ".";
            tooltip.addPara(text, red, pad);
        }
        tooltip.addPara("When the transponder is on, your fleet can be detected at longer range and full information on its composition is available at maximum range.", pad);
        tooltip.addPara("Transponder status also affects the reputation changes from combat and trade. With it turned off, you might be able to trade with otherwise inhospitable factions.", pad);
        tooltip.addPara("In most places, running with the transponder off will attract the attention of nearby patrols, although several factions and certain free ports allow it. Having the transponder off does not grant perfect anonymity.", pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public String getFactionList(List<FactionAPI> factions) {
        String text = "";
        boolean first = true;
        boolean last = false;
        for (FactionAPI faction : factions) {
            last = factions.indexOf(faction) == factions.size() - 1;
            text = first || !last ? String.valueOf(text) + " " + faction.getDisplayNameLongWithArticle() + "," : String.valueOf(text) + " and " + faction.getDisplayNameLongWithArticle() + ",";
        }
        text = String.valueOf(text.substring(0, text.length() - 1));
        return text.trim();
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public List<FactionAPI> getFactionsThatWouldBecomeHostile() {
        return TransponderAbility.getFactionsThatWouldBecomeHostile(this.getFleet());
    }

    public static List<FactionAPI> getFactionsThatWouldBecomeHostile(CampaignFleetAPI fleet) {
        ArrayList<FactionAPI> result = new ArrayList<FactionAPI>();
        if (fleet == null) {
            return result;
        }
        if (fleet.getContainingLocation() == null) {
            return result;
        }
        if (fleet.isTransponderOn()) {
            return result;
        }
        List<CampaignFleetAPI> fleets = fleet.getContainingLocation().getFleets();
        for (CampaignFleetAPI other : fleets) {
            MemoryAPI mem;
            if (other.getFleetData().getNumMembers() <= 0) continue;
            float dist = Misc.getDistance(fleet.getLocation(), other.getLocation());
            fleet.setTransponderOn(true);
            float detectRange = (other.getMaxSensorRangeToDetect(fleet) + 1000.0f) * 1.0f * 1.25f;
            fleet.setTransponderOn(false);
            if (dist > detectRange || (mem = other.getMemoryWithoutUpdate()).getBoolean("$lowRepImpact") || result.contains(other.getFaction()) || !mem.getBoolean("$cfai_makeHostileWhileTOff") || other.getFaction().isHostileTo(fleet.getFaction())) continue;
            result.add(other.getFaction());
        }
        return result;
    }

    @Override
    public void advance(float amount) {
        CampaignFleetAPI fleet;
        if (!Global.getSector().isPaused()) {
            super.advance(amount);
        }
        if ((fleet = this.getFleet()) == null || !fleet.isPlayerFleet()) {
            return;
        }
        this.sinceWarning += amount;
        List<FactionAPI> factions = this.getFactionsThatWouldBecomeHostile();
        this.showAlarm = !factions.isEmpty();
    }

    @Override
    public boolean runWhilePaused() {
        return this.getFleet() != null && this.getFleet().isPlayerFleet();
    }

    @Override
    public boolean showProgressIndicator() {
        return this.showAlarm;
    }

    @Override
    public float getProgressFraction() {
        return 1.0f;
    }

    @Override
    public Color getProgressColor() {
        Color color = Misc.getNegativeHighlightColor();
        return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness());
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.sinceWarning = 1000.0f;
        return this;
    }

    @Override
    public void pressButton() {
        if (this.getFleet().isPlayerFleet()) {
            if (this.sinceWarning < 5.0f) {
                if (this.entity.isPlayerFleet()) {
                    List<FactionAPI> factions = this.getFactionsThatWouldBecomeHostile();
                    if (!factions.isEmpty()) {
                        String list = this.getFactionList(factions);
                        String text = "Turning the transponder on will reveal your identity and make " + list + " hostile.\n\n" + "Are you sure you want to do this?";
                        Global.getSector().getCampaignUI().showConfirmDialog(text, "Confirm", "Cancel", new Script(){

                            public void run() {
                                TransponderAbility.super.pressButton();
                                Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(TransponderAbility.this.getDeactivationMessage());
                                Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(TransponderAbility.this.getActivationMessage());
                                TransponderAbility.this.sinceWarning = 1000.0f;
                            }
                        }, null);
                    } else {
                        super.pressButton();
                        Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getDeactivationMessage());
                        Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getActivationMessage());
                        this.sinceWarning = 1000.0f;
                    }
                } else {
                    super.pressButton();
                    Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getDeactivationMessage());
                    Global.getSector().getCampaignUI().getMessageDisplay().removeMessage(this.getActivationMessage());
                    this.sinceWarning = 1000.0f;
                }
            } else {
                this.sinceWarning = 0.0f;
                if (this.isActive()) {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.getDeactivationMessage());
                } else if (this.showAlarm) {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.getActivationMessage(), Misc.getNegativeHighlightColor());
                } else {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.getActivationMessage());
                }
            }
        } else {
            super.pressButton();
        }
    }

    protected String getDeactivationMessage() {
        return "Transponder shutdown initiated - use again to deactivate";
    }

    protected String getActivationMessage() {
        if (this.showAlarm) {
            return "Activating the transponder will reveal your identity - use again to confirm";
        }
        return "Transponder primed - use again to activate";
    }

    @Override
    public float getCooldownFraction() {
        if (this.sinceWarning < 5.0f) {
            return 0.0f;
        }
        return super.getCooldownFraction();
    }

    @Override
    public boolean isOnCooldown() {
        return false;
    }

    @Override
    public Color getCooldownColor() {
        if (this.sinceWarning < 5.0f) {
            Color color = Misc.getNegativeHighlightColor();
            if (!this.showAlarm) {
                color = Misc.getHighlightColor();
            }
            float b = 1.0f;
            float t = 0.25f;
            if (this.sinceWarning < t) {
                b = this.sinceWarning / t;
            }
            if (this.sinceWarning > 5.0f - t) {
                b = 1.0f - (this.sinceWarning - (5.0f - t)) / t;
            }
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.75f * b);
        }
        return super.getCooldownColor();
    }

    @Override
    public boolean isCooldownRenderingAdditive() {
        return true;
    }
}

