/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.abilities.EmergencyBurnAbility;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class EmergencyBurnAbilityAI
extends BaseAbilityAI {
    public static String AI_USE_TIMEOUT_KEY = "$ebai_timeout";
    public static float AI_USE_TIMEOUT_DAYS_MIN = 3.0f;
    public static float AI_USE_TIMEOUT_DAYS_MAX = 5.0f;
    public static float AI_FREQUENCY_MULT = 1.0f;
    protected IntervalUtil interval = new IntervalUtil(0.05f, 0.15f);

    protected void activate() {
        this.ability.activate();
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        mem.set(AI_USE_TIMEOUT_KEY, true, AI_USE_TIMEOUT_DAYS_MIN + (AI_USE_TIMEOUT_DAYS_MAX - AI_USE_TIMEOUT_DAYS_MIN) * (float)Math.random());
    }

    public void advance(float days) {
        this.interval.advance(days * AI_FREQUENCY_MULT * 0.25f);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (this.ability.isActiveOrInProgress()) {
            MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
            mem.set("$ai_hasSpeedBonus", true, 0.2f);
            mem.set("$ai_hasVisionPenalty", true, 0.2f);
            return;
        }
        if (this.fleet.getStats().getFleetwideMaxBurnMod().getBonusMult() <= 0.15f) {
            return;
        }
        if (this.fleet.getAI() != null && this.fleet.getAI().getCurrentAssignmentType() == FleetAssignment.STANDING_DOWN) {
            return;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean(AI_USE_TIMEOUT_KEY)) {
            return;
        }
        CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
        CampaignFleetAPI fleeingFrom = mem.getFleet("$ai_fleeingFrom");
        if (fleeingFrom != null) {
            boolean avoidingPlayer;
            if (fleeingFrom.isStationMode()) {
                return;
            }
            SectorEntityToken.VisibilityLevel level = this.fleet.getVisibilityLevelTo(fleeingFrom);
            if (level == SectorEntityToken.VisibilityLevel.NONE) {
                return;
            }
            if (!this.ability.isUsable()) {
                return;
            }
            if (fleeingFrom.isPlayerFleet() && (avoidingPlayer = Misc.isAvoidingPlayerHalfheartedly(this.fleet))) {
                return;
            }
            UseCost cost = this.getUseCost();
            boolean hopelessFight = this.isGreatlyOutmatchedBy(fleeingFrom);
            float dist = Misc.getDistance(this.fleet.getLocation(), fleeingFrom.getLocation()) - this.fleet.getRadius() + fleeingFrom.getRadius();
            float detRange = fleeingFrom.getMaxSensorRangeToDetect(this.fleet);
            float ourSpeed = this.fleet.getFleetData().getBurnLevel();
            float theirSpeed = fleeingFrom.getFleetData().getBurnLevel();
            float closingSpeed = Misc.getClosingSpeed(this.fleet.getLocation(), fleeingFrom.getLocation(), this.fleet.getVelocity(), fleeingFrom.getVelocity());
            if (theirSpeed > ourSpeed && closingSpeed > 1.0f || closingSpeed > 1.0f && dist < 100.0f) {
                if (hopelessFight && dist < 200.0f) {
                    this.activate();
                } else if ((cost == UseCost.LOW || cost == UseCost.MEDIUM) && dist < 500.0f) {
                    this.activate();
                } else if ((cost == UseCost.LOW || cost == UseCost.MEDIUM) && dist < 100.0f) {
                    this.activate();
                } else if ((cost == UseCost.LOW || cost == UseCost.MEDIUM) && dist > detRange - 100.0f) {
                    this.activate();
                }
            }
            return;
        }
        if (pursueTarget != null) {
            float closingSpeed;
            ModularFleetAIAPI ai;
            if (pursueTarget.isStationMode()) {
                return;
            }
            if (this.fleet.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.fleet.getAI()).getTacticalModule().isMaintainingContact()) {
                return;
            }
            SectorEntityToken.VisibilityLevel level = pursueTarget.getVisibilityLevelTo(this.fleet);
            if (level == SectorEntityToken.VisibilityLevel.NONE) {
                return;
            }
            if (pursueTarget.isPlayerFleet() && (level = this.fleet.getVisibilityLevelTo(pursueTarget)) == SectorEntityToken.VisibilityLevel.NONE && (closingSpeed = Misc.getClosingSpeed(pursueTarget.getLocation(), this.fleet.getLocation(), pursueTarget.getVelocity(), this.fleet.getVelocity())) > 0.0f) {
                return;
            }
            if (!this.ability.isUsable()) {
                return;
            }
            boolean targetInsignificant = this.otherInsignificant(pursueTarget);
            UseCost cost = this.getUseCost();
            float dist = Misc.getDistance(this.fleet.getLocation(), pursueTarget.getLocation()) - this.fleet.getRadius() - pursueTarget.getRadius();
            if (dist < 0.0f) {
                return;
            }
            float detRange = pursueTarget.getMaxSensorRangeToDetect(this.fleet);
            float ourSpeed = this.fleet.getFleetData().getBurnLevel();
            float theirSpeed = pursueTarget.getFleetData().getBurnLevel();
            float closingSpeed2 = Misc.getClosingSpeed(this.fleet.getLocation(), pursueTarget.getLocation(), this.fleet.getVelocity(), pursueTarget.getVelocity());
            if (cost == UseCost.LOW && closingSpeed2 <= -1.0f && dist > detRange - 100.0f) {
                this.activate();
            } else if (cost == UseCost.LOW && dist < 200.0f && closingSpeed2 < 50.0f && !targetInsignificant) {
                this.activate();
            } else if (cost == UseCost.LOW && theirSpeed > ourSpeed && dist > 300.0f && !targetInsignificant) {
                this.activate();
            }
            return;
        }
        boolean useEB = mem.getBoolean("$ai_useEBForTravel");
        if (useEB) {
            if (!this.ability.isUsable()) {
                return;
            }
            this.activate();
            return;
        }
    }

    private UseCost getUseCost() {
        float count = 0.0f;
        float numCritAlready = 0.0f;
        float numCrit = 0.0f;
        float numLow = 0.0f;
        float numOk = 0.0f;
        float crCrit = Global.getSettings().getCRPlugin().getCriticalMalfunctionThreshold(null);
        float crLow = Global.getSettings().getCRPlugin().getMalfunctionThreshold(null) + 0.01f;
        boolean allCRMaxed = true;
        for (FleetMemberAPI member : this.fleet.getFleetData().getMembersListCopy()) {
            count += 1.0f;
            if (member.isCivilian()) {
                numOk += 1.0f;
                continue;
            }
            float useCost = member.getDeployCost() * EmergencyBurnAbility.CR_COST_MULT;
            float cr = member.getRepairTracker().getCR();
            float maxCR = member.getRepairTracker().getMaxCR();
            float crAfter = cr - useCost;
            if (cr < maxCR) {
                allCRMaxed = false;
            }
            if (cr <= crCrit * 0.5f) {
                numCritAlready += 1.0f;
            }
            if (crAfter <= crCrit) {
                numCrit += 1.0f;
                continue;
            }
            if (crAfter <= crLow) {
                numLow += 1.0f;
                continue;
            }
            numOk += 1.0f;
        }
        if (numCritAlready >= count) {
            return UseCost.LOW;
        }
        if (allCRMaxed) {
            return UseCost.LOW;
        }
        if (numOk + numLow >= count) {
            return UseCost.MEDIUM;
        }
        return UseCost.HIGH;
    }

    protected boolean isGreatlyOutmatchedBy(CampaignFleetAPI other) {
        float us = EmergencyBurnAbilityAI.getStrength(this.fleet);
        float them = EmergencyBurnAbilityAI.getStrength(other);
        if (us < 0.1f) {
            us = 0.1f;
        }
        if (them < 0.1f) {
            them = 0.1f;
        }
        return them > us * 3.0f;
    }

    protected boolean otherInsignificant(CampaignFleetAPI other) {
        float us = EmergencyBurnAbilityAI.getStrength(this.fleet);
        float them = EmergencyBurnAbilityAI.getStrength(other);
        if (us < 0.1f) {
            us = 0.1f;
        }
        if (them < 0.1f) {
            them = 0.1f;
        }
        return us > them * 5.0f;
    }

    public static float getStrength(CampaignFleetAPI fleet) {
        float str = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat()) continue;
            float strength = member.getMemberStrength();
            str += strength;
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseCost {
        LOW,
        MEDIUM,
        HIGH;

    }
}

