/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.events.FoodShortageEvent;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoodShortage
extends BaseMarketConditionPlugin {
    private FoodShortageEvent event = null;

    @Override
    public void apply(String id) {
        this.market.getStability().modifyFlat(id, -1.0f * this.event.getStabilityImpact(), "Food shortage");
        String sellId = Stats.getPlayerSellRepImpactMultId("food");
        this.market.getStats().getDynamic().getStat(sellId).modifyMult(id, 4.0f);
    }

    @Override
    public void unapply(String id) {
        this.market.getCommodityData("food").getPlayerSupplyPriceMod().unmodify(id);
        this.market.getStability().unmodify(id);
        String sellId = Stats.getPlayerSellRepImpactMultId("food");
        this.market.getStats().getDynamic().getStat(sellId).unmodify(id);
    }

    @Override
    public List<String> getRelatedCommodities() {
        return this.event.getRelatedCommodities();
    }

    @Override
    public void setParam(Object param) {
        this.event = (FoodShortageEvent)param;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> tokens = super.getTokenReplacements();
        int penalty = (int)this.event.getStabilityImpact();
        tokens.put("$stabilityPenalty", "" + penalty);
        int remaining = (int)Misc.getRounded(this.event.getRemainingFoodToMeetShortage());
        tokens.put("$neededFood", "" + remaining);
        return tokens;
    }

    @Override
    public String[] getHighlights() {
        ArrayList<String> highlights = new ArrayList<String>();
        this.addTokensToList(highlights, "$stabilityPenalty", "$neededFood");
        return highlights.toArray(new String[0]);
    }

    @Override
    public Color[] getHighlightColors() {
        return super.getHighlightColors();
    }

    @Override
    public boolean isTransient() {
        return false;
    }
}

