/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class FreeMarket
extends BaseMarketConditionPlugin
implements MarketImmigrationModifier {
    public static float OFFICER_MERC_PROB_MOD = 0.25f;
    public static float MIN_STABILITY_PENALTY = 1.0f;
    public static float MAX_STABILITY_PENALTY = 3.0f;
    public static float MIN_ACCESS_BONUS = 0.05f;
    public static float MAX_ACCESS_BONUS = 0.25f;
    public static float MIN_GROWTH = 3.0f;
    public static float MAX_GROWTH = 10.0f;
    public static float MAX_DAYS = 365.0f;
    private float daysActive = 0.0f;

    public static FreeMarket get(MarketAPI market) {
        MarketConditionAPI mc = market.getCondition("free_market");
        if (mc != null && mc.getPlugin() instanceof FreeMarket) {
            return (FreeMarket)mc.getPlugin();
        }
        return null;
    }

    public void advance(float amount) {
        if (!this.market.hasSpaceport()) {
            this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
            this.market.setFreePort(false);
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysActive += days;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public float getDaysActive() {
        return this.daysActive;
    }

    public void setDaysActive(float daysActive) {
        this.daysActive = daysActive;
    }

    public void apply(String id) {
        this.market.addTransientImmigrationModifier(this);
        this.market.getAccessibilityMod().modifyFlat(id, this.getAccessBonus(), "Free port");
        this.market.getStability().modifyFlat(id, -this.getStabilityPenalty(), "Free port");
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").modifyFlat(id, OFFICER_MERC_PROB_MOD);
    }

    public boolean isTransient() {
        return false;
    }

    public void unapply(String id) {
        this.market.removeTransientImmigrationModifier(this);
        this.market.getStability().unmodifyFlat(id);
        this.market.getAccessibilityMod().unmodifyFlat(id);
        this.market.getStats().getDynamic().getMod("officer_is_merc_prob").unmodifyFlat(id);
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("pirates", 5.0f);
        incoming.add("poor", 5.0f);
        incoming.add("independent", 5.0f);
        incoming.getWeight().modifyFlat(this.getModId(), this.getImmigrationBonus(), Misc.ucFirst(this.condition.getName().toLowerCase()));
    }

    protected float getImmigrationBonus() {
        float growth = MIN_GROWTH + this.daysActive / MAX_DAYS * (MAX_GROWTH - MIN_GROWTH);
        if ((growth = (float)Math.round(growth)) > MAX_GROWTH) {
            growth = MAX_GROWTH;
        }
        if (growth < 1.0f) {
            growth = 1.0f;
        }
        return growth;
    }

    protected float getAccessBonus() {
        float access = MIN_ACCESS_BONUS + this.daysActive / MAX_DAYS * (MAX_ACCESS_BONUS - MIN_ACCESS_BONUS);
        if ((access = (float)Math.round(access * 100.0f) / 100.0f) > MAX_ACCESS_BONUS) {
            access = MAX_ACCESS_BONUS;
        }
        if (access < 0.01f) {
            access = 0.01f;
        }
        return access;
    }

    protected float getStabilityPenalty() {
        float s = MIN_STABILITY_PENALTY + this.daysActive / MAX_DAYS * (MAX_STABILITY_PENALTY - MIN_STABILITY_PENALTY);
        if ((s = (float)Math.round(s)) > MAX_STABILITY_PENALTY) {
            s = MAX_STABILITY_PENALTY;
        }
        if (s < 1.0f) {
            s = 1.0f;
        }
        return s;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        if (!this.market.hasSpaceport()) {
            tooltip.addPara("Requires a spaceport to have any effect", Misc.getNegativeHighlightColor(), 10.0f);
            return;
        }
        tooltip.addPara("%s stability (maximum of %s, reached after %s days)", 10.0f, Misc.getHighlightColor(), "-" + (int)this.getStabilityPenalty(), "-" + (int)MAX_STABILITY_PENALTY, "" + (int)MAX_DAYS);
        tooltip.addPara("%s population growth (maximum of %s, reached after %s days)", 10.0f, Misc.getHighlightColor(), "+" + (int)this.getImmigrationBonus(), "+" + (int)MAX_GROWTH, "" + (int)MAX_DAYS);
        tooltip.addPara("%s accessibility (maximum of %s, reached after %s days)", 10.0f, Misc.getHighlightColor(), "+" + Math.round(this.getAccessBonus() * 100.0f) + "%", "+" + Math.round(MAX_ACCESS_BONUS * 100.0f) + "%", "" + (int)MAX_DAYS);
        tooltip.addPara("Colony does not require the transponder to be turned on for open trade. All commodities are legal to trade.", 10.0f);
        tooltip.addPara("Colony gets income from smuggled exports.", 10.0f);
    }
}

