/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;

public class SolarArray
extends BaseMarketConditionPlugin {
    public static int FARMING_BONUS = 2;
    public static List<String> SUPPRESSED_CONDITIONS = new ArrayList<String>();

    static {
        SUPPRESSED_CONDITIONS.add("hot");
        SUPPRESSED_CONDITIONS.add("poor_light");
    }

    public void apply(String id) {
        for (String cid : SUPPRESSED_CONDITIONS) {
            this.market.suppressCondition(cid);
        }
        Industry industry = this.getIndustry();
        if (industry != null) {
            industry.getSupplyBonusFromOther().modifyFlat(id, FARMING_BONUS, Misc.ucFirst(this.condition.getName().toLowerCase()));
        }
    }

    public void unapply(String id) {
        for (String cid : SUPPRESSED_CONDITIONS) {
            this.market.unsuppressCondition(cid);
        }
        Industry industry = this.getIndustry();
        if (industry != null) {
            industry.getSupplyBonusFromOther().unmodifyFlat(id);
        }
    }

    protected Industry getIndustry() {
        Industry industry = this.market.getIndustry("farming");
        if (industry == null) {
            industry = this.market.getIndustry("aquaculture");
        }
        return industry;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        float opad = 10.0f;
        ArrayList<String> conds = new ArrayList<String>();
        for (String id : SUPPRESSED_CONDITIONS) {
            MarketConditionSpecAPI mc = Global.getSettings().getMarketConditionSpec(id);
            conds.add(mc.getName());
        }
        tooltip.addPara("Counters the effects of " + Misc.getAndJoined(conds) + ".\n\nIncreases food production by %s (Farming).", opad, Misc.getHighlightColor(), "" + FARMING_BONUS);
    }
}

