/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.listeners.ColonyOtherFactorsListener;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cryorevival
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float ALPHA_CORE_BONUS = 1.0f;
    public static float IMPROVE_BONUS = 1.0f;
    public static float MIN_BONUS_MULT = 0.1f;
    public static float MAX_BONUS_DIST_LY = 10.0f;
    public static float MAX_BONUS_WHEN_UNMET_DEMAND = 0.5f;

    @Override
    public void apply() {
        super.apply(true);
        this.demand("organics", 10);
    }

    @Override
    public void unapply() {
        super.unapply();
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            Color h = Misc.getHighlightColor();
            float opad = 10.0f;
            float bonus = this.getImmigrationBonus();
            float max = this.getMaxImmigrationBonus();
            float distMult = Cryorevival.getDistancePopulationMult(this.market.getLocationInHyperspace());
            float demandMult = this.getDemandMetPopulationMult();
            Pair<SectorEntityToken, Float> p = Cryorevival.getNearestCryosleeper(this.market.getLocationInHyperspace(), true);
            if (p != null) {
                String dStr = Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue());
                String lights = "light-years";
                if (dStr.equals("1")) {
                    lights = "light-year";
                }
                tooltip.addPara("Distance to nearest cryosleeper: %s " + lights + ", growth bonus multiplier: %s.", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), Math.round(distMult * 100.0f) + "%");
            }
            if (mode != Industry.IndustryTooltipMode.NORMAL) {
                tooltip.addPara("If any demand is unmet, the maximum growth bonus is reduced by %s.", opad, h, Math.round(MAX_BONUS_WHEN_UNMET_DEMAND * 100.0f) + "%");
            } else {
                tooltip.addPara("%s growth bonus multiplier based on met demand. If any demand is unmet, the maximum bonus is reduced by %s.", opad, h, Math.round(demandMult * 100.0f) + "%", Math.round(MAX_BONUS_WHEN_UNMET_DEMAND * 100.0f) + "%");
            }
            tooltip.addPara("Population growth: %s (max for colony size: %s)", opad, h, "+" + Math.round(bonus), "+" + Math.round(max));
        }
    }

    @Override
    public boolean isAvailableToBuild() {
        return Cryorevival.getDistancePopulationMult(this.market.getLocationInHyperspace()) > 0.0f;
    }

    @Override
    public boolean showWhenUnavailable() {
        return false;
    }

    @Override
    public String getUnavailableReason() {
        return "Requires in-system cryosleeper";
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        if (this.isFunctional()) {
            incoming.add("sleeper", this.getImmigrationBonus() * 2.0f);
            incoming.getWeight().modifyFlat(this.getModId(), this.getImmigrationBonus(), this.getNameForModifier());
            if ("alpha_core".equals(this.getAICoreId())) {
                incoming.getWeight().modifyFlat(this.getModId(1), (int)(this.getImmigrationBonus() * ALPHA_CORE_BONUS), "Alpha core (" + this.getNameForModifier() + ")");
            }
            if (this.isImproved()) {
                incoming.getWeight().modifyFlat(this.getModId(2), (int)(this.getImmigrationBonus() * IMPROVE_BONUS), String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
            }
        }
    }

    @Override
    protected void applyAlphaCoreModifiers() {
    }

    @Override
    protected void applyNoAICoreModifiers() {
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = this.getImmigrationBonus() * ALPHA_CORE_BONUS;
        String str = "+" + Math.round(a);
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "%s population growth.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "%s population growth.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = this.getImmigrationBonus() * IMPROVE_BONUS;
        String str = "" + Math.round(a);
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Population growth increased by %s.", 0.0f, highlight, str);
        } else {
            info.addPara("Increases population growth by %s.", 0.0f, highlight, str);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    public static Pair<SectorEntityToken, Float> getNearestCryosleeper(Vector2f locInHyper, boolean usable) {
        SectorEntityToken nearest = null;
        float minDist = Float.MAX_VALUE;
        for (SectorEntityToken entity : Global.getSector().getCustomEntitiesWithTag("cryosleeper")) {
            if (usable && !entity.getMemoryWithoutUpdate().contains("$usable")) continue;
            float dist = Misc.getDistanceLY(locInHyper, entity.getLocationInHyperspace());
            if (dist > MAX_BONUS_DIST_LY && (float)Math.round(dist * 10.0f) <= MAX_BONUS_DIST_LY * 10.0f) {
                dist = MAX_BONUS_DIST_LY;
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = entity;
        }
        if (nearest == null) {
            return null;
        }
        return new Pair<Object, Float>(nearest, Float.valueOf(minDist));
    }

    public static float getDistancePopulationMult(Vector2f locInHyper) {
        Pair<SectorEntityToken, Float> p = Cryorevival.getNearestCryosleeper(locInHyper, true);
        if (p == null) {
            return 0.0f;
        }
        if (((Float)p.two).floatValue() > MAX_BONUS_DIST_LY) {
            return 0.0f;
        }
        float f = 1.0f - ((Float)p.two).floatValue() / MAX_BONUS_DIST_LY;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float mult = MIN_BONUS_MULT + (1.0f - MIN_BONUS_MULT) * f;
        return mult;
    }

    protected float getDemandMetPopulationMult() {
        Pair<String, Integer> deficit = this.getMaxDeficit("organics");
        float demand = this.getDemand("organics").getQuantity().getModifiedValue();
        float def = ((Integer)deficit.two).intValue();
        if (def > demand) {
            def = demand;
        }
        float mult = 1.0f;
        if (def > 0.0f && demand > 0.0f) {
            mult = (demand - def) / demand;
            mult *= MAX_BONUS_WHEN_UNMET_DEMAND;
        }
        return mult;
    }

    protected float getImmigrationBonus() {
        return this.getMaxImmigrationBonus() * this.getDemandMetPopulationMult() * Cryorevival.getDistancePopulationMult(this.market.getLocationInHyperspace());
    }

    protected float getMaxImmigrationBonus() {
        return this.getSizeMult() * 10.0f;
    }

    public static class CryosleeperFactor
    implements ColonyOtherFactorsListener {
        public boolean isActiveFactorFor(SectorEntityToken entity) {
            return Cryorevival.getNearestCryosleeper(entity.getLocationInHyperspace(), true) != null;
        }

        public void printOtherFactors(TooltipMakerAPI text, SectorEntityToken entity) {
            float distMult = Cryorevival.getDistancePopulationMult(entity.getLocationInHyperspace());
            Pair<SectorEntityToken, Float> p = Cryorevival.getNearestCryosleeper(entity.getLocationInHyperspace(), true);
            if (p != null) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                String dStr = Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue());
                String lights = "light-years";
                if (dStr.equals("1")) {
                    lights = "light-year";
                }
                if (((Float)p.two).floatValue() > MAX_BONUS_DIST_LY) {
                    text.addPara("The nearest cryosleeper is located in the " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + ", %s " + lights + " away. The maximum " + "range at which sleepers can be safely brought over for revival is %s light-years.", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), "" + (int)MAX_BONUS_DIST_LY);
                } else {
                    text.addPara("The nearest cryosleeper is located in the " + ((SectorEntityToken)p.one).getContainingLocation().getNameWithLowercaseType() + ", %s " + lights + " away, allowing " + "a Cryorevival Facility built here to operate at %s effectiveness.", opad, h, Misc.getRoundedValueMaxOneAfterDecimal(((Float)p.two).floatValue()), Math.round(distMult * 100.0f) + "%");
                }
            }
        }
    }
}

