/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.campaign.impl.items.ModSpecItemPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TechMining
extends BaseIndustry
implements MarketImmigrationModifier {
    public static final String TECH_MINING_MULT = "$core_techMiningMult";
    public static float ALPHA_CORE_FINDS_BONUS = 0.25f;
    public static float IMPROVE_FINDS_BONUS = 0.25f;

    public void apply() {
        super.apply(false);
        int size = this.market.getSize();
        int max = 0;
        if (this.market.hasCondition("ruins_vast")) {
            max = 4;
        } else if (this.market.hasCondition("ruins_extensive")) {
            max = 3;
        } else if (this.market.hasCondition("ruins_widespread")) {
            max = 2;
        } else if (this.market.hasCondition("ruins_scattered")) {
            max = 1;
        }
        size = Math.min(size, max);
        this.applyIncomeAndUpkeep(size);
        if (!this.isFunctional()) {
            this.supply.clear();
        }
        this.market.addTransientImmigrationModifier(this);
    }

    public void unapply() {
        this.market.removeTransientImmigrationModifier(this);
    }

    public boolean isAvailableToBuild() {
        if (!super.isAvailableToBuild()) {
            return false;
        }
        return this.market.hasCondition("ruins_vast") || this.market.hasCondition("ruins_extensive") || this.market.hasCondition("ruins_widespread") || this.market.hasCondition("ruins_scattered");
    }

    public String getUnavailableReason() {
        if (!super.isAvailableToBuild()) {
            return super.getUnavailableReason();
        }
        return "Requires ruins";
    }

    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("tritachyon", 10.0f);
    }

    public float getPatherInterest() {
        float base = 1.0f;
        if (this.market.hasCondition("ruins_vast")) {
            base = 8.0f;
        } else if (this.market.hasCondition("ruins_extensive")) {
            base = 6.0f;
        } else if (this.market.hasCondition("ruins_widespread")) {
            base = 4.0f;
        } else if (this.market.hasCondition("ruins_scattered")) {
            base = 2.0f;
        }
        return base + super.getPatherInterest();
    }

    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return true;
    }

    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        float opad = 10.0f;
        tooltip.addPara("In addition to extracting basic resources, there's also a chance to find blueprints and other rare items. Anything found will be delivered to the designated production gathering point.", opad);
        boolean hasRuins = true;
        if (this.market.hasCondition("ruins_vast")) {
            tooltip.addPara("The vast ruins here offer incredible potential for valuable finds.", opad);
        } else if (this.market.hasCondition("ruins_extensive")) {
            tooltip.addPara("The extensive ruins here offer the opportunity for valuable finds.", opad);
        } else if (this.market.hasCondition("ruins_widespread")) {
            tooltip.addPara("The widespread ruins here offer a solid chance of finding something valuable, given time.", opad);
        } else if (this.market.hasCondition("ruins_scattered")) {
            tooltip.addPara("The scattered ruins here offer only a slight chance of finding something valuable, though one never knows what might be located given enough time.", opad);
        } else {
            hasRuins = false;
        }
        if (hasRuins) {
            float mult = this.getTechMiningMult();
            if (mult >= 0.9f) {
                tooltip.addPara("These ruins are largely untapped.", opad);
            } else if (mult >= 0.5f) {
                tooltip.addPara("These ruins have been stripped of easy pickings, but the more difficult areas remain, filled with promise.", opad);
            } else if (mult >= 0.25f) {
                tooltip.addPara("These ruins have been combed through, though the chance for a few new finds still remains.", opad);
            } else {
                tooltip.addPara("These ruins have been comprehensively combed over multiple times, and there is little chance of a new valuable find.", opad);
            }
        }
    }

    protected float getEffectivenessMult() {
        float mult = this.market.getStats().getDynamic().getStat("tech_mining_mult").getModifiedValue();
        return mult;
    }

    public float getTechMiningMult() {
        MemoryAPI mem = this.market.getMemoryWithoutUpdate();
        if (mem.contains(TECH_MINING_MULT)) {
            return mem.getFloat(TECH_MINING_MULT);
        }
        mem.set(TECH_MINING_MULT, Float.valueOf(1.0f));
        return 1.0f;
    }

    public void setTechMiningMult(float value) {
        MemoryAPI mem = this.market.getMemoryWithoutUpdate();
        mem.set(TECH_MINING_MULT, Float.valueOf(value));
    }

    public float getTechMiningRuinSizeModifier() {
        return TechMining.getTechMiningRuinSizeModifier(this.market);
    }

    public static float getTechMiningRuinSizeModifier(MarketAPI market) {
        float mod = 0.0f;
        if (market.hasCondition("ruins_vast")) {
            mod = 1.0f;
        } else if (market.hasCondition("ruins_extensive")) {
            mod = 0.6f;
        } else if (market.hasCondition("ruins_widespread")) {
            mod = 0.35f;
        } else if (market.hasCondition("ruins_scattered")) {
            mod = 0.2f;
        }
        return mod;
    }

    public CargoAPI generateCargoForGatheringPoint(Random random) {
        if (!this.isFunctional()) {
            return null;
        }
        float mult = this.getTechMiningMult();
        float decay = Global.getSettings().getFloat("techMiningDecay");
        float base = this.getTechMiningRuinSizeModifier();
        this.setTechMiningMult(mult * decay);
        base *= this.getEffectivenessMult();
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        ArrayList<SalvageEntityGenDataSpec.DropData> dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "blueprints_low";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "rare_tech_low";
        d.valueMult = 0.1f;
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "ai_cores3";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "any_hullmod_low";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 5;
        d.group = "weapons2";
        dropRandom.add(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.group = "basic";
        d.value = 10000;
        dropValue.add(d);
        if (mult >= 1.0f) {
            float num = base * (5.0f + random.nextFloat() * 2.0f);
            if (num < 1.0f) {
                num = 1.0f;
            }
            d = new SalvageEntityGenDataSpec.DropData();
            d.chances = Math.round(num);
            d.group = "techmining_first_find";
            dropRandom.add(d);
        }
        CargoAPI result = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, base * mult, 1.0f, dropValue, dropRandom);
        FactionAPI pf = Global.getSector().getPlayerFaction();
        block0: for (CargoStackAPI stack : result.getStacksCopy()) {
            ModSpecItemPlugin mod;
            if (stack.getPlugin() instanceof BlueprintProviderItem) {
                BlueprintProviderItem bp = (BlueprintProviderItem)((Object)stack.getPlugin());
                List<String> list = bp.getProvidedShips();
                if (list != null) {
                    for (String id : list) {
                        if (!pf.knowsShip(id)) continue block0;
                    }
                }
                if ((list = bp.getProvidedWeapons()) != null) {
                    for (String id : list) {
                        if (!pf.knowsWeapon(id)) continue block0;
                    }
                }
                if ((list = bp.getProvidedFighters()) != null) {
                    for (String id : list) {
                        if (!pf.knowsFighter(id)) continue block0;
                    }
                }
                if ((list = bp.getProvidedIndustries()) != null) {
                    for (String id : list) {
                        if (!pf.knowsIndustry(id)) continue block0;
                    }
                }
                result.removeStack(stack);
                continue;
            }
            if (!(stack.getPlugin() instanceof ModSpecItemPlugin) || !pf.knowsHullMod((mod = (ModSpecItemPlugin)stack.getPlugin()).getModId())) continue;
            result.removeStack(stack);
        }
        return result;
    }

    protected void applyAlphaCoreModifiers() {
        this.market.getStats().getDynamic().getStat("tech_mining_mult").modifyMult(this.getModId(0), 1.0f + ALPHA_CORE_FINDS_BONUS);
    }

    protected void applyNoAICoreModifiers() {
        this.market.getStats().getDynamic().getStat("tech_mining_mult").unmodifyMult(this.getModId(0));
    }

    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_FINDS_BONUS;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases finds by %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases finds by %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
    }

    public boolean canImprove() {
        return true;
    }

    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStats().getDynamic().getStat("tech_mining_mult").modifyMult(this.getModId(1), 1.0f + IMPROVE_FINDS_BONUS);
        } else {
            this.market.getStats().getDynamic().getStat("tech_mining_mult").unmodifyMult(this.getModId(1));
        }
    }

    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_FINDS_BONUS;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Finds increased by %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("Increases finds by %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

