/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.impl.campaign.enc.EPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPointProvider;
import com.fs.starfarer.api.impl.campaign.enc.OutsideSystemNoEPEC;
import com.fs.starfarer.api.impl.campaign.enc.OutsideSystemRemnantEPEC;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamLuddicPathEPEC;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamMercenaryEPEC;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamNoEPEC;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamPirateEPEC;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamScavengerEPEC;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncounterManager
implements EveryFrameScript,
EncounterPointProvider {
    public static String EP_TYPE_SLIPSTREAM = "ep_type_slipstream";
    public static String EP_TYPE_OUTSIDE_SYSTEM = "ep_type_outside_system";
    public static float MAX_EP_DIST_ADD = 4000.0f;
    public static List<EPEncounterCreator> CREATORS = new ArrayList<EPEncounterCreator>();
    protected Random random = new Random();
    protected IntervalUtil interval = new IntervalUtil(0.2f, 0.4f);
    protected TimeoutTracker<String> pointTimeout = new TimeoutTracker();
    protected TimeoutTracker<String> creatorTimeout = new TimeoutTracker();

    static {
        CREATORS.add(new SlipstreamPirateEPEC());
        CREATORS.add(new SlipstreamLuddicPathEPEC());
        CREATORS.add(new SlipstreamMercenaryEPEC());
        CREATORS.add(new SlipstreamScavengerEPEC());
        CREATORS.add(new SlipstreamNoEPEC());
        CREATORS.add(new OutsideSystemRemnantEPEC());
        CREATORS.add(new OutsideSystemNoEPEC());
    }

    public static EncounterManager getInstance() {
        String key = "$encounterManager";
        EncounterManager calc = (EncounterManager)Global.getSector().getMemoryWithoutUpdate().get(key);
        if (calc == null) {
            for (EveryFrameScript curr : Global.getSector().getScripts()) {
                if (!(curr instanceof EncounterManager)) continue;
                calc = (EncounterManager)curr;
                Global.getSector().getMemoryWithoutUpdate().set(key, calc);
                break;
            }
        }
        return calc;
    }

    protected Object readResolve() {
        return this;
    }

    public EncounterManager() {
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    public void advance(float amount) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.pointTimeout.advance(days);
        this.creatorTimeout.advance(days);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            LocationAPI where = Global.getSector().getCurrentLocation();
            if (where == null) {
                return;
            }
            float minRange = Global.getSettings().getMaxSensorRange(where);
            float maxRange = minRange + MAX_EP_DIST_ADD;
            List<EncounterPoint> points = ListenerUtil.generateEncounterPoints(where);
            EncounterPoint closest = null;
            float minDist = Float.MAX_VALUE;
            for (EncounterPoint p : points) {
                float dist;
                if (this.pointTimeout.contains(p.id) || (dist = Misc.getDistance(pf.getLocation(), p.loc)) < minRange || dist > maxRange || !(dist < minDist)) continue;
                closest = p;
                minDist = dist;
            }
            if (closest != null) {
                EPEncounterCreator c2;
                WeightedRandomPicker<EPEncounterCreator> picker = new WeightedRandomPicker<EPEncounterCreator>(this.random);
                for (EPEncounterCreator c2 : CREATORS) {
                    float f;
                    if (this.creatorTimeout.contains(c2.getId()) || !((f = c2.getFrequencyForPoint(this, closest)) > 0.0f)) continue;
                    picker.add(c2, f);
                }
                c2 = (EPEncounterCreator)picker.pick();
                if (c2 != null) {
                    c2.createEncounter(this, closest);
                    float ptTO = c2.getPointTimeoutMin() + (c2.getPointTimeoutMax() - c2.getPointTimeoutMin()) * this.random.nextFloat();
                    float cTO = c2.getCreatorTimeoutMin() + (c2.getCreatorTimeoutMax() - c2.getCreatorTimeoutMin()) * this.random.nextFloat();
                    if (ptTO > 0.0f) {
                        this.pointTimeout.set(closest.id, ptTO);
                    }
                    if (cTO > 0.0f) {
                        this.creatorTimeout.set(c2.getId(), cTO);
                    }
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public Random getRandom() {
        return this.random;
    }

    public TimeoutTracker<String> getPointTimeout() {
        return this.pointTimeout;
    }

    public TimeoutTracker<String> getCreatorTimeout() {
        return this.creatorTimeout;
    }

    @Override
    public List<EncounterPoint> generateEncounterPoints(LocationAPI where) {
        if (!where.isHyperspace()) {
            return null;
        }
        ArrayList<EncounterPoint> result = new ArrayList<EncounterPoint>();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float velAngle = Misc.getAngleInDegrees(pf.getVelocity());
        if (pf.getVelocity().length() < 10.0f) {
            velAngle = pf.getFacing();
        }
        for (CampaignTerrainAPI ter : where.getTerrainCopy()) {
            SlipstreamTerrainPlugin2 plugin;
            List<Vector2f> points;
            if (!(ter.getPlugin() instanceof SlipstreamTerrainPlugin2) || (points = (plugin = (SlipstreamTerrainPlugin2)ter.getPlugin()).getEncounterPoints()) == null) continue;
            for (Vector2f p : points) {
                float diff;
                float dist = Misc.getDistance(pf.getLocation(), p);
                if (dist > 10000.0f || Misc.isInsideSlipstream(p, 500.0f) || !((diff = Misc.getAngleDiff(velAngle, Misc.getAngleInDegrees(pf.getLocation(), p))) < 90.0f)) continue;
                String id = String.valueOf(ter.getId()) + "_" + Math.round(p.x) + "_" + Math.round(p.y);
                EncounterPoint ep = new EncounterPoint(id, where, p, EP_TYPE_SLIPSTREAM);
                result.add(ep);
            }
        }
        return result;
    }
}

