/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamPirateEPEC
extends BaseEPEncounterCreator {
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        CampaignFleetAPI fleet;
        Random random = manager.getRandom();
        PirateBaseIntel intel = SlipstreamPirateEPEC.getClosestPirateBase(point.getLocInHyper());
        float f = SlipstreamPirateEPEC.getProximityFactor(point.getLocInHyper());
        int difficulty = 0;
        difficulty += Math.round(f * 3.0f);
        if (intel != null) {
            switch (intel.getTier()) {
                case TIER_1_1MODULE: {
                    ++difficulty;
                    break;
                }
                case TIER_2_1MODULE: {
                    ++difficulty;
                    break;
                }
                case TIER_3_2MODULE: {
                    difficulty += 2;
                    break;
                }
                case TIER_4_3MODULE: {
                    difficulty += 3;
                    break;
                }
                case TIER_5_3MODULE: {
                    difficulty += 4;
                }
            }
        }
        difficulty += random.nextInt(4);
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = point.getLocInHyper();
        String factionId = "pirates";
        if (intel != null && intel.getMarket() != null) {
            factionId = intel.getMarket().getFactionId();
        }
        m.createStandardFleet(difficulty, factionId, loc);
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        m.triggerFleetAllowLongPursuit();
        if (intel != null && intel.getMarket() != null) {
            m.triggerSetFleetMemoryValue("$sourceMarket", intel.getMarket().getId());
        }
        if ((fleet = m.createFleet()) != null) {
            point.where.addEntity(fleet);
            fleet.setLocation(point.loc.x, point.loc.y);
            Vector2f spawnLoc = Misc.getPointWithinRadius(point.loc, 1000.0f);
            SectorEntityToken e = point.where.createToken(spawnLoc);
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 30.0f * random.nextFloat(), "laying in wait");
            fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
            fleet.addScript(new MissionFleetAutoDespawn(null, fleet));
        }
    }

    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        if (!EncounterManager.EP_TYPE_SLIPSTREAM.equals(point.type)) {
            return 0.0f;
        }
        PirateBaseIntel intel = SlipstreamPirateEPEC.getClosestPirateBase(point.getLocInHyper());
        float f = SlipstreamPirateEPEC.getProximityFactor(point.getLocInHyper());
        if (intel != null && f > 0.0f) {
            f = 0.25f + 0.75f * f;
            switch (intel.getTier()) {
                case TIER_1_1MODULE: {
                    f *= 1.0f;
                    break;
                }
                case TIER_2_1MODULE: {
                    f *= 2.0f;
                    break;
                }
                case TIER_3_2MODULE: {
                    f *= 3.0f;
                    break;
                }
                case TIER_4_3MODULE: {
                    f *= 4.0f;
                    break;
                }
                case TIER_5_3MODULE: {
                    f *= 5.0f;
                }
            }
        }
        return 10.0f * f;
    }

    public static float getProximityFactor(Vector2f locInHyper) {
        PirateBaseIntel intel = SlipstreamPirateEPEC.getClosestPirateBase(locInHyper);
        float f = SlipstreamPirateEPEC.getPirateBaseProximityFactor(intel, locInHyper);
        float f2 = SlipstreamPirateEPEC.getCoreProximityFactor(locInHyper);
        if ((f2 *= 0.5f) > f) {
            f = f2;
        }
        StarSystemAPI ruins = SlipstreamPirateEPEC.getClosestSystemWithRuins(locInHyper);
        float f3 = SlipstreamPirateEPEC.getRuinsProximityFactor(ruins, locInHyper);
        if ((f3 *= 0.25f) > f) {
            f = f3;
        }
        return f;
    }
}

