/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.impl.campaign.eventide.Actor;
import com.fs.starfarer.api.impl.campaign.eventide.DuelEnemyAI;
import com.fs.starfarer.api.impl.campaign.eventide.DuelPanel;

public class DuelEnemyAIImpl
implements DuelEnemyAI {
    public float initialDelay = 1.0f;
    public float moveDelay = 0.0f;
    public WaitThenAct next;
    public float recentBlocks = 0.0f;
    public float noBlockDur = 0.0f;

    public void advance(float amount, DuelPanel duel) {
        boolean opponentBlocking;
        boolean actorBlocking;
        Actor actor = duel.enemy;
        Actor opponent = duel.player;
        if (opponent.health <= 0) {
            return;
        }
        this.initialDelay -= amount;
        if (this.initialDelay > 0.0f) {
            return;
        }
        this.recentBlocks -= amount * 0.25f;
        if (this.recentBlocks < 0.0f) {
            this.recentBlocks = 0.0f;
        }
        this.moveDelay -= amount;
        if (this.moveDelay < 0.0f) {
            this.moveDelay = 0.0f;
        }
        this.noBlockDur -= amount;
        if (this.noBlockDur < 0.0f) {
            this.noBlockDur = 0.0f;
        }
        if (this.next != null) {
            this.next.delay -= amount;
            if (this.next.delay <= 0.0f) {
                actor.doAction(this.next.actionId, false);
                this.next = null;
            }
            return;
        }
        float attackRange = 142.0f;
        float tooCloseRange = 50.0f;
        float waitRange = attackRange + 50.0f;
        float dist = duel.getDistance();
        boolean actorAttacking = actor.currAction != null && actor.currAction.anim.hasAttackFrames() && !actor.currAction.scoredHit && !actor.currAction.wasBlocked;
        boolean bl = actorBlocking = actor.currAction != null && actor.currAction.anim.hasBlockFrames() && !actor.currAction.performedBlock;
        if (actor.nextAction != null && actor.nextAction.anim.hasBlockFrames()) {
            actorBlocking = true;
        }
        boolean actorPerformedBlock = actor.currAction != null && actor.currAction.performedBlock;
        boolean opponentAttacking = opponent.currAction != null && opponent.currAction.anim.hasAttackFrames() && !opponent.currAction.scoredHit && !opponent.currAction.wasBlocked;
        boolean bl2 = opponentBlocking = opponent.currAction != null && opponent.currAction.anim.hasBlockFrames() && !opponent.currAction.performedBlock;
        if (actorBlocking || actorAttacking) {
            return;
        }
        boolean blockOnlyMode = false;
        boolean allowAttack = true;
        if (opponentAttacking && dist < attackRange + 10.0f && opponent.currAction.framesUntilAttackFrame() < 4) {
            if (this.noBlockDur > 0.0f) {
                return;
            }
            if (1.0f + (float)Math.random() * 4.0f < this.recentBlocks) {
                this.noBlockDur = 0.5f + (float)Math.random() * 0.2f;
                if (!blockOnlyMode) {
                    actor.doAction("MOVE_BACK", false);
                    this.next = new WaitThenAct(0.1f, "MOVE_BACK");
                }
                return;
            }
            float delay = 0.2f * (float)Math.random();
            this.next = new WaitThenAct(delay, "BLOCK");
            this.recentBlocks += 1.0f;
            if (blockOnlyMode) {
                this.recentBlocks = 0.0f;
            }
            if (this.recentBlocks > 4.0f) {
                this.recentBlocks = 4.0f;
            }
            return;
        }
        if (opponentAttacking) {
            return;
        }
        if (actorPerformedBlock) {
            this.moveDelay = 0.1f + (float)Math.random() * 0.05f;
            return;
        }
        if (this.moveDelay <= 0.0f && !blockOnlyMode) {
            if (dist > waitRange) {
                actor.doAction("MOVE_FORWARD", false);
                this.moveDelay = 0.3f + (float)Math.random() * 0.2f;
                return;
            }
            if (dist > attackRange) {
                actor.doAction("MOVE_FORWARD", false);
                this.moveDelay = 0.3f + (float)Math.random() * 0.2f;
                return;
            }
        }
        if ((dist < attackRange || actorPerformedBlock) && this.moveDelay <= 0.0f && (!blockOnlyMode || allowAttack)) {
            actor.doAction("ATTACK", false);
            this.moveDelay = 0.1f + (float)Math.random() * 2.0f;
            return;
        }
    }

    public void render(float alphaMult) {
    }

    public static class WaitThenAct {
        float delay;
        String actionId;

        public WaitThenAct(float delay, String actionId) {
            this.delay = delay;
            this.actionId = actionId;
        }
    }
}

