/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuelTutorialPanel
extends BaseCustomUIPanelPlugin {
    protected InteractionDialogAPI dialog;
    protected CustomVisualDialogDelegate.DialogCallbacks callbacks;
    protected CustomPanelAPI panel;
    protected PositionAPI p;
    protected TutStage curr = null;
    protected TooltipMakerAPI info;
    protected float untilNext = 0.0f;
    protected boolean triggeredNext = false;
    protected FaderUtil flash = new FaderUtil(0.0f, 0.125f, 0.5f, false, true);

    public void init(CustomPanelAPI panel, CustomVisualDialogDelegate.DialogCallbacks callbacks, InteractionDialogAPI dialog) {
        this.panel = panel;
        this.callbacks = callbacks;
        this.dialog = dialog;
        this.curr = TutStage.INIT;
        this.showNext();
    }

    public void showNext() {
        if (this.curr == TutStage.LEAVE) {
            return;
        }
        this.curr = this.curr.next();
        if (this.info != null) {
            this.panel.removeComponent(this.info);
        }
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        this.info = this.panel.createUIElement(this.p.getWidth() - 20.0f, 1000.0f, false);
        this.info.setParaInsigniaLarge();
        if (this.curr == TutStage.MOVE_FORWARD) {
            this.info.addPara("Press RIGHT to move forward.", 0.0f, h, "RIGHT");
        } else if (this.curr == TutStage.MOVE_BACK) {
            this.info.addPara("Press LEFT to move backwards.", 0.0f, h, "LEFT");
        } else if (this.curr == TutStage.ATTACK) {
            this.info.addPara("Press SPACE to attack.", 0.0f, h, "SPACE");
        } else if (this.curr == TutStage.BLOCK) {
            LabelAPI label = this.info.addPara("Press UP to block or parry. A skilled fighter can also execute a quick attack, or a \"riposte\", by attacking immediately after deflecting their opponent's attack.", 0.0f, h, "UP");
            label.setHighlightColors(h, Misc.getStoryOptionColor());
            label.setHighlight("UP", "skilled fighter");
        } else if (this.curr == TutStage.LEAVE) {
            this.info.addPara("Your health is in the top left of the screen.\n\nMake a few practice moves, then press ESCAPE to continue.", 0.0f, h, "ESCAPE");
        }
        this.panel.addUIElement(this.info).inTL(opad, opad);
        this.flash.fadeIn();
    }

    public void reportAction(String actionId) {
        boolean triggered = false;
        triggered |= this.curr == TutStage.MOVE_FORWARD && "MOVE_FORWARD".equals(actionId);
        triggered |= this.curr == TutStage.MOVE_BACK && "MOVE_BACK".equals(actionId);
        triggered |= this.curr == TutStage.ATTACK && "ATTACK".equals(actionId);
        if (triggered |= this.curr == TutStage.BLOCK && "BLOCK".equals(actionId)) {
            this.triggeredNext = true;
            this.untilNext = 1.0f;
        }
    }

    public CustomPanelAPI getPanel() {
        return this.panel;
    }

    public PositionAPI getPosition() {
        return this.p;
    }

    @Override
    public void positionChanged(PositionAPI position) {
        this.p = position;
    }

    @Override
    public void render(float alphaMult) {
    }

    @Override
    public void renderBelow(float alphaMult) {
        if (this.p == null) {
            return;
        }
        float x = this.p.getX();
        float y = this.p.getY();
        float cx = this.p.getCenterX();
        float cy = this.p.getCenterY();
        float w = this.p.getWidth();
        float h = this.p.getHeight();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color c = Misc.getBasePlayerColor();
        float a = alphaMult;
        Misc.renderQuad(x, y, w, 1.0f, c, a);
        Misc.renderQuad(x, y + h - 1.0f, w, 1.0f, c, a);
        Misc.renderQuad(x, y + 1.0f, 1.0f, h - 2.0f, c, a);
        Misc.renderQuad(x + w - 1.0f, y + 1.0f, 1.0f, h - 2.0f, c, a);
        Misc.renderQuad(x + w, y - 1.0f, 1.0f, h, Color.black, a);
        Misc.renderQuad(x + 1.0f, y - 1.0f, w - 1.0f, 1.0f, Color.black, a);
        Misc.renderQuad(x + 1.0f, y + 1.0f, w - 2.0f, h - 2.0f, Color.black, a * 0.67f);
        GL11.glBlendFunc((int)770, (int)1);
        Misc.renderQuad(x + 1.0f, y + 1.0f, w - 2.0f, h - 2.0f, Misc.getBrightPlayerColor(), a * 0.25f * this.flash.getBrightness());
    }

    @Override
    public void advance(float amount) {
        if (this.p == null) {
            return;
        }
        if (this.triggeredNext) {
            this.untilNext -= amount;
            if (this.untilNext <= 0.0f) {
                this.triggeredNext = false;
                this.showNext();
            }
        }
        this.flash.advance(amount);
    }

    @Override
    public void processInput(List<InputEventAPI> events) {
        if (this.p == null) {
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TutStage {
        INIT,
        MOVE_FORWARD,
        MOVE_BACK,
        ATTACK,
        BLOCK,
        LEAVE;

        private static TutStage[] vals;

        static {
            vals = TutStage.values();
        }

        public TutStage next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }
    }
}

